/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;

public class MaterialResource
extends Resource {
    private static final long serialVersionUID = 1L;
    private String measurementUnit;

    public MaterialResource(long l) {
        super(l);
    }

    protected void initEmptyResource() {
        if (this.name == null) {
            this.name = "";
        }
        if (this.code == null) {
            this.code = "";
        }
        if (this.notes == null) {
            this.notes = "";
        }
        if (this.measurementUnit == null) {
            this.measurementUnit = "";
        }
        this.empty = false;
        this.getOwner().computeResourceId();
    }

    public double getTotalUnits() {
        double d = 0.0;
        for (Assignment assignment : this.assignments) {
            d += assignment.getUnits();
        }
        return d;
    }

    public double getActualUnits() {
        double d = 0.0;
        for (Assignment assignment : this.assignments) {
            d += assignment.getActualUnits();
        }
        return d;
    }

    public double getRemainingUnits() {
        double d = 0.0;
        for (Assignment assignment : this.assignments) {
            d += assignment.getRemainingUnits();
        }
        return d;
    }

    public double getTotalUnits(Date date, Date date2) {
        double d = 0.0;
        boolean bl = false;
        for (Assignment assignment : this.assignments) {
            double d2 = assignment.getUnits(date, date2);
            if (d2 == -1.0) continue;
            bl = true;
            d += d2;
        }
        if (bl) {
            return d;
        }
        return -1.0;
    }

    public double getActualUnits(Date date, Date date2) {
        double d = 0.0;
        boolean bl = false;
        for (Assignment assignment : this.assignments) {
            double d2 = assignment.getActualUnits(date, date2);
            if (d2 == -1.0) continue;
            bl = true;
            d += d2;
        }
        if (bl) {
            return d;
        }
        return -1.0;
    }

    public double getActualUnits(Assignment assignment, Date date, Date date2) {
        return assignment.getActualUnits(date, date2);
    }

    public double getRemainingUnits(Assignment assignment, Date date, Date date2) {
        return assignment.getRemainingUnits(date, date2);
    }

    public double getUnits(Assignment assignment, Date date, Date date2) {
        return assignment.getUnits(date, date2);
    }

    public double getRemainingUnits(Date date, Date date2) {
        double d = 0.0;
        boolean bl = false;
        for (Assignment assignment : this.assignments) {
            double d2 = assignment.getRemainingUnits(date, date2);
            if (d2 == -1.0) continue;
            bl = true;
            d += d2;
        }
        if (bl) {
            return d;
        }
        return -1.0;
    }

    public String getMeasurementUnit() {
        return this.measurementUnit;
    }

    public void setMeasurementUnit(String string) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.measurementUnit = string;
        this.fireDataChanged();
    }

    public String getProjects(Date date, Date date2) {
        LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
        for (Assignment object : this.getAssignments()) {
            Cloneable cloneable;
            Task task = object.getTask();
            double d = (double)task.getWorkingDuration(date, date2) * object.getUnits();
            if (task.isMilestone()) {
                Task task2;
                cloneable = task.getStartDate();
                if (cloneable.before(date) || !cloneable.before(date2) || linkedList.contains(task2 = object.getTask().getProjectTask())) continue;
                linkedList.add(task2);
                continue;
            }
            if (d == 0.0 || linkedList.contains(cloneable = object.getTask().getProjectTask())) continue;
            linkedList.add(cloneable);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Task task : linkedList) {
            stringBuffer.append(task.toString());
            stringBuffer.append(",");
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public Object clone(boolean bl) {
        long l = bl ? Common.getIdGenerator().getNewId() : this.uniqueId;
        MaterialResource materialResource = new MaterialResource(l);
        materialResource.assignments = new LinkedList();
        materialResource.listeners = new EventListenerList();
        materialResource.owner = null;
        materialResource.code = this.code;
        materialResource.empty = this.empty;
        materialResource.name = this.name;
        materialResource.notes = this.notes;
        materialResource.resourceId = this.resourceId;
        materialResource.standardRate = this.standardRate;
        materialResource.measurementUnit = this.measurementUnit;
        return materialResource;
    }
}

