/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import java.io.Serializable;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class CurrencyManager
implements Serializable {
    public static final String DOLAR = "$";
    public static final String EURO = String.valueOf('\u20ac');
    private static String defaultCurrency;
    private static int fractionDigits;
    private final List currencyList = new LinkedList();

    public CurrencyManager() {
        this.currencyList.add(DOLAR);
        this.currencyList.add(EURO);
    }

    public static int getFractionDigits() {
        return fractionDigits;
    }

    public static String getDefaultCurrency() {
        return defaultCurrency;
    }

    public String[] getCurrencies() {
        return this.currencyList.toArray(new String[0]);
    }

    static {
        Locale locale = Locale.getDefault();
        defaultCurrency = locale.getCountry().equals("") ? DOLAR : Currency.getInstance(locale).getSymbol();
        locale = Locale.getDefault();
        fractionDigits = locale.getCountry().equals("") ? 2 : Currency.getInstance(locale).getDefaultFractionDigits();
    }
}

