/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.event.ContactEvent;
import com.sbs.jpm.core.event.ContactListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class Contact
implements Serializable,
Cloneable,
UniqueId {
    private long id;
    private String name;
    private String phone;
    private String email;
    private String notes;
    private Client owner;
    private EventListenerList listeners;
    private long uniqueId;

    public Contact(long l) {
        this.setUniqueId(l);
        this.listeners = new EventListenerList();
        this.name = "";
        this.email = "";
        this.phone = "";
        this.notes = "";
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
        this.fireDataChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.fireDataChanged();
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
        this.fireDataChanged();
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String string) {
        this.phone = string;
        this.fireDataChanged();
    }

    private void fireContactChanged() {
        if (this.owner != null) {
            this.owner.fireDataChanged();
        }
    }

    public void fireDataChanged() {
        ContactEvent contactEvent = new ContactEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(ContactListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((ContactListener)eventListenerArray[i]).dataChanged(contactEvent);
        }
        this.fireContactChanged();
    }

    public void addContactListener(ContactListener contactListener) {
        this.listeners.add(ContactListener.class, contactListener);
    }

    public void removeContactListener(ContactListener contactListener) {
        this.listeners.remove(ContactListener.class, contactListener);
    }

    public Object clone() {
        try {
            Contact contact = (Contact)super.clone();
            contact.listeners = new EventListenerList();
            return contact;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Common.logException("Error cloning contact:", cloneNotSupportedException);
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        return this.name;
    }

    public Client getOwner() {
        return this.owner;
    }

    public void setOwner(Client client) {
        this.owner = client;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }
}

