/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.RemainingDuration;
import com.sbs.jpm.calendar.event.CalendarManagerEvent;
import com.sbs.jpm.calendar.event.CalendarManagerListener;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Contact;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.conflict.ConflictManager;
import com.sbs.jpm.core.constraint.ALAP;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.core.constraint.FNET;
import com.sbs.jpm.core.constraint.FNLT;
import com.sbs.jpm.core.constraint.MFO;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.CompanyListener;
import com.sbs.jpm.undo.ExtendedUndoManager;
import com.sbs.jpm.undo.ResourceInsertEdit;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Company
implements Serializable,
Cloneable {
    public static final int NONE = 0;
    public static final int SINGLE = 1;
    public static final int MULTI = 2;
    private boolean showCriticalPath = false;
    private boolean changed;
    private boolean loaded;
    private boolean forcedWorking;
    private CalendarManager calendarManager;
    private Task currentTask;
    private Task rootTask;
    private List<CalendarManager> calendarList;
    private List<HumanResource> humanResources;
    private List<MaterialResource> materialResources;
    private List<Client> clients;
    private ConflictManager conflictManager;
    private int multiProject;
    private UndoManager undoManager;
    private final CalendarHandler calendarHandler = new CalendarHandler();
    private EventListenerList listeners;
    private static final Calendar c = Calendar.getInstance();
    public boolean LOADING = false;

    public Company() {
        this(new Task(Common.I18N_RP.getString("project") + " 1"));
    }

    private Company(Task task) {
        this.undoManager = new ExtendedUndoManager();
        this.humanResources = new LinkedList<HumanResource>();
        this.materialResources = new LinkedList<MaterialResource>();
        this.clients = new LinkedList<Client>();
        this.listeners = new EventListenerList();
        this.calendarList = new LinkedList<CalendarManager>();
        this.conflictManager = new ConflictManager();
        this.rootTask = task;
        this.multiProject = 1;
        this.calendarManager = CalendarManager.createStandardCalendarInstance();
        this.addCalendarManager(this.calendarManager);
        this.addCalendarManager(CalendarManager.createFullTimeCalendarInstance());
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(CalendarManager.getDayStartTime(calendar));
        this.calendarManager.getFirstTime(calendar, true, Long.MAX_VALUE);
        task.setCompany(this);
        task.constraint = new SNET(calendar.getTime());
        task.startDate = calendar.getTime();
        TaskPlanner.computeEndDate(task);
        this.currentTask = task;
        this.setStartDate(calendar.getTime());
        this.setHumanResources(new LinkedList<HumanResource>());
        this.setMaterialResources(new LinkedList<MaterialResource>());
    }

    public void setStartDate(Date date) {
        c.setTime(date);
        if (this.rootTask.getFirstNonEmptyChild() == null) {
            this.rootTask.startDate = c.getTime();
            TaskPlanner.computeEndDate(this.rootTask);
        }
        this.changed = true;
        this.computeCriticalPath();
        this.fireCompanyChanged();
    }

    public boolean isForcedWorking() {
        return this.forcedWorking;
    }

    public void setForcedWorking(boolean bl) {
        this.forcedWorking = bl;
    }

    public int getMultiProject() {
        return this.multiProject;
    }

    public void setMultiProject(int n) {
        this.multiProject = n;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public Resource getResourceForId(long l) {
        for (HumanResource resource : this.humanResources) {
            if (resource.getId() != l) continue;
            return resource;
        }
        for (MaterialResource materialResource : this.materialResources) {
            if (materialResource.getId() != l) continue;
            return materialResource;
        }
        return null;
    }

    public CalendarManager getCalendarManager() {
        return this.calendarManager;
    }

    public void setCalendarManager(CalendarManager calendarManager) {
        CalendarManager calendarManager2 = this.calendarManager;
        this.calendarManager = calendarManager;
        if (calendarManager2 != null) {
            calendarManager2.removeCalendarManagerListener(this.calendarHandler);
        }
        if (calendarManager != null) {
            calendarManager.addCalendarManagerListener(this.calendarHandler);
        }
        this.setChanged(true);
    }

    public List<CalendarManager> getCalendarList() {
        return this.calendarList;
    }

    public void setCalendarList(List<CalendarManager> list) {
        this.calendarList = new LinkedList<CalendarManager>();
        for (CalendarManager calendarManager : list) {
            this.addCalendarManager(calendarManager);
        }
    }

    public void addCalendarManager(CalendarManager calendarManager) {
        this.calendarList.add(calendarManager);
        calendarManager.setOwner(this);
        this.computeCalendarId();
        this.fireCalendarAdded(calendarManager);
    }

    public void removeCalendarManager(CalendarManager calendarManager) {
        this.calendarList.remove(calendarManager);
        this.computeCalendarId();
        this.fireCalendarRemoved(calendarManager);
        calendarManager.setOwner(null);
    }

    private void computeCalendarId() {
        long l = 0L;
        for (CalendarManager calendarManager : this.calendarList) {
            calendarManager.setId(l++);
        }
    }

    public void calendarChanged(CalendarManager calendarManager) {
        this.checkDirtyTasks(this.rootTask, calendarManager);
        this.setChanged(true);
    }

    private void checkDirtyTasks(Task task, CalendarManager calendarManager) {
        if (task.getUsedCalendar().equals(calendarManager)) {
            task.setDirty(true, false);
        }
        for (Assignment uniqueId : task.getAssignments()) {
            HumanResource humanResource;
            if (!(uniqueId.getResource() instanceof HumanResource) || !(humanResource = (HumanResource)uniqueId.getResource()).getUsedCalendar().equals(calendarManager)) continue;
            task.setDirty(true, false);
        }
        for (Task task2 : task.getChildList()) {
            this.checkDirtyTasks(task2, calendarManager);
        }
    }

    public void computeCriticalPath() {
        if (this.showCriticalPath && this.loaded) {
            this.loaded = false;
            this.resetCriticalPath(this.currentTask);
            this.computeCriticalPath(this.currentTask);
            this.loaded = true;
        }
    }

    private void resetCriticalPath(Task task) {
        if (!task.isEmpty()) {
            if (task.isLeaf()) {
                task.critical = false;
                task.criticalDate = null;
            } else {
                for (Task task2 : task.getChildList()) {
                    this.resetCriticalPath(task2);
                }
            }
        }
    }

    private void computeCriticalPath(Task task) {
        if (!task.isEmpty()) {
            if (task.isLeaf()) {
                boolean bl = false;
                for (Dependency dependency : task.getSuccessorDependencies()) {
                    if (!dependency.getSuccessor().isDescendent(this.currentTask)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.isCritical(task, this.currentTask.getEndDate().getTime());
                }
            } else {
                for (Task task2 : task.getChildList()) {
                    this.computeCriticalPath(task2);
                }
            }
        }
    }

    private void isCritical(Task task, long l) {
        block7: {
            block8: {
                UniqueId uniqueId;
                Object object;
                if (task.isEmpty()) break block7;
                if (!task.isLeaf()) break block8;
                Date date = task.criticalDate;
                if (date == null || date != null && date.getTime() > l) {
                    task.criticalDate = new Date(l);
                }
                if (!task.critical) {
                    c.setTime(task.getEndDate());
                    object = new RemainingDuration(this.currentTask.getCriticalSlackLimit());
                    uniqueId = task.getUsedCalendar();
                    ((CalendarManager)uniqueId).convertToWorkingTime(c, (RemainingDuration)object, !task.isMilestone());
                    c.setTimeInMillis(((RemainingDuration)object).getEndMilis());
                    if (task.getProjectTask().getEndDate().getTime() < l) {
                        l = task.getProjectTask().getEndDate().getTime();
                    }
                    task.critical = c.getTimeInMillis() >= l;
                }
                if (date != null && (date == null || date.getTime() <= l)) break block7;
                object = new LinkedList<Dependency>();
                object.addAll(task.getPredecessorDependencies());
                uniqueId = task;
                while (((Task)uniqueId).getParent() != null) {
                    uniqueId = ((Task)uniqueId).getParent();
                    object.addAll(((Task)uniqueId).getPredecessorDependencies());
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Dependency dependency = (Dependency)iterator.next();
                    Task task2 = dependency.getPredecessor();
                    long l2 = this.computeLimit(task2, task, dependency.getType(), dependency.getTaskDelay(), l);
                    this.isCritical(task2, l2);
                }
                break block7;
            }
            for (Task task3 : task.getChildList()) {
                boolean bl = true;
                for (Dependency dependency : task3.getSuccessorDependencies()) {
                    Task task4 = dependency.getSuccessor();
                    Task task5 = task4.getParent();
                    if (task5 == null || !task5.equals(task)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                this.isCritical(task3, l);
            }
        }
    }

    private long computeLimit(Task task, Task task2, int n, long l, long l2) {
        RemainingDuration remainingDuration;
        Date date = null;
        c.setTimeInMillis(l2);
        CalendarManager calendarManager = task2.getUsedCalendar();
        CalendarManager calendarManager2 = task.getUsedCalendar();
        if (n == 0) {
            remainingDuration = new RemainingDuration(-task2.getDuration() - l);
            calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
            c.setTimeInMillis(remainingDuration.getEndMilis());
            date = c.getTime();
        } else if (n == 1) {
            remainingDuration = new RemainingDuration(-task2.getDuration() - l);
            calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
            c.setTimeInMillis(remainingDuration.getEndMilis());
            remainingDuration = new RemainingDuration(task.getDuration());
            calendarManager2.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
            c.setTimeInMillis(remainingDuration.getEndMilis());
            date = c.getTime();
        } else if (n == 3) {
            remainingDuration = new RemainingDuration(-l);
            calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
            c.setTimeInMillis(remainingDuration.getEndMilis());
            date = c.getTime();
        } else if (n == 2) {
            remainingDuration = new RemainingDuration(-l);
            calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
            c.setTimeInMillis(remainingDuration.getEndMilis());
            remainingDuration = new RemainingDuration(task.getDuration());
            calendarManager2.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
            c.setTimeInMillis(remainingDuration.getEndMilis());
            date = c.getTime();
        }
        if (task2.getCompletion() != 0.0) {
            c.setTime(task2.getStartDate());
            remainingDuration = new RemainingDuration(this.currentTask.getCriticalSlackLimit());
            calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
            c.setTimeInMillis(remainingDuration.getEndMilis());
            if (c.getTime().before(date)) {
                date = c.getTime();
            }
        } else {
            Constraint constraint = task2.getConstraint();
            if (!(constraint instanceof SNET)) {
                if (constraint instanceof SNLT) {
                    Date date2 = ((SNLT)constraint).getDate();
                    c.setTime(date2);
                    remainingDuration = new RemainingDuration(this.currentTask.getCriticalSlackLimit());
                    calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
                    c.setTimeInMillis(remainingDuration.getEndMilis());
                    if (c.getTime().before(date)) {
                        date = c.getTime();
                    }
                } else if (constraint instanceof FNLT) {
                    c.setTime(((FNLT)constraint).getDate());
                    remainingDuration = new RemainingDuration(-task2.getDuration());
                    calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
                    c.setTimeInMillis(remainingDuration.getEndMilis());
                    remainingDuration = new RemainingDuration(this.currentTask.getCriticalSlackLimit());
                    calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
                    c.setTimeInMillis(remainingDuration.getEndMilis());
                    if (c.getTime().before(date)) {
                        date = c.getTime();
                    }
                } else if (!(constraint instanceof FNET || constraint instanceof ASAP || constraint instanceof ALAP)) {
                    if (constraint instanceof MSO) {
                        Date date3 = ((MSO)constraint).getDate();
                        c.setTime(date3);
                        remainingDuration = new RemainingDuration(this.currentTask.getCriticalSlackLimit());
                        calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
                        c.setTimeInMillis(remainingDuration.getEndMilis());
                        if (c.getTime().before(date)) {
                            date = c.getTime();
                        }
                    } else if (constraint instanceof MFO) {
                        c.setTime(((MFO)constraint).getDate());
                        remainingDuration = new RemainingDuration(-task2.getDuration());
                        calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
                        c.setTimeInMillis(remainingDuration.getEndMilis());
                        remainingDuration = new RemainingDuration(this.currentTask.getCriticalSlackLimit());
                        calendarManager.convertToWorkingTime(c, remainingDuration, !task2.isMilestone());
                        c.setTimeInMillis(remainingDuration.getEndMilis());
                        if (c.getTime().before(date)) {
                            date = c.getTime();
                        }
                    }
                }
            }
        }
        return date.getTime();
    }

    public boolean isShowCriticalPath() {
        return this.showCriticalPath;
    }

    public void setShowCriticalPath(boolean bl) {
        this.showCriticalPath = bl;
        if (bl) {
            this.computeCriticalPath();
        }
    }

    public Task getRootTask() {
        return this.rootTask;
    }

    public void setRootTask(Task task) throws Exception {
        this.rootTask = task;
        task.setCompany(this);
        this.computeTasksId();
        if (task.getProjectChildNumber() != 0) {
            throw new Exception(Common.I18N_MESSAGES.getString("company.errorLoadingMultiIntoSingle"));
        }
        this.currentTask = task;
    }

    public void computeTasksId() {
        if (this.loaded) {
            this.rootTask.computeId(0L);
        }
    }

    public void addResource(Resource resource, CompoundEdit compoundEdit) {
        int n = this.addResource(resource);
        ResourceInsertEdit resourceInsertEdit = new ResourceInsertEdit(this, resource, n - 1, false, "09/11/09 14:56:05");
        compoundEdit.addEdit(resourceInsertEdit);
    }

    public int addResource(Resource resource) {
        if (resource instanceof HumanResource) {
            this.addResource(this.getHumanResourcesNumber(), resource);
            return this.getHumanResourcesNumber();
        }
        this.addResource(this.getMaterialResourcesNumber(), resource);
        return this.getMaterialResourcesNumber();
    }

    public void addResource(int n, Resource resource) {
        if (resource instanceof HumanResource) {
            this.humanResources.add(n, (HumanResource)resource);
        } else {
            this.materialResources.add(n, (MaterialResource)resource);
        }
        resource.setOwner(this);
        this.computeResourceId();
        this.fireResourceAdded(resource, n);
    }

    public int getClientsNumber() {
        return this.clients.size();
    }

    public void addClient(Client client) {
        this.addClient(this.getClientsNumber(), client);
    }

    public void addClient(int n, Client client) {
        this.clients.add(n, client);
        client.setOwner(this);
        this.computeClientId();
        this.fireClientAdded(client, n);
    }

    public void removeClient(Client client) {
        int n = this.clients.indexOf(client);
        this.clients.remove(client);
        this.removeClient(this.rootTask, client);
        this.computeClientId();
        this.fireClientRemoved(client, n);
    }

    public void removeClient(Task task, Client client) {
        if (task.isProject() && task.getClient() != null && task.getClient().equals(client)) {
            task.setClient(null);
        }
        for (int i = 0; i < task.getProjectChildNumber(); ++i) {
            Task task2 = task.getProjectChildAt(i);
            this.removeClient(task2, client);
        }
    }

    public void removeResource(Resource resource) {
        int n = this.humanResources.indexOf(resource);
        if (n != -1) {
            this.humanResources.remove(resource);
        } else {
            n = this.materialResources.indexOf(resource);
            this.materialResources.remove(resource);
        }
        this.computeResourceId();
        this.fireResourceRemoved(resource, n);
    }

    public HumanResource getHumanResourceAt(int n) {
        return this.humanResources.get(n);
    }

    public MaterialResource getMaterialResourceAt(int n) {
        return this.materialResources.get(n);
    }

    public Client getClientAt(int n) {
        return this.clients.get(n);
    }

    public Resource getResourceAt(int n) {
        if (n < this.getHumanResourcesNumber()) {
            return this.humanResources.get(n);
        }
        return this.materialResources.get(n - this.getHumanResourcesNumber());
    }

    public int getHumanResourceIndex(Resource resource) {
        return this.humanResources.indexOf(resource);
    }

    public int getMaterialResourceIndex(Resource resource) {
        return this.materialResources.indexOf(resource);
    }

    public int getClientIndex(Client client) {
        return this.clients.indexOf(client);
    }

    public int getResourceIndex(Resource resource) {
        if (resource instanceof HumanResource) {
            return this.humanResources.indexOf(resource);
        }
        return this.materialResources.indexOf(resource) + this.getHumanResourcesNumber();
    }

    public List<HumanResource> getHumanResources() {
        return this.humanResources;
    }

    public List<MaterialResource> getMaterialResources() {
        return this.materialResources;
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public List<Client> getNonEmptyClients() {
        LinkedList<Client> linkedList = new LinkedList<Client>();
        for (Client client : this.clients) {
            if (client.isEmpty()) continue;
            linkedList.add(client);
        }
        return linkedList;
    }

    public List<Resource> getResources() {
        LinkedList<Resource> linkedList = new LinkedList<Resource>(this.humanResources);
        linkedList.addAll(this.materialResources);
        return linkedList;
    }

    public void setHumanResources(List<HumanResource> list) {
        this.humanResources = list;
    }

    public void setMaterialResources(List<MaterialResource> list) {
        this.materialResources = list;
    }

    public void setClients(List<Client> list) {
        this.clients = list;
    }

    public List<Resource> getNonEmptyResources() {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        for (HumanResource resource : this.humanResources) {
            if (resource.isEmpty()) continue;
            linkedList.add(resource);
        }
        for (MaterialResource materialResource : this.materialResources) {
            if (materialResource.isEmpty()) continue;
            linkedList.add(materialResource);
        }
        return linkedList;
    }

    public int getResourcesNumber() {
        return this.humanResources.size() + this.materialResources.size();
    }

    public int getHumanResourcesNumber() {
        return this.humanResources.size();
    }

    public int getMaterialResourcesNumber() {
        return this.materialResources.size();
    }

    public void computeResourceId() {
        if (this.loaded) {
            long l = 1L;
            for (HumanResource resource : this.humanResources) {
                resource.setId(l++);
            }
            for (MaterialResource materialResource : this.materialResources) {
                materialResource.setId(l++);
            }
        }
    }

    public void computeClientId() {
        if (this.loaded) {
            long l = 1L;
            for (Client client : this.clients) {
                client.setId(l++);
            }
        }
    }

    public List<HumanResource> removeEmptyHumanResources() {
        HumanResource humanResource;
        int n;
        HumanResource[] humanResourceArray = this.humanResources.toArray(new HumanResource[0]);
        int n2 = humanResourceArray.length;
        LinkedList<HumanResource> linkedList = new LinkedList<HumanResource>();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            humanResource = humanResourceArray[n];
            if (humanResource.isEmpty()) continue;
            n3 = n;
        }
        if (n2 - 1 > n3) {
            for (n = n2 - 1; n > n3; --n) {
                humanResource = this.getHumanResourceAt(n);
                linkedList.add(0, humanResource);
                this.removeResource(humanResource);
            }
        }
        return linkedList;
    }

    public List<Client> removeEmptyClients() {
        Client client;
        int n;
        Client[] clientArray = this.clients.toArray(new Client[0]);
        int n2 = clientArray.length;
        LinkedList<Client> linkedList = new LinkedList<Client>();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            client = clientArray[n];
            if (client.isEmpty()) continue;
            n3 = n;
        }
        if (n2 - 1 > n3) {
            for (n = n2 - 1; n > n3; --n) {
                client = this.getClientAt(n);
                linkedList.add(0, client);
                this.removeClient(client);
            }
        }
        return linkedList;
    }

    public List<MaterialResource> removeEmptyMaterialResources() {
        MaterialResource materialResource;
        int n;
        MaterialResource[] materialResourceArray = this.materialResources.toArray(new MaterialResource[0]);
        int n2 = materialResourceArray.length;
        LinkedList<MaterialResource> linkedList = new LinkedList<MaterialResource>();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            materialResource = materialResourceArray[n];
            if (materialResource.isEmpty()) continue;
            n3 = n;
        }
        if (n2 - 1 > n3) {
            for (n = n2 - 1; n > n3; --n) {
                materialResource = this.getMaterialResourceAt(n);
                linkedList.add(0, materialResource);
                this.removeResource(materialResource);
            }
        }
        return linkedList;
    }

    public static List<Resource> cloneResources(List<Resource> list, boolean bl) {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        for (Resource resource : list) {
            Resource resource2 = (Resource)resource.clone(bl);
            linkedList.add(resource2);
        }
        return linkedList;
    }

    public static List<Client> cloneClients(List<Client> list) {
        LinkedList<Client> linkedList = new LinkedList<Client>();
        for (Client client : list) {
            Client client2 = (Client)client.clone();
            linkedList.add(client2);
        }
        return linkedList;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        this.fireCompanyChanged();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public HumanResource getHumanResourceForUniqueId(long l) {
        for (HumanResource humanResource : this.getHumanResources()) {
            if (humanResource.getUniqueId() != l) continue;
            return humanResource;
        }
        return null;
    }

    public MaterialResource getMaterialResourceForUniqueId(long l) {
        for (MaterialResource materialResource : this.getMaterialResources()) {
            if (materialResource.getUniqueId() != l) continue;
            return materialResource;
        }
        return null;
    }

    public Resource getResourceForUniqueId(long l) {
        Resource resource = this.getHumanResourceForUniqueId(l);
        if (resource == null) {
            resource = this.getMaterialResourceForUniqueId(l);
        }
        return resource;
    }

    public Task getTaskForUniqueId(long l) {
        return this.getTaskForUniqueId(this.getRootTask(), l);
    }

    public Risk getRiskForUniqueId(long l) {
        for (Task task : this.getRootTask().getChildList()) {
            if (!task.isProject()) continue;
            for (Risk risk : task.getRisks()) {
                if (risk.getUniqueId() != l) continue;
                return risk;
            }
        }
        return null;
    }

    public Link getLinkForUniqueId(long l) {
        for (Task task : this.getRootTask().getChildList()) {
            if (!task.isProject()) continue;
            for (Link link : task.getLinks()) {
                if (link.getUniqueId() != l) continue;
                return link;
            }
        }
        return null;
    }

    public Task getTaskForUniqueId(Task task, long l) {
        if (task.getUniqueId() == l) {
            return task;
        }
        for (Task task2 : task.getChildList()) {
            Task task3 = this.getTaskForUniqueId(task2, l);
            if (task3 == null) continue;
            return task3;
        }
        return null;
    }

    public Dependency getDependencyForUniqueId(long l) {
        return this.getDependencyForUniqueId(this.getRootTask(), l);
    }

    public Dependency getDependencyForUniqueId(Task task, long l) {
        for (Dependency mouseHoover : task.getSuccessorDependencies()) {
            if (mouseHoover.getUniqueId() != l) continue;
            return mouseHoover;
        }
        for (Task task2 : task.getChildList()) {
            Dependency dependency = this.getDependencyForUniqueId(task2, l);
            if (dependency == null) continue;
            return dependency;
        }
        return null;
    }

    public Client getClientForUniqueId(long l) {
        for (Client client : this.getClients()) {
            if (client.getUniqueId() != l) continue;
            return client;
        }
        return null;
    }

    public Assignment getAssignmentForUniqueId(long l) {
        for (HumanResource humanResource : this.getHumanResources()) {
            for (Assignment assignment : humanResource.assignments) {
                if (assignment.getUniqueId() != l) continue;
                return assignment;
            }
        }
        return null;
    }

    public CalendarManager getCalendarForUniqueId(long l) {
        for (CalendarManager calendarManager : this.getCalendarList()) {
            if (calendarManager.getUniqueId() != l) continue;
            return calendarManager;
        }
        return null;
    }

    public Contact getContactForUniqueId(long l) {
        return null;
    }

    public void addCompanyListener(CompanyListener companyListener) {
        this.listeners.add(CompanyListener.class, companyListener);
    }

    public void removeCompanyListener(CompanyListener companyListener) {
        this.listeners.remove(CompanyListener.class, companyListener);
    }

    private void fireCompanyChanged() {
        if (!this.LOADING) {
            CompanyEvent companyEvent = new CompanyEvent(this);
            EventListener[] eventListenerArray = this.listeners.getListeners(CompanyListener.class);
            int n = eventListenerArray.length;
            for (int i = 0; i < n; ++i) {
                ((CompanyListener)eventListenerArray[i]).companyChanged(companyEvent);
            }
        }
    }

    private void fireCalendarAdded(CalendarManager calendarManager) {
        if (!this.LOADING) {
            CompanyEvent companyEvent = new CompanyEvent((Object)this, calendarManager);
            EventListener[] eventListenerArray = this.listeners.getListeners(CompanyListener.class);
            int n = eventListenerArray.length;
            for (int i = 0; i < n; ++i) {
                ((CompanyListener)eventListenerArray[i]).calendarAdded(companyEvent);
            }
            this.setChanged(true);
        }
    }

    private void fireCalendarRemoved(CalendarManager calendarManager) {
        CompanyEvent companyEvent = new CompanyEvent((Object)this, calendarManager);
        EventListener[] eventListenerArray = this.listeners.getListeners(CompanyListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((CompanyListener)eventListenerArray[i]).calendarRemoved(companyEvent);
        }
        this.setChanged(true);
    }

    private void fireCurrentProjectChanged(Task task) {
        if (!this.LOADING) {
            CompanyEvent companyEvent = new CompanyEvent((Object)this, task);
            EventListener[] eventListenerArray = this.listeners.getListeners(CompanyListener.class);
            int n = eventListenerArray.length;
            for (int i = 0; i < n; ++i) {
                ((CompanyListener)eventListenerArray[i]).currentProjectChanged(companyEvent);
            }
        }
    }

    private void fireResourceAdded(Resource resource, int n) {
        if (!this.LOADING) {
            CompanyEvent companyEvent = new CompanyEvent((Object)this, resource, n);
            EventListener[] eventListenerArray = this.listeners.getListeners(CompanyListener.class);
            int n2 = eventListenerArray.length;
            for (int i = 0; i < n2; ++i) {
                ((CompanyListener)eventListenerArray[i]).resourceAdded(companyEvent);
            }
            this.setChanged(true);
        }
    }

    private void fireResourceRemoved(Resource resource, int n) {
        CompanyEvent companyEvent = new CompanyEvent((Object)this, resource, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(CompanyListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((CompanyListener)eventListenerArray[i]).resourceRemoved(companyEvent);
        }
        this.setChanged(true);
    }

    private void fireClientAdded(Client client, int n) {
        if (!this.LOADING) {
            CompanyEvent companyEvent = new CompanyEvent((Object)this, client, n);
            EventListener[] eventListenerArray = this.listeners.getListeners(CompanyListener.class);
            int n2 = eventListenerArray.length;
            for (int i = 0; i < n2; ++i) {
                ((CompanyListener)eventListenerArray[i]).clientAdded(companyEvent);
            }
            this.setChanged(true);
        }
    }

    private void fireClientRemoved(Client client, int n) {
        CompanyEvent companyEvent = new CompanyEvent((Object)this, client, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(CompanyListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((CompanyListener)eventListenerArray[i]).clientRemoved(companyEvent);
        }
        this.setChanged(true);
    }

    public Task getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(Task task) {
        this.currentTask = task;
        this.fireCurrentProjectChanged(task);
    }

    public Object clone() {
        try {
            Company company = (Company)super.clone();
            company.listeners = new EventListenerList();
            return company;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Common.logException("Error cloning company:", cloneNotSupportedException);
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public ConflictManager getConflictManager() {
        return this.conflictManager;
    }

    private void writeTasksIDs(Task task) {
        System.out.println(task + " : " + task.getUniqueId());
        for (Task task2 : task.getChildList()) {
            this.writeTasksIDs(task2);
        }
    }

    public void writeIDs() {
        Company company = this;
        System.out.println("TASKS ");
        this.writeTasksIDs(company.getRootTask());
        System.out.println("RISKS ");
        for (Task uniqueId : company.getRootTask().getChildList()) {
            if (!uniqueId.isProject()) continue;
            System.out.println("risks of child: " + uniqueId);
            for (Risk risk : uniqueId.getRisks()) {
                System.out.println("     " + risk.getUniqueId());
            }
        }
        System.out.println("LINKS ");
        for (Task task : company.getRootTask().getChildList()) {
            if (!task.isProject()) continue;
            System.out.println("links of child: " + task);
            for (Link link : task.getLinks()) {
                System.out.println("     " + link.getUniqueId());
            }
        }
        System.out.println("HumanResources");
        for (HumanResource humanResource : company.getHumanResources()) {
            System.out.println(humanResource + " : " + humanResource.getUniqueId());
            for (Assignment assignment : humanResource.getAssignments()) {
                System.out.println("    assignment : " + assignment.getUniqueId());
            }
        }
        System.out.println("MaterialResources");
        for (MaterialResource materialResource : company.getMaterialResources()) {
            System.out.println(materialResource + " : " + materialResource.getUniqueId());
        }
        System.out.println("Clients");
        for (Client client : company.getClients()) {
            System.out.println(client + " : " + client.getUniqueId());
            for (Contact contact : client.getContacts()) {
                System.out.println("     contact:" + contact.getUniqueId());
            }
        }
        System.out.println("Calendars");
        for (CalendarManager calendarManager : company.getCalendarList()) {
            System.out.println(calendarManager + " : " + calendarManager.getUniqueId());
        }
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
    }

    private class CalendarHandler
    implements CalendarManagerListener,
    Serializable {
        private CalendarHandler() {
        }

        public void dayWorkingPatternChanged(CalendarManagerEvent calendarManagerEvent) {
        }

        public void calendarChanged(CalendarManagerEvent calendarManagerEvent) {
            Company.this.rootTask.setProjectDirty();
        }

        public void nameChanged(CalendarManagerEvent calendarManagerEvent) {
        }
    }
}

