/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Contact;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.event.ClientEvent;
import com.sbs.jpm.core.event.ClientListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
implements Cloneable,
Serializable,
UniqueId {
    private String name;
    private String notes;
    private Long id;
    private String site;
    private String address;
    private String[] fields = new String[10];
    private Company owner;
    private Contact mainContact;
    private List<Contact> contacts;
    private EventListenerList listeners;
    private boolean empty;
    private long uniqueId;

    public Client(long l) {
        this.setUniqueId(l);
        this.empty = true;
        this.listeners = new EventListenerList();
        this.contacts = new LinkedList<Contact>();
    }

    private Client() {
        this(Long.MIN_VALUE);
    }

    protected void initEmptyClient() {
        if (this.name == null) {
            this.name = "";
        }
        if (this.notes == null) {
            this.notes = "";
        }
        if (this.site == null) {
            this.site = "";
        }
        if (this.address == null) {
            this.address = "";
        }
        this.empty = false;
        this.getOwner().computeClientId();
    }

    public void revertToEmpty() {
        this.empty = true;
        this.getOwner().computeClientId();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = new Long(l);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.empty) {
            this.initEmptyClient();
        }
        this.name = string;
        this.fireDataChanged();
    }

    public void setFieldAt(int n, String string) {
        if (this.empty) {
            this.initEmptyClient();
        }
        this.fields[n] = string;
        this.fireDataChanged();
    }

    public String getFieldAt(int n) {
        return this.fields[n];
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
    }

    public Company getOwner() {
        return this.owner;
    }

    public void setOwner(Company company) {
        this.owner = company;
    }

    public int getContactsNumber() {
        return this.contacts.size();
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public Contact getContactAt(int n) {
        return this.contacts.get(n);
    }

    public int getContactIndex(Contact contact) {
        return this.contacts.indexOf(contact);
    }

    public void addContact(Contact contact) {
        this.contacts.add(contact);
        contact.setOwner(this);
        this.computeContactId();
        this.fireContactAdded(contact, this.contacts.indexOf(contact));
    }

    public void removeContact(Contact contact) {
        if (this.mainContact != null && this.mainContact.equals(contact)) {
            this.setMainContact(null);
        }
        int n = this.contacts.indexOf(contact);
        this.contacts.remove(contact);
        this.computeContactId();
        this.fireContactRemoved(contact, n);
    }

    private void fireClientChanged() {
        this.empty = false;
        if (this.owner != null) {
            this.owner.setChanged(true);
        }
    }

    public void fireDataChanged() {
        ClientEvent clientEvent = new ClientEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(ClientListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((ClientListener)eventListenerArray[i]).dataChanged(clientEvent);
        }
        this.fireClientChanged();
    }

    private void fireContactAdded(Contact contact, int n) {
        ClientEvent clientEvent = new ClientEvent(this, contact, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(ClientListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((ClientListener)eventListenerArray[i]).contactAdded(clientEvent);
        }
        this.fireClientChanged();
    }

    private void fireContactRemoved(Contact contact, int n) {
        ClientEvent clientEvent = new ClientEvent(this, contact, n);
        EventListener[] eventListenerArray = this.listeners.getListeners(ClientListener.class);
        int n2 = eventListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            ((ClientListener)eventListenerArray[i]).contactRemoved(clientEvent);
        }
        this.fireClientChanged();
    }

    private void fireNotesChanged() {
        ClientEvent clientEvent = new ClientEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(ClientListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((ClientListener)eventListenerArray[i]).notesChanged(clientEvent);
        }
        this.fireClientChanged();
    }

    public void addClientListener(ClientListener clientListener) {
        this.listeners.add(ClientListener.class, clientListener);
    }

    public void removeClientListener(ClientListener clientListener) {
        this.listeners.remove(ClientListener.class, clientListener);
    }

    public String toString() {
        return this.name;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        if (this.empty) {
            this.initEmptyClient();
        }
        this.notes = string;
        this.fireNotesChanged();
    }

    public Object clone() {
        Client client = new Client();
        client.contacts = new LinkedList<Contact>();
        for (Contact contact : this.contacts) {
            client.contacts.add((Contact)contact.clone());
        }
        client.address = this.address;
        client.empty = this.empty;
        client.name = this.name;
        client.notes = this.notes;
        client.site = this.site;
        client.mainContact = null;
        client.listeners = new EventListenerList();
        client.owner = null;
        client.setUniqueId(Common.getIdGenerator().getNewId());
        return client;
    }

    public void setContacts(List<Contact> list) {
        this.contacts = list;
    }

    public Contact getMainContact() {
        return this.mainContact;
    }

    public void setMainContact(Contact contact) {
        if (this.empty) {
            this.initEmptyClient();
        }
        this.mainContact = contact;
        this.fireDataChanged();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        if (this.empty) {
            this.initEmptyClient();
        }
        this.address = string;
        this.fireDataChanged();
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String string) {
        if (this.empty) {
            this.initEmptyClient();
        }
        this.site = string;
        this.fireDataChanged();
    }

    public void computeContactId() {
        if (this.getOwner().isLoaded()) {
            long l = 1L;
            for (Contact contact : this.contacts) {
                contact.setId(l++);
            }
        }
    }

    @Override
    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }
}

