/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.Period;
import com.sbs.jpm.core.AllocationUnit;
import com.sbs.jpm.core.AssignmentUnit;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.undo.AssignmentAddEdit;
import com.sbs.jpm.undo.AssignmentRemoveEdit;
import com.sbs.jpm.undo.AssignmentUnitsEdit;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.CompoundEdit;

public class Assignment
implements Serializable,
UniqueId {
    Resource resource;
    private Task task;
    double units = 1.0;
    private List taskUnits;
    private List resourceUnits;
    private List allocationUnits;
    private long actualWork;
    private long actualStandardWork;
    private long actualOvertimeWork;
    private long remainingWork;
    private long remainingStandardWork;
    private long remainingOvertimeWork;
    private long overtimeWork;
    private long standardWork;
    private long overallocatedWork;
    private long intervalOvertimeWork;
    private long intervalStandardWork;
    private long intervalOverallocatedWork;
    private long intervalActualWork;
    private long intervalActualStandardWork;
    private long intervalActualOvertimeWork;
    private long intervalRemainingWork;
    private long intervalRemainingStandardWork;
    private long intervalRemainingOvertimeWork;
    public int assignmentUnitID;
    private long uniqueId;

    public Assignment(long l) {
        this(l, null, null);
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    public Assignment(long l, Task task, Resource resource, double d) {
        this.setUniqueId(l);
        this.task = task;
        this.resource = resource;
        this.units = d;
        this.taskUnits = new LinkedList();
        this.resourceUnits = new LinkedList();
        this.allocationUnits = new LinkedList();
    }

    public Assignment(long l, Task task, Resource resource) {
        HumanResource humanResource;
        this.setUniqueId(l);
        this.task = task;
        this.resource = resource;
        if (resource instanceof HumanResource && (humanResource = (HumanResource)resource).getMaxUnits() < 1.0) {
            this.units = humanResource.getMaxUnits();
        }
        this.taskUnits = new LinkedList();
        this.resourceUnits = new LinkedList();
        this.allocationUnits = new LinkedList();
    }

    public double getUnits() {
        return this.units;
    }

    public double getActualUnits() {
        return this.task.getCompletion() / 100.0 * this.units;
    }

    public double getRemainingUnits() {
        return (100.0 - this.task.getCompletion()) / 100.0 * this.units;
    }

    double getUnits(Date date, Date date2) {
        if (this.task.isMilestone()) {
            Date date3 = this.task.getStartDate();
            if (!date3.before(date) && date3.before(date2)) {
                return this.units;
            }
            return -1.0;
        }
        double d = this.task.getWorkingDuration(date, date2);
        if (d != 0.0) {
            return d / (double)this.task.getWorkingDuration() * this.units;
        }
        return -1.0;
    }

    double getActualUnits(Date date, Date date2) {
        if (this.task.isMilestone()) {
            Date date3 = this.task.getStartDate();
            if (!date3.before(date) && date3.before(date2)) {
                return this.units;
            }
            return -1.0;
        }
        double d = (double)this.task.getWorkingDuration(date, date2) * this.units;
        if (d != 0.0) {
            Date date4 = this.task.getCompletionDate();
            if (date4.before(date)) {
                return -1.0;
            }
            d = date4.before(date2) ? (double)this.task.getWorkingDuration(date, date4) : (double)this.task.getWorkingDuration(date, date2);
            if (d != 0.0) {
                return d / (double)this.task.getWorkingDuration() * this.units;
            }
            return -1.0;
        }
        return -1.0;
    }

    double getRemainingUnits(Date date, Date date2) {
        if (this.task.isMilestone()) {
            Date date3 = this.task.getStartDate();
            if (!date3.before(date) && date3.before(date2)) {
                return this.units;
            }
            return 0.0;
        }
        double d = (double)this.task.getWorkingDuration(date, date2) * this.units;
        if (d != 0.0) {
            Date date4 = this.task.getCompletionDate();
            if (date4.after(date2)) {
                return -1.0;
            }
            d = date4.after(date) ? (double)this.task.getWorkingDuration(date4, date2) : (double)this.task.getWorkingDuration(date, date2);
            if (d != 0.0) {
                return d / (double)this.task.getWorkingDuration() * this.units;
            }
            return -1.0;
        }
        return -1.0;
    }

    public void setUnits(double d, CompoundEdit compoundEdit) {
        AssignmentUnitsEdit assignmentUnitsEdit = new AssignmentUnitsEdit(this, this.getUnits(), d, "15-09-09 15:14:00");
        this.setUnits(d);
        compoundEdit.addEdit(assignmentUnitsEdit);
    }

    public void setUnits(double d) {
        this.units = d;
        this.task.setDirty(true, false);
        this.resource.fireDataChanged();
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        HumanResource humanResource;
        if (this.resource != null) {
            this.resource.removeAssignment(this);
        }
        this.resource = resource;
        if (resource instanceof HumanResource && (humanResource = (HumanResource)resource).getMaxUnits() < 1.0) {
            this.units = humanResource.getMaxUnits();
        }
        resource.addAssignment(this);
        if (this.task != null) {
            this.task.fireDataChanged();
        }
    }

    public void assignIt(CompoundEdit compoundEdit) {
        AssignmentAddEdit assignmentAddEdit = new AssignmentAddEdit(this, "15-09-09 15:16:00");
        this.task.addAssignment(this);
        this.resource.addAssignment(this);
        compoundEdit.addEdit(assignmentAddEdit);
    }

    public void discard(CompoundEdit compoundEdit) {
        AssignmentRemoveEdit assignmentRemoveEdit = new AssignmentRemoveEdit(this, this.task.getAssignmentIndex(this), this.resource.getAssignmentIndex(this), "15-09-09 15:15:00");
        this.task.removeAssignment(this);
        this.resource.removeAssignment(this);
        compoundEdit.addEdit(assignmentRemoveEdit);
    }

    public void replaceResource(Resource resource, boolean bl) {
        if (this.resource != null) {
            this.resource.removeAssignment(this);
        }
        this.resource = resource;
        resource.addAssignment(this);
        if (this.task != null) {
            this.task.fireDataChanged();
        }
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        if (this.task != null) {
            this.task.removeAssignment(this);
        }
        this.task = task;
        task.addAssignment(this);
        if (this.resource != null) {
            this.resource.fireDataChanged();
        }
    }

    public String toString() {
        return this.task.getName();
    }

    public void start(Date date, Date date2, Date date3) {
        if (this.getResource() instanceof HumanResource) {
            AllocationUnit allocationUnit;
            this.taskUnits.clear();
            this.resourceUnits.clear();
            this.allocationUnits.clear();
            LinkedList<Long> linkedList = new LinkedList<Long>();
            Task task = this.getTask();
            HumanResource humanResource = (HumanResource)this.getResource();
            CalendarManager calendarManager = task.getUsedCalendar();
            List list = calendarManager.getPeriods(date, date2);
            calendarManager = humanResource.getResourceCalendar();
            List list2 = calendarManager.getPeriods(date, date2);
            for (Period period : list) {
                if (!period.getType()) continue;
                allocationUnit = new AllocationUnit();
                allocationUnit.startDate = period.getStartPeriod();
                allocationUnit.endDate = period.getEndPeriod();
                allocationUnit.value = allocationUnit.endDate - allocationUnit.startDate;
                this.taskUnits.add(allocationUnit);
                linkedList.add(allocationUnit.startDate);
                linkedList.add(allocationUnit.endDate);
            }
            for (Period period : list2) {
                if (!period.getType()) continue;
                allocationUnit = new AllocationUnit();
                allocationUnit.startDate = period.getStartPeriod();
                allocationUnit.endDate = period.getEndPeriod();
                allocationUnit.value = allocationUnit.endDate - allocationUnit.startDate;
                this.resourceUnits.add(allocationUnit);
                linkedList.add(allocationUnit.startDate);
                linkedList.add(allocationUnit.endDate);
            }
            linkedList.add(task.getCompletionDate().getTime());
            Collections.sort(linkedList);
            for (int i = 0; i < linkedList.size() - 1; ++i) {
                Object object;
                long l;
                long l2;
                long l3 = (Long)linkedList.get(i);
                long l4 = (Long)linkedList.get(i + 1);
                double d = 0.0;
                double d2 = 0.0;
                for (AllocationUnit allocationUnit2 : this.taskUnits) {
                    if (l3 >= allocationUnit2.endDate) continue;
                    if (l4 <= allocationUnit2.startDate) break;
                    l2 = l4 < allocationUnit2.endDate ? l4 : allocationUnit2.endDate;
                    l = l3 > allocationUnit2.startDate ? l3 : allocationUnit2.startDate;
                    d += (double)(l2 - l) * this.units;
                }
                for (AllocationUnit allocationUnit2 : this.resourceUnits) {
                    if (l3 >= allocationUnit2.endDate) continue;
                    if (l4 <= allocationUnit2.startDate) break;
                    l2 = l4 < allocationUnit2.endDate ? l4 : allocationUnit2.endDate;
                    l = l3 > allocationUnit2.startDate ? l3 : allocationUnit2.startDate;
                    d2 += (double)(l2 - l) * this.units;
                }
                if (d != 0.0) {
                    if (d2 == 0.0) {
                        object = new AssignmentUnit(this);
                        ((AssignmentUnit)object).setType(1);
                        ((AssignmentUnit)object).startDate = l3;
                        ((AssignmentUnit)object).endDate = l4;
                        ((AssignmentUnit)object).value = ((AssignmentUnit)object).endDate - ((AssignmentUnit)object).startDate;
                        ((AssignmentUnit)object).units = this.units;
                        this.allocationUnits.add(object);
                        continue;
                    }
                    object = new AssignmentUnit(this);
                    ((AssignmentUnit)object).setType(2);
                    ((AssignmentUnit)object).startDate = l3;
                    ((AssignmentUnit)object).endDate = l4;
                    ((AssignmentUnit)object).value = ((AssignmentUnit)object).endDate - ((AssignmentUnit)object).startDate;
                    ((AssignmentUnit)object).units = this.units;
                    this.allocationUnits.add(object);
                    continue;
                }
                if (d2 == 0.0) continue;
                object = new AssignmentUnit(this);
                ((AssignmentUnit)object).setType(0);
                ((AssignmentUnit)object).startDate = l3;
                ((AssignmentUnit)object).endDate = l4;
                ((AssignmentUnit)object).value = ((AssignmentUnit)object).endDate - ((AssignmentUnit)object).startDate;
                ((AssignmentUnit)object).units = this.units;
                this.allocationUnits.add(object);
            }
            this.computeTotalWork(date, date2, date3);
        }
    }

    private void computeTotalWork(Date date, Date date2, Date date3) {
        this.overtimeWork = 0L;
        this.standardWork = 0L;
        this.overallocatedWork = 0L;
        for (int i = 0; i < this.allocationUnits.size(); ++i) {
            AssignmentUnit assignmentUnit = (AssignmentUnit)this.allocationUnits.get(i);
            double d = 0.0;
            double d2 = 0.0;
            if (assignmentUnit.getType() == 1) {
                d += (double)assignmentUnit.value * this.units;
            } else if (assignmentUnit.getType() == 0) {
                d2 += (double)assignmentUnit.value * this.units;
            } else if (assignmentUnit.getType() == 2) {
                d += (double)assignmentUnit.value * this.units;
                d2 += (double)assignmentUnit.value * this.units;
            }
            if (this.getTask().isForcedWorking()) {
                if (d != 0.0 && d > (double)assignmentUnit.value * ((HumanResource)this.getResource()).getMaxUnits()) {
                    this.overallocatedWork = (long)((double)this.overallocatedWork + (d - (double)assignmentUnit.value * ((HumanResource)this.getResource()).getMaxUnits()));
                }
                if (d != 0.0 && d2 == 0.0) {
                    this.overtimeWork = (long)((double)this.overtimeWork + d);
                    continue;
                }
                this.standardWork = (long)((double)this.standardWork + d);
                continue;
            }
            if (d != 0.0) {
                this.standardWork = (long)((double)this.standardWork + d2);
            }
            if (d == 0.0 || d2 == 0.0 || !(d > (double)assignmentUnit.value * ((HumanResource)this.getResource()).getMaxUnits())) continue;
            this.overallocatedWork = (long)((double)this.overallocatedWork + (d - (double)assignmentUnit.value * ((HumanResource)this.getResource()).getMaxUnits()));
        }
        this.computeWork(date, date3, date3);
        this.actualWork = this.intervalActualWork;
        this.actualStandardWork = this.intervalActualStandardWork;
        this.actualOvertimeWork = this.intervalActualOvertimeWork;
        this.computeWork(date3, date2, date3);
        this.remainingWork = this.intervalRemainingWork;
        this.remainingStandardWork = this.intervalRemainingStandardWork;
        this.remainingOvertimeWork = this.intervalRemainingOvertimeWork;
    }

    public long getOvertimeWork() {
        return this.overtimeWork;
    }

    public long getStandardWork() {
        return this.standardWork;
    }

    public long getWork() {
        return this.getStandardWork() + this.getOvertimeWork();
    }

    long getIntervalOvertimeWork() {
        return this.intervalOvertimeWork;
    }

    public long getIntervalStandardWork() {
        return this.intervalStandardWork;
    }

    long getIntervalOverallocatedWork() {
        return this.intervalOverallocatedWork;
    }

    long getIntervalActualWork() {
        return this.intervalActualWork;
    }

    public long getIntervalRemainingWork() {
        return this.intervalRemainingWork;
    }

    public void computeWork(Date date, Date date2, Date date3) {
        this.intervalStandardWork = 0L;
        this.intervalOvertimeWork = 0L;
        this.intervalOverallocatedWork = 0L;
        this.intervalActualWork = 0L;
        this.intervalActualStandardWork = 0L;
        this.intervalActualOvertimeWork = 0L;
        this.intervalRemainingWork = 0L;
        this.intervalRemainingStandardWork = 0L;
        this.intervalRemainingOvertimeWork = 0L;
        long l = date3.getTime();
        for (int i = 0; i < this.allocationUnits.size(); ++i) {
            AssignmentUnit assignmentUnit = (AssignmentUnit)this.allocationUnits.get(i);
            long l2 = assignmentUnit.startDate;
            long l3 = assignmentUnit.endDate;
            double d = 0.0;
            double d2 = 0.0;
            if (l2 > date2.getTime() || l3 < date.getTime()) continue;
            l3 = l3 < date2.getTime() ? l3 : date2.getTime();
            long l4 = l2 = l2 > date.getTime() ? l2 : date.getTime();
            if (assignmentUnit.getType() == 1) {
                d += (double)(l3 - l2) * this.units;
            } else if (assignmentUnit.getType() == 0) {
                d2 += (double)(l3 - l2) * this.units;
            } else if (assignmentUnit.getType() == 2) {
                d += (double)(l3 - l2) * this.units;
                d2 += (double)(l3 - l2) * this.units;
            }
            if (this.getTask().isForcedWorking()) {
                if (d != 0.0 && d > (double)(l3 - l2) * ((HumanResource)this.getResource()).getMaxUnits()) {
                    this.intervalOverallocatedWork = (long)((double)this.intervalOverallocatedWork + (d - (double)(l3 - l2) * ((HumanResource)this.getResource()).getMaxUnits()));
                }
                if (d != 0.0 && d2 == 0.0) {
                    this.intervalOvertimeWork = (long)((double)this.intervalOvertimeWork + d);
                    if (l >= l3) {
                        this.intervalActualOvertimeWork = (long)((double)this.intervalActualOvertimeWork + d);
                    } else {
                        this.intervalRemainingOvertimeWork = (long)((double)this.intervalRemainingOvertimeWork + d);
                    }
                } else {
                    this.intervalStandardWork = (long)((double)this.intervalStandardWork + d);
                    if (l >= l3) {
                        this.intervalActualStandardWork = (long)((double)this.intervalActualStandardWork + d);
                    } else {
                        this.intervalRemainingStandardWork = (long)((double)this.intervalRemainingStandardWork + d);
                    }
                }
                if (l >= l3) {
                    this.intervalActualWork = (long)((double)this.intervalActualWork + d);
                    continue;
                }
                this.intervalRemainingWork = (long)((double)this.intervalRemainingWork + d);
                continue;
            }
            if (d != 0.0) {
                this.intervalStandardWork = (long)((double)this.intervalStandardWork + d2);
                if (l >= l3) {
                    this.intervalActualStandardWork = (long)((double)this.intervalActualStandardWork + d2);
                } else {
                    this.intervalRemainingStandardWork = (long)((double)this.intervalRemainingStandardWork + d2);
                }
            }
            if (l >= l3) {
                this.intervalActualWork = (long)((double)this.intervalActualWork + d2);
            } else {
                this.intervalRemainingWork = (long)((double)this.intervalRemainingWork + d2);
            }
            if (d == 0.0 || d2 == 0.0 || !(d > (double)(l3 - l2) * ((HumanResource)this.getResource()).getMaxUnits())) continue;
            this.intervalOverallocatedWork = (long)((double)this.intervalOverallocatedWork + (d - (double)(l3 - l2) * ((HumanResource)this.getResource()).getMaxUnits()));
        }
    }

    public long getOverallocatedWork() {
        return this.overallocatedWork;
    }

    public List getTaskUnits() {
        return this.taskUnits;
    }

    public List getAllocationUnits() {
        return this.allocationUnits;
    }

    public List getResourceUnits() {
        return this.resourceUnits;
    }

    public long getIntervalActualOvertimeWork() {
        return this.intervalActualOvertimeWork;
    }

    public long getIntervalActualStandardWork() {
        return this.intervalActualStandardWork;
    }

    public long getIntervalRemainingOvertimeWork() {
        return this.intervalRemainingOvertimeWork;
    }

    public long getIntervalRemainingStandardWork() {
        return this.intervalRemainingStandardWork;
    }

    public long getActualWork() {
        return this.actualWork;
    }

    public long getRemainingWork() {
        return this.remainingWork;
    }

    public long getActualOvertimeWork() {
        return this.actualOvertimeWork;
    }

    public long getActualStandardWork() {
        return this.actualStandardWork;
    }

    public long getRemainingOvertimeWork() {
        return this.remainingOvertimeWork;
    }

    public long getRemainingStandardWork() {
        return this.remainingStandardWork;
    }
}

