/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.configuration;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationIO;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.configuration.serializer.StringSerializer;
import com.sbs.jpm.configuration.serializer.StringSerializerManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class ConfigurationIOProperties
implements ConfigurationIO {
    public void store(Configuration configuration, OutputStream outputStream) {
        Properties properties = new Properties();
        StringSerializerManager stringSerializerManager = StringSerializerManager.getInstance();
        for (int i = ConfigurationSetting.SETTINGS.length - 1; i >= 0; --i) {
            ConfigurationSetting configurationSetting = ConfigurationSetting.SETTINGS[i];
            StringSerializer stringSerializer = stringSerializerManager.getSerializer(configurationSetting.getType());
            Object object = configuration.getValue(configurationSetting);
            properties.put(configurationSetting.getName(), stringSerializer.serialize(object));
        }
        try {
            properties.store(outputStream, null);
        }
        catch (IOException iOException) {
            Common.logException("Error:", iOException);
        }
    }

    public void load(Configuration configuration, InputStream inputStream) {
        Properties properties = new Properties();
        StringSerializerManager stringSerializerManager = StringSerializerManager.getInstance();
        try {
            properties.load(inputStream);
            for (int i = ConfigurationSetting.SETTINGS.length - 1; i >= 0; --i) {
                ConfigurationSetting configurationSetting = ConfigurationSetting.SETTINGS[i];
                String string = (String)properties.get(configurationSetting.getName());
                if (string == null) continue;
                StringSerializer stringSerializer = stringSerializerManager.getSerializer(configurationSetting.getType());
                configuration.setValue(configurationSetting, stringSerializer.deserialize(string));
            }
        }
        catch (IOException iOException) {
            Common.logException("Error:", iOException);
        }
    }
}

