/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.common.IDsGenerator;

import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.common.IDsGenerator.IDGeneratorInterface;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Contact;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.Task;

public class IDGenerator
implements IDGeneratorInterface {
    private long crtID = 0L;
    private boolean direction;

    public IDGenerator(boolean bl) {
        this.direction = bl;
    }

    public void setCompany(Company company) {
        if (company.getRootTask().getUniqueId() != Long.MIN_VALUE) {
            System.out.println("IDs already available");
            this.crtID = this.getNextUniqId(company, this.direction ? Long.MAX_VALUE : Long.MIN_VALUE);
            company.writeIDs();
            System.out.println("next min: " + this.crtID);
        } else {
            System.out.println("generating IDs");
            this.assignIDs(company);
            company.writeIDs();
            System.out.println("next min: " + this.crtID);
        }
    }

    public long getNewId() {
        if (this.direction) {
            return --this.crtID;
        }
        return ++this.crtID;
    }

    private boolean compareIDs(long l, long l2) {
        if (l < l2) {
            return this.direction;
        }
        return !this.direction;
    }

    private long getTaskNextUniqId(Task task, long l) {
        long l2 = l;
        for (Task task2 : task.getChildList()) {
            l2 = this.getTaskNextUniqId(task2, l2);
        }
        if (this.compareIDs(task.getUniqueId(), l2)) {
            l2 = task.getUniqueId();
        }
        return l2;
    }

    private long getNextUniqId(Company company, long l) {
        long l2 = l;
        l2 = this.getTaskNextUniqId(company.getRootTask(), l2);
        for (Task uniqueId : company.getRootTask().getChildList()) {
            if (!uniqueId.isProject()) continue;
            for (Risk risk : uniqueId.getRisks()) {
                if (!this.compareIDs(risk.getUniqueId(), l2)) continue;
                l2 = risk.getUniqueId();
            }
        }
        for (Task task : company.getRootTask().getChildList()) {
            if (!task.isProject()) continue;
            for (Link link : task.getLinks()) {
                if (!this.compareIDs(link.getUniqueId(), l2)) continue;
                l2 = link.getUniqueId();
            }
        }
        for (HumanResource humanResource : company.getHumanResources()) {
            if (!this.compareIDs(humanResource.getUniqueId(), l2)) continue;
            l2 = humanResource.getUniqueId();
        }
        for (MaterialResource materialResource : company.getMaterialResources()) {
            if (this.compareIDs(materialResource.getUniqueId(), l2)) {
                l2 = materialResource.getUniqueId();
            }
            for (Assignment assignment : materialResource.getAssignments()) {
                if (!this.compareIDs(assignment.getUniqueId(), l2)) continue;
                l2 = materialResource.getUniqueId();
            }
        }
        for (Client client : company.getClients()) {
            if (this.compareIDs(client.getUniqueId(), l2)) {
                l2 = client.getUniqueId();
            }
            for (Contact contact : client.getContacts()) {
                if (!this.compareIDs(contact.getUniqueId(), l2)) continue;
                l2 = contact.getUniqueId();
            }
        }
        for (CalendarManager calendarManager : company.getCalendarList()) {
            if (!this.compareIDs(calendarManager.getUniqueId(), l2)) continue;
            l2 = calendarManager.getUniqueId();
        }
        return l2;
    }

    private void assignTasksIDs(Task task) {
        task.uniqueID = this.getNewId();
        for (Task task2 : task.getChildList()) {
            this.assignTasksIDs(task2);
        }
    }

    private void assignIDs(Company company) {
        this.assignTasksIDs(company.getRootTask());
        for (Task uniqueId : company.getRootTask().getChildList()) {
            if (!uniqueId.isProject()) continue;
            for (Risk risk : uniqueId.getRisks()) {
                risk.setUniqueId(this.getNewId());
            }
        }
        for (Task task : company.getRootTask().getChildList()) {
            if (!task.isProject()) continue;
            for (Link link : task.getLinks()) {
                link.setUniqueId(this.getNewId());
            }
        }
        for (HumanResource humanResource : company.getHumanResources()) {
            for (Assignment assignment : humanResource.getAssignments()) {
                assignment.setUniqueId(this.getNewId());
            }
            humanResource.setUniqueId(this.getNewId());
        }
        for (MaterialResource materialResource : company.getMaterialResources()) {
            materialResource.setUniqueId(this.getNewId());
        }
        for (Client client : company.getClients()) {
            client.setUniqueId(this.getNewId());
            for (Contact contact : client.getContacts()) {
                contact.setUniqueId(this.getNewId());
            }
        }
        for (CalendarManager calendarManager : company.getCalendarList()) {
            calendarManager.setUniqueId(this.getNewId());
        }
    }
}

