/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.calendar;

import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.core.HumanResource;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCalendarManager
extends CalendarManager {
    private HumanResource resource;
    private List<CalendarManager.SpecialDay> resourcePatternList;

    public ResourceCalendarManager(HumanResource humanResource) {
        super(Long.MIN_VALUE);
        this.resource = humanResource;
        this.resourcePatternList = new LinkedList<CalendarManager.SpecialDay>();
    }

    @Override
    public String getName() {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        return calendarManager.getName();
    }

    @Override
    public Long getId() {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        return calendarManager.getId();
    }

    @Override
    public PeriodInDay[] getWorkingPeriods() {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        return calendarManager.getWorkingPeriods();
    }

    @Override
    public DayWorkingPattern getWorkingPattern() {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        return calendarManager.getWorkingPattern();
    }

    @Override
    public DayWorkingPattern getNonWorkingPattern() {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        return calendarManager.getNonWorkingPattern();
    }

    @Override
    protected DayWorkingPattern getDayPattern(Calendar calendar) {
        for (CalendarManager.SpecialDay object2 : this.resourcePatternList) {
            if (object2.getDate().get(1) != calendar.get(1) || object2.getDate().get(6) != calendar.get(6)) continue;
            return object2.getDayPattern();
        }
        List<CalendarManager.SpecialDay> list = this.resource.getUsedCalendar().specialPatternList;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CalendarManager.SpecialDay specialDay = (CalendarManager.SpecialDay)iterator.next();
            if (specialDay.getDate().get(1) != calendar.get(1) || specialDay.getDate().get(6) != calendar.get(6)) continue;
            return specialDay.getDayPattern();
        }
        return this.getDayPattern(calendar.get(7));
    }

    @Override
    public void setDayPattern(int n, DayWorkingPattern dayWorkingPattern) {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        calendarManager.setDayPattern(n, dayWorkingPattern);
    }

    @Override
    public void removeDayPattern(Calendar calendar) {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        calendarManager.removeDayPattern(calendar);
    }

    @Override
    public DayWorkingPattern getSpecialDayPattern(Calendar calendar) {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        return calendarManager.getSpecialDayPattern(calendar);
    }

    @Override
    public DayWorkingPattern getDayPattern(int n) {
        CalendarManager calendarManager = this.resource.getUsedCalendar();
        return calendarManager.getDayPattern(n);
    }

    public DayWorkingPattern getResourceDayPattern(Calendar calendar) {
        for (CalendarManager.SpecialDay specialDay : this.resourcePatternList) {
            if (specialDay.getDate().get(1) != calendar.get(1) || specialDay.getDate().get(6) != calendar.get(6)) continue;
            return specialDay.getDayPattern();
        }
        return null;
    }

    public List<CalendarManager.SpecialDay> getResourcePatternList() {
        return this.resourcePatternList;
    }

    public void setResourceDayPattern(Calendar calendar, DayWorkingPattern dayWorkingPattern) {
        for (CalendarManager.SpecialDay specialDay : this.resourcePatternList) {
            if (specialDay.getDate().get(1) != calendar.get(1) || specialDay.getDate().get(6) != calendar.get(6)) continue;
            specialDay.setDayPattern(dayWorkingPattern);
            return;
        }
        CalendarManager.SpecialDay specialDay = new CalendarManager.SpecialDay();
        specialDay.setDate((Calendar)calendar.clone());
        specialDay.setDayPattern(dayWorkingPattern);
        this.resourcePatternList.add(specialDay);
        dayWorkingPattern.setOwner(this);
        this.resource.fireDataChanged();
    }

    public void removeResourceDayPattern(Calendar calendar) {
        CalendarManager.SpecialDay[] specialDayArray = this.resourcePatternList.toArray(new CalendarManager.SpecialDay[0]);
        for (int i = 0; i < specialDayArray.length; ++i) {
            CalendarManager.SpecialDay specialDay = specialDayArray[i];
            if (specialDay.getDate().get(1) != calendar.get(1) || specialDay.getDate().get(6) != calendar.get(6)) continue;
            this.resourcePatternList.remove(specialDay);
            this.resource.fireDataChanged();
        }
    }

    public void setResource(HumanResource humanResource) {
        this.resource = humanResource;
    }

    public HumanResource getResource() {
        return this.resource;
    }

    public void setResourcePatternList(List<CalendarManager.SpecialDay> list) {
        this.resourcePatternList = list;
    }
}

