/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.calendar;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.InvalidOperationException;
import java.io.Serializable;

public class PeriodInDay
implements Serializable,
Cloneable {
    boolean working;
    long startPeriod;
    long endPeriod;

    public PeriodInDay(boolean bl, long l, long l2) throws InvalidOperationException {
        this.working = bl;
        if (l < 0L) {
            throw new InvalidOperationException(Common.I18N_MESSAGES.getString("periodInDay.startLessThanZero"));
        }
        if (l2 <= l) {
            throw new InvalidOperationException(Common.I18N_MESSAGES.getString("periodInDay.startGreaterEqualEnd"));
        }
        if (l2 > 86400000L) {
            throw new InvalidOperationException(Common.I18N_MESSAGES.getString("periodInDay.endExceedsDay"));
        }
        this.startPeriod = l;
        this.endPeriod = l2;
    }

    public boolean isWorking() {
        return this.working;
    }

    public long getDuration() {
        return this.endPeriod - this.startPeriod;
    }

    public long getEndPeriod() {
        return this.endPeriod;
    }

    public long getStartPeriod() {
        return this.startPeriod;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof PeriodInDay) {
            PeriodInDay periodInDay = (PeriodInDay)object;
            if (this.startPeriod != periodInDay.getStartPeriod()) {
                return false;
            }
            if (this.endPeriod != periodInDay.getEndPeriod()) {
                return false;
            }
            if (this.working != periodInDay.isWorking()) {
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        try {
            PeriodInDay periodInDay = new PeriodInDay(this.working, this.startPeriod, this.endPeriod);
            return periodInDay;
        }
        catch (InvalidOperationException invalidOperationException) {
            return null;
        }
    }
}

