/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.calendar;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.core.InvalidOperationException;

public class FullTimeCalendarManager
extends CalendarManager {
    private static final DayWorkingPattern workingPattern = FullTimeCalendarManager.createWorkingPattern();
    private static final DayWorkingPattern nonWorkingPattern = FullTimeCalendarManager.createNonWorkingPattern();

    public FullTimeCalendarManager(long l) {
        super(l);
    }

    private static final DayWorkingPattern createWorkingPattern() {
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        try {
            PeriodInDay periodInDay = new PeriodInDay(true, 0L, 86400000L);
            dayWorkingPattern.addAlternance(periodInDay);
            dayWorkingPattern.fillWithWorking();
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
        }
        return dayWorkingPattern;
    }

    private static final DayWorkingPattern createNonWorkingPattern() {
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        try {
            PeriodInDay periodInDay = new PeriodInDay(false, 0L, 86400000L);
            dayWorkingPattern.addAlternance(periodInDay);
            dayWorkingPattern.fillWithNonWorking();
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
        }
        return dayWorkingPattern;
    }

    public PeriodInDay[] getWorkingPeriods() {
        return workingPattern.getPeriodsInDay();
    }

    public DayWorkingPattern getWorkingPattern() {
        return (DayWorkingPattern)workingPattern.clone();
    }

    public DayWorkingPattern getNonWorkingPattern() {
        return (DayWorkingPattern)nonWorkingPattern.clone();
    }
}

