/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.calendar;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.calendar.RemainingDuration;
import com.sbs.jpm.calendar.event.DayWorkingPatternEvent;
import com.sbs.jpm.calendar.event.DayWorkingPatternListener;
import com.sbs.jpm.core.InvalidOperationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DayWorkingPattern
implements Cloneable,
Serializable {
    private List temporarAlternanceList = new ArrayList();
    private PeriodInDay[] periods;
    private long totalWorkingDuration = 0L;
    private CalendarManager owner;
    private EventListenerList listeners = new EventListenerList();

    public CalendarManager getOwner() {
        return this.owner;
    }

    public void setOwner(CalendarManager calendarManager) {
        this.owner = calendarManager;
    }

    public void firePatternChanged() {
        if (this.owner != null) {
            this.owner.fireCalendarChanged();
        }
    }

    public boolean isWorking() {
        for (int i = 0; i < this.periods.length; ++i) {
            PeriodInDay periodInDay = this.periods[i];
            if (!periodInDay.isWorking()) continue;
            return true;
        }
        return false;
    }

    public void setWorking(boolean bl) {
        this.temporarAlternanceList.clear();
        this.fillWithNonWorking();
        if (bl) {
            PeriodInDay[] periodInDayArray = this.owner.getWorkingPeriods();
            for (int i = 0; i < periodInDayArray.length; ++i) {
                this.addAlternance(periodInDayArray[i]);
            }
        }
    }

    public PeriodInDay[] getPeriodsInDay() {
        return this.periods;
    }

    public PeriodInDay getPeriodInDayAt(int n) {
        return this.periods[n];
    }

    public void fillAs(DayWorkingPattern dayWorkingPattern) {
        PeriodInDay[] periodInDayArray = dayWorkingPattern.getPeriodsInDay();
        this.periods = new PeriodInDay[periodInDayArray.length];
        for (int i = 0; i < periodInDayArray.length; ++i) {
            PeriodInDay periodInDay;
            this.periods[i] = periodInDay = periodInDayArray[i];
        }
        this.totalWorkingDuration = dayWorkingPattern.getTotalWorkingDuration();
    }

    public void addAlternance(PeriodInDay periodInDay) {
        PeriodInDay periodInDay2;
        int n;
        for (n = 0; n < this.temporarAlternanceList.size(); ++n) {
            periodInDay2 = (PeriodInDay)this.temporarAlternanceList.get(n);
            if (periodInDay2.isWorking()) continue;
            this.temporarAlternanceList.remove(periodInDay2);
        }
        if (this.temporarAlternanceList.size() == 0) {
            this.temporarAlternanceList.add(periodInDay);
            this.fillWithNonWorking();
            return;
        }
        for (n = 0; n < this.temporarAlternanceList.size(); ++n) {
            periodInDay2 = (PeriodInDay)this.temporarAlternanceList.get(n);
            if (periodInDay.startPeriod <= periodInDay2.startPeriod) {
                if (periodInDay.endPeriod > periodInDay2.startPeriod) {
                    throw new RuntimeException("Alternance overlap.");
                }
                this.temporarAlternanceList.add(n, periodInDay);
                this.fillWithNonWorking();
                return;
            }
            if (periodInDay.startPeriod >= periodInDay2.endPeriod) continue;
            throw new RuntimeException("Alternance overlap.");
        }
        this.temporarAlternanceList.add(periodInDay);
        this.fillWithNonWorking();
    }

    public void removeAlternance(PeriodInDay periodInDay) {
        this.temporarAlternanceList.remove(periodInDay);
        for (int i = 0; i < this.temporarAlternanceList.size(); ++i) {
            PeriodInDay periodInDay2 = (PeriodInDay)this.temporarAlternanceList.get(i);
            if (periodInDay2.isWorking()) continue;
            this.temporarAlternanceList.remove(periodInDay2);
        }
        this.fillWithNonWorking();
    }

    public void replaceAlternance(PeriodInDay periodInDay, PeriodInDay periodInDay2) {
        this.temporarAlternanceList.remove(periodInDay);
        for (int i = 0; i < this.temporarAlternanceList.size(); ++i) {
            PeriodInDay periodInDay3 = (PeriodInDay)this.temporarAlternanceList.get(i);
            if (periodInDay3.isWorking()) continue;
            this.temporarAlternanceList.remove(periodInDay3);
        }
        this.addAlternance(periodInDay2);
    }

    public long getFirstDayTime(long l, boolean bl) {
        return this.getFirstDayTime(l, bl, true);
    }

    public long getFirstDayTime(long l, boolean bl, boolean bl2) {
        if (bl2) {
            for (int i = 0; i < this.periods.length; ++i) {
                PeriodInDay periodInDay = this.periods[i];
                if (periodInDay.isWorking() != bl || l >= periodInDay.endPeriod) continue;
                if (l >= periodInDay.startPeriod) {
                    return l;
                }
                return periodInDay.startPeriod;
            }
            return -1L;
        }
        for (int i = this.periods.length - 1; i >= 0; --i) {
            PeriodInDay periodInDay = this.periods[i];
            if (periodInDay.isWorking() != bl || l <= periodInDay.startPeriod) continue;
            if (l <= periodInDay.endPeriod) {
                return l;
            }
            return periodInDay.endPeriod;
        }
        return -1L;
    }

    public void fillWithWorking() {
        this.fillAlternance(true);
        this.fireDayWorkingPatternChanged();
    }

    public void fillWithNonWorking() {
        this.fillAlternance(false);
        this.fireDayWorkingPatternChanged();
    }

    public long getTotalWorkingDuration() {
        return this.totalWorkingDuration;
    }

    public long getTotalNonWorkingDuration() {
        return 86400000L - this.totalWorkingDuration;
    }

    private void fillAlternance(boolean bl) {
        try {
            ArrayList<PeriodInDay> arrayList = new ArrayList<PeriodInDay>();
            long l = 0L;
            this.totalWorkingDuration = 0L;
            for (int i = 0; i < this.temporarAlternanceList.size(); ++i) {
                PeriodInDay periodInDay = (PeriodInDay)this.temporarAlternanceList.get(i);
                if (periodInDay.isWorking()) {
                    this.totalWorkingDuration += periodInDay.getDuration();
                }
                if (l < periodInDay.startPeriod) {
                    PeriodInDay periodInDay2 = new PeriodInDay(bl, l, periodInDay.startPeriod);
                    arrayList.add(periodInDay2);
                    if (periodInDay2.isWorking()) {
                        this.totalWorkingDuration += periodInDay2.getDuration();
                    }
                    arrayList.add(periodInDay);
                } else {
                    arrayList.add(periodInDay);
                }
                l = periodInDay.endPeriod;
            }
            if (l < 86400000L) {
                PeriodInDay periodInDay = new PeriodInDay(bl, l, 86400000L);
                arrayList.add(periodInDay);
                if (periodInDay.isWorking()) {
                    this.totalWorkingDuration += periodInDay.getDuration();
                }
            }
            this.periods = new PeriodInDay[arrayList.size()];
            arrayList.toArray(this.periods);
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
            invalidOperationException.printStackTrace();
        }
    }

    public void advanceWorking(long l, RemainingDuration remainingDuration, long l2) {
        if (remainingDuration.getRemainingDuration() >= 0L) {
            long l3 = l;
            for (int i = 0; i < this.periods.length; ++i) {
                long l4;
                PeriodInDay periodInDay = this.periods[i];
                if (l >= periodInDay.endPeriod) continue;
                l3 = l < periodInDay.startPeriod ? periodInDay.startPeriod : l;
                if (!periodInDay.isWorking()) continue;
                if (periodInDay.endPeriod - l3 < remainingDuration.getRemainingDuration()) {
                    remainingDuration.setRemainingDuration(remainingDuration.getRemainingDuration() - (periodInDay.endPeriod - l3));
                    continue;
                }
                long l5 = 0L;
                if (l2 != 0L && (l4 = periodInDay.endPeriod - l3 - remainingDuration.getRemainingDuration()) < l2) {
                    l5 = l4;
                }
                remainingDuration.setEndMilis(l3 + remainingDuration.getRemainingDuration() + l5);
                remainingDuration.setRemainingDuration(0L);
                return;
            }
        } else {
            long l6 = l;
            for (int i = this.periods.length - 1; i >= 0; --i) {
                PeriodInDay periodInDay = this.periods[i];
                if (l <= periodInDay.startPeriod) continue;
                l6 = l > periodInDay.endPeriod ? periodInDay.endPeriod : l;
                if (!periodInDay.isWorking()) continue;
                if (l6 - periodInDay.startPeriod < Math.abs(remainingDuration.getRemainingDuration())) {
                    remainingDuration.setRemainingDuration(remainingDuration.getRemainingDuration() + (l6 - periodInDay.startPeriod));
                    continue;
                }
                remainingDuration.setEndMilis(l6 + remainingDuration.getRemainingDuration());
                remainingDuration.setRemainingDuration(0L);
                return;
            }
        }
    }

    private void fireDayWorkingPatternChanged() {
        DayWorkingPatternEvent dayWorkingPatternEvent = new DayWorkingPatternEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(DayWorkingPatternListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((DayWorkingPatternListener)eventListenerArray[i]).dayWorkingPatternChanged(dayWorkingPatternEvent);
        }
    }

    public void addDayWorkingPatternListener(DayWorkingPatternListener dayWorkingPatternListener) {
        this.listeners.add(DayWorkingPatternListener.class, dayWorkingPatternListener);
    }

    public void removeDayWorkingPatternListener(DayWorkingPatternListener dayWorkingPatternListener) {
        this.listeners.remove(DayWorkingPatternListener.class, dayWorkingPatternListener);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof DayWorkingPattern) {
            DayWorkingPattern dayWorkingPattern = (DayWorkingPattern)object;
            for (int i = 0; i < this.periods.length; ++i) {
                PeriodInDay periodInDay = this.periods[i];
                if (periodInDay.equals(dayWorkingPattern.getPeriodInDayAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        int n;
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        dayWorkingPattern.totalWorkingDuration = this.totalWorkingDuration;
        dayWorkingPattern.listeners = new EventListenerList();
        dayWorkingPattern.owner = null;
        dayWorkingPattern.periods = new PeriodInDay[this.periods.length];
        for (n = 0; n < this.periods.length; ++n) {
            PeriodInDay periodInDay = this.periods[n];
            dayWorkingPattern.periods[n] = (PeriodInDay)periodInDay.clone();
        }
        dayWorkingPattern.temporarAlternanceList = new LinkedList();
        for (n = 0; n < dayWorkingPattern.periods.length; ++n) {
            dayWorkingPattern.temporarAlternanceList.add(dayWorkingPattern.periods[n]);
        }
        return dayWorkingPattern;
    }
}

