/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm;

import ch.randelshofer.quaqua.QuaquaManager;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.dB.xml.VersionLoader;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.JStartupDialog;
import com.sbs.jpm.ui.component.JUpdateDialog;
import com.sbs.jpm.ui.component.Splash;
import com.sbs.jpm.ui.component.util.QuaquaComboBoxUIExt;
import com.sbs.util.LazyCreationManager;
import com.sbs.util.Product;
import com.sbs.util.ShutdownHook;
import com.sbs.util.SystemUtilities;
import com.sbs.util.Version;
import com.standbysoft.component.date.swing.plaf.basic.BasicDatePickerUI;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class Main {
    public static boolean OPENED_ON_MAC = false;
    private static Main main;
    private static String[] mainArgs;
    public static Splash splashScreen;
    public static String INSTALL_DATE_TRIAL_VERSION;
    public static String INSTALL_DATE_FULL_VERSION;
    public static Object swingSynch;
    public static Object macSynch;
    private static boolean macReady;
    public static JApplication mainFrame;

    private Main() {
    }

    public static Main getInstance() {
        if (main == null) {
            main = new Main();
        }
        return main;
    }

    private static void loadDefaults() {
        Object[] objectArray = new Object[]{"TextArea.font", new FontUIResource("Dialog", 0, 12), "TextField.font", new FontUIResource("Dialog", 0, 12), "Table.selectionForeground", new Color(0, 0, 0), "Table.selectionBackground", new Color(207, 212, 226), "Table.focusSelectedCellHighlightBorder", BorderFactory.createLineBorder(Color.BLACK, 1), "Table.focusCellHighlightBorder", BorderFactory.createLineBorder(Color.BLACK, 1), "SplitPaneDivider.oneTouchButtonSize", 20, "SplitPane.centerOneTouchButtons", Boolean.TRUE};
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            javax.swing.UIManager.put(objectArray[i], objectArray[i + 1]);
        }
        if (SystemUtilities.isOSMac()) {
            BasicDatePickerUI.registerDateComboBoxUI((String)"ch.randelshofer.quaqua.QuaquaLookAndFeel", QuaquaComboBoxUIExt.class);
            javax.swing.UIManager.put("Table.gridColor", new ColorUIResource(Color.LIGHT_GRAY));
            javax.swing.UIManager.put("ComboBox.maximumRowCount", 10);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("FileChooser");
            hashSet.add("Component");
            hashSet.add("Browser");
            hashSet.add("Tree");
            hashSet.add("Table");
            hashSet.add("ComboBox");
            hashSet.add("Label");
            hashSet.add("Dialog");
            hashSet.add("SplitPane");
            hashSet.add("ToolBar");
            hashSet.add("Button");
            hashSet.add("CheckBox");
            hashSet.add("Panel");
            hashSet.add("List");
            hashSet.add("ToggleButton");
            hashSet.add("Frame");
            hashSet.add("ScrollPane");
            hashSet.add("TextArea");
            hashSet.add("TableHeader");
            hashSet.add("RootPane");
            hashSet.add("DesktopPane");
            hashSet.add("OptionPane");
            hashSet.add("ColorChooser");
            hashSet.add("TabbedPane");
            QuaquaManager.setIncludedUIs(hashSet);
        }
    }

    private static void prepareForMac() {
        Application application = new Application();
        application.addApplicationListener(new ApplicationListener(){

            public void handleAbout(ApplicationEvent applicationEvent) {
                applicationEvent.setHandled(true);
                ActionManager.getActionManager().getAction(ActionID.HELP_ABOUT).actionPerformed(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleOpenFile(ApplicationEvent applicationEvent) {
                macReady = false;
                Common.LOGGER.info("Start handling the open file action on Mac. File: " + applicationEvent.getFilename());
                try {
                    String string = applicationEvent.getFilename();
                    if (string != null) {
                        OPENED_ON_MAC = true;
                        File file = new File(string);
                        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
                        if (splashScreen != null) {
                            splashScreen.increaseStep(10);
                        }
                        companyDocumentManager.open(file);
                        Common.LOGGER.info("file opened on handleOpenFile(): " + applicationEvent.getFilename());
                        if (splashScreen != null) {
                            splashScreen.increaseStep(10);
                        }
                        Configuration.getInstance().setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
                        try {
                            Object object = macSynch;
                            synchronized (object) {
                                macReady = true;
                                macSynch.notifyAll();
                            }
                        }
                        catch (Throwable throwable) {
                            Common.logException("Exception while waiting for swing to show welcome dialog.", throwable);
                        }
                    }
                    applicationEvent.setHandled(true);
                }
                catch (DocumentException documentException) {
                    Common.logException("Error:", documentException);
                    JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                }
            }

            public void handleQuit(ApplicationEvent applicationEvent) {
                Common.LOGGER.info("Handle quit");
                if (ShutdownHook.shutdown()) {
                    System.exit(0);
                }
            }

            public void handleOpenApplication(ApplicationEvent applicationEvent) {
                Common.LOGGER.info("Start handling the open application action on Mac. File: " + applicationEvent.getFilename());
                try {
                    String string = applicationEvent.getFilename();
                    if (string != null) {
                        OPENED_ON_MAC = true;
                        File file = new File(string);
                        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
                        companyDocumentManager.open(file);
                        Configuration.getInstance().setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
                    }
                }
                catch (DocumentException documentException) {
                    Common.logException("Error:", documentException);
                    JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                }
                applicationEvent.setHandled(true);
            }

            public void handlePreferences(ApplicationEvent applicationEvent) {
                applicationEvent.setHandled(true);
                ActionManager.getActionManager().getAction(ActionID.SETTINGS_OPTIONS).actionPerformed(null);
            }

            public void handlePrintFile(ApplicationEvent applicationEvent) {
            }

            public void handleReOpenApplication(ApplicationEvent applicationEvent) {
                applicationEvent.setHandled(true);
                Common.LOGGER.info("Start handling the reopen application action on Mac. File: " + applicationEvent.getFilename());
                ActionManager.getActionManager().getAction(ActionID.APPLICATION_SHOW).actionPerformed(null);
                try {
                    String string = applicationEvent.getFilename();
                    if (string != null) {
                        File file = new File(string);
                        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
                        companyDocumentManager.open(file);
                        Configuration.getInstance().setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
                    }
                }
                catch (DocumentException documentException) {
                    Common.logException("Error:", documentException);
                    JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        Common.log("Initializing system information");
        Common.setServerBuild(false);
        Common.log("Program version: " + JApplication.getApplicationVersion());
        Common.log("Current Java Version: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + " java home " + System.getProperty("java.vendor"));
        Common.log("Current OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        Common.log("User name: " + System.getProperty("user.name"));
        splashScreen.showSplash();
        Common.log("Start lazy creation threads");
        LazyCreationManager.createAvalaibleLocales();
        Common.log("Load certain UI default settings");
        Main.loadDefaults();
        Common.log("Set Look and Feel");
        try {
            if (SystemUtilities.isOSMac()) {
                javax.swing.UIManager.setLookAndFeel(QuaquaManager.getLookAndFeel());
            } else {
                javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Throwable throwable) {
            Common.logException("Exception setting look&feel: ", throwable);
            try {
                Common.log("Setting Look and Feel to platform default.");
                javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable throwable2) {
                Common.logException("Exception setting look&feel to platform default: ", throwable2);
            }
        }
        splashScreen.increaseStep(3);
        mainArgs = stringArray;
        try {
            Common.log("Creating init thread.");
            object = new Thread(new Runnable(){

                public void run() {
                    try {
                        Common.log("starting app ...");
                        Main.applicationInit(mainArgs);
                        Common.log("app started.");
                    }
                    catch (Throwable throwable) {
                        Common.logException("exception while intializing application: ", throwable);
                    }
                }
            });
            ((Thread)object).start();
        }
        catch (Exception exception) {
            Common.logException("Exception while creating/starting init thread: ", exception);
        }
        try {
            Common.log("Wait for main frame to be created.");
            object = swingSynch;
            synchronized (object) {
                while (mainFrame == null) {
                    swingSynch.wait();
                }
            }
            Common.log(" main frame created ");
        }
        catch (Throwable throwable) {
            Common.logException("Exception while waiting for main frame to be created: ", throwable);
        }
        boolean bl = Boolean.valueOf(Configuration.getInstance().getValue(ConfigurationSetting.STARTUP_UPDATE).toString());
        if (bl) {
            Common.log("Checking for updates");
            try {
                URL uRL = new URL("http://www.rationalplan.com/version.xml");
                Common.log("loading products from url");
                List list = VersionLoader.loadProducts(uRL);
                for (Product product : list) {
                    if (!product.getName().equals(JApplication.getApplicationName())) continue;
                    boolean bl2 = false;
                    Version version = new Version(JApplication.getApplicationVersion());
                    Version version2 = product.getVersion();
                    if (version.getMajor() == version2.getMajor()) {
                        if (version.getMinor() < version2.getMinor()) {
                            bl2 = true;
                        } else if (version.getMinor() == version2.getMinor() && version.getRevision() < version2.getRevision()) {
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        Common.log("presenting update dialog");
                        JUpdateDialog jUpdateDialog = new JUpdateDialog((Frame)mainFrame, product);
                        jUpdateDialog.setLocationRelativeTo(mainFrame);
                        jUpdateDialog.setVisible(true);
                        Common.log("update dialog presented.");
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Common.logException("Exception while Checking for updates", throwable);
            }
            Common.log("Check for updates done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applicationInit(String[] stringArray) {
        Object object;
        Object object2;
        Serializable serializable;
        Common.log("Loading configuration and settings files");
        Configuration configuration = Configuration.getInstance();
        configuration.load();
        configuration.loadUISettings();
        Locale locale = (Locale)configuration.getValue(ConfigurationSetting.LOCALE);
        Locale.setDefault(locale == null ? Locale.getDefault() : locale);
        Common.initI18N();
        Common.log("UI settings loaded.");
        INSTALL_DATE_TRIAL_VERSION = configuration.getValue(ConfigurationSetting.INSTALL_DATE_TRIAL_VERSION).toString();
        if (INSTALL_DATE_TRIAL_VERSION.length() <= 1) {
            serializable = new SimpleDateFormat("yyMMddhhmm");
            INSTALL_DATE_TRIAL_VERSION = "" + ((DateFormat)serializable).format(new Date());
            object2 = TimeZone.getDefault();
            long l = ((TimeZone)object2).getRawOffset();
            long l2 = l / 3600000L;
            INSTALL_DATE_TRIAL_VERSION = INSTALL_DATE_TRIAL_VERSION + ";" + l2;
        }
        splashScreen.increaseStep(5);
        Common.setApplication(new JApplication());
        serializable = Common.getApplication();
        object2 = UIManager.getInstance();
        Object object3 = configuration.getValue(ConfigurationSetting.DATE_FORMAT);
        if (object3 != null) {
            ((UIManager)object2).setDateFormat(object3.toString());
        }
        Common.log("Preparing for Mac");
        if (SystemUtilities.isOSMac()) {
            Main.prepareForMac();
        }
        Common.log("packing frame.");
        ((Window)serializable).pack();
        Common.log("frame packed.");
        boolean bl = Boolean.valueOf(Configuration.getInstance().getValue(ConfigurationSetting.APPLICATION_MAXIMIZED).toString());
        if (bl) {
            ((Frame)serializable).setExtendedState(6);
        } else {
            Dimension dimension = (Dimension)Configuration.getInstance().getValue(ConfigurationSetting.APPLICATION_SIZE);
            ((Window)serializable).setSize(dimension);
        }
        ((UIManager)object2).setStartupAction(Integer.valueOf(configuration.getValue(ConfigurationSetting.STARTUP_ACTION).toString()));
        ((UIManager)object2).setShowProjectRoot(Boolean.valueOf(configuration.getValue(ConfigurationSetting.PROJECT_ROOT).toString()));
        ((UIManager)object2).setShowTaskOutline(Boolean.valueOf(configuration.getValue(ConfigurationSetting.TASK_OUTLINE).toString()));
        ((UIManager)object2).setShowProjectCode(Boolean.valueOf(configuration.getValue(ConfigurationSetting.PROJECT_CODE).toString()));
        ((UIManager)object2).setShowProjectStart(Boolean.valueOf(configuration.getValue(ConfigurationSetting.PROJECT_START_LINE).toString()));
        ((UIManager)object2).setShowProjectStart(Boolean.valueOf(configuration.getValue(ConfigurationSetting.PROJECT_ESTIMATED_START_LINE).toString()));
        ((UIManager)object2).setShowProjectFinish(Boolean.valueOf(configuration.getValue(ConfigurationSetting.PROJECT_FINISH_LINE).toString()));
        ((UIManager)object2).setShowCurrentDate(Boolean.valueOf(configuration.getValue(ConfigurationSetting.CURRENT_LINE).toString()));
        ((UIManager)object2).setShowFocusPoint(Boolean.valueOf(configuration.getValue(ConfigurationSetting.FOCUS_POINT).toString()));
        ((UIManager)object2).setShowHorizontalGrid(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_HORIZONTAL).toString()));
        ((UIManager)object2).setShowVerticalGrid(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_VERTICAL).toString()));
        ((UIManager)object2).setShowNonWorking(Boolean.valueOf(configuration.getValue(ConfigurationSetting.CHART_NONWORKING).toString()));
        ((UIManager)object2).setShowTaskId(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_ID).toString()));
        ((UIManager)object2).setShowTaskName(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_NAME).toString()));
        ((UIManager)object2).setShowTaskDuration(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_DURATION).toString()));
        ((UIManager)object2).setShowTaskWork(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_WORK).toString()));
        ((UIManager)object2).setShowTaskCompletion(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_COMPLETION).toString()));
        ((UIManager)object2).setShowTaskStart(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_START).toString()));
        ((UIManager)object2).setShowTaskEnd(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_END).toString()));
        ((UIManager)object2).setShowAssignmentsName(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_RESOURCES).toString()));
        ((UIManager)object2).setShowAssignmentsCode(Boolean.valueOf(configuration.getValue(ConfigurationSetting.GANTT_TASK_RESOURCES_CODE).toString()));
        boolean bl2 = Boolean.valueOf(Configuration.getInstance().getValue(ConfigurationSetting.STARTUP_WELCOME).toString());
        boolean bl3 = Boolean.valueOf(Configuration.getInstance().getValue(ConfigurationSetting.FIRST_TIME).toString());
        ((Window)serializable).setLocationRelativeTo(null);
        splashScreen.increaseStep(5);
        if (SystemUtilities.isOSMac()) {
            try {
                Common.log("current thread yield");
                Thread.yield();
                Common.log("waiting for macReady");
                object = macSynch;
                synchronized (object) {
                    while (!macReady) {
                        Common.log("macReady not ready");
                        macSynch.wait();
                    }
                }
                Common.log("end waiting for macReady");
            }
            catch (Throwable throwable) {
                Common.logException("Exception while waiting for swing to show welcome dialog.", throwable);
            }
        }
        Common.log("Args length: " + stringArray.length);
        if (!OPENED_ON_MAC) {
            if (stringArray.length == 1) {
                Common.log("Openning file " + stringArray[0].toString());
                try {
                    object = stringArray[0].toString();
                    File file = new File((String)object);
                    Common.log("Openning file: " + file);
                    CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
                    splashScreen.increaseStep(5);
                    companyDocumentManager.open(file);
                    splashScreen.increaseStep(15);
                    splashScreen.setVisible(false);
                    Configuration.getInstance().setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
                }
                catch (DocumentException documentException) {
                    Common.logException("Error:", documentException);
                    JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                }
            } else if (bl2) {
                splashScreen.increaseStep(5);
                try {
                    Common.getProjectDocumentManager().create();
                }
                catch (Exception exception) {
                    Common.logException("Exception creating document.", exception);
                }
                splashScreen.increaseStep(15);
                Common.log("Hide splash before show welcome dialog");
                Common.log("Show welcome dialog");
                object = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object;
                        try {
                            Common.log("Wait for main frame to be created to show welcome dialog.");
                            object = swingSynch;
                            synchronized (object) {
                                while (mainFrame == null) {
                                    swingSynch.wait();
                                }
                            }
                            Common.log(" main frame created. welcome dialog is free to show ");
                        }
                        catch (Throwable throwable) {
                            Common.logException("Exception while waiting for swing to show welcome dialog.", throwable);
                        }
                        Common.log("Thread show welcome dialog");
                        object = new JStartupDialog((Frame)mainFrame, false);
                        ((Window)object).setLocationRelativeTo(null);
                        ((Dialog)object).setVisible(true);
                        Common.log("Welcome dialog is visible");
                    }
                });
                ((Thread)object).start();
                splashScreen.setVisible(false);
            } else {
                try {
                    if (((UIManager)object2).getStartupAction() == 0) {
                        splashScreen.increaseStep(5);
                        Common.log("Create new document");
                        Common.getProjectDocumentManager().create();
                        Common.log("New document created");
                        splashScreen.increaseStep(15);
                    } else if (((UIManager)object2).getStartupAction() == 1) {
                        splashScreen.increaseStep(5);
                        Common.log("Open document");
                        object = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    Common.log("Wait for main frame to be created to show welcome dialog.");
                                    Object object = swingSynch;
                                    synchronized (object) {
                                        while (mainFrame == null) {
                                            swingSynch.wait();
                                        }
                                    }
                                    Common.log(" main frame created. welcome dialog is free to show ");
                                }
                                catch (Throwable throwable) {
                                    Common.logException("Exception while waiting for swing to show welcome dialog.", throwable);
                                }
                                try {
                                    Common.getProjectDocumentManager().open();
                                }
                                catch (DocumentException documentException) {
                                    Common.logException("Exception openning document", documentException);
                                    splashScreen.setVisible(false);
                                    JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                                }
                                finally {
                                    Common.log("Hide splash finnaly");
                                    splashScreen.setVisible(false);
                                    Common.log("splash hidden");
                                }
                            }
                        });
                        ((Thread)object).start();
                    } else if (((UIManager)object2).getStartupAction() == 2) {
                        splashScreen.increaseStep(5);
                        Common.log("Open last document");
                        object = (List)configuration.getValue(ConfigurationSetting.MRU_FILES);
                        String string = object.get(0).toString();
                        File file = new File(string);
                        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
                        companyDocumentManager.open(file);
                        splashScreen.increaseStep(15);
                        Configuration.getInstance().setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
                    }
                    Common.log("Document opened");
                }
                catch (DocumentException documentException) {
                    Common.logException("Exception openning document", documentException);
                    splashScreen.setVisible(false);
                    JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                }
                finally {
                    Common.log("Hide splash finnaly");
                    splashScreen.setVisible(false);
                    Common.log("splash hidden");
                }
            }
        }
        splashScreen.hideSplash();
        Common.log("Set the application as visible");
        ((Window)serializable).setVisible(true);
        object = swingSynch;
        synchronized (object) {
            mainFrame = serializable;
            Common.log("main frame created and visible.");
            swingSynch.notifyAll();
        }
        Common.log("Application is started.");
    }

    static {
        splashScreen = new Splash("com/sbs/jpm/ui/images/splash.jpg", 100);
        INSTALL_DATE_TRIAL_VERSION = "";
        INSTALL_DATE_FULL_VERSION = "";
        swingSynch = new Object();
        macSynch = new Object();
        macReady = true;
        mainFrame = null;
    }
}

