/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.MSMPPFileFilter;
import com.sbs.jpm.MSMPTFileFilter;
import com.sbs.jpm.MSMPXFileFilter;
import com.sbs.jpm.MSXMLFileFilter;
import com.sbs.jpm.RecognizedOpenFileFilter;
import com.sbs.jpm.XMLFileFilter;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.io.FileType;
import com.sbs.jpm.document.AbstractDocumentManager;
import com.sbs.jpm.document.Answer;
import com.sbs.jpm.document.CustomTypeFile;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.ui.JApplication;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class CompanyDocumentManager
extends AbstractDocumentManager {
    public void importProject(boolean bl) throws DocumentException {
        Document document = this.getSelectedDocument();
        CustomTypeFile customTypeFile = this.getImportedProjectFile(bl);
        if (customTypeFile != null && document != null) {
            try {
                boolean bl2;
                boolean bl3;
                int n;
                Object object;
                Document document2 = this.create(customTypeFile.getFile(), customTypeFile.getFileType());
                Company company = ((CompanyDocument)document).getData();
                Company company2 = ((CompanyDocument)document2).getData();
                boolean bl22 = false;
                if (company2.getMultiProject() == 2) {
                    bl22 = true;
                } else if (company2.getMultiProject() == 1) {
                    bl22 = false;
                }
                if (!company2.getCalendarManager().equals(company.getCalendarManager())) {
                    company2.getRootTask().setCalendar(company2.getCalendarManager());
                    if (bl22) {
                        for (Task object2 : company2.getRootTask().getChildList()) {
                            if (object2.isEmpty() || !object2.isProject() || object2.getCalendar() != null) continue;
                            object2.setCalendar(company2.getCalendarManager());
                        }
                    }
                    for (HumanResource humanResource : company2.getHumanResources()) {
                        if (humanResource.isEmpty() || humanResource.getCalendar() != null) continue;
                        humanResource.setCalendar(company2.getCalendarManager());
                    }
                }
                if (bl22) {
                    for (Task task : company2.getRootTask().getChildList()) {
                        task.setDirty(true, true);
                        company.getRootTask().addChild(task, false);
                    }
                    object = company2.getRootTask().getProjectChildNumber() != 0 ? company2.getRootTask().getProjectChildAt(0) : company.getCurrentTask();
                } else {
                    company2.getRootTask().setDirty(true, true);
                    company.getRootTask().addChild(company2.getRootTask(), false);
                    object = company2.getRootTask();
                }
                company.setCurrentTask((Task)object);
                boolean bl4 = true;
                block5: for (CalendarManager calendarManager : company2.getCalendarList()) {
                    for (CalendarManager calendarManager2 : company.getCalendarList()) {
                        if (!calendarManager.getName().equals(calendarManager2.getName())) continue;
                        n = JOptionPane.showConfirmDialog(null, Common.I18N_MESSAGES.getString("document.duplicateImportedCalendarNames.message"), Common.I18N_MESSAGES.getString("document.duplicateImportedCalendarNames.title"), 0, 2);
                        if (n != 1) break block5;
                        bl3 = false;
                        break block5;
                    }
                }
                for (CalendarManager calendarManager : company2.getCalendarList()) {
                    boolean bl5 = false;
                    String string = calendarManager.getName();
                    for (CalendarManager calendarManager3 : company.getCalendarList()) {
                        if (!calendarManager.getName().equals(calendarManager3.getName())) continue;
                        if (bl3) {
                            String string2 = string + "(" + company2.getRootTask().getName() + ")";
                            calendarManager.setName(string2);
                            company.addCalendarManager(calendarManager);
                        } else {
                            this.replaceCalendar(company.getRootTask(), calendarManager3, calendarManager);
                            this.replaceCalendar(company, calendarManager3, calendarManager);
                        }
                        bl5 = true;
                        break;
                    }
                    if (bl5) continue;
                    company.addCalendarManager(calendarManager);
                }
                boolean bl6 = true;
                block9: for (Resource resource : company2.getResources()) {
                    if (resource.isEmpty()) continue;
                    for (Resource resource2 : company.getResources()) {
                        if (!resource.getName().equals(resource2.getName())) continue;
                        n = JOptionPane.showConfirmDialog(null, Common.I18N_MESSAGES.getString("document.duplicateImportedResourceNames.message"), Common.I18N_MESSAGES.getString("document.duplicateImportedResourceNames.title"), 0, 2);
                        if (n != 1) break block9;
                        bl2 = false;
                        break block9;
                    }
                }
                for (Resource resource : company2.getResources()) {
                    boolean bl7;
                    if (resource.isEmpty()) continue;
                    Object object2 = resource.getName();
                    boolean bl8 = false;
                    for (Resource resource3 : company.getResources()) {
                        if (!resource.getName().equals(resource3.getName())) continue;
                        if (bl2) {
                            object2 = (String)object2 + "(" + company2.getRootTask().getName() + ")";
                            resource.setName((String)object2);
                            company.addResource(resource);
                        } else {
                            this.replaceResource(company.getRootTask(), resource, resource3);
                        }
                        bl7 = true;
                        break;
                    }
                    if (bl7) continue;
                    company.addResource(resource);
                }
                TaskPlanner.rescheduleTree(company.getRootTask());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Common.logException("Error importing :", exception);
                throw new DocumentException(exception.getLocalizedMessage());
            }
        }
    }

    private void replaceResource(Task task, Resource resource, Resource resource2) {
        for (Assignment uniqueId : task.getAssignments()) {
            if (uniqueId.getResource() != resource) continue;
            uniqueId.replaceResource(resource2, false);
        }
        for (Task task2 : task.getChildList()) {
            if (task2.isEmpty()) continue;
            this.replaceResource(task2, resource, resource2);
        }
    }

    private void replaceCalendar(Task task, CalendarManager calendarManager, CalendarManager calendarManager2) {
        if (task.getCalendar() != null && task.getCalendar() == calendarManager2) {
            task.setCalendar(calendarManager);
        }
        for (Task task2 : task.getChildList()) {
            if (task2.isEmpty()) continue;
            this.replaceCalendar(task2, calendarManager, calendarManager2);
        }
    }

    private void replaceCalendar(Company company, CalendarManager calendarManager, CalendarManager calendarManager2) {
        for (HumanResource humanResource : company.getHumanResources()) {
            if (humanResource.isEmpty() || humanResource.getCalendar() == null || humanResource.getCalendar() != calendarManager2) continue;
            humanResource.setCalendar(calendarManager);
        }
    }

    protected Document createDefaultDocument() {
        return new CompanyDocument();
    }

    protected Document create(File file, FileType fileType) throws Exception {
        Common.log("Create document - file: " + file.getAbsolutePath());
        return new CompanyDocument(file, fileType);
    }

    protected Answer shouldSaveDocument(String string) {
        JApplication jApplication = Common.getApplication();
        int n = JOptionPane.showConfirmDialog(jApplication, string, JApplication.getApplicationName(), 1);
        switch (n) {
            case 0: {
                return Answer.YES;
            }
            case 1: {
                return Answer.NO;
            }
            case 2: {
                return Answer.CANCEL;
            }
        }
        return Answer.CANCEL;
    }

    protected CustomTypeFile getSelectedFile() {
        Configuration configuration = Configuration.getInstance();
        String string = configuration.getValue(ConfigurationSetting.CURRENT_DIR).toString();
        JFileChooser jFileChooser = new JFileChooser(string);
        XMLFileFilter xMLFileFilter = new XMLFileFilter();
        MSXMLFileFilter mSXMLFileFilter = new MSXMLFileFilter();
        MSMPPFileFilter mSMPPFileFilter = new MSMPPFileFilter();
        MSMPTFileFilter mSMPTFileFilter = new MSMPTFileFilter();
        MSMPXFileFilter mSMPXFileFilter = new MSMPXFileFilter();
        RecognizedOpenFileFilter recognizedOpenFileFilter = new RecognizedOpenFileFilter();
        jFileChooser.addChoosableFileFilter(xMLFileFilter);
        jFileChooser.addChoosableFileFilter(mSMPPFileFilter);
        jFileChooser.addChoosableFileFilter(mSXMLFileFilter);
        jFileChooser.addChoosableFileFilter(mSMPTFileFilter);
        jFileChooser.addChoosableFileFilter(mSMPXFileFilter);
        jFileChooser.addChoosableFileFilter(recognizedOpenFileFilter);
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter(xMLFileFilter);
        JApplication jApplication = Common.getApplication();
        int n = jFileChooser.showOpenDialog(jApplication);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            FileType fileType = null;
            if (fileFilter instanceof XMLFileFilter) {
                fileType = FileType.PROPRIETARY;
                if (!file.getName().toLowerCase().endsWith(".xrp")) {
                    file = new File(file.getAbsolutePath() + ".xrp");
                }
                configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
            } else if (fileFilter instanceof MSXMLFileFilter) {
                fileType = FileType.MSPROJECT_XML;
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
            } else if (fileFilter instanceof MSMPPFileFilter) {
                fileType = FileType.MSPROJECT_MPP;
                if (!file.getName().toLowerCase().endsWith(".mpp")) {
                    file = new File(file.getAbsolutePath() + ".mpp");
                }
            } else if (fileFilter instanceof MSMPTFileFilter) {
                fileType = FileType.MSPROJECT_MPT;
                if (!file.getName().toLowerCase().endsWith(".mpt")) {
                    file = new File(file.getAbsolutePath() + ".mpt");
                }
            } else if (fileFilter instanceof MSMPXFileFilter) {
                fileType = FileType.MSPROJECT_MPX;
                if (!file.getName().toLowerCase().endsWith(".mpx")) {
                    file = new File(file.getAbsolutePath() + ".mpx");
                }
            } else {
                int n2 = file.getName().lastIndexOf(".");
                if (n2 != -1) {
                    String string2 = file.getName().substring(n2).toLowerCase();
                    if (string2.equals(".xrp")) {
                        fileType = FileType.PROPRIETARY;
                    } else if (string2.equals(".mpp")) {
                        fileType = FileType.MSPROJECT_MPP;
                    } else if (string2.equals(".mpt")) {
                        fileType = FileType.MSPROJECT_MPT;
                    } else if (string2.equals(".xml")) {
                        fileType = FileType.MSPROJECT_XML;
                    } else if (string2.equals(".mpx")) {
                        fileType = FileType.MSPROJECT_MPX;
                    }
                }
            }
            CustomTypeFile customTypeFile = new CustomTypeFile(file, fileType);
            configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
            return customTypeFile;
        }
        return null;
    }

    protected CustomTypeFile getImportedFile() {
        Configuration configuration = Configuration.getInstance();
        String string = configuration.getValue(ConfigurationSetting.CURRENT_DIR).toString();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogTitle(Common.I18N_RP.getString("import"));
        MSXMLFileFilter mSXMLFileFilter = new MSXMLFileFilter();
        MSMPPFileFilter mSMPPFileFilter = new MSMPPFileFilter();
        MSMPTFileFilter mSMPTFileFilter = new MSMPTFileFilter();
        MSMPXFileFilter mSMPXFileFilter = new MSMPXFileFilter();
        jFileChooser.addChoosableFileFilter(mSMPPFileFilter);
        jFileChooser.addChoosableFileFilter(mSXMLFileFilter);
        jFileChooser.addChoosableFileFilter(mSMPTFileFilter);
        jFileChooser.addChoosableFileFilter(mSMPXFileFilter);
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter(mSMPPFileFilter);
        JApplication jApplication = Common.getApplication();
        int n = jFileChooser.showDialog(jApplication, Common.I18N_RP.getString("import"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            FileType fileType = null;
            if (fileFilter instanceof MSXMLFileFilter) {
                fileType = FileType.MSPROJECT_XML;
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
            } else if (fileFilter instanceof MSMPPFileFilter) {
                fileType = FileType.MSPROJECT_MPP;
                if (!file.getName().toLowerCase().endsWith(".mpp")) {
                    file = new File(file.getAbsolutePath() + ".mpp");
                }
            } else if (fileFilter instanceof MSMPTFileFilter) {
                fileType = FileType.MSPROJECT_MPT;
                if (!file.getName().toLowerCase().endsWith(".mpt")) {
                    file = new File(file.getAbsolutePath() + ".mpt");
                }
            } else if (fileFilter instanceof MSMPXFileFilter) {
                fileType = FileType.MSPROJECT_MPX;
                if (!file.getName().toLowerCase().endsWith(".mpx")) {
                    file = new File(file.getAbsolutePath() + ".mpx");
                }
            }
            CustomTypeFile customTypeFile = new CustomTypeFile(file, fileType);
            configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
            return customTypeFile;
        }
        return null;
    }

    protected CustomTypeFile getImportedProjectFile(boolean bl) {
        Configuration configuration = Configuration.getInstance();
        String string = configuration.getValue(ConfigurationSetting.CURRENT_DIR).toString();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogTitle(bl ? Common.I18N_RP.getString("restoreProject") : Common.I18N_RP.getString("importProject"));
        XMLFileFilter xMLFileFilter = new XMLFileFilter();
        MSXMLFileFilter mSXMLFileFilter = new MSXMLFileFilter();
        MSMPPFileFilter mSMPPFileFilter = new MSMPPFileFilter();
        MSMPTFileFilter mSMPTFileFilter = new MSMPTFileFilter();
        MSMPXFileFilter mSMPXFileFilter = new MSMPXFileFilter();
        jFileChooser.addChoosableFileFilter(xMLFileFilter);
        if (!bl) {
            jFileChooser.addChoosableFileFilter(mSMPPFileFilter);
            jFileChooser.addChoosableFileFilter(mSXMLFileFilter);
            jFileChooser.addChoosableFileFilter(mSMPTFileFilter);
            jFileChooser.addChoosableFileFilter(mSMPXFileFilter);
        }
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter(xMLFileFilter);
        JApplication jApplication = Common.getApplication();
        jFileChooser.setApproveButtonText(bl ? Common.I18N_RP.getString("restore") : Common.I18N_RP.getString("import"));
        int n = jFileChooser.showDialog(jApplication, null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            FileType fileType = null;
            if (fileFilter instanceof XMLFileFilter) {
                fileType = FileType.PROPRIETARY;
                if (!file.getName().toLowerCase().endsWith(".xrp")) {
                    file = new File(file.getAbsolutePath() + ".xrp");
                }
            } else if (fileFilter instanceof MSXMLFileFilter) {
                fileType = FileType.MSPROJECT_XML;
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
            } else if (fileFilter instanceof MSMPPFileFilter) {
                fileType = FileType.MSPROJECT_MPP;
                if (!file.getName().toLowerCase().endsWith(".mpp")) {
                    file = new File(file.getAbsolutePath() + ".mpp");
                }
            } else if (fileFilter instanceof MSMPTFileFilter) {
                fileType = FileType.MSPROJECT_MPT;
                if (!file.getName().toLowerCase().endsWith(".mpt")) {
                    file = new File(file.getAbsolutePath() + ".mpt");
                }
            } else if (fileFilter instanceof MSMPXFileFilter) {
                fileType = FileType.MSPROJECT_MPX;
                if (!file.getName().toLowerCase().endsWith(".mpx")) {
                    file = new File(file.getAbsolutePath() + ".mpx");
                }
            }
            CustomTypeFile customTypeFile = new CustomTypeFile(file, fileType);
            configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
            return customTypeFile;
        }
        return null;
    }
}

