/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm;

import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.Main;
import com.sbs.jpm.common.IDsGenerator.DummyIdGenerator;
import com.sbs.jpm.common.IDsGenerator.IDGeneratorInterface;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.ui.JApplication;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Common {
    public static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    public static final boolean TRIAL = true;
    public static final boolean MULTIPROJECT = false;
    public static final boolean VIEWER = false;
    public static final boolean SERVER_CONNECT_CAPABLE = false;
    private static boolean SERVER_BUILD = false;
    private static boolean CLIENT_BUILD = !SERVER_BUILD;
    public static boolean SAVE_IDs = SERVER_BUILD;
    public static ResourceBundle I18N_RP;
    public static ResourceBundle I18N_MESSAGES;
    public static ResourceBundle I18N_ACTIONS;
    private static DocumentManager projectDocumentManager;
    private static IDGeneratorInterface idGenerator;
    private static JApplication application;

    public static void setServerBuild(boolean bl) {
        SERVER_BUILD = bl;
        CLIENT_BUILD = !SERVER_BUILD;
        SAVE_IDs = SERVER_BUILD;
    }

    public static boolean isServerBuild() {
        return SERVER_BUILD;
    }

    public static void setProjectDocumentManager(DocumentManager documentManager) {
        projectDocumentManager = documentManager;
    }

    public static void setIdGenerator(Company company, IDGeneratorInterface iDGeneratorInterface) {
        idGenerator = iDGeneratorInterface;
    }

    public static IDGeneratorInterface getIdGenerator() {
        return idGenerator;
    }

    public static void logException(String string, Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        LOGGER.severe(string + " ; " + byteArrayOutputStream.toString());
    }

    public static void log(String string) {
        LOGGER.info(Thread.currentThread() + ": " + string);
    }

    public static void setApplication(JApplication jApplication) {
        application = jApplication;
    }

    public static JApplication getApplication() {
        return application;
    }

    public static void initI18N() {
        I18N_RP = ResourceBundle.getBundle("com.sbs.jpm.i18n.RationalPlan");
        I18N_MESSAGES = ResourceBundle.getBundle("com.sbs.jpm.i18n.messages");
        I18N_ACTIONS = ResourceBundle.getBundle("com.sbs.jpm.i18n.actions");
    }

    public static CompanyDocumentManager getProjectDocumentManager() {
        return (CompanyDocumentManager)projectDocumentManager;
    }

    static {
        idGenerator = new DummyIdGenerator();
        try {
            Handler[] handlerArray = Logger.getLogger("").getHandlers();
            for (int i = 0; i < handlerArray.length; ++i) {
                Handler handler = handlerArray[i];
                handler.setLevel(Level.WARNING);
            }
            FileHandler fileHandler = new FileHandler(Configuration.getSettingsDirectory() + "rationalplan.log", true);
            fileHandler.setFormatter(new SimpleFormatter());
            LOGGER.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LOGGER.warning("Unable to create the log file.");
        }
    }
}

