/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.DateCell;
import jxl.Hyperlink;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Drawing;
import jxl.format.CellFormat;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.read.biff.SheetImpl;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HyperlinkRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.WritableWorkbookImpl;

class WritableSheetImpl
implements WritableSheet {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$WritableSheetImpl == null ? (class$jxl$write$biff$WritableSheetImpl = WritableSheetImpl.class$("jxl.write.biff.WritableSheetImpl")) : class$jxl$write$biff$WritableSheetImpl);
    private String name;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private SharedStrings sharedStrings;
    private TreeSet columnFormats;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private int numRows;
    private int numColumns;
    private PLSRecord plsRecord;
    private boolean chartOnly;
    private ArrayList rowBreaks;
    private ArrayList drawings;
    private SheetSettings settings;
    private SheetWriter sheetWriter;
    private WorkbookSettings workbookSettings;
    private WritableWorkbookImpl workbook;
    private static final int rowGrowSize = 10;
    private static final int numRowsPerSheet = 65536;
    private static final String[] imageTypes = new String[]{"png"};
    static /* synthetic */ Class class$jxl$write$biff$WritableSheetImpl;

    public WritableSheetImpl(String n, File of, FormattingRecords fr, SharedStrings ss, WorkbookSettings ws, WritableWorkbookImpl ww) {
        this.name = n;
        this.outputFile = of;
        this.rows = new RowRecord[0];
        this.numRows = 0;
        this.numColumns = 0;
        this.chartOnly = false;
        this.workbook = ww;
        this.formatRecords = fr;
        this.sharedStrings = ss;
        this.workbookSettings = ws;
        this.columnFormats = new TreeSet(new ColumnInfoComparator());
        this.hyperlinks = new ArrayList();
        this.mergedCells = new MergedCells(this);
        this.rowBreaks = new ArrayList();
        this.drawings = new ArrayList();
        this.settings = new SheetSettings();
        this.sheetWriter = new SheetWriter(this.outputFile, this, this.workbookSettings);
    }

    public Cell getCell(int column, int row) {
        return this.getWritableCell(column, row);
    }

    public WritableCell getWritableCell(int column, int row) {
        WritableCell c = null;
        if (row < this.rows.length && this.rows[row] != null) {
            c = this.rows[row].getCell(column);
        }
        if (c == null) {
            c = new EmptyCell(column, row);
        }
        return c;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numColumns;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (!row[j].getContents().equals(contents)) continue;
                cell = row[j];
                found = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (row[j].getType() != CellType.LABEL && row[j].getType() != CellType.STRING_FORMULA || !row[j].getContents().equals(contents)) continue;
                cell = (LabelCell)row[j];
                found = true;
            }
        }
        return cell;
    }

    public Cell[] getRow(int row) {
        boolean found = false;
        int col = this.numColumns - 1;
        while (col >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        for (int i = 0; i <= col; ++i) {
            cells[i] = this.getCell(i, row);
        }
        return cells;
    }

    public Cell[] getColumn(int col) {
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        for (int i = 0; i <= row; ++i) {
            cells[i] = this.getCell(col, i);
        }
        return cells;
    }

    public String getName() {
        return this.name;
    }

    public void insertRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = this.numRows == this.rows.length ? new RowRecord[oldRows.length + 10] : new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row, this.rows, row + 1, this.numRows - row);
        for (int i = row + 1; i <= this.numRows; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].incrementRow();
        }
        HyperlinkRecord hr = null;
        Iterator i = this.hyperlinks.iterator();
        while (i.hasNext()) {
            hr = (HyperlinkRecord)i.next();
            hr.insertRow(row);
        }
        this.mergedCells.insertRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val >= row) {
                ++val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowInserted(this, row);
        }
        ++this.numRows;
    }

    public void insertColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        for (int i = 0; i < this.numRows; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].insertColumn(col);
        }
        HyperlinkRecord hr = null;
        Iterator i = this.hyperlinks.iterator();
        while (i.hasNext()) {
            hr = (HyperlinkRecord)i.next();
            hr.insertColumn(col);
        }
        i = this.columnFormats.iterator();
        while (i.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i.next();
            if (cir.getColumn() < col) continue;
            cir.incrementColumn();
        }
        this.mergedCells.insertColumn(col);
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnInserted(this, col);
        }
        ++this.numColumns;
    }

    public void removeColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        for (int i = 0; i < this.numRows; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].removeColumn(col);
        }
        HyperlinkRecord hr = null;
        Iterator i = this.hyperlinks.iterator();
        while (i.hasNext()) {
            hr = (HyperlinkRecord)i.next();
            if (hr.getColumn() == col && hr.getLastColumn() == col) {
                this.hyperlinks.remove(this.hyperlinks.indexOf(hr));
                continue;
            }
            hr.removeColumn(col);
        }
        this.mergedCells.removeColumn(col);
        i = this.columnFormats.iterator();
        ColumnInfoRecord removeColumn = null;
        while (i.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i.next();
            if (cir.getColumn() == col) {
                removeColumn = cir;
                continue;
            }
            if (cir.getColumn() <= col) continue;
            cir.decrementColumn();
        }
        if (removeColumn != null) {
            this.columnFormats.remove(removeColumn);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnRemoved(this, col);
        }
        --this.numColumns;
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row + 1, this.rows, row, this.numRows - (row + 1));
        for (int i = row; i < this.numRows; ++i) {
            if (this.rows[i] == null) continue;
            this.rows[i].decrementRow();
        }
        HyperlinkRecord hr = null;
        Iterator i = this.hyperlinks.iterator();
        while (i.hasNext()) {
            hr = (HyperlinkRecord)i.next();
            if (hr.getRow() == row && hr.getLastRow() == row) {
                i.remove();
                continue;
            }
            hr.removeRow(row);
        }
        this.mergedCells.removeRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val == row) continue;
            if (val > row) {
                --val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowRemoved(this, row);
        }
        --this.numRows;
    }

    public void addCell(WritableCell cell) throws WriteException, RowsExceededException {
        CellValue cv = (CellValue)cell;
        if (cv.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int row = cell.getRow();
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.addCell(cv);
        this.numRows = Math.max(row + 1, this.numRows);
        this.numColumns = Math.max(this.numColumns, rowrec.getMaxColumn());
        cv.setCellDetails(this.formatRecords, this.sharedStrings, this);
    }

    private RowRecord getRowRecord(int row) throws RowsExceededException {
        RowRecord rowrec;
        if (row >= 65536) {
            throw new RowsExceededException();
        }
        if (row >= this.rows.length) {
            RowRecord[] oldRows = this.rows;
            this.rows = new RowRecord[Math.max(oldRows.length + 10, row + 1)];
            System.arraycopy(oldRows, 0, this.rows, 0, oldRows.length);
            oldRows = null;
        }
        if ((rowrec = this.rows[row]) == null) {
            this.rows[row] = rowrec = new RowRecord(row);
        }
        return rowrec;
    }

    RowRecord getRowInfo(int r) {
        if (r < 0 || r > this.rows.length) {
            return null;
        }
        return this.rows[r];
    }

    ColumnInfoRecord getColumnInfo(int c) {
        Iterator i = this.columnFormats.iterator();
        ColumnInfoRecord cir = null;
        boolean stop = false;
        while (i.hasNext() && !stop) {
            cir = (ColumnInfoRecord)i.next();
            if (cir.getColumn() < c) continue;
            stop = true;
        }
        if (!stop) {
            return null;
        }
        return cir.getColumn() == c ? cir : null;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setHidden(boolean h) {
        this.settings.setHidden(h);
    }

    public void setProtected(boolean prot) {
        this.settings.setProtected(prot);
    }

    public void setSelected() {
        this.settings.setSelected();
    }

    public boolean isHidden() {
        return this.settings.isHidden();
    }

    public void setColumnView(int col, int width) {
        CellView cv = new CellView();
        cv.setDimension(width);
        this.setColumnView(col, cv);
    }

    public void setColumnView(int col, int width, CellFormat format) {
        CellView cv = new CellView();
        cv.setDimension(width);
        cv.setFormat(format);
        this.setColumnView(col, cv);
    }

    public void setColumnView(int col, CellView view) {
        block6: {
            XFRecord xfr = (XFRecord)view.getFormat();
            if (xfr == null) {
                xfr = WritableWorkbookImpl.NORMAL_STYLE;
            }
            try {
                ColumnInfoRecord cir;
                if (!xfr.isInitialized()) {
                    this.formatRecords.addStyle(xfr);
                }
                if (!this.columnFormats.contains(cir = new ColumnInfoRecord(col, view.getDimension() * 256, xfr))) {
                    this.columnFormats.add(cir);
                } else {
                    boolean removed = this.columnFormats.remove(cir);
                    this.columnFormats.add(cir);
                }
            }
            catch (NumFormatRecordsException e) {
                logger.warn("Maximum number of format records exceeded.  Using default format.");
                ColumnInfoRecord cir = new ColumnInfoRecord(col, view.getDimension() * 256, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(cir)) break block6;
                this.columnFormats.add(cir);
            }
        }
    }

    public void setRowView(int row, int height) throws RowsExceededException {
        this.setRowView(row, height, false);
    }

    public void setRowView(int row, boolean collapsed) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.setCollapsed(collapsed);
    }

    public void setRowView(int row, int height, boolean collapsed) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.setRowHeight(height);
        rowrec.setCollapsed(collapsed);
    }

    public void write() throws IOException {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.hyperlinks, this.mergedCells, this.columnFormats);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.setSettings(this.settings);
        this.sheetWriter.setPLS(this.plsRecord);
        this.sheetWriter.setDrawings(this.drawings);
        this.sheetWriter.write();
    }

    private void copyCells(Sheet s) {
        int cells = s.getRows();
        Cell[] row = null;
        Cell cell = null;
        for (int i = 0; i < cells; ++i) {
            row = s.getRow(i);
            for (int j = 0; j < row.length; ++j) {
                cell = row[j];
                CellType ct = cell.getType();
                try {
                    CellValue b;
                    if (ct == CellType.LABEL) {
                        Label l = new Label((LabelCell)cell);
                        this.addCell(l);
                        continue;
                    }
                    if (ct == CellType.NUMBER) {
                        Number n = new Number((NumberCell)cell);
                        this.addCell(n);
                        continue;
                    }
                    if (ct == CellType.DATE) {
                        DateTime dt = new DateTime((DateCell)cell);
                        this.addCell(dt);
                        continue;
                    }
                    if (ct == CellType.BOOLEAN) {
                        b = new Boolean((BooleanCell)cell);
                        this.addCell(b);
                        continue;
                    }
                    if (ct == CellType.NUMBER_FORMULA || ct == CellType.STRING_FORMULA || ct == CellType.BOOLEAN_FORMULA || ct == CellType.FORMULA_ERROR) {
                        ReadFormulaRecord fr = new ReadFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                        continue;
                    }
                    if (ct != CellType.EMPTY || cell.getCellFormat() == null) continue;
                    b = new Blank(cell);
                    this.addCell(b);
                    continue;
                }
                catch (WriteException e) {
                    Assert.verify(false);
                }
            }
        }
    }

    void copy(Sheet s) {
        this.settings = new SheetSettings(s.getSettings());
        this.copyCells(s);
        SheetImpl si = (SheetImpl)s;
        jxl.read.biff.ColumnInfoRecord[] readCirs = si.getColumnInfos();
        for (int i = 0; i < readCirs.length; ++i) {
            jxl.read.biff.ColumnInfoRecord rcir = readCirs[i];
            for (int j = rcir.getStartColumn(); j <= rcir.getEndColumn(); ++j) {
                ColumnInfoRecord cir = new ColumnInfoRecord(rcir, j, this.formatRecords);
                cir.setHidden(rcir.getHidden());
                this.columnFormats.add(cir);
            }
        }
        Hyperlink[] hls = s.getHyperlinks();
        for (int i = 0; i < hls.length; ++i) {
            WritableHyperlink hr = new WritableHyperlink(hls[i], this);
            this.hyperlinks.add(hr);
        }
        Range[] merged = s.getMergedCells();
        for (int i = 0; i < merged.length; ++i) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i], this));
        }
        try {
            jxl.read.biff.RowRecord[] rowprops = si.getRowProperties();
            for (int i = 0; i < rowprops.length; ++i) {
                RowRecord rr = this.getRowRecord(rowprops[i].getRowNumber());
                rr.setRowDetails(rowprops[i].getRowHeight(), rowprops[i].isCollapsed());
            }
        }
        catch (RowsExceededException e) {
            Assert.verify(false);
        }
        this.sheetWriter.setHeader(new HeaderRecord(si.getHeader()));
        this.sheetWriter.setFooter(new FooterRecord(si.getFooter()));
        int[] rowbreaks = si.getRowPageBreaks();
        if (rowbreaks != null) {
            for (int i = 0; i < rowbreaks.length; ++i) {
                this.rowBreaks.add(new Integer(rowbreaks[i]));
            }
        }
        this.sheetWriter.setCharts(si.getCharts());
        Drawing[] dr = si.getDrawings();
        for (int i = 0; i < dr.length; ++i) {
            WritableImage wi = new WritableImage(dr[i]);
            this.drawings.add(wi);
        }
        this.sheetWriter.setWorkspaceOptions(si.getWorkspaceOptions());
        if (si.getSheetBof().isChart()) {
            this.chartOnly = true;
            this.sheetWriter.setChartOnly();
        }
        if (si.getPLS() != null) {
            this.plsRecord = new PLSRecord(si.getPLS());
        }
    }

    void copy(WritableSheet s) {
        int i;
        this.settings = new SheetSettings(s.getSettings());
        this.copyCells(s);
        this.columnFormats = ((WritableSheetImpl)s).columnFormats;
        Range[] merged = s.getMergedCells();
        for (int i2 = 0; i2 < merged.length; ++i2) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i2], this));
        }
        try {
            RowRecord[] rows = ((WritableSheetImpl)s).rows;
            RowRecord row = null;
            for (i = 0; i < rows.length; ++i) {
                row = rows[i];
                if (row == null || row.isDefaultHeight() && !row.isCollapsed()) continue;
                RowRecord rr = this.getRowRecord(i);
                rr.setRowDetails(row.getRowHeight(), row.isCollapsed());
            }
        }
        catch (RowsExceededException e) {
            Assert.verify(false);
        }
        WritableSheetImpl si = (WritableSheetImpl)s;
        this.sheetWriter.setHeader(si.getHeader());
        this.sheetWriter.setFooter(si.getFooter());
        this.rowBreaks = new ArrayList(si.rowBreaks);
        this.sheetWriter.setCharts(si.getCharts());
        Drawing[] dr = si.getDrawings();
        for (i = 0; i < dr.length; ++i) {
            WritableImage wi = new WritableImage(dr[i]);
            this.drawings.add(wi);
        }
        this.sheetWriter.setWorkspaceOptions(si.getWorkspaceOptions());
        if (si.plsRecord != null) {
            this.plsRecord = new PLSRecord(si.plsRecord);
        }
    }

    final HeaderRecord getHeader() {
        return this.sheetWriter.getHeader();
    }

    final FooterRecord getFooter() {
        return this.sheetWriter.getFooter();
    }

    public boolean isProtected() {
        return this.settings.isProtected();
    }

    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hl = new Hyperlink[this.hyperlinks.size()];
        for (int i = 0; i < this.hyperlinks.size(); ++i) {
            hl[i] = (Hyperlink)this.hyperlinks.get(i);
        }
        return hl;
    }

    public Range[] getMergedCells() {
        return this.mergedCells.getMergedCells();
    }

    public WritableHyperlink[] getWritableHyperlinks() {
        WritableHyperlink[] hl = new WritableHyperlink[this.hyperlinks.size()];
        for (int i = 0; i < this.hyperlinks.size(); ++i) {
            hl[i] = (WritableHyperlink)this.hyperlinks.get(i);
        }
        return hl;
    }

    public void removeHyperlink(WritableHyperlink h) {
        this.removeHyperlink(h, false);
    }

    public void removeHyperlink(WritableHyperlink h, boolean preserveLabel) {
        this.hyperlinks.remove(this.hyperlinks.indexOf(h));
        if (!preserveLabel) {
            Assert.verify(this.rows.length > h.getRow() && this.rows[h.getRow()] != null);
            this.rows[h.getRow()].removeCell(h.getColumn());
        }
    }

    public void addHyperlink(WritableHyperlink h) throws WriteException, RowsExceededException {
        Label l;
        Cell c = this.getCell(h.getColumn(), h.getRow());
        String contents = null;
        if (h.isFile()) {
            contents = h.getFile().getPath();
        } else if (h.isURL()) {
            contents = h.getURL().toString();
        } else if (h.isLocation()) {
            contents = h.getContents();
        }
        if (c.getType() == CellType.LABEL) {
            l = (Label)c;
            l.setString(contents);
            l.setCellFormat(WritableWorkbook.HYPERLINK_STYLE);
        } else {
            l = new Label(h.getColumn(), h.getRow(), contents, (CellFormat)WritableWorkbook.HYPERLINK_STYLE);
            this.addCell(l);
        }
        for (int i = h.getRow(); i <= h.getLastRow(); ++i) {
            for (int j = h.getColumn(); j <= h.getLastColumn(); ++j) {
                if (i == h.getRow() || j == h.getColumn() || this.rows[i] == null) continue;
                this.rows[i].removeCell(j);
            }
        }
        h.initialize(this);
        this.hyperlinks.add(h);
    }

    public Range mergeCells(int col1, int row1, int col2, int row2) throws WriteException, RowsExceededException {
        if (col2 < col1 || row2 < row1) {
            logger.warn("Cannot merge cells - top left and bottom right incorrectly specified");
        }
        if (col2 >= this.numColumns || row2 >= this.numRows) {
            this.addCell(new Blank(col2, row2));
        }
        SheetRangeImpl range = new SheetRangeImpl(this, col1, row1, col2, row2);
        this.mergedCells.add(range);
        return range;
    }

    public void unmergeCells(Range r) {
        this.mergedCells.unmergeCells(r);
    }

    public void setHeader(String l, String c, String r) {
        this.sheetWriter.setHeader(new HeaderRecord(l, c, r));
    }

    public void setFooter(String l, String c, String r) {
        this.sheetWriter.setFooter(new FooterRecord(l, c, r));
    }

    public void setPageSetup(PageOrientation p) {
        this.settings.setOrientation(p);
    }

    public void setPageSetup(PageOrientation p, double hm, double fm) {
        this.settings.setOrientation(p);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public void setPageSetup(PageOrientation p, PaperSize ps, double hm, double fm) {
        this.settings.setPaperSize(ps);
        this.settings.setOrientation(p);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public SheetSettings getSettings() {
        return this.settings;
    }

    WorkbookSettings getWorkbookSettings() {
        return this.workbookSettings;
    }

    public void addRowPageBreak(int row) {
        Iterator i = this.rowBreaks.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            if ((Integer)i.next() != row) continue;
            found = true;
        }
        if (!found) {
            this.rowBreaks.add(new Integer(row));
        }
    }

    private Chart[] getCharts() {
        return this.sheetWriter.getCharts();
    }

    private Drawing[] getDrawings() {
        Drawing[] dr = new Drawing[this.drawings.size()];
        System.arraycopy(this.drawings.toArray(), 0, dr, 0, dr.length);
        return dr;
    }

    void checkMergedBorders() {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.hyperlinks, this.mergedCells, this.columnFormats);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.checkMergedBorders();
    }

    private WorkspaceInformationRecord getWorkspaceOptions() {
        return this.sheetWriter.getWorkspaceOptions();
    }

    void rationalize(IndexMapping xfMapping, IndexMapping fontMapping, IndexMapping formatMapping) {
        Iterator i = this.columnFormats.iterator();
        while (i.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i.next();
            cir.rationalize(xfMapping);
        }
        Chart[] charts = this.getCharts();
        for (int c = 0; c < charts.length; ++c) {
            charts[c].rationalize(xfMapping, fontMapping, formatMapping);
        }
    }

    WritableWorkbookImpl getWorkbook() {
        return this.workbook;
    }

    public CellFormat getColumnFormat(int col) {
        return this.getColumnView(col).getFormat();
    }

    public int getColumnWidth(int col) {
        return this.getColumnView(col).getDimension();
    }

    public int getRowHeight(int row) {
        return this.getRowView(row).getDimension();
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    public CellView getRowView(int row) {
        CellView cv = new CellView();
        try {
            RowRecord rr = this.getRowRecord(row);
            if (rr == null || rr.isDefaultHeight()) {
                cv.setDimension(this.settings.getDefaultRowHeight());
            } else if (rr.isCollapsed()) {
                cv.setHidden(true);
            } else {
                cv.setDimension(rr.getRowHeight());
            }
            return cv;
        }
        catch (RowsExceededException e) {
            cv.setDimension(this.settings.getDefaultRowHeight());
            return cv;
        }
    }

    public CellView getColumnView(int col) {
        ColumnInfoRecord cir = this.getColumnInfo(col);
        CellView cv = new CellView();
        if (cir != null) {
            cv.setDimension(cir.getWidth() / 256);
            cv.setHidden(cir.getHidden());
            cv.setFormat(cir.getCellFormat());
        } else {
            cv.setDimension(this.settings.getDefaultColumnWidth());
        }
        return cv;
    }

    public void addImage(WritableImage image) {
        int i;
        java.io.File imageFile = image.getImageFile();
        String fileName = imageFile.getName();
        int fileTypeIndex = fileName.lastIndexOf(46);
        String fileType = fileTypeIndex != -1 ? fileName.substring(fileTypeIndex + 1) : "";
        boolean supported = false;
        for (i = 0; i < imageTypes.length && !supported; ++i) {
            if (!fileType.equalsIgnoreCase(imageTypes[i])) continue;
            supported = true;
        }
        if (supported) {
            this.workbook.addDrawing(image);
            this.drawings.add(image);
        } else {
            System.err.print("Warning:  image type " + fileType + " not supported.  Supported types are " + imageTypes[0]);
            for (i = 1; i < imageTypes.length; ++i) {
                System.err.print(", ");
                System.err.print(imageTypes[i]);
            }
            System.err.println();
        }
    }

    public int getNumberOfImages() {
        return this.drawings.size();
    }

    public WritableImage getImage(int i) {
        return (WritableImage)this.drawings.get(i);
    }

    public void removeImage(WritableImage wi) {
        boolean removed = this.drawings.remove(wi);
        this.workbook.removeDrawing(wi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ColumnInfoComparator
    implements Comparator {
        private ColumnInfoComparator() {
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Assert.verify(o1 instanceof ColumnInfoRecord);
            Assert.verify(o2 instanceof ColumnInfoRecord);
            ColumnInfoRecord ci1 = (ColumnInfoRecord)o1;
            ColumnInfoRecord ci2 = (ColumnInfoRecord)o2;
            return ci1.getColumn() - ci2.getColumn();
        }
    }
}

