/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.Syntax;

import com.Ostermiller.Syntax.ToHTML;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class ToHTMLAntTask
extends MatchingTask {
    private ToHTML toHTML = new ToHTML();
    private File srcDir;
    private File destDir = null;

    public ToHTMLAntTask() {
        this.toHTML.setStyleSheet("syntax.css");
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setMime(String string) {
        this.toHTML.setMimeType(string);
    }

    public void setLexer(String string) {
        this.toHTML.setLexerType(string);
    }

    public void setTitle(String string) {
        this.toHTML.setTitle(string);
    }

    public void setTemplate(String string) throws MalformedURLException {
        this.toHTML.setTemplate(new URL(this.getProject().getBaseDir().toURL(), string).toString());
    }

    public void setCSS(String string) {
        this.toHTML.setStyleSheet(string);
    }

    public void addConfiguredParameter(Parameter parameter) throws BuildException {
        if (parameter.getType().equals("ignore")) {
            if (parameter.getName() == null) {
                throw new BuildException("ignore parameter must have a name!");
            }
            if (parameter.getValue() != null) {
                throw new BuildException("ignore parameter does not take a value!");
            }
            this.toHTML.addIgnoreStyle(parameter.getName());
        } else if (parameter.getType().equals("translate")) {
            if (parameter.getName() == null || parameter.getValue() == null) {
                throw new BuildException("translate parameter must have a name and value!");
            }
            this.toHTML.translateStyle(parameter.getName(), parameter.getValue());
        } else {
            throw new BuildException("unknown parameter type: " + parameter.getType());
        }
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            this.srcDir = this.getProject().getBaseDir();
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.srcDir == null) {
            this.destDir = this.srcDir;
        }
        if (!this.destDir.exists()) {
            throw new BuildException("destdir does not exist!");
        }
        if (!this.destDir.isDirectory()) {
            throw new BuildException("destdir is not a directory!");
        }
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        SourceFileScanner sourceFileScanner = new SourceFileScanner((Task)this);
        String[] stringArray2 = sourceFileScanner.restrict(stringArray, this.srcDir, this.destDir, new FileNameMapper(){

            public void setFrom(String string) {
            }

            public void setTo(String string) {
            }

            public String[] mapFileName(String string) {
                return new String[]{string + ".html"};
            }
        });
        try {
            if (stringArray2.length > 0) {
                System.out.println("Applying syntax highlighting to " + stringArray2.length + " files.");
            }
            int n = 0;
            while (n < stringArray2.length) {
                File file = new File(this.destDir, stringArray2[n] + ".html");
                File file2 = file.getParentFile();
                if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                    throw new BuildException("could not create directory: " + file2);
                }
                this.toHTML.setInput(new FileReader(stringArray2[n]));
                this.toHTML.setOutput(new FileWriter(file));
                this.toHTML.setDocNameFromFileName(stringArray2[n]);
                this.toHTML.setExtFromFileName(stringArray2[n]);
                this.toHTML.writeFullHTML();
                ++n;
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }
}

