/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.Syntax.Lexer;

import com.Ostermiller.Syntax.Lexer.Token;

public class PlainToken
extends Token {
    public static final int TEXT = 512;
    public static final int WHITE_SPACE = 3584;
    private int ID;
    private String contents;
    private int lineNumber;
    private int charBegin;
    private int charEnd;
    private int state;

    public PlainToken(int n, String string, int n2, int n3, int n4) {
        this(n, string, n2, n3, n4, -1);
    }

    public PlainToken(int n, String string, int n2, int n3, int n4, int n5) {
        this.ID = n;
        this.contents = new String(string);
        this.lineNumber = n2;
        this.charBegin = n3;
        this.charEnd = n4;
        this.state = n5;
    }

    public int getState() {
        return this.state;
    }

    public int getID() {
        return this.ID;
    }

    public String getContents() {
        return new String(this.contents);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharBegin() {
        return this.charBegin;
    }

    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isText() {
        return this.ID >> 8 == 2;
    }

    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    public boolean isError() {
        return false;
    }

    public boolean isComment() {
        return false;
    }

    public String getDescription() {
        if (this.isText()) {
            return "text";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        return "unknown";
    }

    public String errorString() {
        return "";
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

