#!/bin/sh
#---------------------------------------------------------------------------
#   For Unix/Linux
#
#   Start the MM3-WebAssistant - Proxy Offline Browser - Private
#


echo
echo "Would you like to start the MM3-WebAssistant without a console?"
echo "Please click on the file: MM3-WebAssistant.jar"
echo 
echo "If the program doesn't start with that:"
echo " - Java isn't installed" 
echo " - or a faulty file type assignment to Java exists"
echo 
echo "See FAQ: http://www.Proxy-Offline-Browser.com/faq.html"
echo 


#   JAVA_JRE  environment variable must point to your Java Virtuale Machine (JRE).
#             example: JAVA_JRE=/usr/lib/sun/jre1.6.0/bin/java
JAVA_JRE=java


#   Change to the directory which contains the file MM3-WebAssistant.jar.
cd `dirname $0`/..


#   Start the MM3-WebAssistant
"$JAVA_JRE" -jar MM3-WebAssistant.jar


if [ "$?" != "130" ]; then
  echo
  echo "Java isn't installed"
  echo "or the environment variable is not defined correctly."
  echo "Please install Java or define the environment variable in this script-file."
  echo
  echo "You find downloads for Java locally:"
  echo "documentation/getJava-English.html"
  echo
  firefox "`dirname $0`/../documentation/getJava-English.html" &
fi
