###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################

require "$currdir/if_lib/init.pl";
if ($FORM{'skin'} && ($config_skin_name ne $FORM{'skin'}) && -e "$base_skin_dir/$FORM{'skin'}/config_skin.pl") {
   $skin_dir = $base_skin_dir . "/" . $FORM{'skin'};
   $skin_url = $base_skin_url . "/" . $FORM{'skin'};
   require "$skin_dir/config_skin.pl";
}
$numtolist = $columns * $rows;
$no_preview_link = ();
$download_link_under_thumbnail = ();
$using_lightbox_mod = ();
if ($using_lightbox_mod) { &lb_jscript; }
require "$libpath/thumbnails.pl";
&top;


###############################################################################
# TOP
###############################################################################
sub top {

   $| = 1;   # flush output

   $allow_free_access = 1;  # Really inportant to include in imageThumb.cgi !
   $imageThumb_cgi = 1;
   $new_date = 999;

   if ($FORM{'direct'}) {
      $FORM{'cat'} = $FORM{'direct'};
      if (!-d "$image_directory/$FORM{'direct'}") {
         &Error("The category \"$FORM{'direct'}\" is not valid!");
      }
   }

   if ($FORM{'thumbnail'}) {
      if (!$FORM{'direct'}) {
         &Error("You need to specify the category of the thumbnail \"$FORM{'thumbnail'}\"");
      }
      elsif ($FORM{'thumbnail'} != /$mypattern/) {
         &Error("\"$FORM{'thumbnail'}\" is not a thumbnail!");
      }
      elsif (!-e "$image_directory/$FORM{'direct'}/$FORM{'thumbnail'}") {
         &Error("The thumbnail \"$FORM{'thumbnail'}\" in category \"$FORM{'direct'}\" could not be found!");
      }
      else {
         $name = "$FORM{'thumbnail'}";
         $path = "$FORM{'direct'}";
         $found = 1;
      }
   }
   else {
      if ($FORM{'search'} eq "NEW") {
         $sortfiles = 1;
         $cache_sort = 1;
      }
      elsif ($FORM{'search'} eq "HITS") {
         $sortfiles = 1;
         $cache_sort = 3;
      }
      elsif ($FORM{'search'} eq "RATES") {
         $sortfiles = 1;
         $cache_sort = 4;
      }
      elsif ($FORM{'search'} eq "RANDOM") {
         $sortfiles = 5;
         $cache_sort = 5;
      }
      elsif ($FORM{'sort'} =~ /\d/) {
         $sortfiles = $FORM{'sort'};
         $cache_sort = $FORM{'sort'};
      }
      else {
         $sortfiles = 5;
         $cache_sort = 5;
         if (!$FORM{'search'}) {
            $FORM{'search'} = "RANDOM";
         }
      }

      if ($FORM{'show_tn'} =~ /\d/) {
         $show_tn = $FORM{'show_tn'};
      }
      else {
         $show_tn = 1;
      }

      $cachefilename = "thumb~$FORM{'search'}~sort$cache_sort~show_tn$show_tn";
      $cachefilename .= "~$FORM{'direct'}" if $FORM{'direct'};
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";

      if (-e "$cacheloc") {
         if (-M "$cacheloc" <= $cache_date) {
            &open_cache;
         }
         else {
            &new_thumb_search;
         }
      }
      else {
         &new_thumb_search;
      }
   }

    push(@names, $name);
    $thumb_search = $FORM{'search'};
    $FORM{'search'} = ();
   $FORM{'direct'} = ();
   &build_thumbnail_table;

   if ($FORM{'bgcolor'}) {
      $iframe_bg = qq| bgcolor="#$FORM{'bgcolor'}"|;
   }
   if ($FORM{'title'}) {
      $iframe_title = qq|<tr><td align=center><$font>$FORM{'title'}</font></td></tr>|;
   }

   if ($found) {
      $imagethumb = qq|
         <html><head>
         $if_javascript
         </head><body$iframe_bg><center>
         <table border="0" cellspacing=1 cellpadding=2 bgcolor="$thumb_table_border_color">
            $iframe_title
            <tr bgcolor="$thumb_table_bgcolor">
               <td>
                 <table border="0" cellspacing=0 cellpadding=0>
                    <tr>
                       $imagethumb
                    </tr>
                 </table>
               </td>
            </tr>
         </table></center></body></html>|;
   }
   elsif ($FORM{'forum'} && ($thumb_search =~ /^USER~/)) {
      $imagethumb = qq|
         <html><head>
         <SCRIPT LANGUAGE="JavaScript"><!--
         function admin_sign_out() {
            document.cookie="IF_UID=; path=/";
            return true;
         }
         // --></SCRIPT>
         </head><body$iframe_bg><center>
         <table border="0" cellspacing=1 cellpadding=2 bgcolor="$thumb_table_border_color">
            $iframe_title
            <tr bgcolor="$thumb_table_bgcolor">
               <td align="center"><$font>Go ahead and try this out. Sign in <a href="$imagefolio_url?login=1" onclick="admin_sign_out();" target="_parent"><b>here</b></a> with your forum username/password and upload something.</font><br></td>
            </tr>
         </table></center></body></html>|;
   }
   else {
      $imagethumb = qq|
         <html><body$iframe_bg><center>
         <table border="0" cellspacing=1 cellpadding=2 bgcolor="$thumb_table_border_color">
            $iframe_title
            <tr bgcolor="$thumb_table_bgcolor">
               <td align="center"><$font><font color=red><b>404</b></font><br><br>No File Found</font><br></td>
            </tr>
         </table></center></body></html>|;
   }

   print "Content-type: text/html\n\n"; 
   print "$imagethumb";

}

sub new_thumb_search {
   @search = split(/\s+/, $FORM{'search'});
   require "$libpath/search.pl";
   if ($FORM{'search'} =~ /^USER~/) {
      ($blah, $search_user) = split(/~/, $FORM{'search'});
   }
   $FORM{'bool'} = "and";
   &search_index;
   if ($found) {
      if ($show_tn > @names) {
         $show_tn = @names;
      }
      ($name,$path,$filedate,$hits,$votes) = split(/\|/, @names[$show_tn-1]);
      @names = ();
      if ($sortfiles != 5) {
         open (CACHE,">$cacheloc");
         print CACHE "blah|$name|$path|$filedate|$hits|$votes|\n";
         close(CACHE);
         chmod(0666,"$cacheloc");
      }
   }
}

sub open_cache {

   open (FILE,"$cacheloc") or &Error("Can't Open $cacheloc, is it created?: $!");
   my(@LINES)=<FILE>;
   close(FILE);
   if ($sortfiles == 5) {
      $NEWINDEXSIZE = @LINES;
      $show_tn = int(rand($NEWINDEXSIZE));
   }
   else {
      $show_tn = 1;  #the correct tn is now cached
   }
   ($blah,$name,$path,$filedate,$hits,$votes) = split(/\|/, $LINES[$show_tn-1]);
   if ($name) {
      $found = 1;
   }
}

###############################################################################
# Error
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{
   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<html>
<head>
<title>Error</title>
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="150" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="150"><tr bgcolor="000000">
<td nowrap><$font><font color="#ffffff"><strong>Error!</strong></font></font></td>
<td align=right nowrap><$font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
</body>
</html>
|;

exit;
}
1;