###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################

require "$currdir/if_lib/init.pl";
&top;


###############################################################################
# TOP
# Determines what to do
###############################################################################
sub top {

   $| = 1;

   if ($is_admin) {
      $site_title = "***Admin Mode*** $site_title";
      $admin_tools = &create_tools;
      $cache_page_age = ();
      $cache_date = ();
      $allow_free_access = 1;
      $full_size_per = 1;
      $one_time_access = $FORM{'ota'};
   }

   if ($COOKIE{'cachereload'}) {
      ($cachereload_direct, $cachereload_link) = split(/\|/, $COOKIE{'cachereload'});
      if ($FORM{'direct'} && $cachereload_direct) {
         $force_cachereload = 1;
         $cachereload_direct = $cachereload_direct - 1;
      }
      elsif ($FORM{'link'} && $cachereload_link) {
         $force_cachereload = 1;
         $cachereload_link = ();
      }
      if ($cachereload_direct or $cachereload_link) {
         print "Set-Cookie: cachereload=$cachereload_direct|$cachereload_link; path=/;\n";
      }
      else {
         print "Set-Cookie: cachereload=; path=/;\n";
      }
   }

   if (($FORM{'lightbox'} eq 'view') or ($FORM{'lbview'} eq 'view') or $FORM{'account'}) {
      $cache_page_age = ();
   }

   $cache_page_age = () if $using_lightbox_mod; # will need to be fixed

   if ($cache_page_age) {
      if (!$full_query && !-e "$cache_directory/pages/index.html") {
         my $index_page =  qq|<HTML><HEAD><TITLE>Forbidden</TITLE></HEAD><BODY BGCOLOR="#FFFFFF">Please rebuild your index to reset the page caching!.</BODY></HTML>|;
         open (FILE,">$cache_directory/pages/index.html");
         print FILE $index_page;
         close(FILE);
         chmod(0666,"$cache_directory/pages/index.html");
      }
      $full_query_save = $full_query;
      $full_query_save .= "~$group_group_name~$skin_name~${columns}x$rows~sort$sortfiles~$use_textlinks~$thumb_info_right";
      $full_query_save =~ s/[^0-9a-zA-Z\_]/~/g;
      $full_query_save =~ s/~x~[0-9]*~y~[0-9]*//g;
      $cache_page_path = $cache_directory . "/pages/$full_query_save.html";
      $cache_page_url = $cache_url . "/pages/$full_query_save.html";
   }

   if ($cache_page_age && (-e $cache_page_path) && (-M $cache_page_path < $cache_page_age) && !$force_cachereload) {
      open (CACHEPAGE,"$cache_page_path") or &Error("Could not open cachepage.  Reason $!");
      while (<CACHEPAGE>) {
         $template .= $_;
      }
      close(CACHEPAGE);
      if (!$allow_free_access or ($group_cat_access eq 'All')) {
         &A001100;
      }
      else {
         print "Content-type: text/html\n\n";
         print $template;
      }
      if (($FORM{'action'} eq "view") && $record_counts) { 
         require "$libpath/image.pl";
         ($newimage) = $FORM{'image'} =~ m,^(.*)\.\w+$,;
         &record_counts;
      }
#      print $cache_page_path;
   }
   else {
      &load_values;
      if ($FORM{'admin'} && ($is_admin or $is_user))  {                                         &fe_top($FORM{'admin'}); $B001100=1;}
      elsif ($FORM{'link'})                           { require "$libpath/image.pl";            &view_image;            }
      elsif ($FORM{'lightbox'} or $FORM{'lbview'})    { require "$libpath/lightbox.pl";         &gen_image_table;       }
      elsif ($FORM{'direct'})                         { require "$libpath/direct.pl";           &gen_image_table;       }
      elsif ($FORM{'search'})                         { require "$libpath/search.pl";           &search;                }
      elsif ($FORM{'account'})                        { require "$libpath/accounts.pl";         &do_accounts;           }
      elsif ($FORM{'imageconvert'} && ($is_admin))    { require "$libpath/imageconvert.pl";     &load_ic;               }
      elsif ($FORM{'globalkeywords'})                 { require "$libpath/keywords.pl";         &gen_keywords_page;     }
      else                                            { require "$libpath/home.pl";             &gen_home_page;         }

      if ($cache_page_age) {
         if ($allow_free_access && ($group_cat_access ne 'All')) {
            &A001100;
         }
         open (CACHEPAGE,">$cache_page_path");
         print CACHEPAGE $template;
         close(CACHEPAGE);
         chmod(0644,"$cache_page_path");
         if (!$allow_free_access or ($group_cat_access eq 'All')) {
            &A001100;
         }
      }
      elsif (!$B001100) {
         &A001100;
      }
   }
}


###############################################################################
# LOAD VALUES
# Establishes default values for commonly used variables
###############################################################################
sub load_values {
   my ($found, $i, $pos, $count, $cnt, $nav, $subcatlinks, $thumbimages, $template);

   if ($FORM{'direct'}) {
     if ( (!(-e "$image_directory/$FORM{'direct'}")) or(!(-d "$image_directory/$FORM{'direct'}")) or ($FORM{'direct'} =~ /\.\./) ) {
        @count_direct = split(/\//, $FORM{'direct'});
        if ($using_picturepost_mod && (@count_direct == 2)) {
           require "$config_directory/post_config.pl";
           if ($main_users_cat eq $current_cat_root) {
             print qq|Content-type: text/html\n\n<br><br><center><font face="Verdana,Arial,Helvtica" size=2>
             <font color="red"><b>No Files Found!</font>  @count_direct[1]</b> has not uploaded anything so nothing can be shown.<br><br>
             <a href="javascript:history.go(-1)"><b>Return to Previous Page</b></a><br><br><a href="$imagefolio_url"><b>$site_title</b></a></font></center>|;
             exit;
           }
           else {
             print qq|Content-type: text/html\n\n<br><br><center><font face="Verdana,Arial,Helvtica" size=2>
             <font color="red"><b>Error!</font>  $FORM{'direct'}</b> is not a valid category!<br><br>
             <a href="javascript:history.go(-1)"><b>Return to Previous Page</b></a></font></center>|;
             exit;
           }
        }
        else {
          print qq|Content-type: text/html\n\n<br><br><center><font face="Verdana,Arial,Helvtica" size=2>
          <font color="red"><b>Error!</font>  $FORM{'direct'}</b> is not a valid category!<br><br>
          <a href="javascript:history.go(-1)"><b>Return to Previous Page</b></a></font></center>|;
          exit;
        }
     }
     $thisdirectory = get_directory($FORM{'direct'});
     $newthisdirectory = get_clean_name($thisdirectory);
   }
   elsif ($FORM{'link'}) {
     if ($FORM{'link'} =~ /\.\./) {
       print qq|Content-type: text/html\n\n<br><br><center><font face="Verdana,Arial,Helvtica" size=2>
       <font color="red"><b>Error!</font>  $FORM{'link'}</b> is not a valid category!<br><br>
       <a href="javascript:history.go(-1)"><b>Return to Previous Page</b></a></font></center>|;
       exit;
     }
     $thisdirectory = get_directory($FORM{'link'});
     $newthisdirectory = get_clean_name($thisdirectory);
   }
}

1;