#!/usr/bin/perl
###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################

BEGIN {
   ($currdir, $currscript) = $0 =~ m#^(.*)[\\|/](.*)#;
    if (!$currdir) {
#       $currdir = `pwd`;
#       chomp $currdir;
       $currdir = ".";
       $currscript = $0;
    }
    else {
       $currdir =~ s/\\/\//ig;
    }
};



eval {
   $| = 1;
   $full_query = $ENV{'QUERY_STRING'};
   unshift (@INC, $currdir);
   use lib "$currdir/CPAN";

   if (-e "$currdir/data/config/main.pl") {
      require "$currdir/data/config/main.pl";
      eval{require "$currdir/data/config/skins.pl";};
   }
   else {
      require "$currdir/if_lib/setup.pl";
      &do_setup;
   }
   require "$currdir/config/pathsurls_config.pl";
   require "$libpath/error.pl";
   require "$config_directory/config.pl";
   if (($ifup) = $full_query =~ /^ifup\=(.*)/) {
      ($ifup, $ENV{'QUERY_STRING'}) = split(/\?/, $ifup) if $ifup =~ /\?/;
      ($ifup) = split(/\&/, $ifup);
      $ifup =~ s/\.\.//g;
      if (-e "$admindir_directory/$ifup.pl") {
         require "$admindir_directory/$ifup.pl";
      }
      else {
         die "Can't find upload script: $ifup";
      }
   }
   elsif (!$ENV{'HTTP_USER_AGENT'}) {
      require "$currdir/admin/commandline.pl";
   }
   else {
      if ($full_query =~ /^admin\=admin\&cgi\=templates\.pl/ or $full_query =~ /^admin\=admin\&cgi\=headerfooter\.pl/) {
         require "$admindir_directory/admin_parse.pl";
      }
      else {
         &parse_form;
      }
      if ($FORM{'lightbox'} eq 'update') {
#         close STDIN;
#         close STDOUT;
         require "$libpath/lightbox.pl";
         &update_lightbox;
      }
      elsif ($FORM{'admin'} =~ /^(admin|build)$/) {
         require "$admindir_directory/$FORM{'admin'}.pl";
      }
      elsif (-e "$commercepath/$FORM{'commerce'}.pl") {
         require "$commercepath/$FORM{'commerce'}.pl";
      }
      elsif (-e "$mainpath/$FORM{'main'}.pl") {
         require "$mainpath/$FORM{'main'}.pl";
      }
      else {
         require "$mainpath/imageFolio.pl";
      }
   }
};


if ($@) { print "Content-type: text/html\n\n<pre>Script Error: $@</pre>\n"; }

exit;

###############################################################################
# PARSE THE FORM
# Parses the form input and returns a hash with all the name
# value pairs.
###############################################################################
sub parse_form {
   my ($buffer, $pair, $name, $value);

   if ($ENV{'REQUEST_METHOD'} eq 'GET') {
     @formpairs = split(/&/, $ENV{'QUERY_STRING'});
   }
   elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
     read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
     $cache_page_age = ();
     @formpairs = split(/&/, $buffer);
   }

   foreach $pair (@formpairs) {
     ($name, $value) = split(/=/, $pair);
     $name =~ tr/+/ /;
     $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ s/\.\.//g;
     $value =~ s/\t//g;
     $value =~ s/\|//g;
     if ($FORM{'admin'} ne 'admin') {
         $value =~ s/(<|\%\W*3\W*c|\&lt)\/?[^>]*(>|\%\W*3\W*e|\&gt)//mig;
         $value =~ s/(<|\%\W*3\W*c|\&lt)//mig;
         $value =~ s/(>|\%\W*3\W*e|\&gt)//mig;
#         $value =~ s/(\(|\%28)//mig;
#         $value =~ s/(\)|\%29)//mig;
     }
     if ($FORM{$name} && ($value) && $name ne "uid") { $FORM{$name} = "$FORM{$name},$value"; }
     elsif ($value) { $FORM{$name} = $value; }
   }
   if (lc($FORM{'cat'}) eq 'all') {$FORM{'cat'} = ();}
   $current_cat = $FORM{'cat'} if $FORM{'cat'};
   $current_cat = $FORM{'direct'} if $FORM{'direct'};
   $current_cat = $FORM{'link'} if $FORM{'link'};
   if (($FORM{'search'} eq 'USER') && $FORM{'username'}) {
      $FORM{'username'} =~ s/[$deny_chars]//g;
      $FORM{'search'} = "USER~$FORM{'username'}";
   }
   ($current_cat_root) = split (/\//, $current_cat);
}

