###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################

use lib "$cpanpath";

###############################################################################
# BUILD NAV
# creates previous, home, and next link buttons if necessary
###############################################################################
sub build_nav {

   $textnav .= qq|\||;

   if ($previous_page_link) { 
      $nav .= qq|<a href="$previous_page_link"><img src="$previous_image" border=0 alt="View Previous Page" title="View Previous Page"></a>|;
      $textnav .= qq| <a href="$previous_page_link" alt="View Previous Page" title="View Previous Page">Previous</a> \||;
      $imagepage_textlinks = qq|<a href="$previous_page_link" alt="View Previous" title="View Previous">[&lt;&lt;] Previous</a> |;
   }
   if ($is_admin && $using_picturepost_mod){
      $nav .= qq|<a href="$imagefolio_url?search=APPROVE"><img src="$approve_image" border=0 alt="View Pending Approval" title="View Pending Approval"></a>|;
      $textnav .= qq| <a href="$imagefolio_url?search=APPROVE" alt="View Pending Approval" title="View Pending Approval">Pending</a> \||;
#      push(@storemainnav, qq|<a class=mainnav href="$imagefolio_url?search=APPROVE" alt="View Pending Approval" title="View Pending Approval">Pending</a>|);
   }

   if ($homelink) {
      $nav .= qq|<a href="$homelink"><img src="$home_image" border=0 alt="Return to Home Page" title="Return to Home Page"></a>|;
      $textnav .= qq| <a href="$homelink" alt="Return to Home Page" title="Return to Home Page">Home</a> \||;
   }

   $nav .= qq|%%%UPLOAD_BUTTON%%%|;
   $textnav .= qq|%%%UPLOAD_BUTTON_NEXT_NAV%%%|;


   if ($keyword_threshold) {
      $nav .= qq|<a href="$imagefolio_url?globalkeywords=1"><img src="$keywords_image" border=0 alt="View Keywords" title="View Keywords"></a>|;
      $textnav .= qq| <a href="$imagefolio_url?globalkeywords=1" alt="View Keywords" title="View Keywords">Keywords</a> \||;
#      push(@storemainnav, qq|<a class=mainnav href="$imagefolio_url?globalkeywords=1" alt="View Keywords" title="View Keywords">Keywords</a>|);
   }

   if ($using_lightbox_mod==1){
      $nav .= qq|<a href="$imagefolio_url?lightbox=view&ct=$current_time"><img src="$if_images_directory/$lightbox_view_gif" border=0 alt="View $lightbox_name" title="View $lightbox_name"></a>|;
      $textnav .= qq| <a href="$imagefolio_url?lightbox=view&ct=$current_time" alt="View $lightbox_name" title="View $lightbox_name">$lightbox_name</a> \||;
#      push(@storemainnav, qq|<a class=mainnav href="$imagefolio_url?lightbox=view&ct=$current_time" alt="View $lightbox_name" title="View $lightbox_name">$lightbox_name</a>|);
   }
   if ($display_new){
      $nav .= qq|<a href="$imagefolio_url?search=NEW"><img src="$newlyadd_image" border=0 alt="View Newly Added" title="View Newly Added"></a>|;
      $textnav .= qq| <a href="$imagefolio_url?search=NEW" alt="View Newly Added" title="View Newly Added">New</a> \||;
#      push(@storemainnav, qq|<a class=mainnav href="$imagefolio_url?search=NEW" alt="View Newly Added" title="View Newly Added">New</a>|);
   }
   if ($display_random){
      $nav .= qq|<a href="$imagefolio_url?search=RANDOM"><img src="$random_image" border=0 alt="View Random Display" title="View Random Display"></a>|;
      $textnav .= qq| <a href="$imagefolio_url?search=RANDOM" alt="View Random Display" title="View Random Display">Random</a> \||;
#      push(@storemainnav, qq|<a class=mainnav href="$imagefolio_url?search=RANDOM" alt="View Random Display" title="View Random Display">Random</a>|);
   }
   if ($display_top_hits){
      $nav .= qq|<a href="$imagefolio_url?search=HITS"><img src="$tophits_image" border=0 alt="View Top Hits" title="View Top Hits"></a>|;
      $textnav .= qq| <a href="$imagefolio_url?search=HITS" alt="View Top Hits" title="View Top Hits">Top Hits</a> \||;
#      push(@storemainnav, qq|<a class=mainnav href="$imagefolio_url?search=HITS" alt="View Top Hits" title="View Top Hits">Top Hits</a>|);
   }
   if ($display_top_rates){
      $nav .= qq|<a href="$imagefolio_url?search=RATES"><img src="$toprates_image" border=0 alt="View Top Rated" title="View Top Rated"></a>|;
      $textnav .= qq| <a href="$imagefolio_url?search=RATES" alt="View Top Rated" title="View Top Rated">Top Rated</a> \||;
#      push(@storemainnav, qq|<a class=mainnav href="$imagefolio_url?search=RATES" alt="View Top Rated" title="View Top Rated">Top Rated</a>|);
   }

   if ($FORM{'action'} eq "view") {
      if ($FORM{'search'}) {
         $thumblinks .= qq|<a href="$imagefolio_url?search=$query&img=$FORM{'img'}&cat=$FORM{'cat'}&bool=$FORM{'bool'}" alt="Return to $searchphrase" title="Return to $searchphrase">|;
         $thumblinks .= qq|Return to $searchphrase</a><br>|;
         $thumblinks .= qq|<a href="$imagefolio_url?direct=$FORM{'link'}" alt="View this Category" title="View this Category">View this Category</a><br>|;
      }
      elsif ($FORM{'lbview'}) {
         if ($use_textlinks) {
            $thumblinks .= qq|<a href="$imagefolio_url?lightbox=$FORM{'lbview'}" alt="Return to $lightbox_name" title="Return to $lightbox_name">Return to $lightbox_name</a><br>|;
            $thumblinks .= qq|<a href="$imagefolio_url?direct=$FORM{'link'}" alt="View this Category" title="View this Category">View this Category</a><br>|;
         }
         else {
            $thumblinks .= qq|<a href="$imagefolio_url?lightbox=$FORM{'lbview'}" alt="Return to $lightbox_name" title="Return to $lightbox_name">Return to $lightbox_name</a><br>|;
            $thumblinks .= qq|<a href="$imagefolio_url?direct=$FORM{'link'}" alt="View this Category" title="View this Category">View this Category</a><br>|;         
         }
      }
      else {
         if ($use_textlinks) {
            $thumblinks .= qq|<a href="$imagefolio_url?direct=$FORM{'link'}&img=$FORM{'img'}" alt="Return to Thumbnail View" title="Return to Thumbnail View">Return to Thumbnail View</a><br>| unless $FORM{'search'};
         }
         else {
            $thumblinks .= qq|<a href="$imagefolio_url?direct=$FORM{'link'}&img=$FORM{'img'}" alt="Return to Thumbnail View" title="Return to Thumbnail View">Return to Thumbnail View</a><br>| unless $FORM{'search'};         
         }
      }
      if ($using_postcard_mod) {
         $thumblinks .= qq|<a href="$imagefolio_url?main=imageCard&action=ecard&link=$FORM{'link'}&image=$FORM{'image'}&img=$FORM{'img'}&tt=$FORM{'tt'}" alt="Send As A Postcard" title="Send As A Postcard">Send As A Postcard</a><br>|;
      }
      if ($auto_slideshow && $next_page_link) {
         if ($FORM{'slideshow'}) {
            $nav .= qq|<a href="$stop_link"><img src="$stop_image" border=0 alt="Stop Slideshow" title="Stop Slideshow"></a>|;
            $textnav .= qq| <a href="$stop_link" alt="Stop Slideshow" title="Stop Slideshow">Stop</a> \||;
            $imagepage_textlinks .= qq| <a href="$stop_link" alt="Stop Slideshow" title="Stop Slideshow">Stop</a> |;
         }
         else {
            $nav .= qq|<a href="$next_page_link&slideshow=1"><img src="$slide_image" border=0 alt="Play Slideshow" title="Play Slideshow"></a>|;
            $textnav .= qq| <a href="$next_page_link&slideshow=1" alt="Play Slideshow" title="Play Slideshow">Play</a> \||;
            $imagepage_textlinks .= qq| <a href="$next_page_link&slideshow=1" alt="Play Slideshow" title="Play Slideshow">Play</a> |;
         }
      }
   }

   if ($next_page_link) {
      $nav .= qq|<a href="$next_page_link"><img src="$next_image" border=0 alt="View Next Page" title="View Next Page"></a>|;
      $textnav .= qq| <a href="$next_page_link" alt="View Next Page" title="View Next Page">Next</a> \||;
      $imagepage_textlinks .= qq| <a href="$next_page_link" alt="View Next" title="View Next">Next [&gt;&gt;]</a>|;
   }


   $text_next_previous = $imagepage_textlinks;
   $text_next_previous =~ s/  / \| /g;
   
}

###############################################################################
# UNIX TO DATE
# Takes in a unix time and coverts it to legible form
###############################################################################
sub unix_to_date {
   my $time   = shift;
   my ($sec, $min, $hour, $day, $mon, $year, $dweek, $dyear, $tz) = localtime $time;
   my @months = qw!1 2 3 4 5 6 7 8 9 10 11 12!;
   $year += 1900;
   if ($eu_date_format) {
      return sprintf "%02d/%02d/%04d", $day, $months[$mon], $year;
   }
   else {
      return sprintf "%02d/%02d/%04d", $months[$mon], $day, $year;
   }
}

###############################################################################
# FIND DATE AND SIZE
###############################################################################
sub find_size_date {
   my ($date_size_cat, $date_size_file1, $date_size_file2) = @_;
   $filesize = ();
   $filedate = ();
   if ($save_upload_date) {
      $date_size_path = ();
      ($extension_date_1) = ($date_size_file1 =~ /\.([^.]+)$/);
      ($extension_date_2) = ($date_size_file2 =~ /\.([^.]+)$/);
      if (lc($extension_date_1) eq 'jpg') {
         $date_size_path = qq|$image_directory/$date_size_cat/$date_size_file1|;
      }
      elsif (lc($extension_date_2) eq 'jpg') {
         $date_size_path = qq|$image_directory/$date_size_cat/$date_size_file2|;
      }
      if ($date_size_path) {
         $upload_info = new Image::IPTCInfo("$date_size_path");
         if (defined($upload_info)){
            $attribute_custom18 = $upload_info->Attribute('custom18');
            if ($attribute_custom18 !~ /\D/) {
               $custom18_date = $attribute_custom18;
            }
            else {
               ($custom18_date) = $attribute_custom18 =~ /\[(.*?)\]/g;
            }
            if ($custom18_date) {
               $filedate = $custom18_date;
            }
         }
      }
   }
   if ($use_fullsize) {
      ($fullsize_name) = $date_size_file1 =~ m,^(.*)\.\w+$,;
      $fullsize_name =~ s/$mypattern//ig;
      $fullsize_name = qq|$mypattern_fullsize$fullsize_name.$myextension_fullsize|;
      $date_size_path = qq|$image_directory/$date_size_cat/$fullsize_name|;
      if (-e "$date_size_path") {
         $found_downloads = 1 if $display_downloads;
         ($filesize)  = (stat("$date_size_path"))[7];
         ($filedate)  = (stat("$date_size_path"))[9] unless $filedate;
         $file_type = $extensions{lc($myextension_fullsize)}[0];
         
         $totalfilesize += $filesize;
         $filesize_done = 1;

         my $uc_myextension_fullsize = uc($myextension_fullsize);

         if ($filesize < 1500) {
            $filesize = commify($filesize) . " bytes";
         }
         else { $filesize = int($filesize/1024);
            if ($filesize < 1500) {
               $filesize = commify($filesize) . " Kb";
            }
            else { $filesize = int($filesize/10.24);
               $filesize = ($filesize/100) . " Mb";
            }
         }


         if ($download_link_under_thumbnail) {
            $date_size_file1 =~ s/$mypattern//ig;
            if ($use_textlinks) {
               if ($uc_myextension_fullsize ne 'ZIP' && !$download_from_temp) {
                  $fullsize_link = qq|<a href="javascript:;" onClick="if (confirm('Do you want to download the $filesize $uc_myextension_fullsize file? (OK = Yes   Cancel = No)')) {location='$imagefolio_url?action=view&link=$date_size_cat&image=$date_size_file1&download=1';};return false;" alt="Download This File" title="Download This File"><$font_dl_link>Download</font></a><br>|;
               }
               else {
                  $fullsize_link = qq|<$font_dl_link><a href="javascript:;" onClick="location='$imagefolio_url?action=view&link=$date_size_cat&image=$date_size_file1&download=1';return false;" alt="Download This File" title="Download This File"><$font_dl_link>Download</font></a><br>|;
               }
            }
            else {
               if ($uc_myextension_fullsize ne 'ZIP' && !$download_from_temp) {
                  $fullsize_link = qq|<a href="javascript:;" onClick="if (confirm('Do you want to download the $filesize $uc_myextension_fullsize file? (OK = Yes   Cancel = No)')) {location='$imagefolio_url?action=view&link=$date_size_cat&image=$date_size_file1&download=1';};return false;"><img src="$if_images_directory/download2.$ButtonExt" border=0 alt="Download This File" title="Download This File"></a><br>|;
               }
               else {
                  $fullsize_link = qq|<a href="javascript:;" onClick="location='$imagefolio_url?action=view&link=$date_size_cat&image=$date_size_file1&download=1';return false;"><img src="$if_images_directory/download2.$ButtonExt" border=0 alt="Download This File" title="Download This File"></a><br>|;
               }
            }
         }
      }
      else {
         $found_downloads = ();
      }
   }
   ($filesize)  = (stat("$image_directory/$date_size_cat/$date_size_file1"))[7] unless $filesize;
   ($filedate)  = (stat("$image_directory/$date_size_cat/$date_size_file1"))[9] unless $filedate;
}

###############################################################################
# BUILD TITLE LINKED
# Returns a string of the current category broken up 
# by section, with each part linked to the respective section.
###############################################################################
sub build_title_linked {
   my $input = shift;
   my (@categories, @shorttitles, $cat, $output, $path, $last);
   @categories = split (/\//, $input);
   my @workcategories = @categories;
   foreach my $shortcat (@workcategories) {
       $shortcat = substr($shortcat, 0, ($title_cut_off-2)) . ".." if (length($shortcat) > $title_cut_off && $title_cut_off);
       push(@shorttitles, $shortcat);
   }
   $i=0;
   $last_title = get_clean_name(pop @categories);
   $last = get_clean_name(pop @shorttitles);
   $output = qq| <$font><A HREF="$imagefolio_url">Top</A> &gt;|;


   foreach my $cat (@categories) {
      if ($i < 1) { $path .= "$cat"; }
      else { $path .= "/$cat"; }
      my $titles = get_clean_name("$cat");
      my $link = get_clean_name("$shorttitles[$i]");
      $output .= qq| <A HREF="$imagefolio_url?direct=$path" title="$titles" alt="$titles">$link</A> &gt;|;
      $i++;
   }

   if ($FORM{'direct'}) {
      if ($totalnames > $numtolist) {
         if ($FORM{'img'}) { $imagecount = $FORM{'img'}; }
         else { $imagecount = "0"; }
         $pagenumber = int($imagecount / $numtolist);
         $pagenumber++;
         if ($pagenumber eq "1") { $output .= " <$font>$last</font>"; }
         else {
         $output .= qq| <A HREF="$imagefolio_url?direct=$FORM{'direct'}" title="$last_title" alt="$last_title">$last</A>
         &gt; Page $pagenumber|;
         }
      }
      else { $output .= " $last"; }
   }
   elsif ($FORM{'link'}) {
      $output .= qq| <a href="$imagefolio_url?direct=$FORM{'link'}&img=$FORM{'img'}" title="$last_title" alt="$last_title">$last</a> &gt; $newimage|;
   }
   $output .= "</font>";
   return $output;
}

###############################################################################
# BUILD PULL DOWN MENU
# Here we read the image directory get a list of directory names
# the names are then put in the @alldirectories
###############################################################################
sub build_pull_down_menu {



   if (-e $catdesc) { 
      open (DESC,"< $catdesc");
      while (<DESC>) {
         chomp;
         next if /^\s*$/; # skip blank lines
         next if /^#/;    # skip comment lines
         push(@desc, $_);
      }
      close(DESC);
   }

#   foreach $line (@desc) {
#      my ($catname, $catdescription) = split(/\t/, $line);
#      $catdescription =~ s/^\s+//g;
#      $catdescription =~ s/\s+$//g;
#      next if (!$catdescription);
#      if ($catname eq $FORM{'direct'}) {
#         $newthisdirectory .= qq|</b><br><font size=1 color="#FFFFFF">$catdescription<b></b></font></font>|;
#         last;
#      }
#   }
#    if (-e "$image_directory/$FORM{'direct'}/_category_image.jpg") {
#       $newthisdirectory = qq|<img src="$imageurl/$FORM{'direct'}/_category_image.jpg" align="left">$newthisdirectory|;
#    }



   $i=0;
   $j=0;


   $pulldown_menu = qq|
   <table border=0 cellspacing=0 cellpadding=1>
   <tr><form name="Categories" method=get action="$imagefolio_url">
   <td><select name="direct" onChange="window.location='$imagefolio_url?direct=' + this[this.selectedIndex].value">
   |;

   open (FILE,"$catfile");
   (@CATFILE_LINES)=<FILE>;
   close(FILE);
   chomp @CATFILE_LINES;
   $CATSIZE = @CATFILE_LINES;
   
   if ($use_textlinks) {
      $columncat = qq|<table border=0 cellspacing=0 cellpadding=2 width="100%">|;
   }
   else {
      $columncat = qq|<table border=0 cellspacing=1 cellpadding=3 width="100%">|;   
   }

   @alldirectories = ();

   if ($allow_free_access) {
      opendir (DIR, $image_directory) or &Error("Error Reading Directory: $!");
      @files = readdir(DIR);
      closedir (DIR);
      @files = sort { lc($a) cmp lc($b) } @files;
      @alldirectories = ();

      foreach $file (@files) {
         $found_access = ();
         if ( -d "$image_directory/$file" ) {                   #make sure this really is a directory
            chop $file if ($file =~ /\/$/);
            next if $file =~ /^\.\.?$/;                         #weed out all .. directories
            next if $file =~ /_vti_cnf/i;                       #weed out front page directories
#            if ($allow_free_access) {
               push(@alldirectories, $file);
#            }
#            else {
#               foreach $this_cat_access (@current_cat_access) {
#                  if ($this_cat_access eq $file) {
#                     $found_access=1;
#                     last;
#                  }
#               }
#               if ($found_access) {
#                  push(@alldirectories, $file);
#               }
#            }
         }
      }
   }
   else {
      foreach my $this_cat_access (@current_cat_access) {
         if ( -d "$image_directory/$this_cat_access" ) {
            push(@alldirectories, $this_cat_access);
         }
      }
   }

   if ($add_user_category) {
      push(@alldirectories, $add_user_category);
      $pd_catlist = get_clean_name($add_user_category);
      $pd_catlist = qq|<option value="$add_user_category"> - $pd_catlist</option>|;
   }

   $total_categories = $#alldirectories;

   if ($cat_columns == 2) {
      ($half) = int (($total_categories+2) / 2);
      $cat_column_width = 'width="50%"';
   }
   elsif ($cat_columns == 3) {
      ($half) = int (($total_categories+3) / 3);
      $cat_column_width = 'width="33%"';
   }
   else {
      $cat_column_width = 'width="100%"';
   }

   foreach $directory (@alldirectories) {
      $ttcount = 0;

      if ($alldirectories[$i] eq $FORM{'direct'} or $alldirectories[$i] eq $FORM{'link'}) {
         if ( -d "$image_directory/$alldirectories[($i+1)]" ) { $nextcat = $alldirectories[($i+1)]; }
         if ( -d "$image_directory/$alldirectories[($i-1)]" ) { $prevcat = $alldirectories[($i-1)]; }
      }

      $mydirectory = get_clean_name($directory);

      if ($current_cat_root eq $directory) {
         $selected = " selected";
      }
      else {
         $selected = ();
      }

      $catlist .= qq|<option value="$directory"$selected> - $mydirectory</option>| unless $directory eq $add_user_category;

      unless ($FORM{'direct'} or $FORM{'link'} or $FORM{'search'} or $FORM{'lightbox'}) {
#      unless ($FORM{'direct'} or $FORM{'link'} or $FORM{'search'} or $FORM{'lightbox'} or $skip_overhead) {
         $homepage = 1;
         $catmatch = $directory;
         &create_category_column;
      }
      $i++;
      $imagecount = "";
   }  # end of foreach

   $i=0;
   &create_jsrollovers if $homepage;
#   &create_jsrollovers;
   $columncat .= qq|</table>|;

   $pulldown_menu .= qq|$catlist$pd_catlist</select></td><td align=left>|;

   if ($use_textlinks) {
      $pulldown_menu .= qq|<input type=submit value="View">|;
   }
   else {
      $pulldown_menu .= qq|<a href="javascript:;" onClick="Categories.submit(); return false;"><img src="$if_images_directory/view.$ButtonExt" border="0"></a>|;
   }
   $pulldown_menu .= qq|</td></form></tr></table>|;


  # get the search box

   if ($FORM{'search'} =~ /^(RANDOM|NEW|HITS|RATES|USER~(.*)|APPROVE)$/) { $searchtag = ""; }
   else { $searchtag = $FORM{'search'}; }

   $search_box =~ s/%%%CATLIST%%%/$catlist/i;
   $search_box =~ s/%%%QUERY%%%/$searchtag/ig;
#   $search_box =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $search_box =~ s/%%%FONT%%%/$font/ig;
#   $search_box =~ s/%%%SEARCHBUTTON%%%/search\.$ButtonExt/ig;
   if ($use_textlinks) {
      $search_box =~ s/%%%SEARCHBUTTON%%%/<input type=button value="Search">/ig;
   }
   else {
      $search_box =~ s/%%%SEARCHBUTTON%%%/<img src="$if_images_directory\/search\.$ButtonExt" border="0">/ig;
   }



   my $radio_button_bgcolor = qq| bgcolor="$radio_bgcolor"|;
   $search_box =~ s/%%%RADIO_BGCOLOR%%%/$radio_button_bgcolor/g;
   if ($FORM{'bool'} eq "and") { $search_box =~ s/%%%AND%%%/CHECKED/ig; }
   elsif ($FORM{'bool'} eq "or") { $search_box =~ s/%%%OR%%%/CHECKED/ig; }
   elsif ($FORM{'bool'} eq "phrase") { $search_box =~ s/%%%PHRASE%%%/CHECKED/ig; }
   else { $search_box =~ s/%%%AND%%%/CHECKED/; }
   $search_box =~ s/%%%(.*)%%%//ig;

   # get the next and previous category text links

   if ($prevcat && !$FORM{'lbview'} && !$FORM{'search'}) {
      $newprevcat = get_directory($prevcat);
      $newprevcat = get_clean_name($newprevcat);
      $previous_category = qq|<$font><nobr>BACKWARD</nobr><br>
      <a href="$imagefolio_url?direct=$prevcat"><b>$newprevcat</b></a></font>|;
   }

   if ($nextcat && !$FORM{'lbview'} && !$FORM{'search'}) {
      $newnextcat = get_directory($nextcat);
      $newnextcat = get_clean_name($newnextcat);
      $next_category = qq|<$font><nobr>FORWARD</nobr><br>
      <a href="$imagefolio_url?direct=$nextcat"><b>$newnextcat</b></a></font>|;
   }
}

###############################################################################
# CREATE THE CATEGORY LIST
# Here we create 1, 2 or 3 colums with the categories listed
###############################################################################
sub create_category_column {
   $direct_link = "$imagefolio_url?direct=" if !$direct_link;
   my ($index_time)  = (stat($indexfile))[9];
   if ($random_thumbnail) {
      require "$libpath/iptc.pl";
   }
   if (($i == $half) && ($cat_columns == 2)) { 
      if ($use_textlinks) {
         $columncat .= qq|
                   </table>
                 </td>
                 <td $cat_column_width valign="top">
                   <table border=0 cellspacing=0 cellpadding=2 width="100%">
         |;
      }
      else {
         $columncat .= qq|
                   </table>
                 </td>
                 <td $cat_column_width valign="top">
                   <table border=0 cellspacing=1 cellpadding=3 width="100%">
         |;
      }
   }
   elsif (($i == $half) && ($cat_columns == 3)) {
      $i=0;   
      $catrest = $total_categories-$half;
      $half = int (($catrest+2) / 2);

      if ($use_textlinks) {
         $columncat .= qq|
                   </table>
                 </td>
                 <td $cat_column_width valign="top">
                   <table border=0 cellspacing=0 cellpadding=2 width="100%">
         |;
      }
      else {
         $columncat .= qq|
                   </table>
                 </td>
                 <td $cat_column_width valign="top">
                   <table border=0 cellspacing=1 cellpadding=3 width="100%">
         |;
      }
   }

   $cat_desc = "";

   if (-e $catdesc) {
      foreach $line (@desc) {
         my ($catname, $catdescription) = split(/\t/, $line);
         $catdescription =~ s/^\s+//g;    # trim leading blanks...
          $catdescription =~ s/\s+$//g;    # trim trailing blanks...
          next if (!$catdescription); # skip line if no description
         if ($catname eq $catmatch) { $cat_desc = "<br><$font>$catdescription</font><br>"; last; }
      }
   }
   $if_new = "";
   if ($display_counts or $use_new_image) {
      foreach $LINE (@CATFILE_LINES) {
         ($category, $totalcount, $catdate) = split(/\t/, $LINE);
         if (($category eq $catmatch) or ($category =~ /^$catmatch\//)) {
            if ($display_counts) {
               $ttcount += $totalcount;
            }
            if ($use_new_image) {
               my $elapsed = ($index_time - $catdate) / 86400; # 86400 sec = 1 day
               if ($elapsed <= $new_date) {
                  $if_new = qq|<img src="$new_image" border=0 alt="New" title="New">|;
               }
            }
         }
      }
      if ($display_counts) {
         $ttcount = $newcount if $do_cat_search;
         $imagecount = qq|<$count_font>($ttcount)</font> |;
      }
   }
   $if_new .= "<$count_font> (" . &unix_to_date($newdate) . ")</font>" if $do_cat_search;
#   if (!$jplus) {
#      $jplus = 1;
#      $jsrollovers .= qq|catimageon = new Image();\n|;
#      $jsrollovers .= qq|catimageon.src = "$caton_image";\n|;
#      $jsrollovers .= qq|catimageoff = new Image();\n|;
#      $jsrollovers .= qq|catimageoff.src = "$catoff_image";\n\n|;
#   }
   $j++;
   $mouseover  = qq| onmouseover="changeImages('image$j', 'catimageon')"|;
   $mouseover .= qq| onmouseout="changeImages('image$j', 'catimageoff')"|;
   $found_catimage = ();
   if (-e "$image_directory/$catmatch/_category_image.jpg") {
      $catimageurl="$imageurl/$catmatch/_category_image.jpg";
      $cellprob='align=center';
      $mouseover="";
      $catimageurl =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;
      $found_catimage = 1;
   }
   elsif ($random_thumbnail){
      $nothumb = ();
      $image = ();
      $custom18_approval = ();
      opendir(DIR,"$image_directory/$catmatch");
      @files = grep { /$mypattern/i } readdir(DIR);
      closedir(DIR);
      $thumblist = @files;
      if ($thumblist > 0) {
         &shuffle_catimage(\@files);
         for ($cnt=0; $cnt < $thumblist; $cnt++) {
            $image = @files[$cnt];
            $catimagepath = "$image_directory/$catmatch/$image";
            my $iptc_info = new Image::IPTCInfo("$catimagepath");
            if (defined($iptc_info)){
               $iptcvalue = $iptc_info->Attribute('custom18');
               ($custom18_date, $custom18_user, $custom18_email, $custom18_approval) = $iptcvalue =~ /\[(.*?)\]/g;
            }
            if (!$custom18_approval) {
               $found_catimage = 1;
               last;
            }
         }
      }
      if ($found_catimage) {
         $catimageurl="$imageurl/$catmatch/$image";
         $cellprob='align=center';
         $mouseover=();
         $catimageurl =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;
      }
      else{
         $catimageurl="$catoff_image";
         $cellprob='width=1';
      }
   }
   else {
      $catimageurl="$catoff_image";
      $cellprob='width=1';
   }
   if ($use_textlinks) {
      if ($found_catimage) {
         $icon_cell = qq|<td $cellprob valign=top><a href="$direct_link$catmatch" $mouseover><img name= "image$j" src="$catimageurl" border=0></a></td>|;
      }
      else {
         $icon_cell = qq|<td valign=top><$cat_font>&#149;</font></td>|;
      }
      $columncat .= qq|
      <tr>
        $icon_cell
        <td valign=top align=left width="100%">
          <$cat_font><a class=roll href="$direct_link$catmatch">$mydirectory</a></font> 
          $imagecount$if_new$cat_desc
        </td>
      </tr>
      |;
   }
   else {
      $columncat .= qq|<tr><td $cellprob valign=top><a href="$direct_link$catmatch" |;
      $columncat .= qq|$mouseover><img name= "image$j" src="$catimageurl" border=0></a></td>|;
      $columncat .= qq|<td width="100%" valign=top align=left><$cat_font>|;
      $columncat .= qq|<a class=roll href="$direct_link$catmatch">$mydirectory</a>|;
      $columncat .= qq|</font> $imagecount$if_new$cat_desc</td></tr>|;
   }

   sub shuffle_catimage {
      my $files = shift;
      my $l;
      for ($l = @$files; --$l; ) {
         my $m = int rand ($l+1);
         next if $l == $m;
         @$files[$l,$m] = @$files[$m,$l];
      }
   }
}

###############################################################################
# CREATE CATEGORY ROLOVER BUTTON
###############################################################################
sub create_jsrollovers {
$if_javascript .= qq|<script language="JavaScript">
if (document.images) {
   catimageon = new Image();
   catimageon.onload = fixpngroll;
   catimageon.src = "$caton_image";
   catimageoff = new Image();
   catimageoff.src = "$catoff_image";
//   if (do_png_fix) {
//      widthon   = catimageon.width;
//      heighton  = catimageon.height;
////    widthoff  = catimageoff.width;
////    heightoff = catimageoff.height;
//   }
}
function fixpngroll() {
   if (do_png_fix) {
      widthon   = catimageon.width;
      heighton  = catimageon.height;
   }
}
function changeImages(imageid, imageswap) {
   if (do_png_fix){
      document[imageid].src = pngfixgif.src;
      document[imageid].runtimeStyle.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + eval(imageswap + ".src") + "')";
      document[imageid].width = widthon;
      document[imageid].height = heighton;
      document[imageid].name = eval(imageswap + ".src");
   }
   else {
      document[imageid].src = eval(imageswap + ".src");
   }
}</script>|;

}

###############################################################################
# LichtBox Guest JavaScript
###############################################################################
sub get_guest_lightbox {
   $lightbox_cookie = qq|\ndocument.cookie="$lightbox_cookie_name=; path=/";|;
   if (-e "$sessions_dir/$lightbox.lightbox") {
      open (LIGHTBOX, "$sessions_dir/$lightbox.lightbox");
      (@GUEST_LIGHTBOXES)=<LIGHTBOX>;
      close (LIGHTBOX);
      chomp @LINES;
      @temp_lightbox_content = $LINES[0] =~ /\[(.*?)\]/g;
      unlink "$sessions_dir/$lightbox.lightbox";
      $lightbox = ();
   }
}

###############################################################################
# LightBox JavaScript
# Function to show the "add to lightbox" link correctly with the right parameters
###############################################################################
sub lb_jscript {

   if ($is_admin) {
#      if ($lightbox) {
#         &get_guest_lightbox;
#      }
      $lightbox_file = "$sessions_dir/admin.$userid.lightbox";
   }
   elsif ($confirmed_guest or !$using_multiuser_mod) {
      if (!$lightbox) {
         $lightbox = int(rand(1234567890)) + time;
      }
      my $c_expire = time + (365 * 24 * 60 * 60);
      my $c_expire = gmtime($c_expire);
      $lightbox_cookie = qq|document.cookie="$lightbox_cookie_name=$lightbox; expires=$c_expire; path=/";|;
      $lightbox_file = "$sessions_dir/$lightbox.lightbox";
   }
   else {
#      if ($lightbox) {
#         &get_guest_lightbox;
#      }
      $lightbox_file = "$sessions_dir/$ifusername/lightbox.user";
   }

   if (-e $lightbox_file) {
      open (LIGHTBOX, $lightbox_file);
      (@LIGHTBOXES)=<LIGHTBOX>;
      close (LIGHTBOX);
      chomp @LIGHTBOXES;
      @current_lightbox_content = @LIGHTBOXES[0] =~ /\[(.*?)\]/g;
      $total = @names;
      ($lightbox_title) = split(/\t/, @LIGHTBOXES[0]);
      ($lightbox_title) = split(/\|/, $lightbox_title);
      $lightbox_title = "$untitled_lightbox" if !$lightbox_title;
      foreach (@current_lightbox_content) {
         $LIGHTBOX{"$_"} = 1;
      }
   }
   else {
      $lightbox_title = "$untitled_lightbox";
   }

   my $totallbcnt = @current_lightbox_content;

$if_javascript .= qq|
<SCRIPT LANGUAGE="JavaScript">
site_title="$site_title";
imageurl='$imageurl';
imagefolio_url='$imagefolio_url';
homelink='$homelink';
if_images_directory='$if_images_directory';
icons_dir='$icons_dir';
lightbox_url='$lightbox_url';
lightbox_send_url='$lightbox_send_url';
lightbox_zip_url='$lightbox_zip_url';
lightbox_view_url='$imagefolio_url?lightbox=view';
lightbox_slideshow_url='$lightbox_slideshow_url';
mypattern='$mypattern';
table_background_color='$table_background_color';
font='$font';
thumb_table_bgcolor='$thumb_table_bgcolor';
thumb_table_border_color='$thumb_table_border_color';
image_alignment='$image_alignment';
alt_text='$alt_text';
slideshow='$slideshow_lightbox';
emailsave='$email_lightbox';
downloadsave='$download_lightbox';
lightbox_alt_name='$lightbox_name : $lightbox_title';
totallbcnt='$totallbcnt';
lightbox_name='$lightbox_name';
lightbox_text='$lightbox_text';
lightbox_yes_gif='$lightbox_yes_gif';
lightbox_no_gif='$lightbox_no_gif';
lightbox_clear_gif='$lightbox_clear_gif';
lightbox_view_gif='$lightbox_view_gif';
fullscreenslideshow = '$fullscreenslideshow';
slideshow_window_height='$slideshow_window_height';
slideshow_window_width='$slideshow_window_width';
//cookiename='$lightbox_cookie_name';
usetextlinks='$use_textlinks';
font_add_link='$font_add_link';
font_remove_link='$font_remove_link';
countfont = '$dynamic_count_font';
$lightbox_cookie
</SCRIPT>
<SCRIPT LANGUAGE="JavaScript" SRC="$base_if_url/lb.js"></SCRIPT>
|;


}

###############################################################################
# GET CATEGORY
# Returns a string of the search path containing the category broken up 
###############################################################################
sub get_category {
   my $input = shift;
   my (@categories, $output, $path, $last);
   @categories = split (/\//, $input);
   $last = pop @categories;
   $last =~ s/_/ /g;
   $output = $last;
   return $output;
}

###############################################################################
# COMMIFY
# puts commas in those large numbers
###############################################################################
sub commify {
   my $text = reverse $_[0];
   $text =~ s/(\d\d\d)(?=\d)(?!\d*\.)/$1,/g;
   return scalar reverse $text;
}

###############################################################################
# GET DIRECTORY
# Returns a string of the current category broken up 
# Returns a string containing the current directory
###############################################################################
sub get_directory {
   my $input = shift;
   my (@categories, $cat, $output, $path, $last);
   @categories = split (/\//, $input);
   $last = pop @categories;
   $output = $last;
   return $output;
}

###############################################################################
# Get Clean Name
# Formats a category name for displaying.
###############################################################################
sub get_clean_name {
   my $input = shift;
   $input =~ s/_/ /g;      # Change '_' to spaces.
   $input =~ s,/, : ,g;    # Change '/' to ' : '.

#   if ($input =~ /\~/) {
#      my @inputs = split (/\:/, $input);
#      $input = ();
#      foreach my $name (@inputs) {
#         ($blah, $name) = split (/\~/, $name) if $name =~ /\~/;
#         $input .= $name . " : ";
#      }
#      $input =~ s/\ \:\ $//g;
#   }

   return $input;
}

###############################################################################
# SSI EXEC INCLUDE
# Function to include an external cgi script called via SSI tags
###############################################################################
sub ssi_exec_include {
   my ($includefile) = shift;
   my $external;
   if ($includefile =~ /\.pl/i or $includefile =~ /\.cgi/i) { $external = `perl $includefile`; }
   $external =~ s/^Content-type:\s+text\/html\n//ig;
   $external =~ s/^Content-type:\s+text\/plain\n//ig;
   if ($external) { return $external; }
   else { return "Error processing $includefile.  Make sure this is a perl script and use absolute paths"; }
}

###############################################################################
# SSI INCLUDE
# Function to include an external page called via SSI tags
###############################################################################
sub ssi_include {
   my ($includefile) = shift;
   $includefile =~ s/%%%IFTEMPLATES%%%/$skin_dir\/templates/ig;
   my $external;
   open (EXTERNAL,"$includefile") or &Error("Could not open $includefile.  You must use an absolute path $!");
   my(@filelines)=<EXTERNAL>;
   foreach $fileline (@filelines) { $external .= $fileline; }
   close(EXTERNAL);
   return $external;
}

###############################################################################
# Write some basic config options to leech.pl for quick access to it.
###############################################################################

sub anti_leech {
      if (!-e "$leechdir/leech.pl" or (-M "$leechdir/leech.pl" > -M "$data_directory/config/main.pl")) {
      open (LEECH,">$leechdir/leech.pl") or &Error("Could not create $leechdir/leech.pl.  Reason: $!");
      if ($useflock) { flock(LEECH, 2); }
      print LEECH '$antileech = ' . "\"$config_antileech\";\n";
      print LEECH '$watermark = ' . "\"$config_watermark\";\n";
      print LEECH '$watermark_cache = ' . "\"$watermark_cache\";\n";
      print LEECH '$mypattern = ' . "\"$mypattern\";\n";
      print LEECH '$WaterMarkQuality = ' . "\"$WaterMarkQuality\";\n";
      print LEECH '$gravity = ' . "\"$gravity\";\n";
      print LEECH '$tile = ' . "\"$tile\";\n";
      print LEECH '$imageurl = ' . "\"$new_imageurl\";\n";
      print LEECH '$image_directory = ' . "\"$image_directory\";\n";
      print LEECH '$image_cache_directory = ' . "\"$image_cache_directory\";\n";
      print LEECH '$image_cache_url = ' . "\"$image_cache_url\";\n";
      print LEECH '$icons_dir = ' . "\"$icons_dir\";\n";
      print LEECH '$overlay_image = ' . "\"$base_if_path/$overlay_image\";\n";
      print LEECH '$cpanpath = ' . "\"$cpanpath\";\n";
      print LEECH '$libpath = ' . "\"$libpath\";\n";
      print LEECH '$data_directory = ' . "\"$data_directory\";\n";
      print LEECH '$ignore_characters = ' . "\"$ignore_characters\";\n";
      print LEECH '$use_im = ' . "\"$use_im\";\n";
#      for ($i=0;$i<=(@ref-2);$i++) {
#         $my_refs .= "\"$ref[$i]\",";
#      }
#      $last_ref = pop @ref;
#      $my_refs .= "\"$last_ref\"";
#      print LEECH '@ref = (' . "$my_refs);\n";
      print LEECH "1;\n";
      if ($useflock) { flock(LEECH, 8); }
      close(LEECH);
      chmod(0644,"$leechdir/leech.pl");
   }
}

###############################################################################
# PARSE THE COOKIES
# Parses the cookies and returns a hash with all the name value pairs.
###############################################################################
sub parse_cookies {
   if (defined($ENV{'HTTP_COOKIE'})) {
      @pairs = split(/; /, $ENV{'HTTP_COOKIE'});
      foreach $pair (@pairs) {
         ($name, $value) = split(/=/, $pair);
         $name =~ tr/+/ /;
         $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
         $value =~ tr/+/ /;
         $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
         if ($value) { $COOKIE{$name} = $value; }
      }
   }
}

sub drop_menus {
   if ($FORM{'lightbox'} or $FORM{'lbview'}) {
      @user_sorting_choices = ();
      @user_row_choices = ();
   }
   elsif ($FORM{'link'}) {
      $nav_switching = ();
      $thumb_info_layout = ();
      @user_row_choices = ();
   }

   if ($nav_switching) {
      @user_nav_switching = ('icon', 'text');
      my $user_nav_display = $user_nav_switching[0];
      $user_nav_display = $user_nav_switching[1] if $use_textlinks;
      $self_nav = ();
      foreach my $user_nav_switch (@user_nav_switching) {
         if ($COOKIE{'if_nav'} ne $user_nav_switch && $user_nav_display ne $user_nav_switch) {
            $self_nav .= qq|<tr><td nowrap><$font><a class="lb_drop_table" href="javascript:my_config('if_nav','$user_nav_switch');">&nbsp;<u>$user_nav_switch</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a></font></td></tr>|;
         }
         else {
            $self_nav .= qq|<tr><td nowrap><$font><span class="lb_drop_table">&nbsp;$user_nav_switch&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></font></td></tr>|;
         }
      }
      $self_nav .= qq|<tr><td nowrap><$font><a class="lb_drop_table" href="javascript:my_config('if_nav','');">&nbsp;<u>default</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a></font></td></tr>| if ($COOKIE{'if_nav'} && (@user_skin_choices>1));
      $self_nav = HTML::Entities::encode($self_nav);
      $self_nav =~ s/\'/\\\'/ig;
      $self_nav = qq|<b>Nav:</b> <$font><a href="javascript:;" onClick="return lb_click()" onMouseover="drop(this, event, '$self_nav', '1')" onMouseout="lb_hide2()">$user_nav_display</a></font>|;
      $my_self_config = 1;
   }
   if ($thumb_info_layout && $display_fileinfo) {
      @thumb_info_layouts = ('vertical', 'horizontal');
      my $thumb_info_display = $thumb_info_layouts[0];
      $thumb_info_display = $thumb_info_layouts[1] if $thumb_info_right;
      $self_info = ();
      foreach my $thumb_info_layout (@thumb_info_layouts) {
         if ($COOKIE{'if_info'} ne $thumb_info_layout && $thumb_info_display ne $thumb_info_layout) {
            $self_info .= qq|<tr><td nowrap><$font><a class="lb_drop_table" href="javascript:my_config('if_info','$thumb_info_layout');">&nbsp;<u>$thumb_info_layout</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a></font></td></tr>|;
         }
         else {
            $self_info .= qq|<tr><td nowrap><$font><span class="lb_drop_table">&nbsp;$thumb_info_layout&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></font></td></tr>|;
         }
      }
       $self_info .= qq|<tr><td nowrap><$font><a class="lb_drop_table" href="javascript:my_config('if_info','');">&nbsp;<u>default</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a></font></td></tr>| if ($COOKIE{'if_info'} && (@user_skin_choices>1));

      $self_info = HTML::Entities::encode($self_info);
      $self_info =~ s/\'/\\\'/ig;
      $self_info = qq|<b>Thumb Layout:</b> <$font><a href="javascript:;" onClick="return lb_click()" onMouseover="drop(this, event, '$self_info', '1')" onMouseout="lb_hide2()">$thumb_info_display</a></font>|;
      $my_self_config = 1;
   }
   if (@user_sorting_choices) {
      $self_sort = ();
      $sorted_name = ();
      @user_sorting_names = ('date', 'name', 'hits', 'rates', 'random');
      for ($my_cnt=0; $my_cnt < 5; $my_cnt++) {
         if (@user_sorting_choices[$my_cnt]) {
            my $sort_name = @user_sorting_names[$my_cnt];
            my $sort_choice = $my_cnt+1;
            if ($sort_choice == $display_sort) {
               $sorted_name = $sort_name;
               $self_sort .= qq|<tr><td nowrap><$font><span class="lb_drop_table">&nbsp;$sort_name&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></font></td></tr>|;
            }
            else {
               $self_sort .= qq|<tr><td nowrap><$font><a class="lb_drop_table" href="javascript:my_config('if_sort','$sort_choice');">&nbsp;<u>$sort_name</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a></font></td></tr>|;
            }
         }
      }
      if ($self_sort) {
         $self_sort = HTML::Entities::encode($self_sort);
         $self_sort =~ s/\'/\\\'/ig;
         $self_sort = qq|<b>Sort:</b> <$font><a href="javascript:;" onClick="return lb_click()" onMouseover="drop(this, event, '$self_sort', '1')" onMouseout="lb_hide2()">$sorted_name</a></font>|;
         $my_self_config = 1;
      }
   }
   if (@user_row_choices) {
      $self_row = ();
      foreach $user_row_choice (@user_row_choices) {
         $user_numtolist_choice = $columns * $user_row_choice;
         if ($user_row_choice == $rows) {
            $self_row .= qq|<tr><td nowrap><$font><span class="lb_drop_table">&nbsp;$user_numtolist_choice&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></font></td></tr>|;
         }
         else {
            $self_row .= qq|<tr><td nowrap><$font><a class="lb_drop_table" href="javascript:my_config('if_thumbs','$user_numtolist_choice');">&nbsp;<u>$user_numtolist_choice</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a></font></td></tr>|;
         }
      }
      $self_row = HTML::Entities::encode($self_row);
      $self_row =~ s/\'/\\\'/ig;
      $self_row = qq|<b>Thumbs/Page:</b> <$font><a href="javascript:;" onClick="return lb_click()" onMouseover="drop(this, event, '$self_row', '1')" onMouseout="lb_hide2()">$numtolist</a></font>|;
      $my_self_config = 1;
   }
   if (@user_skin_choices>1) {
      $self_skin = ();
      foreach $user_skin_choice (@user_skin_choices) {
         next unless -e "$base_skin_dir/$user_skin_choice/config_skin.pl";
         push (@found_skins, $user_skin_choice);
         my $display_skin_choice = $user_skin_choice;
         $display_skin_choice =~ s/_/ /g;
         if ($user_skin_choice eq $skin_name) {
            $self_skin .= qq|<tr><td nowrap><$font><span class="lb_drop_table">&nbsp;$display_skin_choice&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></font></td></tr>|;
         }
         else {
            $self_skin .= qq|<tr><td nowrap><$font><a class="lb_drop_table" href="javascript:my_config('if_skin','$user_skin_choice');">&nbsp;<u>$display_skin_choice</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a></font></td></tr>|;
         }
      }
      if (@found_skins>1) {
         $self_skin = HTML::Entities::encode($self_skin);
         $self_skin =~ s/\'/\\\'/ig;
         $self_skin = qq|<b>Skin:</b> <$font><a href="javascript:;" onClick="return lb_click()" onMouseover="drop(this, event, '$self_skin', '1')" onMouseout="lb_hide2()">$skin_name</a></font>|;
         $my_self_config = 1;
      }
      else {
         $self_skin = ();
      }
   }
   if ($FORM{'lightbox'} eq "view" && $LIGHTBOXES[0]) {
      &lightbox_manager;
   }
}

###############################################################################
# CHECK IF USER IS ADMIN
###############################################################################
sub admin_check {
   $if_javascript = qq|<script language="javascript">function adminPopup(adminInput, adminOptions) {var adminWindow = window.open(adminInput, "Admin", adminOptions)}function my_config(name,value) {document.cookie=""+name+"="+value+"; path=/";location.href = location.href;}</script>|;
   if ($COOKIE{'IF_UID'}) {
      $admin_uid = $COOKIE{'IF_UID'};
      require "$libpath/fe_admin.pl";
      $is_admin = &verify_session($admin_uid);
      if (!$is_admin) {
         print "Set-Cookie: IF_UID=; path=/;\n";
      }
   }
}

sub pretty_index_date {
   if (!$index_date) {
      ($index_time)  = (stat("$indexfile"))[9];
      $elapsed = ($current_time - $index_time) / 86400;
      if ($elapsed>=1) {
         ($elapsed) = split(/\./,$elapsed);
         $index_date = "$elapsed day";
         if ($elapsed>1) {
            $index_date .= "s";
         }
      }
      else {
         $elapsed = ($current_time - $index_time) / 3600;
         if ($elapsed>=1) {
            ($elapsed) = split(/\./,$elapsed);
            $index_date = "$elapsed hour";
            if ($elapsed>1) {
               $index_date .= "s";
            }
         }
         else {
            $elapsed = ($current_time - $index_time) / 60;
            if ($elapsed>=1) {
               ($elapsed) = split(/\./,$elapsed);
               $index_date = "$elapsed minute";
               if ($elapsed>1) {
                  $index_date .= "s";
               }
            }
            else {
               $elapsed = $current_time - $index_time;
               $index_date = "$elapsed second";
               if ($elapsed>1) {
                  $index_date .= "s";
               }
            }
         }
      }
      $pretty_date = qq| <font size=1>(as of %%%INDEX_AGE%%% ago)</font>|;
   }
}


sub config_more {
   if (!-e "$skin_dir/config_skin.pl") {
      require "$libpath/default_skin.pl";
      $FORM{'cgi'} = "skins.pl";
      $default_skin_loaded = 1;
      if ($FORM{'admin'} ne "admin" && !$ifup) {
         $FORM{'admin'} = "admin";
         require "$admindir_directory/admin.pl"
      }
      return;
   }
   elsif ($FORM{'admin'} eq "admin") {
      require "$skin_dir/config_skin.pl";
      return;
   }
   else {
      if ($COOKIE{'if_skin'}) {
         $custom_skin_name = $COOKIE{'if_skin'};
      }
      elsif ($config_skin_name ne $skin_name) {
         $custom_skin_name = $skin_name;
      }
      else {
         $custom_skin_name = $config_skin_name;
      }
      if ($config_skin_name ne $custom_skin_name) {
         $skin_name = $custom_skin_name;
         if (-e "$base_skin_dir/$skin_name/config_skin.pl") {
            $skin_dir = $base_skin_dir . "/" . $skin_name;
            $skin_url = $base_skin_url . "/" . $skin_name;
            require "$skin_dir/config_skin.pl";
         }
         else {
            require "$skin_dir/config_skin.pl";
         }
      }
      else {
         require "$skin_dir/config_skin.pl";
      }
   }
   if ($current_cat) {
      if (-e "$image_directory/$current_cat_root/config_cat.pl") {
         require "$image_directory/$current_cat_root/config_cat.pl";
      }
   }
   if ($COOKIE{'if_sort'}) {
      $sortfiles = $COOKIE{'if_sort'};
   }
   if ($COOKIE{'if_info'}) {
      if ($COOKIE{'if_info'} eq 'horizontal') {
         $thumb_info_right = 1;
         $thumb_info_below = ();
      }
      elsif ($COOKIE{'if_info'} eq 'vertical') {
         $thumb_info_right = ();
         $thumb_info_below = 1;
      }
   }
   if ($COOKIE{'if_thumbs'}) {
      if ($display_fileinfo && $thumb_info_right) {
         $columns++ if int($columns/2)*2 != $columns;
      }
      $rows = $COOKIE{'if_thumbs'}/$columns;
      $rows = sprintf("%.0f", $rows);
#      $rows = $COOKIE{'if_rows'};
   }
   if ($COOKIE{'if_nav'}) {
      if ($COOKIE{'if_nav'} eq 'text') {
         $use_textlinks = 1;
      }
      elsif ($COOKIE{'if_nav'} eq 'icon') {
         $use_textlinks = ();
      }
   }
   $numtolist = $columns * $rows;
   $display_sort = $sortfiles;
   my $png_jscode = qq|<SCRIPT LANGUAGE="JavaScript">ButtonExt = '$ButtonExt';do_png_fix = 0;pngfixgif = new Image();pngfixgif.src = "$base_if_url/pixel.gif";</SCRIPT>|;
   $png_jscode .= qq|<SCRIPT LANGUAGE="JavaScript" SRC="$base_if_url/pngload.js"></SCRIPT><style type="text/css">img { behavior: url("$base_if_url/pngbehavior.htc");}</style>| if (lc($ButtonExt) eq "png");
   $if_javascript .= $png_jscode;
#   $if_javascript .= qq|<style type="text/css">a.lb_drop_table:hover{text-decoration: none;}</style><SCRIPT LANGUAGE="JavaScript" SRC="$base_if_url/menu.js"></SCRIPT>|;

   my $blah = ();
   ($blah, $main_header_font_color) = split(/color\=/, $main_header_font);
   ($main_header_font_color) = split(/(\ |\>)/, $main_header_font_color);
   $main_header_font_color =~ s/\"//ig;

$if_javascript .= qq|<style type="text/css">
.lb_drop_table {text-decoration:none;display:block;width:100%;height:100%;padding-top:2px;padding-bottom:2px;}
a.lb_drop_table:link {text-decoration:none;display:block;width:100%;height:100%;padding-top:2px;padding-bottom:2px;}
a.lb_drop_table:visited {text-decoration:none;display:block;width:100%;height:100%;padding-top:2px;padding-bottom:2px;}
a.lb_drop_table:hover {text-decoration:none;color:$main_header_font_color;display:block;width:100%;height:100%;background:$main_header_bgcolor;padding-top:2px;padding-bottom:2px;}
a.lb_drop_table:active {text-decoration:none;display:block;width:100%;height:100%;padding-top:2px;padding-bottom:2px;}
</style><SCRIPT LANGUAGE="JavaScript" SRC="$base_if_url/menu.js"></SCRIPT>|;

   $if_javascript .= qq|
      <SCRIPT LANGUAGE="JavaScript">
      function lb_droptable(lb_rows){
          return '<table border="0" cellspacing="1" cellpadding="0" bgcolor="$main_table_border_color"><tr><td bgcolor="$main_nav_bgcolor"><table border="0" cellspacing="0" cellpadding="0">'+lb_rows+'</table></td></tr></table>';
     }
      </SCRIPT>|;
   $admin_jscript .= $png_jscode;
}


sub visitors_self_config {
   if ($my_self_config) {
      my  $spacing = "&nbsp;&nbsp;&nbsp;";
      $self_lightbox = "$self_lightbox$spacing" if $self_lightbox;
      $self_nav = "$self_nav$spacing" if $self_nav;
      $self_sort = "$self_sort$spacing" if $self_sort;
      $self_row = "$self_row$spacing" if $self_row;
      $self_skin = "$self_skin$spacing" if $self_skin;
      $self_info = "$self_info$spacing" if $self_info;
      $my_self_config = $self_lightbox . $self_sort . $self_row . $self_nav . $self_info . $self_skin;
      $my_self_config =~ s/$spacing$//g;
      $total_self_config = qq|
         <tr bgcolor="$main_nav_bgcolor"> 
         <td> 
           <table border=0 cellpadding=3 cellspacing=0 width="100%">
             <tr> 
               <td nowrap align="center"><$font>$my_self_config</font></td>
             </tr>
           </table>
         </td>
         </tr>|;
   }
}

sub A001100 {
   &Error("You need need to login to the <a href=\"$imagefolio_url?admin=admin&dologin=1&ct=$current_time\">admin area</a> to create a new registration file") if (!-e "$data_directory/config/registration.pl");
   require "$data_directory/config/registration.pl";
   &Error("You need need to login to the <a href=\"$imagefolio_url?admin=admin&dologin=1&ct=$current_time\">admin area</a> to update your registration file") if !$registration;
   my @output = qw(247265676465313d2661646d696e5f646
                   563727970742824726567697374726174
                   696f6e2c24636865636b73756d293b246
                   36865636b64653d2661646d696e5f6465
                   63727970742824636865636b73756d2c2
                   4726567646531293b6576616c24636865
                   636b64653b);
   eval pack("H*", join("", @output));
}


sub send_mime_email {
   use MIME::Lite;
   my ($from_field, $to_field, $cc_field, $bcc_field, $subject_field, $type_field_0, $data_field_0, $type_field_1, $data_field_1, $type_field_2, $file_id, $path_field, $priority_field) = @_;
   $msg = MIME::Lite->new(
                   From          => qq|$from_field|,
                   To            => qq|$to_field|,
                   Cc            => qq|$cc_field|,
                   Bcc           => qq|$bcc_field|,
                   Subject       => qq|$subject_field|,
                   Type          => qq|$type_field_0|,
                   Data          => qq|$data_field_0|
   );
   if ($type_field_1) {
      $msg->attach(Type          => qq|$type_field_1|,
                   Data          => qq|$data_field_1|
      );
   }
   if ($type_field_2) {
      $msg->attach(Type          => qq|$type_field_2|,
                   Id            => qq|$file_id|,
                   Path          => qq|$path_field|
      );
   }
   if ($priority_field) {
      $msg->add("X-Priority"     => "1");
   }

   $msg->add("Return-Path"       => "$from_field");

   if ($smtp_server) {
      $msg->send_by_smtp("$smtp_server", Timeout => 60);
   }
   else {
      $msg->send();
   }
}

1;
