###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################



sub do_setup {
   $gallery_root = "gallery";
   require "$currdir/config/pathsurls_config.pl";
   $gallery_root = qq|\"$gallery_root\"|;
   &su_check_permissions;
   &su_write_main_pl unless $total_error;
   eval{require "$data_directory/config/main.pl";};
   if ($total_error) {
      print "Content-type: text/html\n\n";
      print $total_error;
      unlink("$data_directory/config/main.pl");
      exit;
   }
   else {
      eval{require "$currdir/data/config/skins.pl";};
      $skin_dir = $base_skin_dir . "/" . $skin_name;
      $skin_url = $base_skin_url . "/" . $skin_name;
   }
}


sub su_write_main_pl {
   if (!-e "$data_directory/config/main.pl") {
      open(MAIN,">$data_directory/config/main.pl") or $total_error .= qq|<nobr>Can not create file: $data_directory/config/main.pl (reason: $!)</nobr><br>|;
      print MAIN &su_main_pl;
      close(MAIN);
      chmod(0777,"$data_directory/config/main.pl");
   }
   if (!-e "$data_directory/config/headerfooter.pl") {
      open(MAIN,">$data_directory/config/headerfooter.pl") or $total_error .= qq|<nobr>Can not create file: $data_directory/config/headerfooter.pl (reason: $!)</nobr><br>|;
      print MAIN &su_headerfooter_pl;
      close(MAIN);
      chmod(0777,"$data_directory/config/headerfooter.pl");
   }
}

sub su_check_permissions {
   my $index_html = qq|<HTML><HEAD><TITLE>Forbidden</TITLE></HEAD><BODY>You do not have permission to access this directory.</BODY></HTML>|;

   my @ceck_paths = &su_check_dirs;
   my $last_dir = "null";

   foreach (@ceck_paths) {
      my @files = ();
      my @foundfiles = ();
      my $levelup = ();
      my $this_error = ();
      if ($_ =~ /\*$/) {
         $levelup = 1;
         $_ =~ s/\/\*$//ig;
      }
      if (!-d $_) {
         next if ($_ =~ /^$last_dir\//);
         mkdir("$_", "0777") or $this_error = qq|<nobr><b>Can not create directory</b>: $_ (reason: $!)</nobr><br>|;
         chmod(0777,"$_");
         if ($this_error) {
            $total_error .= $this_error;
            next;
         }
      }
      if (-d $_) {
         unlink ("$_/index.html");
         open(INDEXHTML,">$_/index.html") or $this_error = qq|<nobr><b>Can not create an index.html in directory</b>: $_ (reason: $!)</nobr><br>|;
         print INDEXHTML $index_html;
         close(INDEXHTML);
         chmod(0777,"$_/index.html");
         if ($this_error) {
            $last_dir = $_;
            $total_error .= $this_error;
            next;
         }
         if ($_ eq $data_directory && (!-e "$_/index.txt" or !-e "$_/categories.txt")) {
            open(INDEXHTML,">$_/index.txt") or $total_error .= qq|<nobr>Can not create file: $_/index.txt (reason: $!)</nobr><br>|;
            print INDEXHTML "";
            close(INDEXHTML);
            chmod(0777,"$_/index.txt");
            open(INDEXHTML,">$_/categories.txt") or $total_error .= qq|<nobr>Can not create file: $_/categories.txt (reason: $!)</nobr><br>|;
            print INDEXHTML "";
            close(INDEXHTML);
            chmod(0777,"$_/categories.txt");
         }
         elsif ($_ eq $midi_directory && !-e "$_/Readme.txt") {
            open(README,">$_/Readme.txt");
            print README "Here you can add your own midi files to be used as background music.\nThe Postcard Mod will create a dropdown menu from the files listed here.\n\"_\" will be replace by a space for the title of the song.\n\nYou can find more songs here:\nhttp://home.swipnet.se/~w-54954/midi.htm\n";
            close(README);
            chmod(0777,"$_/Readme.txt");
         }
         if ($levelup) {
            opendir (DL, "$_");
            my @found = readdir(DL);
            closedir (DL);
            foreach my $found (@found) {
               next if (-d "$_/$found");
               chmod(0777,"$_/$found");
               if (!-w "$_/$found") {
                  $total_error .= qq|<nobr>File is not writable: $file</nobr><br>|;
               }
            }
         }
      }
   }
}


sub su_check_dirs {
   return ("$data_directory/*",
           "$data_directory/backup/*",
           "$data_directory/config/*",
           "$data_directory/db/*",
           "$leechdir/*",
           "$logdir/*",
           "$sessions_dir/*",
           "$base_if_path",
           "$image_directory",
           "$cards_directory",
           "$midi_directory",
           "$base_skin_dir",
           "$tempdir",
           "$cache_directory",
           "$cache_directory/pages",
           "$cache_directory/searches",
           "$image_cache_directory",
   );
}


sub su_main_pl {
   return qq~\$site_title = 'ImageFolio Lite Gallery';
\$homelink = '';
\$admin_email = '';
\$smtp_server = '';
\%extensions = (
	'jpg' => ['JPEG Image', 1, '', '_self', 'JPG.jpg'],
);
\$mypattern = 'tn_';
\$columns = '4';
\$rows = '2';
\$pages_ahead_count = '3';
\$cat_columns = '2';
\$maxsubdirectory = '0';
\$subcat_ahead_count = '10';
\$sortfiles = '1';
\$record_counts = '1';
\$display_fileinfo = '1';
\$display_filename = '1';
\$display_filesize = '1';
\$display_date = '1';
\$eu_date_format = '';
\$thumb_info_right = '';
\$mypattern_fullsize = 'h7Fl3d_';
\$display_counts = '1';
\$cache_date = '0.5';
\$alt_text = 'Click to view';
\$use_textlinks = '0';
\$main_table_width = '760';
\$random_thumbnail = '0';
\$image_editor = 'ic';
\@user_sorting_choices = (1, 1, 0, 0, 1);
\@user_row_choices = (2, 3, 4);
\$thumb_info_layout = '1';
\$nav_switching = '1';
\%IPTCfields = (
	'a0' => [2000, 'caption/abstract', 'Caption', 1],
	'a1' => [32, 'writer/editor', 'Caption Writer', 1],
	'a2' => [256, 'headline', 'Headline', 2],
	'a4' => [9999, 'keywords', 'Keywords', 2],
	'a5' => [128, 'copyright notice', 'Copyright Notice', 1],
	'a6' => [32, 'credit', 'Credit', 1],
	'a7' => [32, 'source', 'Source', 1],
	'a9' => [10, 'date created', 'Date Created', 1],
	'b1' => [32, 'by-line', 'Byline (Photographer)', 2],
	'c1' => [128, 'contact', 'Contact', 1],
);
\@iptc_thumbnails_fields = ('headline', 'copyright notice');
\$save_upload_date = '1';
\$imageprotect = '1';
\$gallery_root = $gallery_root;
1;
~;
}

sub su_headerfooter_pl {
   return qq~\$imagefolio_header_html = qq|<table width="%%%MAIN_TABLE_WIDTH%%%" cellspacing=1 cellpadding=4 bgcolor="%%%MAIN_TABLE_BORDER_COLOR%%%"><tr bgcolor="%%%MAIN_HEADER_BGCOLOR%%%"><td align=center><font %%%MAIN_HEADER_FONT%%%><b>%%%SITE_TITLE%%%</b></font></td></tr></table><br>|;
\$imagefolio_footer_html = qq|<font %%%MAIN_HEADER_FONT%%%><font size=1>&copy; Copyright 2007 %%%SITE_TITLE%%%.  All rights reserved.<br><br></font></font>|;

1;
~;
}

1;