###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################

sub info_ic_in {
   &which_ic;
   my ($ic_installed, $ic_working, $ic_why) = split(/~/, &do_load_ic);
   if ($ic_why) {
      $ic_why_this = "<br><font color=\"#cccccc\" size=1>Error: Couldn't execute imageConvert ($ic_why)</font>";
   }
   &die_ic("Operating System: <b>$info_OS</b><br>OS Version: <b>$info_OSv</b><br>Kernel: <b>$info_PROC_RELEASE</b><br>Machine: <b>$info_MACHINE</b><br>Processor Type: <b>$info_PROCESSOR</b><br><br>ImageConvert installed: <b>$ic_installed</b><br>ImageConvert working: <b>$ic_working</b>$ic_why_this");
}


sub manual_install_ic_in {
   if ($FORM{'test'}) {
      &man_test_ic;
   }
   &check_dir_ic;
   &which_ic;
   my $manual_install = qq|<b>ImageConvert installation: Manual install</b><br>Please provide the username and password for
      the download area that you received when you purchased ImageFolio.|;
   my $manual_install_button = &manual_install_button;
   &die_ic($manual_install, $manual_install_button);
}

sub manual_install_button {
   my $ic_output = qq|
      <form method="post" action="http://www.imagefolio.com/ImageConvert/locate/index.cgi">
      <input type="hidden" name="ic_reg" value="$ic_reg">
      <input type="hidden" name="return_url" value="$imagefolio_url">
      <input type="hidden" name="operating_system" value="$info_OS">
      <input type="hidden" name="os_version" value="$info_OSv">
      <input type="hidden" name="kernel" value="$info_PROC_RELEASE">
      <input type="hidden" name="machine" value="$info_MACHINE">
      <input type="hidden" name="processor_type" value="$info_PROCESSOR">
      <input type="hidden" name="connected" value="manual">
      <input type="hidden" name="from" value="pro4$no_imageconvert_watermark">
      <input type="hidden" name="zipsupport" value="$zipsupport">
        <tr>
          <td align="center">
            <table border="0" cellspacing="1" cellpadding="1">
              <tr> 
                <td nowrap align="right"><font class="ic_main"><b>Username:</b></font> </td>
                <td nowrap><input type="text" name="username"size="20"></td>
              </tr>
              <tr> 
                <td nowrap align="right"><font class="ic_main"><b>Password:</b></font> </td>
                <td nowrap><input type="password" name="password" size="20" maxlength="20"></td>
              </tr>
              <tr> 
                <td nowrap colspan="2" align="center">
                  <input type="button" class="ic_button" value="Go Back" onClick="history.go(-1)">
                  <input type="submit" value="Submit info" class="ic_button" onClick='this.value="Processing ..."'>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </form>|;
   return $ic_output;
}

sub close_ic_button {
   my $ic_output = qq|<tr><td align="center"><input type="button" class="ic_button" value="Close Window" onClick="window.close()"> <input type="button" class="ic_button" value="Home" onClick='location.href="$imagefolio_url"'></td></tr>|;
   return $ic_output;
}

sub check_dir_ic {
   if (!-d "$data_directory/ic") {
      mkdir("$data_directory/ic", "0777") or &Error("Unable to create your data/ic directory.  Reason: $!");
      chmod(0777,"$data_directory/ic") or &Error("Could not set permissions on the data/ic directory.  Reason: $!");
   }
}

sub install_ic_button {
   my $ic_output = qq|<tr><td align="center"><input type="button" class="ic_button" value="Go Back" onClick="history.go(-1)"> <input type="button" class="ic_button" value="Install ImageConvert" onClick='this.value="Processing ...";location.href="$imagefolio_url?imageconvert=install";'></td></tr>|;
   return $ic_output;
}

sub which_ic {
   $info_OS = $^O;
   if ($info_OS ne "MSWin32") {
#      if ($info_OSname = `uname -s`) {
#         $info_OS = $info_OSname;
#      }
      ($info_OSv) = split(/\:/, `uname -v`);
      $info_PROC_RELEASE = `uname -r`;
      $info_MACHINE = `uname -m`;
      $info_PROCESSOR = `uname -p`;
   }
   $zipsupport = "yes";
   eval "use Archive::Zip qw(:CONSTANTS :ERROR_CODES);1;" or $zipsupport = "no";
}

sub install_manual_ic_button {
   my $ic_output = qq|<tr><td align="center"><input type="button" class="ic_button" value="Go Back" onClick="history.go(-1)"> <input type="button" class="ic_button" value="Manual Installation" onClick='this.value="Processing ...";location.href="$imagefolio_url?imageconvert=manual_install"'></td></tr>|;
   return $ic_output;
}

sub set_reg_ic {
   my $this_reg = shift;
   open (IC_REG,">$data_directory/ic/ver.pl");
   print IC_REG '$ic_ver = \'' . $this_reg . '\';' . "\n";
   print IC_REG "1;\n";
   close(IC_REG);
   chmod(0777,"$data_directory/ic/ver.pl");
}

sub uncompress_ic {
   my ($uc_file, $uc_path, $uc_save) = @_;
   if ($uc_file =~ /.zip$/i) {
      require Archive::Zip;
      my $ic_zip = Archive::Zip->new();
      $ic_zip->read("$uc_file");
      my @members = $ic_zip->memberNames();
      foreach $member (@members) {
         $ic_zip->extractMember($member, "$uc_path/$member");
      }
      if (!$uc_save) {
         unlink("$uc_file");
      }
   }
   elsif ($uc_file =~ /.tar.gz/i) {
      if (-e "/usr/local/bin/tar") {$info_TAR = "/usr/local/bin/tar";}
      elsif (-e "/usr/bin/tar") {$info_TAR = "/usr/bin/tar";}
      elsif (-e "/usr/local/tar") {$info_TAR = "/usr/local/tar";}
      elsif (-e "/bin/tar") {$info_TAR = "/bin/tar";}
      if (!$info_TAR) { $info_TAR = `which tar`;}
      if ($info_TAR) {
         system "$info_TAR -xzf $uc_file -C $uc_path";
         if (!$uc_save) {
            unlink("$uc_file");
         }
      }
   }
   opendir(IC_DIR,"$uc_path");
   @files = readdir(IC_DIR);
   closedir(IC_DIR);
   foreach $file (@files) {
     chmod(0777,"$uc_path/$file");
   }
}

sub man_test_ic {
   if (-e "$data_directory/ic/ImageConvert.$FORM{'test'}") {
      &uncompress_ic("$data_directory/ic/ImageConvert.$FORM{'test'}", "$data_directory/ic", "1");
      &set_reg_ic($FORM{'this_reg'});
      ($ic_installed, $ic_working, $ic_why) = split(/~/, &do_load_ic);
      if (($ic_installed eq "No") or ($ic_working eq "No")) {
         if ($ic_why) {
            $ic_why_this = "<br><font color=\"#cccccc\" size=1>Error: Couldn't execute imageConvert ($ic_why)</font>";
         }
         $man_inst_finish_text = "ImageConvert is not working. Please go back and make sure you have followed the instructions or contact <a href=\"mailto:support\@bizdesign.com\">support\@bizdesign.com</a>.";
      }
      else {
         $close_ic_button = &close_ic_button;
         $man_inst_finish_text = "The installation of ImageConvert is finished. Now try it out and see if it works by uploading an image. Make sure you have a look at the various ImageConvert settings in you admin_config.pl like size, sharpness, contrast etc. of your uploaded image files.";
      }
   }
   else {
      $ic_installed = "No";
      $ic_working = "No";
      $man_inst_finish_text = "We could not find ImageConvert.$FORM{'test'} in your \"data/ic\" directory. Please go back and make sure you have followed the instructions or contact <a href=\"mailto:support\@bizdesign.com\">support\@bizdesign.com</a>.";
   }
   &die_ic("<b>ImageConvert installation: Manual install</b><br><br>ImageConvert installed: <b>$ic_installed</b><br>ImageConvert working: <b>$ic_working</b><br><br>$man_inst_finish_text$ic_why_this", $close_ic_button);
}

sub die_ic{
   my ($die_ouput, $die_button, $die_onload, $die_js) = @_;
   if (!$die_button) {
      $die_button = qq|<tr><td align="center"><input type="button" class="ic_button" value="Go Back" onClick="history.go(-1)"></td></tr>|;
   }
   print "Content-type: text/html\n\n";
   print qq|<html>
   <head>
   <title>ImageConvert info console</title>
   <META HTTP-EQUIV= "expires" CONTENT="-1">
   <META HTTP-EQUIV="Pragma" CONTENT="no-cache">
   <META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
   <META HTTP-EQUIV="imagetoolbar" CONTENT="no">
   <style type="text/css">
      <!--
      .ic_console {
      font-family: verdana,arial,helvetica;
      font-size:14px;
      color:#cccccc;
      font-weight:bold;
      }
      .ic_main {
      font-family: verdana,arial,helvetica;
      font-size:12px;
      color:#000066;
      }
      .ic_button {
      font-family: verdana,arial,helvetica;
      font-size:12px;
      color:#cccccc;
      font-weight:bold;
      background-color:#333399;
      }
      -->
   </style>$die_js
   </head>
   <body bgcolor="#ffffff"$die_onload>
   <table width="100%" border="0" cellspacing="1" cellpadding="1" height="100%">
     <tr>
       <td align="center" valign="middle">
         <table width="450" border="0" cellspacing="1" cellpadding="0" bgcolor="#000066">
           <tr bgcolor="#000066">
             <td align=center valign=bottom background="http://www.imagefolio.com/ImageConvert/images/topback.gif"> 
               <table border=0 cellspacing=0 cellpadding=0 width="100%">
                 <tr> 
                   <td align=center><img src="http://www.imagefolio.com/ImageConvert/images/topimage.gif" alt="" width=157 height=10 border=0 hspace=0 vspace=0></td>
                 </tr>
               </table>
             </td>
           </tr>
           <tr>
             <td bgcolor="#333399">
                <table width="100%" border="0" cellspacing="1" cellpadding="3">
                  <tr>
                     <td align="center" nowrap><font class="ic_console">I m a g e C o n v e r t &#153;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;i n f o &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c o n s o l e</font></td>
                 </tr>
               </table>
             </td>
           </tr>
           <tr>
             <td bgcolor="#9999CC">
               <table width="100%" border="0" cellspacing="1" cellpadding="5">
                 <tr>
                   <td><font class="ic_main">$die_ouput</font></td>
                 </tr>
                 $die_button
               </table>
             </td>
           </tr>
           <tr bgcolor="#000066"> 
             <td align=center valign=bottom background="http://www.imagefolio.com/ImageConvert/images/botback.gif"> 
               <table border=0 cellspacing=0 cellpadding=0 width="100%">
                 <tr> 
                   <td width=1><img src="http://www.imagefolio.com/ImageConvert/images/left.gif" alt="" border=0 hspace=0 vspace=0 width=14 height=17></td>
                   <td align=center width="100%"><a href="http://www.imagefolio.com" target="_blank"><img src="http://www.imagefolio.com/ImageConvert/images/folio.gif" alt="ImageConvert: Powered by ImageFolio" border=0 hspace=0 vspace=0></a></td>
                   <td align=right width=1><img src="http://www.imagefolio.com/ImageConvert/images/right.gif" alt="" border=0 hspace=0 vspace=0 width=14 height=17></td>
                 </tr>
               </table>
             </td>
           </tr>
         </table>
       </td>
     </tr>
   </table>
   </body>
   </html>
   |;
   exit;
}

1;
