###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################

sub load_ic {
   if ($FORM{'imageconvert'}) {
      require "$libpath/imageconvert_1.pl";
      if ($FORM{'imageconvert'} eq "install") {
         require "$libpath/imageconvert_2.pl";
      }
      &{"$FORM{'imageconvert'}_ic_in"};
   }
   else {
      my ($ic_installed, $ic_working, $ic_why) = split(/~/, &do_load_ic);
      if ($ic_working eq "No") {
         require "$libpath/imageconvert_1.pl";
         if ($is_admin) {
            $install_button = &install_ic_button;
         }
         if ($ic_installed eq "No") {
            &die_ic("<b>ImageConvert installation: First time install</b><br>ImageConvert is not installed yet. You will need to be logged in as an administrator to be able to install it.", $install_button);
         }
         else {
            &die_ic("<b>ImageConvert installation: Incomplete installation</b><br>ImageConvert seems to be installed but it is not working. Please install in again or contact <a href=\"mailto:support\@bizdesign.com\">support\@bizdesign.com</a>. You will need to be logged in as an administrator to reinstall it.<br><font color=\"#cccccc\" size=1>Error: Couldn't execute imageConvert ($ic_why)</font>", $install_button);
         }
      }
   }
}

sub do_ic {
   my ($ic_path_to_in, $ic_path_to_out, $ic_resize, $ic_quality, $ic_sharpen, $ic_contrast, $ic_custom, $ic_crop, $ic_out_format, $ic_rtype, $ic_rflag, $ic_wm_file, $ic_wm_gravity) = @_;
   if ($ic_sharpen > 0 && $ic_sharpen <= 1) {
      $ic_sharpen = 100-($ic_sharpen*100);
   }
   $ic_out_format = "jpeg" if !$ic_out_format;
   $ic_rtype = "linear" if !$ic_rtype;
   $ic_rflag = "decr" if !$ic_rflag;
   my $ic_system_call = "$data_directory/ic/imageConvert";
   $ic_system_call .= " -quiet" if !$imageconvert_log;
   $ic_system_call .= " -out $ic_out_format";
   $ic_system_call .= " -ratio";
   $ic_system_call .= " -truecolors";
   $ic_system_call .= " -resize $ic_resize $ic_resize" if $ic_resize;
   $ic_system_call .= " -crop $ic_crop" if $ic_crop;
   $ic_system_call .= " -rtype $ic_rtype";
   $ic_system_call .= " -rflag $ic_rflag";
   $ic_system_call .= " -q $ic_quality" if $ic_quality;
   $ic_system_call .= " -sharpen $ic_sharpen" if $ic_sharpen;
   $ic_system_call .= " -contrast $ic_contrast" if $ic_contrast;
   $ic_system_call .= " -wmfile $ic_wm_file" if $ic_wm_file;
   $ic_system_call .= " -wmflag $ic_wm_gravity" if $ic_wm_gravity;
   $ic_system_call .= " $ic_custom" if $ic_custom;
   $ic_system_call .= " -o $ic_path_to_out";
   $ic_system_call .= " $ic_path_to_in";
   my $ic_output = `$ic_system_call`;
   &log_ic($ic_output) if $imageconvert_log;
#   return $ic_system_call;
}

sub test_ic {
   my $ic_system_call = "$data_directory/ic/imageConvert -help";
   my $ic_test_output = `$ic_system_call`;
   if ($ic_test_output) {
      return "Yes";
   }
   else {
      $ic_test_output = `$ic_system_call 1>&1 2>&1`;
      return "No~$ic_test_output";
   }
}

sub log_ic {
   $ic_file = ();
   my(@ic_output) = split(/\n/, shift);
   $ic_log = "$logdir/$imageconvert_log";
   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $year += 1900;
   $mon++;
   $logdate = sprintf "%04d-%02d-%02d %02d:%02d:%02d", $year, $mon, $mday, $hour, $min, $sec;

   $ic_file .= "$logdate\n";

   for my $i (14..@ic_output){
      $ic_file .= "@ic_output[$i]\n";
   }

   open (FILE,">>$ic_log");
   print FILE $ic_file;
   close(FILE);
   chmod(0666,"$ic_log");
}

sub do_load_ic {
   if (-e "$data_directory/ic/ver.pl") {
      require "$data_directory/ic/ver.pl";
      $ENV{"$ic_ver"} = "$data_directory/ic";
      return "Yes~" . &test_ic;
   }
   else {
      return "No~No";
   }
}

1;
