###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################


###############################################################################
# VIEW IMAGE
# Generates a page showing one image.  Results from the click on a linked
# thumbnail image.  The header and footer files used here are different than
# the ones for thumbnail pages generated by gen_image_table.
###############################################################################
sub view_image {


   require "$libpath/iptc.pl";
   $this_alt = "$FORM{'image'}";

   if ($watermark && !$antileech) {
      $imageurl = $imagefolio_url . "?main=imageLeech&source=IF&ct=$current_time&file=";
   }

   ($newimage) = $FORM{'image'} =~ m,^(.*)\.\w+$,;
   if ($record_counts) { &record_counts; }
   $fullsize_name = qq|$mypattern_fullsize$newimage.$myextension_fullsize|;
   $fullsize_file = qq|$image_directory/$FORM{'link'}/$fullsize_name|;

   $ratelink = qq|<a href="javascript:" onClick="window.open('$imagefolio_url?main=imageRate&direct=|;
   $ratelink .= qq|$FORM{'link'}&file=$FORM{'image'}','Rate','height=200,width=200');return false"><b>Rate It!</b></a>|;

   $newlink = $FORM{'link'};
   $newlink =~ s/\//\./g;
   if (!$hits)   { $hits = "0";     }
   if (!$votes)  { $votes = "0";    }
   if (!$rating) { $rating = "0.00"; }

   if    (-e "$image_directory/$FORM{'link'}/$mypattern$newimage.jpg") {$timage = qq|$mypattern$newimage.jpg|;}
   elsif (-e "$image_directory/$FORM{'link'}/$mypattern$newimage.JPG") {$timage = qq|$mypattern$newimage.JPG|;}
   elsif (-e "$image_directory/$FORM{'link'}/$mypattern$newimage.gif") {$timage = qq|$mypattern$newimage.gif|;}
   elsif (-e "$image_directory/$FORM{'link'}/$mypattern$newimage.GIF") {$timage = qq|$mypattern$newimage.GIF|;}

   $mediapath = "$image_directory/$FORM{'link'}/$FORM{'image'}";

   if (($FORM{'image'} =~/(\.jpg|\.gif|\.png)/i) && $imageprotect) {
      my ($width, $height) = imgsize("$mediapath");
#      my $media_info = image_info("$mediapath");
#      my $width = $media_info->{width};
#      my $height = $media_info->{height};
      if ($width && $height) {
         $wh_info = qq| width="$width" height="$height"|;
      }
   }
   if ($wh_info) {
      $mediaurl = "$if_images_directory/pixel.gif";
      $mediaurl_bg = "$imageurl/$FORM{'link'}/$FORM{'image'}";
      $mediaurl_bg =~ s/([^a-zA-Z0-9$ignore_chars])/"%" . sprintf("%2x", ord($1))/ge;
      if ($FORM{'url'}) {
#         print "Content-type: text/html\n";
         print "Location:$mediaurl_bg\n\n";
         exit;
      }
   }
   else {
      $mediaurl = "$imageurl/$FORM{'link'}/$FORM{'image'}";
      $non_jpg_file_url = "$new_imageurl/$FORM{'link'}/$FORM{'image'}";
      if (!-e $mediapath) {
         $mediaurl = "$icons_dir/404.jpg";
         $mediaurl_404 = 1;
         $this_alt = "File not Found";
      }
      else {
         $mediaurl =~ s/([^a-zA-Z0-9$ignore_chars])/"%" . sprintf("%2x", ord($1))/ge;
         $non_jpg_file_url =~ s/([^a-zA-Z0-9$ignore_chars])/"%" . sprintf("%2x", ord($1))/ge;
      }
      if ($FORM{'url'}) {
#         print "Content-type: text/html\n";
         print "Location:$mediaurl\n\n";
         exit;
      }
   }

   if ($FORM{'search'}) {

      $query = $FORM{'search'};
      $query =~ s/([^a-zA-Z0-9\~])/"%" . sprintf("%2x", ord($1))/ge;

      if ($FORM{'search'} eq "NEW")      { $searchphrase = "Newly Added"; $sortfiles = 1; $display_sort = 1;}
      elsif ($FORM{'search'} eq "HITS") { $searchphrase = "Top Hits"; $sortfiles = 1; $display_sort = 3;}
      elsif ($FORM{'search'} eq "RATES") { $searchphrase = "Top Rates"; $sortfiles = 1; $display_sort = 4;}
      elsif ($FORM{'search'} eq "RANDOM") { $searchphrase = "Random"; $sortfiles = 5; $display_sort = 5;}
      elsif ($FORM{'search'} =~ /^USER~/) { ($blah, $search_user) = split(/~/, $FORM{'search'}); $searchphrase = "Uploads from $search_user"; }
      elsif ($FORM{'search'} eq "APPROVE") { $searchphrase = "Pending Approval"; $sortfiles = 1; $display_sort = 1;}
      else                        { $searchphrase = "Search Results"; }

      &get_nextprev_search_links;

      $newthisdirectory = "$searchphrase Display";

      if ($FORM{'tt'}) {
         $mediasrc = get_object($FORM{'tt'}, $mediaurl);
      }
      else {
         $mediasrc  = qq|<a href="$imagefolio_url?img=$FORM{'img'}|;
         $mediasrc .= qq|&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}">|;
         $mediasrc .= qq|<img src="$mediaurl" border=0 alt="$this_alt"$wh_info></a>|;
      }

      if ($FORM{'search'} eq "NEW" && $show_new_cats && $FORM{'cat'}) {
         if ($FORM{'cat'} =~ /\//) {
            my ($currcat, $lastcat) = $FORM{'cat'} =~ m#^(.*)\/(.*)#;
            $thisdir = get_clean_name($lastcat);
         }
         else {
            $thisdir = get_clean_name($FORM{'cat'});
         }
         $pagelinks = qq| <$font><A HREF="$imagefolio_url">Top</A> &gt; <a href="$imagefolio_url?search=$query&bool=$FORM{'bool'}">$searchphrase</a> &gt; <a href="$imagefolio_url?search=$query&img=$FORM{'img'}&cat=$FORM{'cat'}&bool=$FORM{'bool'}">$thisdir</a> &gt; $newimage</font>|;
      }
      else {
         $pagelinks = qq| <$font><A HREF="$imagefolio_url">Top</A> &gt; <a href="$imagefolio_url?search=$query&img=$FORM{'img'}&cat=$FORM{'cat'}&bool=$FORM{'bool'}">$searchphrase</a> &gt; $newimage</font>|;
      }
   }
   elsif ($FORM{'lbview'}) {

      &get_nextprev_lightbox_links;
      $newthisdirectory = "$lb_display";

      if ($FORM{'tt'}) {
         $mediasrc = get_object($FORM{'tt'}, $mediaurl);
      }
      else {
         $mediasrc  = qq|<a href="$imagefolio_url?lightbox=$FORM{'lbview'}">|;
         $mediasrc .= qq|<img src="$mediaurl" border=0 alt="$this_alt"$wh_info></a>|;
      }

      $pagelinks = qq| <$font><A HREF="$imagefolio_url">Top</A> &gt; <a href="$imagefolio_url?lightbox=$FORM{'lbview'}">$lightbox_name</a> &gt; $newimage</font>|;
   }
   else {
      &get_nextprev_image_links;

      $pagelinks = build_title_linked($FORM{'link'});

      if ($FORM{'tt'}) {
         $mediasrc = get_object($FORM{'tt'}, $mediaurl);
      }
      else {
         $mediasrc = qq|<a href="$imagefolio_url?direct=$FORM{'link'}&img=$FORM{'img'}">
         <img src="$mediaurl" border=0 alt="$this_alt"$wh_info></a>|;
      }
   }

   if ($wh_info) {
     $mediasrc = qq|<table border="0" cellspacing="0" cellpadding="0"><tr><td background="$mediaurl_bg">$mediasrc</td></tr></table>|;
  }

   $mediasrc = qq|<table border="0" cellspacing="8" cellpadding="0"><tr><td align="center">$mediasrc</td></tr>|;

   &find_size_date($FORM{'link'}, $FORM{'image'}, $timage);
   $filedate = unix_to_date($filedate);
   if (!$filesize_done) {
   if ($filesize < 1500) { $filesize = commify($filesize) . " bytes"; }
      else { $filesize = int($filesize/1024);
         if ($filesize < 1500) { $filesize = commify($filesize) . " Kb"; }
            else { $filesize = int($filesize/10.24);
                  $filesize = ($filesize/100) . " Mb";  }    }
   }

   $admin_image1 = $FORM{'image'} if !$mediaurl_404;
   $admin_image2 = $timage;

   &build_pull_down_menu;
   &build_nav;

if ($if2_caption) {
   if (-e "$data_directory/$newlink.captions.txt"){
     open (CAPTIONS,"$data_directory/$newlink.captions.txt");
     while (<CAPTIONS>) {
       my($filename, $description) = split(/\t/,$_);
       chomp $_;
       next if !$description;
       ($newfile) = $filename =~ m,^(.*)\.\w+$,;
       if ($newfile eq $newimage) {
         $image_caption = $description;
         last;
       }
     }
     close(CAPTIONS);
   }
}

   $iptc_category = $FORM{'link'};
   if ($timage) {
      $iptc_image = $timage;
   }
   else {
      $iptc_image = $FORM{'image'};
   }

   &iptc_create_table;

   if ($custom18_user && -e "$sessions_dir/$custom18_user/_watermark.png") {
      print "Set-Cookie: IFPro_userwm=$custom18_user; path=/;\n";
   }
   else {
      print "Set-Cookie: IFPro_userwm=; path=/;\n";
   }

   if ($is_admin) {
      my $plugunder = &create_image_tools;
      $mediasrc .= qq|<tr><td align="center">$plugunder</td></tr>|;
   }
   elsif ($is_user && $custom18_user) {
      $plugunder = qq|<SCRIPT LANGUAGE="JavaScript">|;
      $plugunder .= &create_user_image_tools($FORM{'link'});
      $plugunder .= qq|
         var this_guest = "$guest_username";
         var this_file = "$custom18_user";
         var block_rename_move ="$custom18_approval";
         if (IFPro_user_session) {
            per_array=IFPro_user_session.split("\|");
            if (this_file==per_array[1] && this_file != this_guest){
               if (usetextlinks == 1) {
                  document.writeln('<font size=1 face="arial,helvetica">');
               }
               if (per_array[2] == 1 && block_rename_move != 1) {
                  document.write(rename_me);
               }
               if (per_array[3] == 1) {
                  document.write(caption_me);
               }
               if (per_array[4] == 1) {
                  document.write(delete_me);
               }
               if (per_array[5] == 1 && block_rename_move != 1) {
                  document.write(move_me);
               }
               if (usetextlinks == 1) {
                  document.writeln('</font>');
               }
            }
         }
      </SCRIPT>|;
      $mediasrc .= qq|<tr><td align="center">$plugunder</td></tr>|;
      $plugunder = ();
   }

   if ($using_lightbox_mod){
      my ($base) = $FORM{'image'} =~ m,^(.*)\.\w+$,;
      my ($ext) = ($FORM{'image'} =~ /\.([^.]+)$/);
      my $inout = 1 if defined $LIGHTBOX{"$FORM{'link'}|$base|$ext"};
      my $plugunder= qq|<SCRIPT LANGUAGE="JavaScript">showItems("$base", "$FORM{'link'}", "$ext", "$inout");</SCRIPT>|;
      $mediasrc .= qq|<tr><td align="center">$plugunder</td></tr>|;
   }

   if ($show_similar && $show_similar_link) {
      $thumblinks .= qq|<a href="$imagefolio_url?img=0&cat=all&search=$show_similar&bool=or&numtolist=6" alt="Show similar $mystuff_plural" title="Show similar $mystuff_plural">Show similar $mystuff_plural</a><br>|;
   }


if ($imageprotect) {
   if (!$wh_info) {
      $if_javascript .= qq|<script language="JavaScript" src="$base_if_url/imageprotect.js"></script>\n|;
   }
   $if_javascript = qq|<META HTTP-EQUIV="imagetoolbar" CONTENT="no">$if_javascript|;
# Not supported by "Safari":
#   $if_javascript .= qq|<STYLE media="print">BODY {display:none}</STYLE>|;
}

if ($one_time_access or $is_admin) {
   $if_javascript .= qq|
      <style type="text/css">
      <!--
      .ab_delete {
      font-family: verdana,arial,helvetica;
      font-size:12px;
      color:#ffffff;
      font-weight:bold;
      background-color:#FF0000;
      }
      .ab_approve {
      font-family: verdana,arial,helvetica;
      font-size:12px;
      color:#ffffff;
      font-weight:bold;
      background-color:#00CC00;
      }
      -->
      </style>|;
   $current = "&admin_directory=$FORM{'link'}";
   $current .= "&admin_image1=$admin_image1"; #preview image
   $current .= "&admin_image2=$admin_image2"; #thumbnail image
   $current .= "&user_owner=$custom18_user"; #user
   if ($custom18_email && $custom18_user) {
      $current .= "&user_email=$custom18_email"; #user email
   }
   $current .= "&ota=$FORM{'ota'}";
   $current .= "&tt=$FORM{'tt'}";
   if ($custom18_approval) {
      $del_appr_button = qq|&nbsp;<input type=button value="&nbsp;&nbsp;Delete&nbsp;&nbsp;" class="ab_delete" onclick="javascript:adminPopup('$imagefolio_url?admin=delete_confirm_image$current','width=500,height=520,scrollbars=yes')">&nbsp;|;
      $del_appr_button .= qq|&nbsp;<input type=button value="&nbsp;Approve&nbsp;" class="ab_approve" onclick="javascript:adminPopup('$imagefolio_url?admin=admin_approve_image$current','width=500,height=320,scrollbars=no')">&nbsp;|;
      if ($is_admin or $config_cache_page_age) {
         $del_appr_button .= qq|<br><$font>Make sure you rebuild the index after you are done approving files.</font><br>|;
      }
   }
   elsif ($one_time_access) {
      $del_appr_button = qq|&nbsp;<input type=button value="&nbsp;&nbsp;Delete&nbsp;&nbsp;" class="ab_delete" onclick="javascript:adminPopup('$imagefolio_url?admin=delete_confirm_image$current','width=500,height=520,scrollbars=yes')">&nbsp;|;
   }
   if ($del_appr_button) {
      $mediasrc = qq|<center>$del_appr_button</center>$mediasrc|;
   }
}
elsif ($custom18_approval) {
   &Error('This file has not been approved for viewing yet!');
}


###############################################################################
# REMOVE OLD FILES
# Searches the temp directory for old files, and removes them from your web space
###############################################################################
#sub remove_old_files {
#   opendir (DL, "$tempdir");
#   @old_files= grep { /\d+/ } readdir(DL);
#   closedir (DL);
#   $OLDFILESSIZE = @old_files;
#
#   use File::Path;
#
#   if ($OLDFILESSIZE > 1) {
#      foreach $old_file (@old_files) {
#         if (-M "$tempdir/$old_file" > "0.25") {
#            if (-d "$tempdir/$old_file") {
#               rmtree("$tempdir/$old_file");
#            }
#            else {
#               unlink("$tempdir/$old_file");
#            }
#         }
#      }
#   }
#}
#$download_from_temp = 1;
#$tempdirurl         = $base_if_url . "/temp";


   if ($FORM{'download'}) {
      if ($download_from_temp) {
         eval "use Archive::Zip qw(:CONSTANTS :ERROR_CODES);1;" or $donnotzip = 1;
         use File::Copy;
         &remove_old_files;
         my $temp_id = int(rand(1234567890)) + time;
         mkdir ("$tempdir/$temp_id", "0777") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
         chmod(0777,"$tempdir/$temp_id") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
#         &File::Copy::copy ("$fullsize_file", "$tempdir/$temp_id/$newimage.$myextension_fullsize") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
#         chmod(0777,"$tempdir/$temp_id/$newimage.$myextension_fullsize") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;


         if (lc($myextension_fullsize) eq 'zip' or $donnotzip) {
            &File::Copy::copy ("$fullsize_file", "$tempdir/$temp_id/$newimage.$myextension_fullsize") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
            chmod(0777,"$tempdir/$temp_id/$newimage.$myextension_fullsize") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
         }
         else {
            my $zip = Archive::Zip->new();
            $zip->addFile( $fullsize_file, "$newimage.$myextension_fullsize" );
            my $member = $zip->memberNamed( "$newimage.$myextension_fullsize" );
            $member->desiredCompressionMethod( 0 );
            die 'write error' if $zip->writeToFileNamed( "$tempdir/$temp_id/$newimage.zip" ) != AZ_OK;
            chmod(0777,"$tempdir/$temp_id/$newimage.zip") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
            $myextension_fullsize = 'zip';
         }

         if (!$failed_download) {
            if (!$is_admin && $download_log) {
               &create_download_log;
            }
            print "Location:$tempdirurl/$temp_id/$newimage.$myextension_fullsize\n\n";
            exit;
         }
      }
      else {
         if(open(SENDFILE, $fullsize_file)) {
            if($image_directory =~ /\:/) {
               binmode(SENDFILE);
               binmode(STDOUT);
            }
            $FileSize = (stat($fullsize_file))[7];
            ($Filename = $fullsize_file) =~  m!([^/^\\]*)$!;
            if (lc($myextension_fullsize) eq 'zip'){
               print "Content-Type: application/x-zip\n";
            }
            else {
               print "Content-Type: application/x-unknown\n";
   #           print "Content-Type: application/octet-stream\n";
            }
            print "Content-Length: $FileSize\n";
            print "Content-Disposition: attachment; filename=$newimage.$myextension_fullsize\n\n";
            print while(<SENDFILE>);
            close(SENDFILE);
            if (!$is_admin && $download_log) {
               &create_download_log;
            }
            exit;
         }
         else {
            $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
         }
      }
   }

   if (-e $fullsize_file && $use_fullsize) {
      if (lc($myextension_fullsize) eq 'zip' && $custom18_file_type){
         $display_name = "$newimage.$custom18_file_type";
      }
      else {
         $display_name = "$newimage.$myextension_fullsize";
      }
      if ($download_link_under_preview) {
         
         my $plugunder = "";


         if ($use_textlinks) {
            if (lc($myextension_fullsize) ne 'zip' && !$download_from_temp) {
               $plugunder = qq|<a href="javascript:;" onClick="if (confirm('Do you want to download the $filesize $uc_myextension_fullsize file? (OK = Yes   Cancel = No)')) {location='$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1';};return false;" alt="Download This File" title="Download This File"><$font_dl_link>Download</font></a>$failed_download|;
            }
            else {
               $plugunder = qq|<a href="javascript:;" onClick="location='$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1';return false;" alt="Download This File" title="Download This File"><$font_dl_link>Download</font></a>$failed_download|;
            }
         }
         else {
            if (lc($myextension_fullsize) ne 'zip' && !$download_from_temp) {
               $plugunder = qq|<a href="javascript:;" onClick="if (confirm('Do you want to download the $filesize $uc_myextension_fullsize file? (OK = Yes   Cancel = No)')) {location='$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1';};return false;"><img src="$if_images_directory/download2.$ButtonExt" border=0  alt="Download This File" title="Download This File"></a>$failed_download|;
            }
            else {
               $plugunder = qq|<a href="javascript:;" onClick="location='$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1';return false;"><img src="$if_images_directory/download2.$ButtonExt" border=0  alt="Download This File" title="Download This File"></a>$failed_download|;
            }
         }
         $mediasrc .= qq|<tr><td align="center">$plugunder</td></tr>|;
      }
   }
   else {
      $display_name = $FORM{'image'};
   }

   $mediasrc .= "</table>";


   if ($commerce_skin) {
      require "$commercepath/ifc_lib/image.pl";
      &calc_price_options;
   }

   if (-e "$image_directory/$FORM{'link'}/image.html") {
     open (TEMPLATE,"$image_directory/$FORM{'link'}/image.html") or &Error("Could not open template.  Reason $!");
   }
   else {
     open (TEMPLATE,"$image_template") or &Error("Could not open template.  Reason $!");
   }

   while (<TEMPLATE>) {
     if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_include($2); }
     elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_exec_include($2); }
     else { $template .= $_; }
   }
   close(TEMPLATE);

   require "$libpath/headerfooter.pl";

   if (-e "$image_directory/$FORM{'link'}/$newimage.data") {
     open (METADATA,"$image_directory/$FORM{'link'}/$newimage.data") or &Error("Could not open database.  Reason $!");
     LINE: while (defined ($line = <METADATA>)) {
      next LINE if ($line =~ /^\s*$/); # skip blank lines
      next LINE if ($line =~ /^#/);   # skip comment lines
      my ($fieldname, $fieldvalue) = split(/\t/, $line);
      $template =~ s/$fieldname/$fieldvalue/ig;
     }
     close(METADATA);
   }

   $site_title =~ s/\*\*\*Admin Mode\*\*\*// if $quickdisplay;

   $template =~ s/%%%TEXTNAV%%%/$textnav/ig;
   
   if ($use_textlinks) {
      $template =~ s/%%%NAV%%%/<$font>$textnav<\/font>/ig;
   }
   else {
      $template =~ s/%%%NAV%%%/$nav/ig;      
   }
   
   $template =~ s/%%%TEXT_NEXT_PREVIOUS%%%/$text_next_previous/ig;
   $template =~ s/%%%IPTCTABLE%%%/$iptc_table/ig;
   $template =~ s/%%%FILENAME%%%/$display_name/ig;
   $template =~ s/%%%FILESIZE%%%/$filesize/ig;
   $template =~ s/%%%FILEDATE%%%/$filedate/ig;
   $template =~ s/%%%CAPTION%%%/$image_caption/ig;
   $template =~ s/%%%DIRECTORY%%%/$FORM{'link'}/ig;
   $template =~ s/%%%HITS%%%/$hits/ig;
   $template =~ s/%%%RATING%%%/$rating/ig;
   $template =~ s/%%%VOTES%%%/$votes/ig;
   $template =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $template =~ s/%%%IMAGE%%%/$mediasrc/ig;
   $template =~ s/%%%NAV%%%/$nav/ig;
   $template =~ s/%%%IMAGE_NAME%%%/$newimage/ig;
   $template =~ s/%%%SLIDESHOW%%%/$slideshow_tag/ig;
   $template =~ s/%%%CATEGORY%%%/$newthisdirectory/ig;
   $template =~ s/%%%SEARCH_INFO%%%/$searchinfo/ig;
   $template =~ s/%%%PAGELINKS%%%/$pagelinks/ig;
   $template =~ s/%%%TEXTPULLDOWN_MENU%%%/$textpulldown_menu/ig;
   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;

   if ($use_printbutton) {
      $template =~ s/%%%PRINTBUTTON_ADD_IMAGE%%%/<script language="Javascript">buy('$FORM{'image'}','$PrintButton{'add_image'}','thumbnail_url=$new_imageurl\/$FORM{'link'}\/$timage')<\/script>/ig;
      $template =~ s/%%%PRINTBUTTON_ADD_SELECTED%%%/<script language="Javascript">addtobasket("$PrintButton{'add_selected'}")<\/script>/ig;
   }

   $template =~ s/%%%THUMB_LINK%%%/$thumblinks/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;

   $template =~ s/%%%RATELINK%%%/$ratelink/ig;
   $template =~ s/%%%PULLDOWN_MENU%%%/$pulldown_menu/ig;
   $template =~ s/%%%SEARCH_BOX%%%/$search_box/ig;
   $template =~ s/%%%PREVIOUS_CATEGORY%%%/$previous_category/ig;
   $template =~ s/%%%NEXT_CATEGORY%%%/$next_category/ig;

   $template =~ s/%%%IF_JAVASCRIPT%%%/$if_javascript/ig;
   if ($parse_single_iptc_fields) {
      foreach my $key (sort keys %IPTCtag) {
         my $tag = "%%%IPTC_" . uc($key) . "%%%";
         $template =~ s/$tag/$IPTCtag{$key}/ig;
      }
   }
}

###############################################################################
# GET OBJECT
# retrieves the template for this media type and returns the $mediasrc tag
###############################################################################
sub get_object {
   my $file = shift;
   if (-e "$media_template_directory/$file.html") {
     open (TEMPLATE,"$media_template_directory/$file.html") or &Error("Could not open $file.  $!");
     while (<TEMPLATE>) { $medtemplate .= $_; }
     close(TEMPLATE);
   }
   else {
#     print "Content-type: text/html\n";
     print "Location:$mediaurl\n\n";
     exit;
   }
   if (!$antileech) {
      $medtemplate =~ s/%%%FILE%%%/$non_jpg_file_url/ig;
   }
   else {
      $medtemplate =~ s/%%%FILE%%%/$mediaurl/ig;
   }
   $medtemplate =~ s/%%%DOWNLOAD_FILE%%%/$mediaurl/ig;
   $medtemplate =~ s/%%%NAME%%%/$newimage/ig;
   $medtemplate =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   return $medtemplate;
}

###############################################################################
# GET NEXTPREV SEARCH LINKS
# called from view_image to provide navigation to next and previous full-size
# images from a search result
###############################################################################
sub get_nextprev_search_links {

   $cachefilename = "search~$FORM{'search'}";
   $cachefilename .= ".$FORM{'cat'}" if $FORM{'cat'};
   $cachefilename .= ".$FORM{'bool'}" if $FORM{'bool'};
   $cachefilename .= ".sort5" if ($sortfiles == 5);
   $cachefilename .= ".$group_group_name" if $group_group_name;
   $cachefilename .= ".is_admin" if $is_admin;
   $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
   $cacheloc = "$cache_directory/searches/$cachefilename";

   @names = ();
   @idx = ();
   @LINES = ();
   open (FILE,"$cacheloc") or &Error("Our database was updated $index_date ago. Please click <a href=\"$imagefolio_url?search=$FORM{'search'}&cat=$FORM{'cat'}&bool=$FORM{'bool'}&img=$FORM{'img'}&tt=$FORM{'tt'}&from_link=$FORM{'link'}&image=$FORM{'image'}\">here</a> to run the search again since the result might have changed.");
   my(@LINES)=<FILE>;
   close(FILE);

   foreach (@LINES) {
      my ($blah,$name,$path,$filedate,$hits,$votes) = split(/\|/, $_);
      ($linkimage) = $name =~ m,^(.*)\.\w+$,;
      $linkimage =~ s/$mypattern//g;
      foreach $key (keys %extensions) {
         $lckey = lc($key);
         $uckey = uc($key);
         $extfound = 0;
         if ( -e "$image_directory/$path/$linkimage.$lckey" ) {
            $extfound = 1;
            $mykey = $lckey;
            last;
         }
         elsif ( -e "$image_directory/$path/$linkimage.$uckey" ) {
            $extfound = 1;
            $mykey = $uckey;
            last;
         }
      }
      if ($extfound) {
         push(@names, "$linkimage.$mykey\t$path\t$filedate\t$hits\t$votes");
         if ($sortfiles == 3) {
            push(@idx, $hits);
         }
         elsif ($sortfiles == 4) {
            push(@idx, $votes);
         }
      }
   }

   if ($sortfiles == 2) {
      @names = sort { lc($a) cmp lc($b) } @names;
   }
   elsif (($sortfiles == 3) or ($sortfiles == 4)) {
      @names = @names[ sort { $idx[$b] <=> $idx[$a] } 0 .. $#idx ];
   }

   $SIZE=@names;
   $current_image = $FORM{'image'};
   $cnt = 0;


   if ($SIZE) {
     foreach (@names) {
       my ($ifname, $ifpath) = split(/\t/, $_);
       if (lc($ifname) eq lc($current_image) && lc($ifpath) eq lc($current_cat)) {
         $thiscount = ($cnt + 1);
         $nextcount = ($cnt + 1);
         $prevcount = ($cnt - 1);
         last;
       }
       $cnt++;
     }

   $searchinfo  = qq|$newimage from $newthisdirectory<br>|;
   $searchinfo .= qq|Image $thiscount of $SIZE|;

   $cnt = 0;

   if ($thiscount eq $SIZE) { $nextcount = 0; }

     foreach (@names) {
       my ($name, $path) = split(/\t/, $_);
       if ($cnt eq $nextcount) {
         $nextimage = $name;
         $nextpath = $path;
         ($extension) = ($nextimage =~ /\.([^.]+)$/);
         $if_tagfile =  $extensions{lc($extension)}[2];
         $next_page_link =  qq|$imagefolio_url?action=view&link=$nextpath&image=$nextimage&img=$FORM{'img'}&tt=$if_tagfile&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}|;
         if ($auto_slideshow && $FORM{'slideshow'}) {
            $slideshow_tag  = qq|<META HTTP-EQUIV="refresh" CONTENT="$ss_refresh ;URL=$imagefolio_url?|;
            $slideshow_tag .= qq|action=view&link=$nextpath&image=$nextimage&img=$FORM{'img'}&tt=|;
            $slideshow_tag .= qq|$if_tagfile&slideshow=1&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}">|;
            $stop_link =  qq|$imagefolio_url?action=view&link=$FORM{'link'}&image=$current_image&img=$FORM{'img'}&tt=$if_tagfile&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}|;
         }
       }
       if ($cnt eq $prevcount) {
         $previmage = $name;
         $prevpath = $path;
         ($extension) = ($previmage =~ /\.([^.]+)$/);
         $if_tagfile =  $extensions{lc($extension)}[2];
         $previous_page_link =  qq|$imagefolio_url?action=view&link=$prevpath&image=$previmage&img=$FORM{'img'}&tt=$if_tagfile&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}|;
       }
       last if $previmage && $nextimage;
       $cnt++;
     }
   }
   @names = ();
}

###############################################################################
# GET NEXTPREV IMAGE LINKS
# called from view_image to provide navigation to next and previous full-size
# images
###############################################################################
sub get_nextprev_image_links {

   $cachefilename = "link~$FORM{'link'}";
   $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
   $cachefilename .= "~sort5" if ($sortfiles == 5);
   $cacheloc = "$cache_directory/searches/$cachefilename";

   @names = ();
   @db_lines = ();
   @idx = ();

   if (-e "$cacheloc") { 
      if ((-M "$cacheloc" <= $cache_date) && !$force_cachereload) { 
         &get_link_cache;
      }
      else { 
         &creat_link_list;
      }
   }
   else {
      &creat_link_list;
   }

   sub creat_link_list {
      @idsort = ();
      opendir(IMAGEDIR,"$image_directory/$FORM{'link'}")or &Error("Error Reading Directory: $!");
      @files = readdir(IMAGEDIR);
      closedir(IMAGEDIR);

      foreach $file (@files) {
#         if ( -B "$image_directory/$FORM{'link'}/$file") {
            next if $file =~ /^$mypattern/i;
            next if $file =~ /^$mypattern_fullsize/i;
#            next if $file eq "_category_image.jpg";
            next if $file =~ /(index\.html|_category_image\.jpg|\.vote|\.count)$/i;
            ($extension) = ($file =~ /\.([^.]+)$/);
            next if !exists($extensions{lc($extension)});
            $filedate = ();
            $my_count = ();
            $my_votes = ();
            $my_rates = ();
            &find_size_date($FORM{'link'}, $file);
            my ($name_base) = $file =~ m,^(.*)\.\w+$,;
            my $countfile = qq|$image_directory/$FORM{'link'}/$name_base.count|;
            if (-e $countfile) {
               open (FILE,"$countfile");
               while (<FILE>) {
                  ($my_count) = split(/\t/, $_);
                  last;
               }
               close(FILE);
            }
            my $votefile = qq|$image_directory/$FORM{'link'}/$name_base.vote|;
            if (-e $votefile) {
               open (FILE,"$votefile");
               while (<FILE>) {
                  ($my_votes, $my_rates) = split(/\t/, $_);
                  last;
               }
               close(FILE);
            }
            push(@db_lines, "$filedate\t$file\t$my_count\t$my_rates\t$my_votes");
            push(@idsort, $name_base);
#         }
      }

      if (($sortfiles == 5) && @db_lines) {
          &shuffle_link(\@db_lines);
      }
      else {
         @db_lines = @db_lines[ sort { lc($idsort[$a]) cmp lc($idsort[$b]) } 0 .. $#idsort ];
      }

      open (CACHE,">$cacheloc") or &Error("Unable to create cache file at $cacheloc: $!");
      foreach $db_line (@db_lines) {
         print CACHE "$db_line\t\n";
      }
      close(CACHE);
      chmod(0666,"$cacheloc");
      @db_lines = ();
      &get_link_cache
   }

   sub get_link_cache {
      open (FILE,"$cacheloc") or &Error("Can't Open $cacheloc: $!");
      while (<FILE>) {
         my ($filedate, $file, $my_count, $my_rates, $my_votes) = split(/\t/, $_);
         push(@db_lines, "$filedate\t$file\t$my_count\t$my_rates\t$my_votes");
         if ($sortfiles == 3) {
            push(@idx, $my_count);
         }
         elsif ($sortfiles == 4) {
            push(@idx, $my_rates);
         }
      }
      close(FILE);
   }

   sub shuffle_link {
      my $db_lines = shift;
      my $l;
      for ($l = @$db_lines; --$l; ) {
         my $m = int rand ($l+1);
         next if $l == $m;
         @$db_lines[$l,$m] = @$db_lines[$m,$l];
      }
   }

   if ($sortfiles == 1) {
      @names = sort { $b <=> $a } @db_lines;
   }
   elsif (($sortfiles == 2) or ($sortfiles == 5)) {
      @names = @db_lines;
   }
   elsif (($sortfiles == 3) or ($sortfiles == 4)) {
      @names = @db_lines[ sort { $idx[$b] <=> $idx[$a] } 0 .. $#idx ];
   }

   $SIZE=@names;
   $current_image = $FORM{'image'};
   $cnt = 0;

   if ($SIZE) {
     foreach (@names) {
       my ($ifdate, $ifname) = split(/\t/, $_);
       if (lc($ifname) eq lc($current_image)) {
         $thiscount = ($cnt + 1);
         $nextcount = ($cnt + 1);
         $prevcount = ($cnt - 1);
         last;
       }
       $cnt++;
     }

   $searchinfo = qq|Displaying image $thiscount of $SIZE|;
   if ($auto_slideshow && $FORM{'slideshow'}) { $searchinfo .= qq|<br>$ss_refresh Second Slideshow Mode|; }
   else { $searchinfo .= qq|<br>Manual Slideshow Mode| unless $quickdisplay; }

   $cnt = 0;

   if ($thiscount eq $SIZE) { $nextcount = 0; }

     foreach (@names) {
       my ($nulldate, $name) = split(/\t/, $_);
       if ($cnt eq $nextcount) {
         $nextimage = $name;
         ($extension) = ($nextimage =~ /\.([^.]+)$/);
         $if_tagfile =  $extensions{lc($extension)}[2];
         $next_page_link =  qq|$imagefolio_url?action=view&link=$FORM{'link'}&image=$nextimage&img=$FORM{'img'}&tt=$if_tagfile|;
         if ($auto_slideshow && $FORM{'slideshow'}) {
            $slideshow_tag = qq|<META HTTP-EQUIV="refresh" CONTENT="$ss_refresh ;URL=$imagefolio_url?action=view&link=$FORM{'link'}&image=$nextimage&img=$FORM{'img'}&tt=$if_tagfile&slideshow=1">|;
            $stop_link =  qq|$imagefolio_url?action=view&link=$FORM{'link'}&image=$current_image&img=$FORM{'img'}&tt=$if_tagfile|;
         }
       }
       if ($cnt eq $prevcount) {
         $previmage = $name;
         ($extension) = ($previmage =~ /\.([^.]+)$/);
         $if_tagfile =  $extensions{lc($extension)}[2];
         $previous_page_link =  qq|$imagefolio_url?action=view&link=$FORM{'link'}&image=$previmage&img=$FORM{'img'}&tt=$if_tagfile|;
       }
       last if $previmage && $nextimage;
       $cnt++;
     }
   }
   @names = ();
}

###############################################################################
# GET NEXTPREV LIGHTBOX LINKS
# called from view_image to provide navigation to next and previous full-size
# images
###############################################################################
sub get_nextprev_lightbox_links {

   if ($FORM{'lbview'} eq 'view') {
      ($lb_display) = split(/\t/, @LIGHTBOXES[0]);
      ($lb_display) = split(/\|/, $lb_display);
      $lb_display = "$untitled_lightbox" if !$lb_display;
      $lb_display = "$lightbox_name : $lb_display";
      @files = @current_lightbox_content;
   }
   else {
      $savedlightbox = $FORM{'lbview'};
      $savedlightbox .= "$emailed_lightboxes_ext";
      if (-e "$emailed_lightboxes_directory/$savedlightbox"){
         open (LIGHTBOXES,"< $emailed_lightboxes_directory/$savedlightbox");
         while (<LIGHTBOXES>) {
            chomp;
            push(@lightboxcopy, $_);
          }
         close(LIGHTBOXES);
         my ($rawtempsubject, $cookie, $no_expire) = split(/\t/, $lightboxcopy[0]);
         @files = $cookie =~ /\[(.*?)\]/g;
         ($lb_display) = split(/\|/, $rawtempsubject);
         if ($no_expire) {
            $lightboxtype = "Saved";
         }
         else {
            $lightboxtype = "Emailed";
         }
         $lb_display = "$lightboxtype $lightbox_name : $lb_display";
      }
   }

   foreach $file (@files) {
     ($path, $linkimage, $extension) = split(/\|/, $file);
     $file = "$linkimage.$extension";
     if ( -e "$image_directory/$path/$file") {
       next if $file =~ /^$mypattern/i;
       next if $file =~ /^$mypattern_fullsize/i;
       next if $file eq "_category_image.jpg";
       next if !exists($extensions{lc($extension)});
       my $dbline = "$path\t$file";
       push(@names, $dbline);
     }
   }

   $SIZE=@names;
   $current_image = $FORM{'image'};
   $cnt = 0;



   if ($SIZE) {
     foreach (@names) {
       my ($ifpath, $ifname) = split(/\t/, $_);
       if (lc($ifname) eq lc($current_image) && lc($ifpath) eq lc($current_cat)) {
         $thiscount = ($cnt + 1);
         $nextcount = ($cnt + 1);
         $prevcount = ($cnt - 1);
#         $next_page_link = "yes";
         last;
       }
       $cnt++;
     }

      $searchinfo = qq|Displaying image $thiscount of $SIZE|;
      if ($auto_slideshow && $FORM{'slideshow'}) { $searchinfo .= qq|<br>$ss_refresh Second Slideshow Mode|; }
      else { $searchinfo .= qq|<br>Manual Slideshow Mode|; }

      $cnt = 0;

      if ($thiscount eq $SIZE) { $nextcount = 0; }

      foreach (@names) {
         my ($path, $name) = split(/\t/, $_);
         if ($cnt eq $nextcount) {
            $nextimage = $name;
            ($extension) = ($nextimage =~ /\.([^.]+)$/);
            $if_tagfile =  $extensions{lc($extension)}[2];
            $next_page_link =  qq|$imagefolio_url?action=view&link=$path&image=$nextimage&tt=$if_tagfile&lbview=$FORM{'lbview'}|;
            if ($auto_slideshow && $FORM{'slideshow'}) {
               $slideshow_tag = qq|<META HTTP-EQUIV="refresh" CONTENT="$ss_refresh ;URL=$imagefolio_url?action=view&link=$path&image=$nextimage&tt=$if_tagfile&slideshow=1&lbview=$FORM{'lbview'}">|;
               $stop_link =  qq|$imagefolio_url?action=view&link=$path&image=$current_image&tt=$if_tagfile&lbview=$FORM{'lbview'}|;
            }
         }
         if ($cnt eq $prevcount) {
            $previmage = $name;
            ($extension) = ($previmage =~ /\.([^.]+)$/);
            $if_tagfile =  $extensions{lc($extension)}[2];
            $previous_page_link =  qq|$imagefolio_url?action=view&link=$path&image=$previmage&tt=$if_tagfile&lbview=$FORM{'lbview'}|;
         }
         last if $previmage && $nextimage;
         $cnt++;
      }
   }
   @names = ();
}

###############################################################################
# REMOVE OLD FILES
# Searches the temp directory for old files, and removes them from your web space
###############################################################################
sub remove_old_files {

   opendir (DL, "$tempdir");
   @old_files= grep { /\d+/ } readdir(DL);
   closedir (DL);
   $OLDFILESSIZE = @old_files;

   use File::Path;

   if ($OLDFILESSIZE > 1) {
      foreach $old_file (@old_files) {
         if (-M "$tempdir/$old_file" > "0.25") {
            if (-d "$tempdir/$old_file") {
               rmtree("$tempdir/$old_file");
            }
            else {
               unlink("$tempdir/$old_file");
            }
         }
      }
   }
}

###############################################################################
# RECORD STATS
# Opens our stats database and updates or creates the hit counter
###############################################################################
sub record_counts {

   $votefile = "$image_directory/$FORM{'link'}/$newimage.vote";
   if (-e $votefile) {
      open (FILE,"$votefile") or &Error("Could not open $votefile.  $! \n");
      while (<FILE>) {
         ($votes, $rating) = split(/\t/, $_);
         last;
      }
      close(FILE);
   }

   @hits = ();

   $count_host = $ENV{'REMOTE_ADDR'};
   $count_host .= " DOWNLOAD" if $FORM{'download'};
   $countfile = "$image_directory/$FORM{'link'}/$newimage.count";
   if (-e $countfile) {
      open (FILE,"$countfile") or &Error("Could not open $countfile.  $!");
      (@hits)=<FILE>;
      close(FILE);
      chomp @hits;
      $SIZE=@hits;


      for ($i=0;$i<$SIZE;$i++) {
         $_=$hits[$i];
         if ($i==0) {
            ($hits, $time, $downloads) = split(/\t/, $_);
            $downloads = 0 if !$downloads;
            $hits++ if !$FORM{'download'};
            $downloads++ if $FORM{'download'};
            $new_countfile = $hits . "\t" . $time . "\t" . $downloads . "\t\n";
            $elapsed = ($current_time - $time) / 86400; # 86400 sec = 1 day
         }
         elsif ($elapsed > 1) {
            $new_countfile = $hits . "\t" . $current_time . "\t" . $downloads . "\t\n";
            last;
         }
         elsif ($_ eq $count_host) {
            $hits = $hits-1 if !$FORM{'download'};
            $downloads = $downloads-1 if $FORM{'download'};
            $no_permission = 1;
            last;
         }
         else {
            $new_countfile .= "$_\n";
         }
      }
   }
   else {
      $hits = 0;
      $downloads = 0;
      $hits = 1 if !$FORM{'download'};
      $downloads = 1 if $FORM{'download'};
      $new_countfile = $hits . "\t" . $current_time . "\t" . $downloads . "\t\n";
   }

   if (!$no_permission) {
      $new_countfile .= "$count_host\n";
      open (FILE,">$countfile");
      if ($useflock) { flock(FILE, 2); }
      print FILE $new_countfile;
      close(FILE);
      chmod(0666,"$countfile");
   }
}

sub create_download_log {
   if ($ifusername) {
      $log_user = $ifusername;
   }
   elsif ($is_admin) {
      $log_user = "Administrator";
   }
   else {
      $log_user = $guest_username;
   }
   $download_log = "$logdir/$download_log";
   if (! -e $download_log) {
      $log_file = "DOWNLOAD SYSTEM\tUSER\tIP\tDATE/TIME\tFILE(S)\n";
   }
   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $year += 1900;
   $mon++;
   $logdate = sprintf "%04d-%02d-%02d %02d:%02d:%02d", $year, $mon, $mday, $hour, $min, $sec;

   $log_file .= "File download\t$log_user\t$ENV{'REMOTE_ADDR'}\t$logdate\t$FORM{'link'}/$fullsize_name\n";

   open (FILE,">>$download_log") or &Error("Can't Open Download Log: $!");
   print FILE $log_file;
   close(FILE);
   chmod(0777,"$download_log");
}

1;

