###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################

###############################################################################
###                              MANUAL CONFIGURATION                      ####
###############################################################################
# If you have problems getting ImageFolio's "zero config" to work then please
# fill in the correct values here (2 to 5)

# (2) #########################################################################
# WHAT IS THE ABSOLUTE PATH TO THE DIRECTORY CONTAINING imageFolio.cgi,
# imageRate.cgi, AND THE data, admin, config and if_lib DIRECTORIES?
# Type the full path below. (no trailing slash)

#$base_scripts_path = '/home/httpd/html/www.yourdomain.com/cgi-bin/ImageFolioLite';

# (3) #########################################################################
# WHAT IS THE URL TO THE DIRECTORY CONTAINING imageFolio.cgi,
# imageRate.cgi, config.pl, AND THE data, templates, AND if_lib DIRECTORIES?
# Type the URL to the directory you defined above. (no trailing slash)

#$base_scripts_url = 'http://www.yourdomain.com/cgi-bin/ImageFolioLite';

# (4) #########################################################################
# WHAT IS THE ABSOLUTE PATH TO THE IMAGEFOLIO DIRECTORY CONTAINING the directories:
# cache, gallery, if_images, temp.

#$base_if_path = '/home/httpd/html/www.yourdomain.com/ImageFolioLite_files';

# (5) #########################################################################
# WHAT IS THE ABSOLUTE URL TO THE IMAGEFOLIO DIRECTORY CONTAINING the directories:
# cache, gallery, if_images, temp.

#$base_if_url = 'http://www.yourdomain.com/ImageFolioLite_files';

###############################################################################
###                           END MANUAL CONFIGURATION                     ####
###############################################################################
# NO NEED TO MODIFY ANYTHING BELOW THIS LINE #################################

if (!$base_if_url) {
   eval{require "$currdir/data/config/paths.pl";};
   if (!-d "$base_scripts_path" or !-d "$base_if_path" or !$ENV{'HTTP_USER_AGENT'}) {
      unlink ("$currdir/data/config/paths.pl") if $ENV{'HTTP_USER_AGENT'};
      $pathsfile = ();
      $imagefolio_files_directory = "ImageFolioLite_files"; # Change this if you have renamed the default "ImageFolioLite_files" directory.
      my @webroot = ('', 'html', 'httpdocs', 'htdocs', 'www'); # If you have your "cgi-bin" located outside of your webroot then make sure your webroot directory is one listed. Default = ('', 'html', 'httpdocs', 'htdocs', 'www')
      foreach (@webroot) {
         &locate_ifdir($_);
         last if $base_if_url;
      }
      if (!$base_if_url) {
         print qq|Content-type: text/html\n\n<b> ImageFolio's zero config problem:</b><br><br>We could not locate the "$imagefolio_files_directory" directory on your server. There are two solutions:<br><br><b>1:</b> Change the value of <b>\$imagefolio_files_directory</b> in <b>pathsurls_config.pl</b> to match the correct name of the ImageFolio directory that contains the subdirectories <b>cache</b>, <b>gallery</b>, <b>if_images</b>, <b>temp</b>, etc.<br><br>or<br><br><b>2:</b> In your <b>pathsurls_config.pl</b> uncomment the 4 lines in the "MANUAL CONFIGURATION" and set them correctly.|;
         exit;
      }
   }
}
# scripts and databases
$imagefolio_url            = "$base_scripts_url/$currscript";
$admindir_directory        = $base_scripts_path . "/admin";
$config_directory          = $base_scripts_path . "/config";
$libpath                   = $base_scripts_path . "/if_lib";
$mainpath                  = $base_scripts_path . "/main";
$commercepath              = $base_scripts_path . "/commerce";
$db_link_path              = $libpath . "/db_link";
$cpanpath                  = $base_scripts_path . "/CPAN"; # Comprehensive Perl Archive Network (http://www.cpan.org/)
$lightbox_directory        = $base_if_path . "/lightbox";
$lightbox_url              = $base_if_url . "/lightbox";
$image_directory           = $base_if_path . "/" .$gallery_root;
$imageurl                  = $base_if_url . "/" .$gallery_root;
$data_directory            = $base_scripts_path . "/data"; # cannot be changed unless "data" replaced in this file and imageFolio.cgi, imageLeech.pl, imageZoomify.pl.
$leechdir                  = $data_directory . "/leech";
$logdir                    = $data_directory . "/logs";
$sessions_dir              = $data_directory . "/sessions";
$cache_directory           = $base_if_path . "/cache";
$cache_url                 = $base_if_url . "/cache";
$catdesc                   = $data_directory . "/catdesc.txt";
$indexfile                 = $data_directory . "/index.txt";
$catfile                   = $data_directory . "/categories.txt";
$disk_usage_file           = $data_directory . "/disk_usage.txt";
$tempdir                   = $base_if_path . "/temp";
$tempdirurl                = $base_if_url . "/temp";
$tempuploaddir             = $tempdir;
$base_skin_dir             = $base_if_path . "/skins";
$base_skin_url             = $base_if_url . "/skins";
$skin_dir                  = $base_skin_dir . "/" . $skin_name;
$skin_url                  = $base_skin_url . "/" . $skin_name;
$current_time              = time();
$image_cache_directory     = $cache_directory . "/images";
$image_cache_url           = $cache_url . "/images";
$new_imageurl              = $imageurl;
$imageurl                  = $imagefolio_url . "?main=imageLeech&source=IF&ct=$current_time&file=" if $antileech eq 1;

# file and directory locations for Post Cards ##########
$cards_directory     = "$base_if_path/postcards";
$cards_url           = "$base_if_url/postcards";
$midi_directory      = "$cards_directory/midi";
$midi_url            = "$cards_url/midi";
$post_db             = "$cards_directory/post.db";

###############################################################################
# LOCATE IF FILES
# Routine for finding the directory with the ImageFolio files
###############################################################################
sub locate_ifdir {
   my $html_httpdocs_htdocs_www = shift;
   $html_httpdocs_htdocs_www .= "/" if $html_httpdocs_htdocs_www;
   $base_scripts_path = $currdir;
   ($base_scripts_url) = $ENV{'SCRIPT_NAME'} =~ m#^(.*)\/#;
   $part_base_scripts_url = $base_scripts_url;
   $base_scripts_url = "http://$ENV{'HTTP_HOST'}$base_scripts_url";
   $base_if_path = $base_scripts_path;
   for($i=1;$i<=3;$i++){
      if ($base_scripts_path eq ".") {
         $base_if_path .= "/..";
      }
      else {
         ($base_if_path) = $base_if_path =~ m#^(.*)\/(.*)#;
      }
      if (-d "$base_if_path/${html_httpdocs_htdocs_www}$imagefolio_files_directory") {
         $backpath = $i;
         last;
      }
   }
   if ($backpath) {
      $base_if_url = $base_scripts_url;
      $part_base_if_url = $part_base_scripts_url;
      for($i=1;$i<=$backpath;$i++){
         ($base_if_url) = $base_if_url =~ /(.*)\/(.*$)/;
         ($part_base_if_url) = $part_base_if_url =~ /(.*)\/(.*$)/;
      }
      $base_if_url .= "/$imagefolio_files_directory";
      $part_base_if_url .= "/$imagefolio_files_directory";
      $base_if_path .= "/${html_httpdocs_htdocs_www}$imagefolio_files_directory";
   }
   elsif (!$ENV{'HTTP_USER_AGENT'}) {
      $base_if_url = 1;
      $base_if_path = $base_scripts_path;
      for($i=1;$i<=3;$i++){
         $base_if_path .= "/..";
         if (-d "$base_if_path/${html_httpdocs_htdocs_www}$imagefolio_files_directory") {
            $base_if_path .= "/${html_httpdocs_htdocs_www}$imagefolio_files_directory";
            last;
         }
      }
   }
}

if (!$pathsfile && $ENV{'HTTP_USER_AGENT'}) {
   open(PATHS,">$data_directory/config/paths.pl");
   print PATHS '$base_scripts_path      = "' . $base_scripts_path . "\";\n";
#   print PATHS '#$base_scripts_url       = "' . $base_scripts_url . "\";\n";
   print PATHS '$base_scripts_url       = "http://" . $ENV{"HTTP_HOST"} . "' . $part_base_scripts_url . "\";\n";
   print PATHS '$base_if_path           = "' . $base_if_path . "\";\n";
#   print PATHS '#$base_if_url            = "' . $base_if_url . "\";\n";
   print PATHS '$base_if_url            = "http://" . $ENV{"HTTP_HOST"} . "' . $part_base_if_url . "\";\n";
   print PATHS '$image_directory        = "' . $image_directory . "\";\n";
   print PATHS '$imageurl               = "' . $imageurl . "\";\n";
   print PATHS '$tempdir                = "' . $tempdir . "\";\n";
   print PATHS '$tempdirurl             = "' . $tempdirurl . "\";\n";
   print PATHS '$data_directory         = "' . $data_directory . "\";\n";
   print PATHS '$pathsfile              = ' . "1;\n";
   print PATHS "1;\n";
   close(PATHS);
   chmod(0777,"$data_directory/config/paths.pl");
}
1;