###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################
$DELETEFILES = "active";

###############################################################################
# STEP 1
# If we don't receive any information we display the list of categories
###############################################################################
sub remove_step_1 {

$pagetitle = "Delete Files - Select A Category";
&get_header;
&get_catlist;

print qq|

<form method=post action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="remove.pl">
<input type=hidden name=rmstep value=2>

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Select A Category</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 2</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>$catlist</td></tr></table></td></tr></table>

<br><input type=submit value="Select Files">

</center>

</form>
|;

&get_footer;
}

###############################################################################
# STEP 2
# Show the select box so the user can select an image for deletion
###############################################################################
sub remove_step_2 {

&get_imagelist;
$pagetitle = "Select Files for Deletion";
&get_header;

      $newcategory = $category;
      $newcategory =~ s/_/ /g;
      $newcategory =~ s/\// \&gt; /g;

print qq|

<form name="imageform" method=post action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="remove.pl">
<input type=hidden name=rmstep value=final>
<input type=hidden name=category value="$category">

<center>|;

   if ($image && $rmstep eq "final") {
      if (!$lastdeleted) {
         print qq|<$admin_font><b>Error:  Could not delete requested files, none selected.</b></font><br><br>|;
      }
      else {
         print qq|<$admin_font><b>The selected files have been successfully removed from 
         <font color=red>$newcategory</font></b></font><br><br>|;
      }
   }

print qq|

<table border="0" width="100%" cellspacing=0 cellpadding=4><tr><td>
<$admin_font><b>Instructions:</b>  Mark the checkbox next to each file you would like to delete.  
Click the &quot;Delete Files&quot; button below to delete all selected files.</font></td></tr></table><br>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td colspan=2>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Select Files for Deletion</b></font></td>
<td align=right><$admin_big_font><b>Step 2 of 2</b></font></td></tr></table>

<tr bgcolor="#ffffff"><td colspan=2>


<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_small_font>$newcategory</font></td>

<td align=right><$admin_small_font>$totalnames files found</font></td></tr></table>

</td></tr>

<tr bgcolor="#ffffff"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=0>

<tr><td align=center>

<table border=0 cellspacing=1 cellpadding=3 width="100%">
<tr bgcolor="#999999"><td>&nbsp;</td>
<td><$admin_font color="#ffffff"><b>Filename</b></font></td>
<td><$admin_font color="#ffffff"><b>Filesize</b></font></td>
<td><$admin_font color="#ffffff"><b>Last Modified</b></font></td>
</tr>

$imagelist

</table>


</td></tr>

</table>

</td></tr></table></td></tr></table>

<br><input type=submit value="Delete Files"><br><br>

</center>
</form>
</body>
</html>
|;

&get_footer;
}

###############################################################################
# FINAL
# We delete the files from the database then display step 2 again
###############################################################################
sub remove_final {

   if ($image) {
      @images = split (/,/, $image);

      unless ($admin_demo_mode) {
         foreach $deletable (@images) {
            unlink("$image_directory/$category/$deletable") or &Error ("Could not remove selected file(s).  Reason: $!");
            $lastdeleted = 1;
         }
      }
   }
&remove_step_2;
}

###############################################################################
# GET IMAGELIST
# We read the directory selected in step one and pull out all of the images
# in the directory and create a selection form
###############################################################################
sub get_imagelist {

$totalnames = 0;
if ($image eq $file) { $selected = " selected"; }
else { $selected = ""; }

opendir(IMAGEDIR,"$image_directory/$category") or &Error ("Could not read directory, $image_directory/$category. Reason: $!");

@files = readdir(IMAGEDIR);
@files = sort { lc($a) cmp lc($b) } @files;
@names = ();

   foreach $file (@files) {
      if ( -d "$image_directory/$category/$file" ) {
         # do nothing
      }
      else{
         ($filesize, $filedate) = (stat("$image_directory/$category/$file"))[7,9];
         if ($filesize < 1500) { $filesize = commify($filesize) . " bytes"; }
         else { $filesize = int($filesize/1000) . " Kb"; }
         $filedate = unix_to_date($filedate); 

         $imagelist .= qq|
         <tr bgcolor="#dddddd"><td width=1><input type=checkbox name="image" value="$file"></td>
         <td bgcolor="#eeeeee" width="40%"><$admin_font><b><a href="$imageurl/$category/$file" target="_blank">$file</a></b></font></td>
         <td width="30%"><$admin_font>$filesize</font></td>
         <td width="30%"><$admin_font>$filedate</font></td>
         </tr>
         |;

         $totalnames++;
      }
   }

closedir(IMAGEDIR);

unless ($totalnames >= 1) { &Error ("The category '$category' does not contain any images."); }

}

1;
