###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################
$ADDFILEDESCRIPTIONS = "active";

###############################################################################
# STEP 1
# If we don't receive any information we display the list of categories
###############################################################################
sub keywords_step_1 {

$pagetitle = "Add Keywords and Captions to Images - Select A Category";
&get_header;
&get_catlist;

print qq|

<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="keywords.pl">
<input type=hidden name=kwstep value=2>

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Select A Category</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 3</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>$catlist</td></tr></table></td></tr></table>

<br><input type=submit value="Select An Image">

</center>

</form>
|;

&get_footer;
}

###############################################################################
# STEP 2
# If we don't receive any information we display the list of categories
###############################################################################
sub keywords_step_2 {

&get_imagelist;
$pagetitle = "Select An Image";
&get_header;

      $newcategory = $category;
      $newcategory =~ s/_/ /g;
      $newcategory =~ s/\// \&gt; /g;

   if ($image) { $imagesource = "$imageurl/$category/$image"; }
   else { $imagesource = $if_images_directory . "/image_viewer.gif"; }

print qq|

<SCRIPT LANGUAGE="JavaScript"><!--
   function imgchange() {
      var si =  document.imageform.image.selectedIndex;
      var fname = document.imageform.image.options[si].value
      var directory = '$imageurl/$category';
      document.myimg.src = directory + '/' + fname}
//--></SCRIPT>

<form name="imageform" method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="keywords.pl">
<input type=hidden name=kwstep value=3>
<input type=hidden name=category value="$category">

<center>|;

   if ($keywords && $kwstep eq "final") {
      if (!$imagefound) {
         print qq|<$admin_font><b>Error:  Could not save Keywords to
         <font color=red>$image ($newcategory)</font></b></font><br><br>|;
      }
      else {
         print qq|<$admin_font><b>Keywords and Caption saved successfully for
         <font color=red>$image ($newcategory)</font></b></font><br><br>|;
      }
   }

print qq|

<table border="0" width="100%" cellspacing=0 cellpadding=4><tr><td>
<$admin_font><b>Instructions:</b>  Select an image from the select box.  If you would
like to view the image, click &quot;View This Image.&quot;  To add or modify the selected image's Keywords and Caption,
click &quot;Add Keywords and Caption&quot;</font></td></tr></table><br>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>

<tr bgcolor="#ffcc00"><td colspan=2>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Select An Image</b></font></td>
<td align=right><$admin_big_font><b>Step 2 of 3</b></font></td></tr></table>
</td></tr>

<tr bgcolor="#ffffff"><td colspan=2>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_small_font>$newcategory</font></td>
<td align=right><$admin_small_font>$totalnames found</font></td></tr></table>
</td></tr>


<tr bgcolor="#eeeeee"><td width="50%" align=center>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td align=center>$imagelist</td></tr>
<tr><td align=center><INPUT type="button" value="View This Image" onClick="imgchange()"></td></tr>
</table>

</td><td width="50%" align=center valign=middle><IMG SRC="$imagesource" NAME="myimg" alt=".."></td></tr>

</table></td></tr></table>

<br><input type=submit value="Add Keywords and Caption"><br><br>

</center>
</form>
</body>
</html>
|;

&get_footer;
}

###############################################################################
# STEP 3
# We display a form for adding/modifying keywords
###############################################################################
sub keywords_step_3 {

$pagetitle = "Add or Modify Keywords and Caption";
&get_header;
&get_keyform;
&get_image_info;

      $newcategory = $category;
      $newcategory =~ s/_/ /g;
      $newcategory =~ s/\// \&gt; /g;


print qq|

<form method=post action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="keywords.pl">
<input type=hidden name=kwstep value="final">
<input type=hidden name=category value="$category">
<input type=hidden name=image value="$image">

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=4><tr><td>
<$admin_font><b>Instructions:</b>  Add or modify keywords and image caption in the
text area below then click &quot;Save Keywords and Caption&quot;  Be sure to separate each keyword
with a space only, NOT a comma or separate line.</font></td></tr></table><br>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>

<tr bgcolor="#ffcc00"><td colspan=2>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><font face="Arial,Helvetica"><b>Add or Modify Keywords and Caption</b></font></td>
<td align=right><font face="Arial,Helvetica"><b>Step 3 of 3</b></font></td></tr></table>
</td></tr>

<tr bgcolor="#ffffff"><td colspan=2>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_small_font>$newcategory</font></td></tr></table>
</td></tr>

<tr bgcolor="#eeeeee"><td width="50%" align=center>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td align=center>$keyform</td></tr></table>

</td><td width="50%" align=center valign=top><br>

<table border=1 cellspacing=1 cellpadding=4>
<tr bgcolor="#000000"><td valign=top align=center><img src="$imageurl/$category/$image" alt="$thisimage" border=0></td></tr>
<tr bgcolor="#ffffff"><td valign=top nowrap><$font><b>$thisimage</b><br>$file_type
<br>Size: $filesize<br>Added: $filedate<br></font></td></tr></table>

</td></tr></table></td></tr></table>

<br><input type=submit value="Save Keywords and Caption"><br><br>

</center>
</form>
|;

&get_footer;
}

###############################################################################
# FINAL
# We save the Keywords to the database then display step 2 again
###############################################################################
sub keywords_final {

   $keywords =~ s/,/ /g;                # Change commas to spaces
   $keywords =~ s/^\s+//g;              # Trim leading blanks...
   $keywords =~ s/\s+$//g;              # Trim trailing blanks...
   $keywords =~ s/\n/ /g;               # Change newline to a space.
   $keywords =~ s/\r//g;                # Remove Windows linefeed character.
   $keywords =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $keywords =~ s/\s+\s+/ /g;           # Change two spaces to one again.

   $icaption =~ s/^\s+//g;              # Trim leading blanks...
   $icaption =~ s/\s+$//g;              # Trim trailing blanks...
   $icaption =~ s/\n/ /g;               # Change newline to a space.
   $icaption =~ s/\r//g;                # Remove Windows linefeed character.
   $icaption =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $icaption =~ s/\s+\s+/ /g;           # Change two spaces to one again.

   $tcaption =~ s/^\s+//g;              # Trim leading blanks...
   $tcaption =~ s/\s+$//g;              # Trim trailing blanks...
   $tcaption =~ s/\n/ /g;               # Change newline to a space.
   $tcaption =~ s/\r//g;                # Remove Windows linefeed character.
   $tcaption =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $tcaption =~ s/\s+\s+/ /g;           # Change two spaces to one again.

   $newcategory = $category;
   $newcategory =~ s/\//\./g;           # Generate filename for our captions file
   $newimage = $image;
   $newimage =~ s/$mypattern//g;        # Get full-size image name for use in captions

# FIRST, WE WRITE THE KEYWORDS TO THE INDEX FILE

open (FILE,"$indexfile") or &Error ("Could not open $indexfile, is it created.  Reason: $!");
my(@LINES)=<FILE>;
close(FILE);
$SIZE=@LINES;

# Open Link File to Output
open (INDEX,">$indexfile") or &Error ("Could not open $indexfile, is it created.  Reason: $!");
if ($useflock) { flock(INDEX, 2); }

   for ($i=0;$i<=$SIZE;$i++) {
      $_=$LINES[$i];
      my ($filename, $path, $blah, $blah, $blah) = split(/\|/, $_);

      if ($filename eq $image && $path eq $category) {
         $imagefound = 1;
         print INDEX "$filename\|$path\|\|\|$keywords\n";
      }
      else {
         print INDEX $_;
      }
   }

if ($useflock) { flock(INDEX, 8); }
close(INDEX);


# SECOND, WE WRITE THE FULL-SIZE IMAGE CAPTION TO A FILE

open (FILE,"$data_directory/$newcategory.captions.txt") or &Error ("Could not read captions file, $newcategory.captions.txt.  Reason: $!");
my(@LINES)=<FILE>;
close(FILE);
$SIZE=@LINES;

# Open Link File to Output
open (INDEX,">$data_directory/$newcategory.captions.txt") or &Error ("Could not read captions file, $newcategory.captions.txt.  Reason: $!");
if ($useflock) { flock(INDEX, 2); }

   for ($i=0;$i<=$SIZE;$i++) {
      $_=$LINES[$i];
      my ($filename, $caption) = split(/\t/, $_);

      if ($filename eq $newimage) {
         $keyfound = 1;
         print INDEX $filename . "\t" . $icaption . "\n";
      }
      else {
         print INDEX $_;
      }
   }

if (!$keyfound) { print INDEX $newimage . "\t" . $icaption . "\n"; }

if ($useflock) { flock(INDEX, 8); }
close(INDEX);

$keyfound = 0;

# THIRD, WE WRITE THE THUMBNAIL IMAGE CAPTION TO A FILE

open (FILE,"$data_directory/$newcategory.tcaptions.txt") or &Error ("Could not read captions file, $newcategory.tcaptions.txt.  Reason: $!");
my(@LINES)=<FILE>;
close(FILE);
$SIZE=@LINES;

# Open Link File to Output
open (INDEX,">$data_directory/$newcategory.tcaptions.txt") or &Error ("Could not read captions file, $newcategory.tcaptions.txt.  Reason: $!");
if ($useflock) { flock(INDEX, 2); }

   for ($i=0;$i<=$SIZE;$i++) {
      $_=$LINES[$i];
      my ($filename, $caption) = split(/\t/, $_);

      if ($filename eq $newimage) {
         $keyfound = 1;
         print INDEX $filename . "\t" . $tcaption . "\n";
      }
      else {
         print INDEX $_;
      }
   }

if (!$keyfound) { print INDEX $newimage . "\t" . $tcaption . "\n"; }

if ($useflock) { flock(INDEX, 8); }
close(INDEX);

&keywords_step_2;

}

###############################################################################
# GET KEYFORM
# We read through the image index, find a matching file then build a form
# from which to add/modify keywords
###############################################################################
sub get_keyform {
open (FILE,"$indexfile") or &Error ("Could not read index, $indexfile.  Reason: $!");
my(@LINES)=<FILE>;
close(FILE);
$SIZE=@LINES;

$keyform .= qq|<table border=0 cellspacing=0 cellpadding=4 width="100%">
<tr><td><$admin_small_font><b>K E Y W O R D S</b> (This is the old ImageFolio keywords system. Please use IPTC instead)</font></td></tr>|;

   foreach $LINE (@LINES) {
      ($filename, $path, $blah, $blah, $words) = split(/\|/, $LINE);
      if ($filename eq $image && $path eq $category) {
         $keyform .= qq|<tr><td><textarea name="keywords" cols=40 rows=4 wrap=virtual>$words</textarea></td></tr>|;
         $keyfilefound = 1;
         last;
      }
   }

   if (!$keyfilefound) {
      $keyform = qq|<tr><td><$admin_font color=red><b>Error:</b> 
      The entry for $image was not found in the Image Index (index.txt).  Please rebuild the Image
      Index using build.cgi</font></td></tr>|; 
   }


$keyform .=qq|<tr><td><$admin_small_font><b>C A P T I O N</b> (This is the old ImageFolio caption system. Please use IPTC instead)</font></td></tr>
<tr><td><textarea name="icaption" cols=40 rows=4 wrap=virtual>|;

      $newcategory = $category;
      $newcategory =~ s/\//\./g;
      $newimage = $image;
      $newimage =~ s/$mypattern//g;                        # remove the pattern

   if (-e "$data_directory/$newcategory.captions.txt"){
      open (CAPTIONS,"$data_directory/$newcategory.captions.txt");
      my(@LINES)=<CAPTIONS>;
      close(CAPTIONS);

      foreach $line (@LINES) {
         my($filename, $caption) = split(/\t/,$line);
         if ($filename eq $newimage) {
            $keyform .= $caption;
            last;
         }
      }
   }
   else { # if we didn't find a captions.txt file above, we make one here
      opendir(IMAGEDIR,"$image_directory/$category") or &Error ("Could not read directory, $image_directory/$category.  Reason: $!");
      @files = readdir(IMAGEDIR);
      @files = sort { lc($a) cmp lc($b) } @files;                 # sort the file names alphabetically

      foreach $file (@files) {
         if ( -d "$image_directory/$category/$file" ) {            # if this is a directory we aren't doing anything
           # do nothing
         }
         else{
            if ( -B "$image_directory/$category/$file" && $file =~ /$mypattern/i ) {            # if this is a thumbnail and binary file
               $newfile = $file;
               $newfile =~ s/$mypattern//g;                        # remove the pattern
               $captionslist .= $newfile . "\t" . "\n";            # create captions list so we can print it below
            }
         }
      }

     closedir(IMAGEDIR);

      open (INDEX,">$data_directory/$newcategory.captions.txt") or &Error ("Unable to create captions.txt file.  Reason: $!");
      print INDEX $captionslist;
      close(INDEX);
      chmod(0777,"$data_directory/$newcategory.captions.txt");
   }

$keyform .= qq|</textarea></td></tr>|;

# THIS IS THE NEW SECTION FOR ADDING THUMBNAIL CAPTIONS

$keyform .=qq|<tr><td><$admin_small_font><b>T H U M B&nbsp;&nbsp;&nbsp;C A P T I O N</b> (This is the old ImageFolio keywords system. Please use IPTC instead)</font></td></tr>
<tr><td><textarea name="tcaption" cols=40 rows=4 wrap=virtual>|;

   if (-e "$data_directory/$newcategory.tcaptions.txt"){
      open (CAPTIONS,"$data_directory/$newcategory.tcaptions.txt");
      my(@LINES)=<CAPTIONS>;
      close(CAPTIONS);

      foreach $line (@LINES) {
         my($filename, $caption) = split(/\t/,$line);
         if ($filename eq $newimage) {
            $keyform .= $caption;
            last;
         }
      }
   }
   else { # if we didn't find a captions.txt file above, we make one here
      open (INDEX,">$data_directory/$newcategory.tcaptions.txt") or &Error ("Unable to create tcaptions.txt file.  Reason: $!");
      print INDEX $captionslist;
      close(INDEX);
      chmod(0777,"$data_directory/$newcategory.tcaptions.txt");
   }

$keyform .= qq|</textarea></td></tr>|;

# END OF NEW SECTION


$keyform .= qq|</table>|;

}

###############################################################################
# GET IMAGELIST
# We read the directory selected in step one and pull out all of the images
# in the directory and create a selection form
###############################################################################
sub get_imagelist {

$totalnames = 0;
if ($image eq $file) { $selected = " selected"; }
else { $selected = ""; }

opendir(IMAGEDIR,"$image_directory/$category") or &Error ("Could not read directory, $image_directory/$category. Reason: $!");

$imagelist .= qq|<select name="image" size="8">|;

@files = readdir(IMAGEDIR);
@files = sort { lc($a) cmp lc($b) } @files;                     # sort the file names alphabetically

@names = ();                                                    # declare the thumbnails array

   foreach $file (@files) {
      if ( -d "$image_directory/$category/$file" ) {            # if this is a directory we aren't doing anything
         # do nothing
      }
      else{
         if ( -B "$image_directory/$category/$file" && $file =~ /$mypattern/i ) {            # if this is a thumbnail and binary file
            $newfile = $file;
            $newfile =~ s/$mypattern//g;                        # remove the pattern
               if ($image eq $file) { $selected = " selected"; }
               else { $selected = ""; }
            $imagelist .= qq|<option value="$file"$selected>$newfile|;   # create our options for the select form
            $totalnames++;                                               # count all of the thumnails found
         }
      }
   }

closedir(IMAGEDIR);

$imagelist .= qq|</select>|;

unless ($totalnames >= 1) { &Error ("The category '$category' does not contain any images."); }

}

1;
