###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################
$DISKUSAGE = "active";

###############################################################################
# DISK USAGE
# Reports for displaying disk usage by category and total disk usage
###############################################################################

sub disk_usage {
   my $admin_ouptut;
   my $admin_title = "Disk Usage";

   if (-e $disk_usage_file) {
      ($dufiledate) = unix_to_date((stat("$disk_usage_file"))[9]);
      $dufiledate = qq{Generated On $dufiledate};
      
      open (FILE,"$disk_usage_file");
      my(@Usage)=<FILE>;
      close(FILE);


      foreach $Usage (@Usage) {
         chomp $Usage;
         my ($UsageKb, $IFCategory) = split(/\t/, $Usage);  
         $UsageBytes = $UsageKb * 1024;
         $UsageMb = $UsageBytes / 1048576;
         $UsageMb = sprintf("%.2f", $UsageMb);


         if ($bgcolortd eq "#dddddd") {
            $bgcolortd = "#eeeeee";
         }
         else {
            $bgcolortd = "#dddddd";
         }
         
         
         $CatLink = qq|<a href="$imagefolio_url?direct=$IFCategory" target="_blank">|;
      
         if ($IFCategory =~ /^Total/) {
            $UsageMb = "<b>$UsageMb MB</b>";
            $IFCategory = "<b>TOTAL DISK USAGE</b>";
            $CatLink = "";
            $bgcolortd = "#666666";
            $totalcolor = qq| color="#ffffff"|;
         }

         $usage_output .= qq{
         <tr>
           <td align=left width="100%" bgcolor="$bgcolortd"><$fe_admin_small_font$totalcolor>$CatLink$IFCategory</a></font></td>
           <td align=right bgcolor="$bgcolortd" nowrap><$fe_admin_small_font$totalcolor>$UsageMb</font></td>
         </tr>
         };
       
      }
   }
   
   if (!$usage_output) {
      $usage_output = qq{
      <tr>
        <td colspan=2 bgcolor="#ffffff"><$fe_admin_small_font>No data available.</font></td>
      </tr>
      };
   }
   
   $output = qq{
      <table width="100%" cellpadding="5" cellspacing="0" border="0">
         <tr>
           <td align="left" bgcolor="#666666"><$fe_admin_small_font color="#ffffff"><b>CATEGORY</b></font></td>
           <td align=right nowrap bgcolor="#666666"><$fe_admin_small_font color="#ffffff"><b>USAGE (MB)</b></font></td>
         </tr>$usage_output
      </table>
   };



&get_header;

print qq|
<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000"><tr><td>
<table border="0" width="100%" cellspacing=1 cellpadding=0>

<tr bgcolor="#ffcc00"><td>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Disk Usage</b></font></td>
<td align=right><$admin_big_font><b>$dufiledate</b></font></td> </tr></table></td></tr>

<tr><td>


$output

</td></tr></table></td></tr></table>

|;

&get_footer;

}


1;