###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################

###############################################################################
# MODIFY USER
# Shows the modify a user form
###############################################################################
sub modify_user {

$MODIFYADMIN = "active";

if ($userstep eq "2") { &modify_user_step2; }
elsif ($userstep eq "final") { &modify_user_final; }
else {
$pagetitle = "Modify Admin - Select Admin";
&get_header;
&get_user_list;

print qq|$comment

<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="admin_user.pl">
<input type=hidden name=useraction value="modify">
<input type=hidden name=userstep value=2>

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Select Admin</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 2</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>$userlist</td></tr></table></td></tr></table>

<br><input type=submit value="Modify Admin">

</center>

</form>
|;

&get_footer;
}
}

###############################################################################
# MODIFY USER STEP 2
# Shows a form to modify a single user's information
###############################################################################
sub modify_user_step2 {

$pagetitle = "Modify Admin";
&get_header;
&get_user;

if ($admin_demo_mode) {
   $iffirstname = "**********";
   $iflastname = "**********";
   $ifemail = "**********";
   $ifusername = "**********";
   $decryptpassword = "**********";
}

print qq|
<form method=post action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="admin_user.pl">
<input type=hidden name=useraction value="modify">
<input type=hidden name=userstep value=final>
<input type=hidden name=ifuser value="$ifuser">

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Modify Admin</b></font></td>
<td align=right><$admin_big_font><b>Step 2 of 2</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>

<br><$admin_small_font><b>A D M I N&nbsp;&nbsp;&nbsp;I D E N T I T Y</b></font><br><br>

<table border=0 cellspacing=0 cellpadding=0 bgcolor="#000000" width=400><tr><td align=center>
<table border=0 cellspacing=1 cellpadding=4 width="100%">

<tr bgcolor="#dddddd"><td align=left><$admin_font><b>First Name</b></font></td><td align=left><input type=text size=35 name=iffirstname value="$iffirstname"></td></tr>
<tr bgcolor="#dddddd"><td align=left><$admin_font><b>Last Name</b></font></td><td align=left><input type=text size=35 name=iflastname value="$iflastname"></td></tr>
<tr bgcolor="#dddddd"><td align=left><$admin_font><b>Email</b></font></td><td align=left><input type=text size=35 name=ifemail value="$ifemail"></td></tr>
<tr bgcolor="#dddddd"><td align=left><$admin_font><b>Username</b></font></td><td align=left><input type=text size=35 name=ifusername value="$ifusername"></td></tr>
<tr bgcolor="#dddddd"><td align=left><$admin_font><b>Password</b></font></td><td align=left><input type=text size=35 name=ifpassword value="$decryptpassword"></td></tr>

</table></td></tr></table>

<br><$admin_small_font><b>A D M I N&nbsp;&nbsp;&nbsp;P E R M I S S I O N S</b></font><br><br>

<table border=0 cellspacing=0 cellpadding=0 width="450" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%" align=left><$admin_font color="#ffffff"><b>Allow this administrator to...</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Yes</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>No</b></font></td></tr>

<tr bgcolor="#dddddd">
<td align=left><$admin_font><b>Add IPTC File Info</b> ?</font></td>|;

if ($ifdesc_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifdesc_per" value=Yes checked></td>
<td align=center><input type=radio name="ifdesc_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifdesc_per" value=Yes></td>
<td align=center><input type=radio name="ifdesc_per" value=No checked></td>|;
}

print qq|</tr>

<tr bgcolor="#ffffff">
<td align=left><$admin_font><b>Upload Media</b> ?</font></td>|;

if ($ifupload_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifupload_per" value=Yes checked></td>
<td align=center><input type=radio name="ifupload_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifupload_per" value=Yes></td>
<td align=center><input type=radio name="ifupload_per" value=No checked></td>|;
}

print qq|</tr>

<tr bgcolor="#dddddd">
<td align=left><$admin_font><b>Add Categories</b> ?</font></td>|;

if ($ifaddcat_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifaddcat_per" value=Yes checked></td>
<td align=center><input type=radio name="ifaddcat_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifaddcat_per" value=Yes></td>
<td align=center><input type=radio name="ifaddcat_per" value=No checked></td>|;
}

print qq|</tr>

<tr bgcolor="#ffffff">
<td align=left><$admin_font><b>Rename Categories</b> ?</font></td>|;

if ($ifrencat_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifrencat_per" value=Yes checked></td>
<td align=center><input type=radio name="ifrencat_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifrencat_per" value=Yes></td>
<td align=center><input type=radio name="ifrencat_per" value=No checked></td>|;
}

print qq|</tr>

<tr bgcolor="#dddddd">
<td align=left><$admin_font><b>Delete Categories</b> ?</font></td>|;

if ($ifdelcat_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifdelcat_per" value=Yes checked></td>
<td align=center><input type=radio name="ifdelcat_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifdelcat_per" value=Yes></td>
<td align=center><input type=radio name="ifdelcat_per" value=No checked></td>|;
}

print qq|</tr>

<tr bgcolor="#ffffff">
<td align=left><$admin_font><b>Rebuild the Database/Index</b> ?</font></td>|;

if ($ifbuild_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifbuild_per" value=Yes checked></td>
<td align=center><input type=radio name="ifbuild_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifbuild_per" value=Yes></td>
<td align=center><input type=radio name="ifbuild_per" value=No checked></td>|;
}


print qq|</tr>

<tr bgcolor="#dddddd">
<td align=left><$admin_font><b>Add New Administrators/Groups/Users</b> ?</font></td>|;

if ($ifaddusr_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifaddusr_per" value=Yes checked></td>
<td align=center><input type=radio name="ifaddusr_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifaddusr_per" value=Yes></td>
<td align=center><input type=radio name="ifaddusr_per" value=No checked></td>|;
}


print qq|</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Modify Other Administrators/Groups/Users</b> ?</font></td>|;

if ($ifmodusr_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifmodusr_per" value=Yes checked></td>
<td align=center><input type=radio name="ifmodusr_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifmodusr_per" value=Yes></td>
<td align=center><input type=radio name="ifmodusr_per" value=No checked></td>|;
}


print qq|</tr>

<tr bgcolor="#dddddd">
<td nowrap align=left><$admin_font><b>Delete Other Administrators/Groups/Users</b> ?</font></td>|;

if ($ifdelusr_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifdelusr_per" value=Yes checked></td>
<td align=center><input type=radio name="ifdelusr_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifdelusr_per" value=Yes></td>
<td align=center><input type=radio name="ifdelusr_per" value=No checked></td>|;
}

print qq|</tr></table></td></tr></table><br><br>


<table border=0 cellspacing=0 cellpadding=0 width="450" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%" align=left><$admin_font color="#ffffff"><b>Use demontration/tutorial mode ?</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Yes</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>No</b></font></td></tr>

<tr bgcolor="#ffffff">
<td align=left><$admin_font>If set to &quot;Yes&quot; then this administrator has access to all functions above, 
but no changes are saved. Useful for showing colleagues/friends or educating employees.</font></td>|;

if ($ifdemo_per eq "Yes") {
print qq|<td align=center><input type=radio name="ifdemo_per" value=Yes checked></td>
<td align=center><input type=radio name="ifdemo_per" value=No></td>|;
}
else {
print qq|<td align=center><input type=radio name="ifdemo_per" value=Yes></td>
<td align=center><input type=radio name="ifdemo_per" value=No checked></td>|;
}


print qq|</tr>

</table></td></tr></table><br>


<input type=submit value="Modify Admin">&nbsp;<input type=reset value="Cancel"><br><br>


</td></tr></table></td></tr></table>


</center>
</form>
|;

&get_footer;
}

###############################################################################
# MODIFY USER FINAL
# Modifies a user's information in the database
###############################################################################
sub modify_user_final {
&get_user;

   if    (!$FORM{'ifusername'})       { print &Error('You must enter a Username.');                      exit; }
   elsif (!$FORM{'ifemail'})          { print &Error('You must enter your Email Address.');              exit; }
   elsif (!$FORM{'ifpassword'})       { print &Error('You must enter a Password.');                      exit; }
   elsif ($plength < 6)               { print &Error('Your Password must be at least six characters.');  exit; }
   elsif ($llength < 5)               { print &Error('Your Username must be at least five characters.'); exit; }
   elsif (!$FORM{'iffirstname'})      { print &Error('You must enter your First Name.');                 exit; }
   elsif (!$FORM{'iflastname'})       { print &Error('You must enter your Last Name.');                  exit; }

   require "$libpath/crypt.pl";
   $newpass = &admin_encrypt($FORM{'ifpassword'}, $secret_key);

   unless ($admin_demo_mode) {
      open (ADMINDB,">$admindb") or print &Error('Could not open the admin database!');
      if ($useflock) { flock(ADMINDB, 2); }
      print ADMINDB "$database";   # print the existing database minus this user, then the user
      print ADMINDB "$FORM{'ifusername'}\|$newpass\|$ifuser\|$FORM{'ifemail'}\|";
      print ADMINDB "$FORM{'iffirstname'}\|$FORM{'iflastname'}\|$FORM{'ifdesc_per'}\|$FORM{'ifupload_per'}\|";
      print ADMINDB "$FORM{'ifaddcat_per'}\|$FORM{'ifrencat_per'}\|$FORM{'ifdelcat_per'}\|$FORM{'ifbuild_per'}\|";
      print ADMINDB "$FORM{'ifaddusr_per'}\|$FORM{'ifmodusr_per'}\|$FORM{'ifdelusr_per'}\|$FORM{'ifdemo_per'}\n";
      if ($useflock) { flock(ADMINDB, 8); }
      close(ADMINDB);
   }

$comment = qq|<$admin_font><b>The administrator <font color=red>$FORM{'ifusername'}</font> has been modified.<b></font><br><br>|;
$userstep = "";
&modify_user;
}

###############################################################################
# DELETE USER
# Opens the user database and builds a select box of all users
###############################################################################
sub delete_user {

$DELETEADMIN = "active";

if ($userstep eq "final" && $ifuser) {
   &get_user;
   unless ($admin_demo_mode) {
      open (ADMINDB,">$admindb") or print &Error('Could not open the admin database!');
      if ($useflock) { flock(ADMINDB, 2); }
      print ADMINDB "$database";
      if ($useflock) { flock(ADMINDB, 8); }
      close(ADMINDB);
   }
   $comment = qq|<$admin_font><b>The administrator <font color=red>$ifusername</font> has been deleted.<b></font><br><br>|;
}

$pagetitle = "Delete Admin - Select Admin";
&get_header;
&get_user_list;

print qq|$comment

<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="admin_user.pl">
<input type=hidden name=useraction value="delete">
<input type=hidden name=userstep value=final>

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Delete Admin</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 1</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>$userlist</td></tr></table></td></tr></table>

<br><input type=submit value="Delete Admin">

</center>

</form>
|;

&get_footer;
}

###############################################################################
# GET USER LIST
# Opens the user database and builds a select box of all users
###############################################################################
sub get_user {

   if ($useraction eq "modify" && $userstep eq "final") {
      $FORM{'ifusername'} =~ s/ //g;
      $plength = length($FORM{'ifpassword'});
      $llength = length($FORM{'ifusername'});
   }

   open (ADMINDB, "$admindb");
      while (<ADMINDB>) {
         chomp;
         /^#/      and next;        # Skip comment Lines.
         /^\s*$/   and next;        # Skip blank lines.
         $row=$_;
         @user = split(/\|/,$row);

         if ($user[2] eq $ifuser) {
            $ifusername   = $user[0];    $ifpassword   = $user[1];
            $ifusernum    = $user[2];    $ifemail      = $user[3];
            $iffirstname  = $user[4];    $iflastname   = $user[5];
            $ifdesc_per   = $user[6];    $ifupload_per = $user[7];
            $ifaddcat_per = $user[8];    $ifrencat_per = $user[9];
            $ifdelcat_per = $user[10];   $ifbuild_per  = $user[11];
            $ifaddusr_per = $user[12];   $ifmodusr_per = $user[13];
            $ifdelusr_per = $user[14];   $ifdemo_per   = $user[15];
            require "$libpath/crypt.pl";
            $decryptpassword = &admin_decrypt($ifpassword, $secret_key);
         }
         elsif ($userstep eq "final") {
            if ($useraction eq "modify" && lc($user[0]) eq lc($FORM{'ifusername'})) {
               print &Error('The Username you requested is already in use by another administrator.');
               exit;
            }
            $database .= "$user[0]\|$user[1]\|$user[2]\|$user[3]\|$user[4]\|";
            $database .= "$user[5]\|$user[6]\|$user[7]\|$user[8]\|$user[9]\|";
            $database .= "$user[10]\|$user[11]\|$user[12]\|$user[13]\|$user[14]\|$user[15]\n";
         }
      }
   close (ADMINDB);
   $decryptpassword = "**********" if $admin_demo_mode;
}

###############################################################################
# GET USER LIST
# Opens the user database and builds a select box of all users
###############################################################################
sub get_user_list {
   $userlist = qq|<select name="ifuser" size=8>|;

   open (ADMINDB, "$admindb");
      while (<ADMINDB>) {
         chomp;
         /^#/      and next;        # Skip comment Lines.
         /^\s*$/   and next;        # Skip blank lines.
         push(@rows, $_);
      }
   close (ADMINDB);

@rows = sort { lc($a) cmp lc($b) } @rows;

foreach $users (@rows) {
   @user = split(/\|/,$users);
   if ($admin_demo_mode) {
      $userlist .= qq|<option value="$user[2]">($user[0]) -  ********** **********|;
   }
   else {
      $userlist .= qq|<option value="$user[2]">($user[0]) -  $user[4] $user[5]|;
   }
}

   $userlist .= qq|</select>|;
}

1;
