###############################################################################
# BizDesign ImageFolio Lite Edition 4.2 (Four-dot-Two)
###############################################################################
#
#          ##          ###        VERSION       :  4.2
#        ####        ##   ##      RELEASED ON   :  02/15/2007
#      ##  ##              ##     LAST MODIFIED :  02/15/2007
#    ##########          ##       
#          ##   ###    ##         
#          ##   ###  ########     
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/support/
# Phone      :  (214) 642-9787
# Email      :  sales@bizdesign.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2007 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################


require "$currdir/admin/init.pl";
if ($using_multiuser_mod) {
   require "$config_directory/users_config.pl";
}
&get_session;
&check_file;
&top;

###############################################################################
# TOP
# Determines what to do
###############################################################################
sub top {
   $| = 1;   # flush output

   &load_values;

   if ($FORM{'login'}) {
      &admin_login;
   }
   elsif ($FORM{'logout'}) {
     &logout;
      print "Location:$imagefolio_url\n\n";
   }
   elsif (!$is_admin or $FORM{'dologin'}) {
     &logout;
     &admin_login;
     &login;
   }
   else {
      &admin_login unless $cgi eq "admin_user_setup.pl";
      &main;
   }
   exit;
}

sub admin_login {
   require "$admindir_directory/login.pl";

}
###############################################################################
# START URL
###############################################################################
sub start_url {
   if ($FORM{'start'}) {
      require "$libpath/crypt.pl";
      $start_url = &admin_decrypt($FORM{'start'}, $secret_key);
      $start_url = qq|
      <SCRIPT LANGUAGE="JavaScript"><!--
      location.href = "$start_url";
      // --></SCRIPT>
      |;
   }
}

###############################################################################
# MAIN
# Determines what to do
###############################################################################
sub main {
   &start_url;
   if ($cgi eq "keywords.pl")                { require "$admindir_directory/keywords.pl";
      if    ($kwstep eq "2")                 { &keywords_step_2; }
      elsif ($kwstep eq "3")                 { &keywords_step_3; }
      elsif ($kwstep eq "final")             { &keywords_final;  }
      else                                   { &keywords_step_1; }
   }
   elsif ($cgi eq "iptc_keywords.pl")        { require "$admindir_directory/iptc_keywords.pl";
      if    ($kwstep eq "2")                 { &keywords_step_2; }
      elsif ($kwstep eq "3")                 { &keywords_step_3; }
      elsif ($kwstep eq "final")             { &keywords_final;  }
      else                                   { &keywords_step_1; }
   }
   elsif ($cgi eq "remove.pl")               { require "$admindir_directory/remove.pl";
      if    ($rmstep eq "2")                 { &remove_step_2; }
      elsif ($rmstep eq "final")             { &remove_final;  }
      else                                   { &remove_step_1; }
   }
   elsif ($cgi eq "admin_user_setup.pl")     { require "$admindir_directory/admin_user_setup.pl";
      if    ($newaction eq "adduser")        { &step_two; }
      else                                   { &step_one; }
   }
   elsif ($cgi eq "gallery_group_setup.pl")  { require "$admindir_directory/gallery_group_setup.pl";
      if    ($newaction eq "addgroup")       { &step_two; }
      elsif ($newaction eq "updategroup")    { &step_two; }
      else                                   { &step_one; }
   }
   elsif ($cgi eq "categories.pl")           { require "$admindir_directory/categories.pl";
      if    ($cataction eq "add")            { &add_category;    }
      elsif ($cataction eq "adddesc")        { &add_cat_desc;    }
      elsif ($cataction eq "rename")         { &rename_category; }
      elsif ($cataction eq "delete")         { &delete_category; }
      elsif ($cataction eq "batch_me")       { &batch_thumbnail; }
      elsif ($cataction eq "index_me")       { &build_index; }
   }
   elsif ($cgi eq "images.pl")               { require "$admindir_directory/images.pl";
      if    ($imgaction eq "upload")         { &upload_image;    }
      elsif ($imgaction eq "iBULC_iframe")   { &iBULC_iframe;    }
      elsif ($imgaction eq "rename")         { &rename_image;    }
      elsif ($imgaction eq "delete")         { &delete_image;    }
   }
   elsif ($cgi eq "admin_user.pl")           { require "$admindir_directory/admin_user.pl";
      if    ($useraction eq "modify")        { &modify_user;    }
      elsif ($useraction eq "delete")        { &delete_user;    }
   }
#   elsif ($cgi eq "gallery_user.pl")       { require "gallery_user.pl"; require "$libpath/users_access.pl";
#      if    ($useraction eq "modify") { &modify_user;    }
#      elsif ($useraction eq "delete") { &delete_user;    }
#   }
#   elsif ($cgi eq "accounts.pl")       { require "$libpath/crypt.pl"; require "$libpath/accounts.pl"; $admin_cgi = 1;
#      if    ($useraction eq "modify") { &modify_user;      }
#      elsif ($useraction eq "add")    { if ($FORM{'step'} == 2) {&account_validate;} else {&account_register;} &account_template;}
#      elsif ($useraction eq "delete") { &delete_user;      }
#   }

   elsif ($cgi eq "orders.pl")         { require "$commercepath/admin/orders.pl";
      if    ($ordaction eq "view")    { &view_order;       }
      elsif ($ordaction eq "modify")   { &modify_order;     }
      elsif ($ordaction eq "delete")   { &delete_order;     }
      elsif ($ordaction eq "download") { &edit_download;     }
      elsif ($ordaction eq "status")   { &edit_status;     }
      else  { &list_orders; }
   }

   elsif ($cgi eq "accounts.pl")      { require "$admindir_directory/accounts.pl";
      if    ($useraction eq "modify") { &modify_user; }
      elsif ($useraction eq "add")    { &add_user; }
      elsif ($useraction eq "delete") { &delete_user; }
   }
   elsif ($cgi eq "gallery_group.pl")        { require "$admindir_directory/gallery_group.pl"; require "$libpath/users_access.pl";
      if    ($useraction eq "modify")        { &modify_group;    }
      elsif ($useraction eq "delete")        { &delete_group;    }
      elsif ($useraction eq "viewgroups")    { &view_groups;    }
   }
   elsif ($cgi eq "thumb_island.pl")         { require "$admindir_directory/thumb_island.pl";
      if    ($thumbaction eq "create")       { &create_tisland;  }
      elsif ($thumbaction eq "show")         { &show_tisland;    }
   }
   elsif ($cgi eq "disk_usage.pl")         { require "$admindir_directory/disk_usage.pl";
      &disk_usage;
   }
   elsif ($cgi eq "config_editor.pl")        {
       require "$admindir_directory/config_editor.pl";
       &menu;
   }
   elsif ($cgi eq "skins.pl")                {
       require "$admindir_directory/skins.pl";
       &menu;
   }
   elsif ($cgi eq "templates.pl")                {
       require "$admindir_directory/templates.pl";
       &templates;
   }
   elsif ($cgi eq "headerfooter.pl")                {
       require "$admindir_directory/headerfooter.pl";
       &headerfooter;
   }
   elsif ($cgi eq "cat_price.pl")      {
      require "$commercepath/admin/cat_price.pl";
      if ($cataction eq "addprice")    {
         &add_cat_price;
      }
   }
   else {
      $ADMINHOME = "active";
      &get_header;
      &show_instructions;
      &get_footer;
   }
}

###############################################################################
# GET SESSION
# Gets the session and session file location
###############################################################################
sub get_session {
   if ($COOKIE{'IF_UID'}) {
     $FORM{'uid'} = $COOKIE{'IF_UID'};
     $unique = $COOKIE{'IF_UID'};              # first, we get the random id
     $sessionid = "$sessions_dir/$unique.admin"; # second, we get the location
   }
   else {
     $sessionid = "111aaa.11a.admin";            # give a bogus name if nonexistent
   }
}

###############################################################################
# CHECK FILE
# checks to see if an id file exists before using it
###############################################################################
sub check_file {
   $exists = '1' if -e $sessionid;
   if ($exists eq '1') { $is_admin=1; &parse_session; }
}

###############################################################################
# PARSE SESSION
# Opens and reads a session file's contents
###############################################################################
sub parse_session {
   open (SESSION,"$sessionid") or print &Error('Unable to verify your identity.');
   my(@userdata)=<SESSION>;
   close(SESSION);

   open(SESSION,">$sessionid") or print &Error('Unable to verify your identity.');
   if ($useflock) { flock(SESSION, 2); }
   foreach $userdata (@userdata) {
      ($userid, $firstname, $lastname, $email, $desc_per, $upload_per, $addcat_per, $rencat_per, $delcat_per, $build_per, $addusr_per, $modusr_per, $delusr_per, $demo_per) = split(/\|/, $userdata);
      print SESSION "$userid|$firstname|$lastname|$email|$desc_per|";
      print SESSION "$upload_per|$addcat_per|$rencat_per|$delcat_per|";
      print SESSION "$build_per|$addusr_per|$modusr_per|$delusr_per|$demo_per";
   }
   if ($useflock) { flock(SESSION, 8); }
   close(SESSION);
   $admin_demo_mode = 1 if ($demo_per eq "Yes");
}





###############################################################################
# LOGOUT
# Deletes the current session file for an effective logout
###############################################################################
sub logout {
   &get_session;
   if (-e "$sessions_dir/$unique.admin") {
      unlink("$sessions_dir/$unique.admin");
   }
   print "Set-Cookie: IF_UID=; path=/;\n";
}

###############################################################################
# LOGIN
# Our login screen
###############################################################################
sub login {

   my $logo = qq|<img src="$if_images_directory/logo.gif" border=0 alt="ImageFolio Login">|;
   $logo = qq|<font face="Verdana,Arial,Helvetica" size=3 color="#ffffff"><b>&nbsp;&nbsp;ImageFolio</b></font>| if $default_skin_loaded;

   print "Content-type: text/html\n\n";

print qq|
<html>
<head>
<title>$site_title Administration : Login</title>|;

if ($use_cookies) {
   &print_cookie;
   print qq|\n</head>\n<body bgcolor="#eeeeee" onLoad="loadWallet()">|;
}
else {
   print qq|\n</head>\n<body bgcolor="#eeeeee">|;
}

my $login_up_info = qq|
<table border=0 cellspacing=0 cellpadding=3>
<tr><td align=left>
<font face="Verdana,Arial,Helvetica" size=2 >
<b>For this demo, use the following login</b><br><br>
<b>Username:</b> Admin<br>
<b>Password:</b> ImageFolio<br><br>
</font></td></tr></table>| if $imagefolio_url =~ /^http\:\/\/if4\.imagefolio\.com/i;

print qq|
<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%">
  <tr>
    <td valign=middle align=center>

      $login_up_info

      <table border=0 cellspacing=1 cellpadding=10 width=420 bgcolor="#000000">
        <tr bgcolor="#666666">
          <td align=center>

            <form method=post action="$imagefolio_url">
            <input type=hidden name=admin value="admin">
            <input type=hidden name=login value=1>
            <input type=hidden name=start value="$FORM{'start'}">

            <table border=0 cellspacing=1 cellpadding=0 width="100%" bgcolor="#cccccc">
              <tr>
                <td align=center>
                  <table border=0 cellspacing=0 cellpadding=2 width="100%">
                    <tr bgcolor="#000000">
                      <td>$logo</td>
                      <td align=right><font face="Verdana,Arial,Helvetica" size=2 color="#ffffff"><b>Admin Login&nbsp;&nbsp;</b></font></td>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
            
            <br><br>

            <table border=0 cellpadding=4 width="100%">
              <tr>
                <td align=right><font face="Verdana,Arial,Helvetica" size=2 color="#ffffff"><b>Username</b> </font></td>
                <td><input type=text name="user" size=25 value=""></td>
              </tr>
              <tr>
                <td align=right><font face="Verdana,Arial,Helvetica" size=2 color="#ffffff"><b>Password</b> </font></td>
                <td><input type="password" name="password" value="" size=25></td>
              </tr>
            </table>
            
            <br>
            |;


if ($use_cookies) {
   print qq|<input type="Submit" name=save ONCLICK="saveWallet()" Value="Login">|;
}
else {
   print qq|<input type="Submit" name=save Value="Login">|;
}

print qq|
            <br>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>

</form>

</body>
</html>
|;

}

###############################################################################
# GET CATLIST
# We read in the list of all of the categories from the categories.txt file
# which is built by build.pl and create a selection form
###############################################################################
sub get_catlist {
   open (FILE,"$catfile") or &Error ("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   close(FILE);
   chomp @LINES;
   @LINES = sort { lc($a) cmp lc($b) } @LINES;

   $catlist = qq|<select name="category" size="8">|;

   foreach $LINE (@LINES) {
      $space = "";
      ($category, $imagecount) = split(/\t/, $LINE);
      @categories = split (/\//, $category);
      foreach $cat (@categories) {
         $space .= "......";
      }
      $newcategory = pop @categories;
      $newcategory = &get_clean_name($newcategory);
      $space =~ s/\.\.\.\.\.\.//;
      $catlist .= qq|<option value="$category">$space$newcategory|;
   }

$catlist .= qq|</select>|;
}

###############################################################################
# GET IMAGE INFO
# Get some stats about this image
###############################################################################
sub get_image_info {

   ($thisimage) = $image =~ m,^(.*)\.\w+$,;
   $thisimage =~ s/$mypattern//g;

   foreach $key (keys %extensions) {
      my $lckey = lc($key);
      my $uckey = uc($key);
      $extfound = 0;
      $mykey = "";
      my ($if_filetype, $if_link, $if_tagfile, $if_target, $default_icon);

      if ( -e "$image_directory/$category/$thisimage.$lckey" )    { $mykey = $lckey; $extfound = 1; }
      elsif ( -e "$image_directory/$category/$thisimage.$uckey" ) { $mykey = $uckey; $extfound = 1; }

      if ($extfound) {
         $if_filetype   =  $extensions{$key}[0];
         $thisimage     .= ".$mykey";
         $file_type     =  $if_filetype;
         ($filesize, $filedate) = (stat("$image_directory/$category/$thisimage"))[7,9];   #get size, timestamp
         $filedate = unix_to_date($filedate);               #convert unix time to a legible day
         last;
      }
   }

   if (!$extfound && $name =~ /$mypattern/i) {
      ($filesize, $filedate) = (stat("$image_directory/$category/$image"))[7,9];        #get size, timestamp
      $filedate = unix_to_date($filedate);               #convert unix time to a legible day
      $file_type = "No Match Found";
   }

   if ($filesize < 1500) { $filesize = commify($filesize) . " bytes"; }
   else { $filesize = int($filesize/1000) . " Kb"; }
}






###############################################################################
# GET HEADER
# The top part of all pages (contains the nav stuff)
###############################################################################
sub get_header {

   $admin_demo_html = () if !$admin_demo_mode;

   if (($build_per eq 'Yes') && $remind_rebuild) {
      $my_logout = qq|<script language="javascript">
      function admin_signout() {
         rebuild = confirm("Do you want to rebuild the index before you log out? (OK = Yes   Cancel = No)");
         if (rebuild == true) {
            location.href = "$buildurl&log_out_option=1";
         }
         else {
            location.href = "$adminurl&logout=1&uid=$FORM{'uid'}";
         }
      }</script><a href="javascript:admin_signout();"|;
   }
   else {
      $my_logout = qq|<a href="$adminurl&logout=1&uid=$FORM{'uid'}"|;
   }


$admin_header  = "Expires: Sun, 01 Jan 2000 00:00:00 GMT\n";
$admin_header .= "Cache-Control: no-cache\n";
$admin_header .= "Pragma: no-cache\n";
$admin_header .= "Content-type: text/html\n\n";


   my $logo_img = qq|<img src="$if_images_directory/logo.gif" border=0 alt="BizDesign ImageFolio">|;
   my $logout_img = qq|<img src="$if_images_directory/admin_logout.gif" border=0 alt="Logout" width=61 height=43>|;
   my $home_img = qq|<img src="$if_images_directory/admin_home.gif" border=0 alt="Home" width=61 height=43>|;
   my $gallery_img = qq|<img src="$if_images_directory/admin_gallery.gif" border=0 alt="Gallery" width=61 height=43>|;
   if ($default_skin_loaded) {
      $logo_img = qq|<font face="Verdana,Arial,Helvetica" size=3 color="#ffffff"><b>&nbsp;&nbsp;BizDesign ImageFolio</b></font>|;
      $logout_img = qq|<font face="Verdana,Arial,Helvetica" size=2 color="#ffffff"><b>Logout</b></font>|;
      $home_img = qq|<font face="Verdana,Arial,Helvetica" size=2 color="#ffffff"><b>Home</b></font>|;
      $gallery_img = qq|<font face="Verdana,Arial,Helvetica" size=2 color="#ffffff"><b>Gallery</b></font>|;
      $img_spacer = qq| <img src="$base_if_url/pixel.gif"  width=20 height=43 border=0 align="absmiddle"> |;
   }

$admin_header .= qq|
<!doctype html public "-//w3c//dtd html 3.2 final//en">
<html>
<head>
<title>$site_title Administration : $pagetitle</title>
<META HTTP-EQUIV="expires" CONTENT="-1">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
$start_url


<style type="text/css">

  .menu { font-family:verdana,arial,helvetica; line-height:15px; font-size:9px; font-weight:bold; text-decoration:none; background-color:#ffcc00; color:#000000; }

  .pagemenu { font-family:verdana,arial,helvetica; font-size:9px; font-weight:bold; background-color:#666666; color:#ffffff; }

  .stats { font-family:verdana,arial,helvetica; font-size:10px; font-weight:bold; background-color:#999999; color:#ffffff; }

  .statsval { font-family:verdana,arial,helvetica; font-size:10px; font-weight:normal; background-color:#dddddd; color:#000000; }
  
  .normal { font-family:verdana,arial,helvetica; font-size:12px; font-weight:normal; color:#000000; }
  
  .title { font-family:verdana,arial,helvetica; font-size:14px; font-weight:bold; color:#ff0000; }

  .btitle { font-family:verdana,arial,helvetica; font-size:14px; font-weight:bold; color:#000000; }

  .submenu { background-image:url($if_images_directory/admin_buttback.gif); line-height:20px; background-color:#666666; }

  .submenuactive { background-image:url($if_images_directory/admin_buttback2.gif); line-height:20px; background-color:#000000; }
  



.sideroll {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffffff;display:block;width:100%;height:100%;}
a.sideroll:link {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffffff;display:block;width:100%;height:100%;}
a.sideroll:visited {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffffff;display:block;width:100%;height:100%;}
a.sideroll:hover {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffcc00;display:block;width:100%;height:100%;background:#333333;}
a.sideroll:active {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffffff;display:block;width:100%;height:100%;}

.siderollactive {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffffff;display:block;width:100%;height:100%;}
a.siderollactive:link {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffffff;display:block;width:100%;height:100%;}
a.siderollactive:visited {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffffff;display:block;width:100%;height:100%;}
a.siderollactive:hover {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffcc00;display:block;width:100%;height:100%;}
a.siderollactive:active {font-family:verdana,arial,helvetica;font-size:11px;font-weight:bold;text-decoration:none;color:#ffffff;display:block;width:100%;height:100%;}


  .roll { font-family:verdana,arial,helvetica; font-size:12px; font-weight:bold; text-decoration:none; color:#ffffff; }
  
  A.roll:hover { color:#ffcc00; }
  
  .roll2 { font-family:verdana,arial,helvetica; font-size:12px; font-weight:bold; text-decoration:none; color:#000000; }
  
  A.roll2:hover { color:#ff0000; }

</style>

</head>

<body bgcolor="#eeeeee" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0 bottommargin=0 rightmargin=0>
$admin_demo_html
<table border=0 cellspacing=0 cellpadding=0 width="100%">
  <tr bgcolor="#000000">
    <td width="100%" align=left nowrap valign=middle><nobr>$img_spacer$logo_img</nobr></td>
    <td align=right>
      <table border=0 cellspacing=0 cellpadding=0>
        <tr>
          <td width=61 nowrap valign=middle><nobr>$my_logout>$logout_img</a>$img_spacer</nobr></td>
          <td width=61 nowrap valign=middle><nobr><a href="$adminurl&uid=$FORM{'uid'}">$home_img</a>$img_spacer</nobr></td>
          <td width=61 nowrap valign=middle><nobr><a href="$imagefolio_url">$gallery_img</a>$img_spacer</nobr></td>
        </tr>
      </table>
    </td>
  </tr>
</table>

<table border=0 cellspacing=0 cellpadding=0 width="100%">
  <tr>
    <td width="100%" valign=top bgcolor="#666666" background="$if_images_directory/admin_buttback.gif"><img src="$base_if_url/pixel.gif" height=7 width=1 border=0></td>
  </tr>
</table>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%">
  <tr>
    <td width=170 valign=top bgcolor="#666666">
      <table border=0 cellspacing=1 cellpadding=0 width="100%" bgcolor="#333333">
|;

if ($addusr_per eq "Yes") {
   $admin_header .= qq|
        <tr>
          <td align=center class=menu>C O N F I G U R A T I O N</td>
        </tr>
        <tr>
          <td align=left class=submenu%%%CONFIGEDITOR%%%>\n<A HREF="$adminurl&cgi=config_editor.pl&uid=$FORM{'uid'}" class="sideroll%%%CONFIGEDITOR%%%" alt="Edit ImageFolio's Configuration" title="Edit ImageFolio's Configuration">&nbsp;&nbsp;Configuration Editor</a></td>
        </tr>
        <tr>
          <td align=left class=submenu%%%SKINSMANAGER%%%>\n<A HREF="$adminurl&cgi=skins.pl&uid=$FORM{'uid'}" class="sideroll%%%SKINSMANAGER%%%" alt="Use ImageFolio's Skins Manager" title="Use ImageFolio's Skins Manager">&nbsp;&nbsp;Skins Manager</a></td>
        </tr>
   |;
}

$admin_header .= qq|
        <tr>
          <td align=center class=menu>F I L E S</td>
        </tr>
|;


if (($desc_per eq "Yes") && ($if2_search or $if2_caption or $if2_thumbcaption)) {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%ADDFILEDESCRIPTIONS%%%>\n<A HREF="$adminurl&cgi=keywords.pl&uid=$FORM{'uid'}" class="sideroll%%%ADDFILEDESCRIPTIONS%%%>" alt="Add File Descriptions" title="Add File Descriptions">&nbsp;&nbsp;Add Descriptions</a></td>
   </tr>
   |;
}




if ($upload_per eq "Yes") {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%UPLOADFILES%%%>\n<A HREF="$adminurl&cgi=images.pl&imgaction=upload&uid=$FORM{'uid'}" class="sideroll%%%UPLOADFILES%%%" alt="Upload New Files" title="Upload New Files">&nbsp;&nbsp;Upload Files</a></td>
   </tr>
   |;
}




if ($delcat_per eq "Yes") {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%DELETEFILES%%%>\n<A HREF="$adminurl&cgi=remove.pl&uid=$FORM{'uid'}" class="sideroll%%%DELETEFILES%%%" alt="Delete Existing Files" title="Delete Existing Files">&nbsp;&nbsp;Delete Files</a></td>
   </tr>
   |;
}



if ($desc_per eq "Yes") {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%ADDFILEINFO%%%>\n<A HREF="$adminurl&cgi=iptc_keywords.pl&uid=$FORM{'uid'}" class="sideroll%%%ADDFILEINFO%%%" alt="Add File Info (IPTC)" title="Add File Info (IPTC)">&nbsp;&nbsp;Add File Info (IPTC)</a></td>
   </tr>
   |;
}



if ($addcat_per eq "Yes") {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%ADDCATEGORY%%%>\n<A HREF="$adminurl&cgi=categories.pl&cataction=add&uid=$FORM{'uid'}" class="sideroll%%%ADDCATEGORY%%%" alt="Add a New Category" title="Add a New Category">&nbsp;&nbsp;Add Category</a></td>
   </tr>
   |;
}



if ($rencat_per eq "Yes") {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%ADDDESCRIPTIONS%%%>\n<A HREF="$adminurl&cgi=categories.pl&cataction=adddesc&uid=$FORM{'uid'}" class="sideroll%%%ADDDESCRIPTIONS%%%" alt="Add Category Descriptions" title="Add Category Descriptions">&nbsp;&nbsp;Add Descriptions</a></td>
   </tr>
   <tr>
     <td align=left class=submenu%%%RENAMECATEGORY%%%>\n<A HREF="$adminurl&cgi=categories.pl&cataction=rename&uid=$FORM{'uid'}" class="sideroll%%%RENAMECATEGORY%%%" alt="Rename a Category" title="Rename a Category">&nbsp;&nbsp;Rename Category</a></td>
   </tr>
   |;
}


if ($delcat_per eq "Yes") {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%DELETECATEGORY%%%>\n<A HREF="$adminurl&cgi=categories.pl&cataction=delete&uid=$FORM{'uid'}" class="sideroll%%%DELETECATEGORY%%%" alt="Delete a Category" title="Delete a Category">&nbsp;&nbsp;Delete Category</a></td>
   </tr>
   |;
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%PRICECATEGORY%%%>\n<A HREF="$adminurl&cgi=cat_price.pl&cataction=addprice&uid=$FORM{'uid'}" class="sideroll%%%PRICECATEGORY%%%" alt="Add Category Pricing" title="Add Category Pricing">&nbsp;&nbsp;Add Category Pricing</a></td>
   </tr>
   | if $IF_edition eq "Commerce" && $demo_per eq "No";;
}



$admin_header .= qq|
  <tr>
    <td align=left class=submenu%%%DISKUSAGE%%%>\n<A HREF="$adminurl&cgi=disk_usage.pl&uid=$FORM{'uid'}" class="sideroll%%%DISKUSAGE%%%" alt="View Per Category Disk Usage" title="View Per Category Disk Usage">&nbsp;&nbsp;Disk Usage</a></td>
  </tr>
  <tr>
    <td align=center class=menu>D A T A B A S E S</td>
  </tr>
|;



if ($using_batch_thumbnail_mod) {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%BATCHTHUMBNAIL%%%>\n<A HREF="$adminurl&cgi=categories.pl&cataction=batch_me&uid=$FORM{'uid'}" class="sideroll%%%BATCHTHUMBNAIL%%%" alt="Batch Thumbnail Images" title="Batch Thumbnail Images">&nbsp;&nbsp;Batch Thumbnail</a></td>
   </tr>
   |;
}



if ($build_per eq "Yes") {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%REBUILDINDEX%%%>\n<A HREF="$buildurl" class="sideroll%%%REBUILDINDEX%%%" alt="Rebuild The Database/Index" title="Rebuild The Database/Index">&nbsp;&nbsp;Rebuild Index</a></td>
   </tr>|;
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu%%%ORDERDB%%%>\n<A HREF="$adminurl&cgi=orders.pl&ordaction=view&uid=$FORM{'uid'}" class="sideroll%%%ORDERDB%%%" alt="Orders Database" title="Orders Database">&nbsp;&nbsp;Orders Database</a></td>
   </tr>
   | if $IF_edition eq "Commerce" && $demo_per eq "No";

}




$admin_header .= qq|
  <tr>
    <td align=center class=menu nowrap>A D M I N I S T R A T O R S</td>
  </tr>
|;



if ($allow_multiple_administrators) {

   if ($addusr_per eq "Yes") {
      $admin_header .= qq|
      <tr>
        <td align=left class=submenu%%%ADDNEWADMIN%%%>\n<A HREF="$adminurl&cgi=admin_user_setup.pl&uid=$FORM{'uid'}" class="sideroll%%%ADDNEWADMIN%%%" alt="Add a New ImageFolio Administrator" title="Add a New ImageFolio Administrator">&nbsp;&nbsp;Add New Admin</a></td>
      </tr>
      |;
   }

   if ($modusr_per eq "Yes") {
      $admin_header .= qq|
      <tr>
        <td align=left class=submenu%%%MODIFYADMIN%%%>\n<A HREF="$adminurl&cgi=admin_user.pl&useraction=modify&uid=$FORM{'uid'}" class="sideroll%%%MODIFYADMIN%%%" alt="Modify an ImageFolio Administrator" title="Modify an ImageFolio Administrator">&nbsp;&nbsp;Modify Admin</a></td>
      </tr>
      |;
   }

   if ($delusr_per eq "Yes") {
      $admin_header .= qq|
      <tr>
        <td align=left class=submenu%%%DELETEADMIN%%%>\n<A HREF="$adminurl&cgi=admin_user.pl&useraction=delete&uid=$FORM{'uid'}" class="sideroll%%%DELETEADMIN%%%" alt="Delete an ImageFolio Administrator" title="Delete an ImageFolio Administrator">&nbsp;&nbsp;Delete Admin</a></td>
      </tr>
      |;
   }

} # end allow multiple users
else {
   $admin_header .= qq|
   <tr>
     <td align=left class=submenu><$admin_font><b>&nbsp;&nbsp;Disabled</b></font></td>
   </tr>
   |;
}

unless ($IF_edition eq "Lite") {

   $admin_header .= qq|
     <tr>
       <td align=center class=menu>G A L L E R Y&nbsp;&nbsp;G R O U P S</td>
     </tr>
   |;

   if ($using_multiuser_mod) {

      if ($modusr_per eq "Yes") {
         $admin_header .= qq|
         <tr>
           <td align=left class=submenu%%%VIEWGROUPS%%% nowrap>\n<A HREF="$adminurl&cgi=gallery_group.pl&useraction=viewgroups&uid=$FORM{'uid'}" class="sideroll%%%VIEWGROUPS%%%" alt="View All Users and Groups" title="View All Users and Groups">&nbsp;&nbsp;View Users &amp; Groups</a></td>
         </tr>
         |;
      }
      
      if ($addusr_per eq "Yes") {
         $admin_header .= qq|
         <tr>
           <td align=left class=submenu%%%ADDNEWGROUP%%%>\n<A HREF="$adminurl&cgi=gallery_group_setup.pl&uid=$FORM{'uid'}" class="sideroll%%%ADDNEWGROUP%%%" alt="Add a New Group" title="Add a New Group">&nbsp;&nbsp;Add New Group</a></td>
         </tr>
         |;
      }


      if ($modusr_per eq "Yes") {
         $admin_header .= qq|
         <tr>
           <td align=left class=submenu%%%MODIFYGROUP%%%>\n<A HREF="$adminurl&cgi=gallery_group.pl&useraction=modify&uid=$FORM{'uid'}" class="sideroll%%%MODIFYGROUP%%%" alt="Modify a Group" title="Modify a Group">&nbsp;&nbsp;Modify Group</a></td>
         </tr>
         |;
      }


      if ($delusr_per eq "Yes") {
         $admin_header .= qq|
         <tr>
           <td align=left class=submenu%%%DELETEGROUP%%%>\n<A HREF="$adminurl&cgi=gallery_group.pl&useraction=delete&uid=$FORM{'uid'}" class="sideroll%%%DELETEGROUP%%%" alt="Delete a Group" title="Delete a Group">&nbsp;&nbsp;Delete Group</a></td>
         </tr>
         |;
      }

   } # end allow multiple users
   else { 
      $admin_header .= qq|
      <tr>
        <td align=left class=submenu><$admin_font><b>&nbsp;&nbsp;Disabled</b></font></td>
      </tr>
      |;
   }





   $admin_header .= qq|
     <tr>
       <td align=center class=menu>G A L L E R Y&nbsp;&nbsp;U S E R S</td>
     </tr>
   |;




   if ($using_multiuser_mod) {
      if ($user_registration == 1) {
      
         if ($addusr_per eq "Yes") { 
            $admin_header .= qq|
            <tr>
              <td align=left class=submenu%%%ADDUSER%%%>\n<A HREF="$adminurl&cgi=accounts.pl&useraction=add&uid=$FORM{'uid'}" class="sideroll%%%ADDUSER%%%" alt="Add a New User" title="Add a New User">&nbsp;&nbsp;Add New User</a></td>
            </tr>
            |;
         }
         
         if ($modusr_per eq "Yes") {
            $admin_header .= qq|
            <tr>
              <td align=left class=submenu%%%MODIFYUSER%%%>\n<A HREF="$adminurl&cgi=accounts.pl&useraction=modify&uid=$FORM{'uid'}" class="sideroll%%%MODIFYUSER%%%" alt="Modify a User" title="Modify a User">&nbsp;&nbsp;Modify User</a></td>
            </tr>
            |;
         }
         
         if ($delusr_per eq "Yes") {
            $admin_header .= qq|
            <tr>
              <td align=left class=submenu%%%DELETEUSER%%%>\n<A HREF="$adminurl&cgi=accounts.pl&useraction=delete&uid=$FORM{'uid'}" class="sideroll%%%DELETEUSER%%%" alt="Delete a User" title="Delete a User">&nbsp;&nbsp;Delete User</a></td>
            </tr>
            |;
         }

      }
      elsif (($user_registration == 2) && ($addusr_per eq "Yes" or $modusr_per eq "Yes" or $delusr_per eq "Yes")) { 
        
        require "$db_link_path/$db_link_file";
         
         if ($control_panel_url) {
            $admin_header .= qq|
            <tr>
              <td align=left class=submenu%%%CONTROLPANEL%%%>\n<A HREF="$control_panel_url" class="sideroll%%%CONTROLPANEL%%%" target="_blank" alt="Control Panel" title="Control Panel">&nbsp;&nbsp;Control Panel</a></td>
            </tr>
            |;
         }
         else { 
            $admin_header .= qq|
            <tr>
              <td align=left class=submenu><$admin_font><b>&nbsp;&nbsp;No Control Panel</b></font></td>
            </tr>
            |;}
      }
      else {
         $admin_header .= qq|
         <tr>
           <td align=left class=submenu><$admin_font><b>&nbsp;&nbsp;No Control Panel</b></font></td>
         </tr>
         |;
      }
   } # end allow multiple users

   else {
      $admin_header .= qq|
      <tr>
        <td align=left class=submenu><$admin_font><b>&nbsp;&nbsp;Disabled</b></font></td>
      </tr>
      |;
   }
}


$admin_header .= qq|
  <tr>
    <td align=center class=menu>G E N E R A L</td>
  </tr>
  <tr>
    <td align=left class=submenu%%%ADMINHOME%%%>\n<A HREF="$adminurl&uid=$FORM{'uid'}" class="sideroll%%%ADMINHOME%%%" alt="Return to Administration Area Home Page" title="Return to Administration Area Home Page">&nbsp;&nbsp;Admin Home</a></td>
  </tr>
  <tr>
    <td align=left class=submenu><A HREF="$imagefolio_url" class="sideroll" alt="View in Gallery Mode" title="View in Gallery Mode">&nbsp;&nbsp;Gallery Mode</a></td>
  </tr>
  <tr>
    <td align=left class=submenu><$admin_font><b>$my_logout class="sideroll" alt="Logout of the Administration Area" title="Logout of the Administration Area">&nbsp;&nbsp;Logout</a></b></font></td>
  </tr>
  <tr>
    <td align=left class=submenu><A HREF="http://www.imagefolio.com/support" target="_blank" class="sideroll" alt="ImageFolio Technical Support" title="ImageFolio Technical Support">&nbsp;&nbsp;Tech Support</a></td>
  </tr>
</table>

<br><img src="$base_if_url/pixel.gif" height=1 width=170 border=0 alt="."><br>

<center><$admin_small_font><font color="#ffffff">&copy; 1999-2007<br>BizSecure, Inc.</font></font></center>
<br><br>

</td>

<td valign=top width="100%"><table border=0 cellspacing=0 cellpadding=20 width="100%"><tr><td valign=top>
|;


$admin_header =~ s/%%%(.*)%%%/${$1}/g;
print $admin_header;

}











###############################################################################
# GET HEADER
# Bottom piece of all the pages
###############################################################################
sub get_footer {
print qq|
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>

</body>
</html>
|;
}

###############################################################################
# PRINT COOKIE
# Javascript code for saving the username and password for login purposes
###############################################################################
sub print_cookie {

print qq|<SCRIPT LANGUAGE="JavaScript" SRC="$base_if_url/cookie.js"><!--
// -->
</SCRIPT>

<SCRIPT LANGUAGE="JavaScript"><!--
function loadWallet() {

 var cookie=document.cookie
 if(nameDefined(cookie,"IF_User")) { 
IFUsername=getCookieValue(cookie,"IF_User")
IFUsername=decode(IFUsername)
 }else IFUsername=""
 document.forms[0].user.value=IFUsername

 if(nameDefined(cookie,"IF_Password")) { 
IFPass=getCookieValue(cookie,"IF_Password")
IFPass=decode(IFPass)
 }else IFPass=""
 document.forms[0].password.value=IFPass

}

function saveWallet() {
IFUsername=window.document.forms[0].user.value
IFPass=window.document.forms[0].password.value

IFUsername=encode(IFUsername)
IFPass=encode(IFPass)

 var newCookie = "IF_User="+IFUsername+"; expires="
 newCookie += "Tuesday, 09-Nov-10 23:12:40 GMT"
 document.cookie=newCookie
 var newCookie = "IF_Password="+IFPass+"; expires="
 newCookie += "Tuesday, 09-Nov-10 23:12:40 GMT"
 document.cookie=newCookie
}

function encode(s) {
t=""
for(var i=0;i<s.length;++i) {
ch=s.charAt(i)
if(ch=="/") t += "//"
else if(ch==" ") t += "/b"
else if(ch==",") t += "/."
else if(ch==";") t += "/:"
else if(ch=="\\n") t += "/n"
else if(ch=="\\r") t += "/r"
else if(ch=="\\t") t += "/t"
else if(ch=="\\b") t += "/b"
else t += ch
}
return t
}
function decode(s) {
// Decode the encoded cookie value
t=""
if(s==null) return t
for(var i=0;i<s.length;++i) {
var ch=s.charAt(i)
if(ch=="/") {
++i
if(i<s.length){
ch=s.charAt(i)
if(ch=="/") t += ch
else if(ch==".") t += ","
else if(ch==":") t += ";"
else if(ch=="n") t += "\\n"
else if(ch=="r") t += "\\r"
else if(ch=="t") t += "\\t"
else if(ch=="b") t += " "
}
}else t += ch
}
return t
}
// --></SCRIPT>
|;
}

###############################################################################
# UNIX TO DATE
# Takes in a unix time and coverts it to legible form
###############################################################################
sub unix_to_date {
my $time   = shift;
my ($sec, $min, $hour, $day, $mon, $year, $dweek, $dyear, $tz) = localtime $time;
my @months = qw!01 02 03 04 05 06 07 08 09 10 11 12!;
$year += 1900;
return "$months[$mon]/$day/$year";
}

###############################################################################
# COMMIFY
# puts commas in those large numbers
###############################################################################
sub commify {
   my $text = reverse $_[0];
   $text =~ s/(\d\d\d)(?=\d)(?!\d*\.)/$1,/g;
   return scalar reverse $text;
}

###############################################################################
# LOAD VALUES
# here we define some commonly used variables
###############################################################################
sub load_values {
   $rmstep      = $FORM{'rmstep'};
   $kwstep      = $FORM{'kwstep'};
   $catstep     = $FORM{'catstep'};
   $cataction   = $FORM{'cataction'};
   $category    = $FORM{'category'};
   $image       = $FORM{'image'};
   $keywords    = $FORM{'keywords'};
   $icaption    = $FORM{'icaption'};
   $tcaption    = $FORM{'tcaption'};
   $type        = $FORM{'type'};
   $cgi         = $FORM{'cgi'};
   $catname     = $FORM{'catname'};
   $imgaction   = $FORM{'imgaction'};
   $newaction   = $FORM{'newaction'};
   $imgstep     = $FORM{'imgstep'};
   $useraction  = $FORM{'useraction'};
   $thumbaction = $FORM{'thumbaction'};
   $userstep    = $FORM{'userstep'};
   $ifuser      = $FORM{'ifuser'};
   $ifgroup     = $FORM{'ifgroup'};
   $description = $FORM{'description'};
   $ordaction   = $FORM{'ordaction'};
   $orddate     = $FORM{'orddate'};
   $ordtype     = $FORM{'ordtype'};
   $order       = $FORM{'order'};
   $order =~ s/\s+//g;
   $orddate     = $FORM{'orddate'};
   $ordstep     = $FORM{'ordstep'};
}

###############################################################################
# SHOW INSTRUCTIONS
# Instructions are displayed if no data is received
###############################################################################
sub show_instructions {


require "$currdir/admin/gen_stats.pl";

print qq|
<center>
<table border="0" width="100%" cellspacing=0 cellpadding=0><tr><td>
<table border="0" width="100%" cellspacing=0 cellpadding=0>

<tr><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td class=btitle>ImageFolio Administration</td>
<td align=right class=btitle>Overview</td></tr></table>

</td></tr><tr><td valign=top>

<table border=0 cellspacing=1 cellpadding=0 width="100%" bgcolor="#000000">
<tr><td align=center bgcolor="#eeeeee">


<table border=0 cellspacing=1 cellpadding=3 width="100%">
<tr>
<td class=stats align=right width="17%">Date</td><td align=left class=statsval width="17%">$nowdate</td>
<td class=stats align=right width="17%">Licensed To</td><td align=left class=statsval width="17%">$ENV{'HTTP_HOST'}</td>
<td class=stats align=right width="16%">Version</td><td align=left class=statsval width="16%">$imagefolio_version $IF_edition Edition</td>
</tr>
<tr>
<td class=stats align=right>Files</td><td align=left class=statsval>$total_thumbs</td>
<td class=stats align=right>Categories</td><td align=left class=statsval>$total_cats</td>
<td class=stats align=right>Keywords</td><td align=left class=statsval>$total_keywords</td>
</tr>
<tr>
<td class=stats align=right>Admins</td><td align=left class=statsval>$total_admins</td>
<td class=stats align=right>Groups</td><td align=left class=statsval>$total_groups</td>
<td class=stats align=right>Users</td><td align=left class=statsval>$total_users</td>
</tr>
<tr>
<td class=stats align=right nowrap>Last Rebuild</td><td align=left class=statsval>$index_date</td>
<td class=stats align=right nowrap>Last Backup</td><td align=left class=statsval>$last_backup_date</td>
<td class=stats align=right>Disk Usage</td><td align=left class=statsval>$total_disk_usage</td>
</tr>
<tr>
<td class=stats align=right>Machine</td><td align=left class=statsval>$if_machine</td>
<td class=stats align=right>OS/Kernel</td><td align=left class=statsval>$info_OS $if_proc_release</td>
<td class=stats align=right>Processor</td><td align=left class=statsval>$if_processor</td>
</tr>
</table>

</td></tr></table><br>



<table border=0 cellspacing=1 cellpadding=5 width="100%">
|;



print qq|<tr><td align=center class=pagemenu>C O N F I G U R A T I O N</a></td></tr>
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=config_editor.pl&uid=$FORM{'uid'}" class="roll2">Configuration Editor</a><br>
This will allow you edit ImageFolio's setup and configuration settings, add or remove functionality, and quite a few other 
things.  Please be careful!<br>
</td></tr>
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=skins.pl&uid=$FORM{'uid'}" class="roll2">Skins Manager</a><br>
This will allow you view descriptions and images of skins, install new skins when available, 
remove existing skins, restore existing skins to original condition (in case you've made 
modifications and messed up), and/or duplicate existing skins to create your own.<br>
</td></tr>
| if $addusr_per eq "Yes";




print qq|

<tr><td align=center class=pagemenu>F I L E S</td></tr>|;

if ($if2_search or $if2_caption or $if2_thumbcaption) {
   print qq|
   <tr><td align=left width="22%">
   <A HREF="$adminurl&cgi=keywords.pl&uid=$FORM{'uid'}" class="roll2">Add Descriptions</a><br>
   This is the old ImageFolio keywords system compatible with IF 2.x. Please use IPTC instead!<br>
   </td></tr>| if $desc_per eq "Yes";
}


print qq|
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=images.pl&imgaction=upload&uid=$FORM{'uid'}" class="roll2">Upload Files</a><br>
This will allow you to batch upload your photos, movies, pdf documents, zipped files, etc.<br>
</td></tr>| if $upload_per eq "Yes";

print qq|
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=remove.pl&uid=$FORM{'uid'}" class="roll2">Delete Files</a><br>
This will allow you to remove files from the category or subcategory of your choice.<br>
</td></tr>| if $delcat_per eq "Yes";

print qq|
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=keywords.pl&uid=$FORM{'uid'}" class="roll2">Add File Info (IPTC)</a><br>
This allows you to add searchable keywords, captions, copyright info, etc. to your files using the IPTC standard.<br>
</td></tr>| if $desc_per eq "Yes";


print qq|
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=thumb_island.pl&thumbaction=create&uid=$FORM{'uid'}" class="roll2">Thumbnail Island</a><br>
This allows you to show any thumbnail from your ImageFolio gallery on any of your other web pages.<br>
</td></tr>
|;

print qq|<tr><td align=center class=pagemenu>C A T E G O R I E S</td></tr>|;

print qq|<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=categories.pl&cataction=add&uid=$FORM{'uid'}" class="roll2">Add Category</a><br>
This will create a new directory in your image directory
either as a sub-category or main (parent) category.<br>
</td></tr>| if $addcat_per eq "Yes";

print qq|<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=categories.pl&cataction=adddesc&uid=$FORM{'uid'}" class="roll2">Add Descriptions</a><br>
This allows you to add descriptions to your categories and subcategories.<br>
</td></tr>

<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=categories.pl&cataction=rename&uid=$FORM{'uid'}" class="roll2">Rename Category</a><br>
This allows you to rename an existing directory (category) in your image directory.<br>
</td></tr>| if $rencat_per eq "Yes";

print qq|<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=categories.pl&cataction=delete&uid=$FORM{'uid'}" class="roll2">Delete Category</a><br>
Warning! This will delete an existing directory (category)
and all associated images, sub-directories, and their associated images.<br>
</td></tr>| if $delcat_per eq "Yes";

print qq|<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=disk_usage.pl&uid=$FORM{'uid'}" class="roll2">Disk Usage</a><br>
This allows you to view total per category disk usage and total gallery disk usage in a printable format.<br>
</td></tr>
|;

  
print qq|<tr><td align=center class=pagemenu>D A T A B A S E S</td></tr>|;


print qq|<tr><td align=left class=normal><A HREF="$buildurl" class="roll2" target="_blank">Rebuild Index</a><br>
This will backup your existing category and file indices; rebuild the category index and gather file counts; compile disk usage statistics;
and extract IPTC keywords, rates, counts, and other data from your files and deposit them as searchwords into the main database
and the global/common keywords database.  The Rebuild Index should be performed each time you have *finished* uploading and thumbnailing new content, 
added new categories, or modified IPTC information.<br>
</td></tr>

<tr><td align=left class=normal><A HREF="$adminurl&cgi=categories.pl&cataction=batch_me&uid=$FORM{'uid'}" class="roll2" target="_blank">Batch Thumbnail</a><br>
Automates the process of thumbnailing and resizing your images.  This tool will create a thumbnail image and 
preview image for every un-thumbnailed image in the category of your choice, according to your specifications.<br>
</td></tr
| if $build_per eq "Yes";


if ($allow_multiple_administrators) {

print qq|<tr><td align=center class=pagemenu>A D M I N I S T R A T O R S</td></tr>|;


print qq|
<tr><td align=left class=normal>
<A HREF="$admin_setup_url" class="roll2">Add New Admin</a><br>
This will allow you to add a new administrator and selectively set permissions for this administrator.<br>
</td></tr>| if $addusr_per eq "Yes";

print qq|
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=admin_user.pl&useraction=modify&uid=$FORM{'uid'}" class="roll2">Modify Admin</a><br>
This will allow you to modify the name, username, password, email address, or permissions for any administrator.<br>
</td></tr>| if $modusr_per eq "Yes";

print qq|<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=admin_user.pl&useraction=delete&uid=$FORM{'uid'}" class="roll2">Delete Admin</a><br>
This will allow you to remove a administrator from the administrators database and effectively prevent them from logging in again.<br>
</td></tr>| if $delusr_per eq "Yes";
}

if ($using_multiuser_mod) {

print qq|<tr><td align=center class=pagemenu>G A L L E R Y&nbsp; &nbsp;G R O U P S</td></tr>|;


print qq|
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=gallery_group.pl&useraction=viewgroups&uid=$FORM{'uid'}" class="roll2">View Users &amp; Groups</a><br>
This will allow you to view a list of all users and groups and their respective permissions, usernames, and passwords.<br>
</td></tr>| if $modusr_per eq "Yes";


print qq|
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=gallery_group_setup.pl&uid=$FORM{'uid'}" class="roll2">Add New Group</a><br>
This will allow you to add a new group and selectively set permissions for this group.<br>
</td></tr>| if $addusr_per eq "Yes";

print qq|
<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=gallery_group.pl&useraction=modify&uid=$FORM{'uid'}" class="roll2">Modify Group</a><br>
This will allow you to modify the group permissions for any group.<br>
</td></tr>| if $modusr_per eq "Yes";

print qq|<tr><td align=left class=normal>
<A HREF="$adminurl&cgi=gallery_group.pl&useraction=delete&uid=$FORM{'uid'}" class="roll2">Delete Group</a><br>
This will allow you to remove a group from the group database.<br>
</td></tr>| if $delusr_per eq "Yes";
}

if ($using_multiuser_mod) {

   print qq|<tr><td align=center class=pagemenu>G A L L E R Y&nbsp; &nbsp;U S E R S</td></tr>|;

   if ($user_registration == 1) {
      print qq|
      <tr><td align=left class=normal>
      <A HREF="$adminurl&cgi=accounts.pl&useraction=add&uid=$FORM{'uid'}" class="roll2">Add New User</a><br>
      This will allow you to add a new user and choose the group he belongs to.<br>
      </td></tr>| if $addusr_per eq "Yes";

      print qq|
      <tr><td align=left class=normal>
      <A HREF="$adminurl&cgi=accounts.pl&useraction=modify&uid=$FORM{'uid'}" class="roll2">Modify User</a><br>
      This will allow you to modify the username, password, email address and group for any user.<br>
      </td></tr>| if $modusr_per eq "Yes";

      print qq|<tr><td align=left class=normal>
      <A HREF="$adminurl&cgi=accounts.pl&useraction=delete&uid=$FORM{'uid'}" class="roll2">Delete User</a><br>
      This will allow you to remove a user from the user database and effectively prevent them from logging in again.<br>
      </td></tr>| if $delusr_per eq "Yes";
   }
   elsif (($user_registration == 2) && ($addusr_per eq "Yes" or $modusr_per eq "Yes" or $delusr_per eq "Yes")) { 
      require "$db_link_path/$db_link_file";
      if ($control_panel_url) { print qq|<tr><td align=left class=normal>
         <A HREF="$control_panel_url" class="roll2">Control Panel</a><br>
         This will forward you to the control panel that is used to maintain your user database.<br>
         </td></tr>|;
      }
      else { print qq|<tr><td align=left class=normal>
         No Control Panel<br>
         No control panel is supplied, or no permission to maintain your user database.<br>
         </td></tr>|;
      }
   }
   else { print qq|<tr><td align=left class=normal>
      No Control Panel<br>
      No control panel is supplied, or no permission to maintain your user database.<br>
      </td></tr>
   |;}
}

print qq|

<tr><td align=center class=pagemenu>G E N E R A L</td></tr>

<tr><td align=left class=normal>
<A HREF="$adminurl&uid=$FORM{'uid'}" class="roll2">Admin Home</a><br>
This is the page you are currently reading.<br></td></tr>

<tr><td align=left class=normal>
<A HREF="$imagefolio_url" class="roll2">Gallery Mode</a><br>
This allows you to administer your gallery while viewing your gallery.<br></td></tr>

<tr><td align=left class=normal>
$my_logout class="roll2">Logout</a><br>
This will delete your session file and prevent others from accessing the Administration Area 
using your current session id.<br></td></tr>

<tr><td align=left class=normal>
<A HREF="http://www.imagefolio.com/support" class="roll2" target="_blank">Tech Support</a><br>
This will take you to the ImageFolio Technical Support Area.<br></td></tr>
 
</table>
</td></tr></table>
</td></tr></table>

<br><$admin_small_font>&copy; Copyright 1999-2007 <a href="http://www.bizsecure.com">BizSecure, Inc.</a></font><br><br>
|;
}

###############################################################################
# Error
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{
   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$admin_font color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><$admin_font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$admin_font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$admin_font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
|;

exit;
}

1;