/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;

class EpochUtilInterface
extends JFrame
implements ClipboardOwner {
    private static final short _WIDTH = 250;
    private static final short _HEIGHT = 350;
    private EpochUtil uTimeStamp;
    private JCheckBox cbxManual;
    private JCheckBox cbxUpdate;
    private JComboBox cmbDate;
    private JComboBox cmbMonth;
    private JComboBox cmbYear;
    private JComboBox cmbHour;
    private JComboBox cmbMinute;
    private JComboBox cmbSecond;
    private JTabbedPane tabMenu;
    private JTextField txtUnixTime;
    private JTextField txtMadeDate;
    private JTextField txtInputTime;
    private JTextField txtTimeFormat;
    private JTextField txtDateFormat;
    private boolean bInitialManualSet;

    public EpochUtilInterface() {
        this.setLayout(new GridLayout(1, 1));
        this.uTimeStamp = new EpochUtil();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exErr) {
            // empty catch block
        }
        JButton btnClipCopy = new JButton("Clipboard Copy");
        JButton btnReset = new JButton("R");
        JButton btnMake = new JButton("Make Date");
        JButton btnDateCopy = new JButton("Clipboard Copy");
        this.cbxManual = new JCheckBox("Manual Setting");
        this.cbxUpdate = new JCheckBox("Enable Tick Over");
        this.cmbDate = new JComboBox();
        this.cmbMonth = new JComboBox();
        this.cmbYear = new JComboBox();
        this.cmbHour = new JComboBox();
        this.cmbMinute = new JComboBox();
        this.cmbSecond = new JComboBox();
        JLabel lblDateFormat = new JLabel("dd/mm/yyyy :");
        JLabel lblNullox = new JLabel("0.1.3 Nullox");
        JLabel lblTimeFormat = new JLabel("hh:mm:ss :");
        this.txtUnixTime = new JTextField();
        this.txtInputTime = new JTextField();
        this.txtTimeFormat = new JTextField("h:m:s");
        this.txtDateFormat = new JTextField("d/m/y");
        this.txtMadeDate = new JTextField("00:00:00 01/01/1970");
        this.setTitle("ETU 0.1.3");
        this.setSize(250, 350);
        this.setLocation(100, 100);
        this.setIconImage(new ImageIcon(this.getClass().getResource("media/icon.png")).getImage());
        lblNullox.setForeground(new Color(205, 205, 205));
        this.cbxUpdate.setEnabled(false);
        Cursor curSelection = new Cursor(12);
        this.cbxManual.setCursor(curSelection);
        this.cbxUpdate.setCursor(curSelection);
        this.cmbDate.setCursor(curSelection);
        this.cmbMonth.setCursor(curSelection);
        this.cmbYear.setCursor(curSelection);
        this.cmbHour.setCursor(curSelection);
        this.cmbMinute.setCursor(curSelection);
        this.cmbSecond.setCursor(curSelection);
        btnClipCopy.setCursor(curSelection);
        btnReset.setCursor(curSelection);
        btnMake.setCursor(curSelection);
        btnDateCopy.setCursor(curSelection);
        for (int i_day = 1; i_day <= 31; ++i_day) {
            if (i_day < 10) {
                this.cmbDate.addItem("0" + i_day);
                continue;
            }
            this.cmbDate.addItem(i_day);
        }
        this.cmbMonth.addItem("January");
        this.cmbMonth.addItem("February");
        this.cmbMonth.addItem("March");
        this.cmbMonth.addItem("April");
        this.cmbMonth.addItem("May");
        this.cmbMonth.addItem("June");
        this.cmbMonth.addItem("July");
        this.cmbMonth.addItem("August");
        this.cmbMonth.addItem("September");
        this.cmbMonth.addItem("October");
        this.cmbMonth.addItem("November");
        this.cmbMonth.addItem("December");
        for (int i_year = 1970; i_year <= 2037; ++i_year) {
            this.cmbYear.addItem(i_year);
        }
        for (int i_time_indice = 0; i_time_indice <= 59; ++i_time_indice) {
            String s_buffer = i_time_indice < 10 ? "0" + i_time_indice : "" + i_time_indice;
            if (i_time_indice <= 23) {
                this.cmbHour.addItem(s_buffer);
            }
            this.cmbMinute.addItem(s_buffer);
            this.cmbSecond.addItem(s_buffer);
        }
        this.txtUnixTime.setText("" + this.uTimeStamp.getSeconds());
        this.txtUnixTime.setEditable(false);
        this.txtMadeDate.setEditable(false);
        this.txtUnixTime.setHorizontalAlignment(0);
        this.txtMadeDate.setHorizontalAlignment(0);
        ActionListener alRemoveFocus = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpochUtilInterface.this.txtUnixTime.requestFocusInWindow();
            }
        };
        this.cmbDate.addActionListener(alRemoveFocus);
        this.cmbHour.addActionListener(alRemoveFocus);
        this.cmbMinute.addActionListener(alRemoveFocus);
        this.cmbSecond.addActionListener(alRemoveFocus);
        this.cbxManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EpochUtilInterface.this.cbxManual.isSelected()) {
                    EpochUtilInterface.this.cbxUpdate.setEnabled(true);
                } else {
                    EpochUtilInterface.this.cbxUpdate.setEnabled(false);
                    EpochUtilInterface.this.cbxUpdate.setSelected(false);
                }
            }
        });
        this.cbxUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpochUtilInterface.this.txtUnixTime.requestFocusInWindow();
            }
        });
        this.cmbMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i_temp = EpochUtilInterface.this.cmbDate.getSelectedIndex();
                EpochUtilInterface.this.doUpdateDaysCombo();
                if (i_temp >= EpochUtilInterface.this.getNumDaysInMonth()) {
                    EpochUtilInterface.this.cmbDate.setSelectedIndex(EpochUtilInterface.this.cmbDate.getItemCount() - 1);
                } else {
                    EpochUtilInterface.this.cmbDate.setSelectedIndex(i_temp);
                }
                EpochUtilInterface.this.txtUnixTime.requestFocusInWindow();
            }
        });
        this.cmbYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i_temp = EpochUtilInterface.this.cmbDate.getSelectedIndex();
                EpochUtilInterface.this.doUpdateDaysCombo();
                if (i_temp >= EpochUtilInterface.this.getNumDaysInMonth()) {
                    EpochUtilInterface.this.cmbDate.setSelectedIndex(EpochUtilInterface.this.cmbDate.getItemCount() - 1);
                } else {
                    EpochUtilInterface.this.cmbDate.setSelectedIndex(i_temp);
                }
                EpochUtilInterface.this.txtUnixTime.requestFocusInWindow();
            }
        });
        btnClipCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpochUtilInterface.this.setClipboardContents(EpochUtilInterface.this.txtUnixTime.getText());
                EpochUtilInterface.this.txtUnixTime.requestFocusInWindow();
            }
        });
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpochUtilInterface.this.cmbDate.setSelectedIndex(0);
                EpochUtilInterface.this.cmbMonth.setSelectedIndex(0);
                EpochUtilInterface.this.cmbYear.setSelectedIndex(0);
                EpochUtilInterface.this.cmbHour.setSelectedIndex(0);
                EpochUtilInterface.this.cmbMinute.setSelectedIndex(0);
                EpochUtilInterface.this.cmbSecond.setSelectedIndex(0);
                EpochUtilInterface.this.cbxUpdate.setSelected(false);
                EpochUtilInterface.this.cbxManual.setSelected(false);
                EpochUtilInterface.this.uTimeStamp.doReset();
                EpochUtilInterface.this.uTimeStamp.doRefresh();
                EpochUtilInterface.this.txtUnixTime.requestFocusInWindow();
            }
        });
        btnDateCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpochUtilInterface.this.setClipboardContents(EpochUtilInterface.this.txtMadeDate.getText());
            }
        });
        btnMake.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpochUtilInterface.this.txtMadeDate.setText(EpochUtilInterface.this.getDateFromUnixTime());
            }
        });
        ActionListener tmrInterval = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EpochUtilInterface.this.cbxManual.isSelected()) {
                    if (!EpochUtilInterface.this.bInitialManualSet) {
                        EpochUtilInterface.this.uTimeStamp.setDate(EpochUtilInterface.this.cmbDate.getSelectedIndex() + 1);
                        EpochUtilInterface.this.uTimeStamp.setMonth(EpochUtilInterface.this.cmbMonth.getSelectedIndex() + 1);
                        EpochUtilInterface.this.uTimeStamp.setYear(Integer.parseInt(EpochUtilInterface.this.cmbYear.getSelectedItem().toString()));
                        EpochUtilInterface.this.uTimeStamp.setHour(Integer.parseInt(EpochUtilInterface.this.cmbHour.getSelectedItem().toString()));
                        EpochUtilInterface.this.uTimeStamp.setMinute(Integer.parseInt(EpochUtilInterface.this.cmbMinute.getSelectedItem().toString()));
                        EpochUtilInterface.this.uTimeStamp.setSecond(Integer.parseInt(EpochUtilInterface.this.cmbSecond.getSelectedItem().toString()));
                        EpochUtilInterface.this.bInitialManualSet = true;
                    } else {
                        if (EpochUtilInterface.this.cbxUpdate.isSelected()) {
                            if (EpochUtilInterface.this.cmbSecond.getSelectedIndex() == 59) {
                                EpochUtilInterface.this.cmbSecond.setSelectedIndex(0);
                                if (EpochUtilInterface.this.cmbMinute.getSelectedIndex() == 59) {
                                    EpochUtilInterface.this.cmbMinute.setSelectedIndex(0);
                                    if (EpochUtilInterface.this.cmbHour.getSelectedIndex() == 23) {
                                        EpochUtilInterface.this.cmbHour.setSelectedIndex(0);
                                        if (EpochUtilInterface.this.cmbDate.getSelectedIndex() == EpochUtilInterface.this.cmbDate.getItemCount() - 1) {
                                            EpochUtilInterface.this.cmbDate.setSelectedIndex(0);
                                            if (EpochUtilInterface.this.cmbMonth.getSelectedIndex() == 11) {
                                                EpochUtilInterface.this.cmbMonth.setSelectedIndex(0);
                                                if (EpochUtilInterface.this.cmbYear.getSelectedIndex() == EpochUtilInterface.this.cmbYear.getItemCount() - 1) {
                                                    EpochUtilInterface.this.cmbYear.addItem(Integer.parseInt(EpochUtilInterface.this.cmbYear.getSelectedItem().toString()) + 1);
                                                }
                                                EpochUtilInterface.this.cmbYear.setSelectedIndex(EpochUtilInterface.this.cmbYear.getSelectedIndex() + 1);
                                            } else {
                                                EpochUtilInterface.this.cmbMonth.setSelectedIndex(EpochUtilInterface.this.cmbMonth.getSelectedIndex() + 1);
                                            }
                                            EpochUtilInterface.this.doUpdateDaysCombo();
                                        } else {
                                            EpochUtilInterface.this.cmbDate.setSelectedIndex(EpochUtilInterface.this.cmbDate.getSelectedIndex() + 1);
                                        }
                                    } else {
                                        EpochUtilInterface.this.cmbHour.setSelectedIndex(EpochUtilInterface.this.cmbHour.getSelectedIndex() + 1);
                                    }
                                } else {
                                    EpochUtilInterface.this.cmbMinute.setSelectedIndex(EpochUtilInterface.this.cmbMinute.getSelectedIndex() + 1);
                                }
                            } else {
                                EpochUtilInterface.this.cmbSecond.setSelectedIndex(EpochUtilInterface.this.cmbSecond.getSelectedIndex() + 1);
                            }
                        }
                        EpochUtilInterface.this.uTimeStamp.setDate(EpochUtilInterface.this.cmbDate.getSelectedIndex() + 1);
                        EpochUtilInterface.this.uTimeStamp.setMonth(EpochUtilInterface.this.cmbMonth.getSelectedIndex() + 1);
                        EpochUtilInterface.this.uTimeStamp.setYear(Integer.parseInt(EpochUtilInterface.this.cmbYear.getSelectedItem().toString()));
                        EpochUtilInterface.this.uTimeStamp.setHour(Integer.parseInt(EpochUtilInterface.this.cmbHour.getSelectedItem().toString()));
                        EpochUtilInterface.this.uTimeStamp.setMinute(Integer.parseInt(EpochUtilInterface.this.cmbMinute.getSelectedItem().toString()));
                        EpochUtilInterface.this.uTimeStamp.setSecond(Integer.parseInt(EpochUtilInterface.this.cmbSecond.getSelectedItem().toString()));
                    }
                } else {
                    EpochUtilInterface.this.uTimeStamp.doRefresh();
                    EpochUtilInterface.this.bInitialManualSet = false;
                }
                EpochUtilInterface.this.txtUnixTime.setText("" + EpochUtilInterface.this.uTimeStamp.getSeconds());
            }
        };
        Timer tmrUnixStat = new Timer(1000, tmrInterval);
        tmrUnixStat.setInitialDelay(1000);
        tmrUnixStat.start();
        JTabbedPane tabMenuPane = new JTabbedPane();
        JPanel pnlTimeStamper = new JPanel();
        JPanel pnlDateStamper = new JPanel();
        JPanel pnlControlSetA = new JPanel();
        JPanel pnlControlSetB = new JPanel();
        tabMenuPane.addTab("Time Stamp", new ImageIcon(this.getClass().getResource("media/time.png")), pnlTimeStamper, "Get Timestamps");
        tabMenuPane.setMnemonicAt(0, 49);
        tabMenuPane.addTab("Date Stamp", new ImageIcon(this.getClass().getResource("media/calendar.png")), pnlDateStamper, "Get Datestamps");
        tabMenuPane.setMnemonicAt(1, 50);
        this.add(tabMenuPane);
        tabMenuPane.setTabLayoutPolicy(1);
        pnlTimeStamper.setLayout(null);
        pnlDateStamper.setLayout(null);
        pnlControlSetA.setLayout(new GridLayout(6, 2));
        pnlControlSetB.setLayout(new GridLayout(3, 2));
        pnlControlSetA.add(new JLabel("Date:"));
        pnlControlSetA.add(this.cmbDate);
        pnlControlSetA.add(new JLabel("Month:"));
        pnlControlSetA.add(this.cmbMonth);
        pnlControlSetA.add(new JLabel("Year:"));
        pnlControlSetA.add(this.cmbYear);
        pnlControlSetA.add(new JLabel("Hour:"));
        pnlControlSetA.add(this.cmbHour);
        pnlControlSetA.add(new JLabel("Minute:"));
        pnlControlSetA.add(this.cmbMinute);
        pnlControlSetA.add(new JLabel("Second:"));
        pnlControlSetA.add(this.cmbSecond);
        pnlControlSetB.add(new JLabel("Unix Time:"));
        pnlControlSetB.add(this.txtInputTime);
        pnlControlSetB.add(new JLabel("Time Format:"));
        pnlControlSetB.add(this.txtTimeFormat);
        pnlControlSetB.add(new JLabel("Date Format:"));
        pnlControlSetB.add(this.txtDateFormat);
        pnlControlSetA.setBounds(5, 5, pnlControlSetA.getPreferredSize().width, pnlControlSetA.getPreferredSize().height);
        pnlControlSetB.setBounds(5, 5, 215, pnlControlSetB.getPreferredSize().height);
        pnlTimeStamper.add(pnlControlSetA);
        pnlDateStamper.add(pnlControlSetB);
        pnlTimeStamper.add(this.cbxManual);
        pnlTimeStamper.add(this.cbxUpdate);
        this.cbxManual.setBounds(5, 15 + pnlControlSetA.getHeight(), this.cbxManual.getPreferredSize().width, this.cbxManual.getPreferredSize().height);
        this.cbxUpdate.setBounds(5, (int)(this.cbxManual.getLocation().getY() + (double)this.cbxManual.getHeight()), this.cbxUpdate.getPreferredSize().width, this.cbxUpdate.getPreferredSize().height);
        pnlTimeStamper.add(this.txtUnixTime);
        this.txtUnixTime.setBounds(5, (int)(5.0 + this.cbxUpdate.getLocation().getY() + (double)this.cbxUpdate.getHeight()), pnlControlSetA.getWidth() - 5, this.txtUnixTime.getPreferredSize().height);
        pnlTimeStamper.add(btnClipCopy);
        pnlTimeStamper.add(btnReset);
        btnClipCopy.setBounds(5, (int)(5.0 + this.txtUnixTime.getLocation().getY() + (double)this.txtUnixTime.getHeight()), btnClipCopy.getPreferredSize().width, btnClipCopy.getPreferredSize().height);
        btnReset.setBounds((int)(10.0 + btnClipCopy.getLocation().getX() + (double)btnClipCopy.getWidth()), (int)(5.0 + this.txtUnixTime.getLocation().getY() + (double)this.txtUnixTime.getHeight()), btnReset.getPreferredSize().width, btnReset.getPreferredSize().height);
        pnlDateStamper.add(this.txtMadeDate);
        this.txtMadeDate.setBounds(5, 15 + pnlControlSetB.getHeight(), pnlControlSetB.getWidth() - 5, this.txtMadeDate.getPreferredSize().height);
        pnlDateStamper.add(btnMake);
        pnlDateStamper.add(btnDateCopy);
        btnMake.setBounds(5, (int)(5.0 + this.txtMadeDate.getLocation().getY() + (double)this.txtMadeDate.getHeight()), btnMake.getPreferredSize().width, btnMake.getPreferredSize().height);
        btnDateCopy.setBounds((int)(10.0 + btnMake.getLocation().getX() + (double)btnMake.getWidth()), (int)(5.0 + this.txtMadeDate.getLocation().getY() + (double)this.txtMadeDate.getHeight()), btnDateCopy.getPreferredSize().width, btnDateCopy.getPreferredSize().height);
        JLabel lblNulloxIcon = new JLabel();
        lblNulloxIcon.setIcon(new ImageIcon(this.getClass().getResource("media/logo.png")));
        pnlDateStamper.add(lblNulloxIcon);
        lblNulloxIcon.setBounds(35, 200, lblNulloxIcon.getPreferredSize().width, lblNulloxIcon.getPreferredSize().height);
    }

    @Override
    public void lostOwnership(Clipboard cbClipboard, Transferable tContents) {
    }

    private void doUpdateDaysCombo() {
        this.cmbDate.removeAllItems();
        int i_bound = this.getNumDaysInMonth();
        for (int idx_i = 1; idx_i <= i_bound; ++idx_i) {
            if (idx_i < 10) {
                this.cmbDate.addItem("0" + idx_i);
                continue;
            }
            this.cmbDate.addItem("" + idx_i);
        }
        this.cmbDate.setSelectedIndex(0);
    }

    private int getNumDaysInMonth() {
        switch (this.cmbMonth.getSelectedIndex()) {
            case 0: {
                return 31;
            }
            case 1: {
                if (this.isLeapYear()) {
                    return 29;
                }
                return 28;
            }
            case 2: {
                return 31;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 31;
            }
            case 5: {
                return 30;
            }
            case 6: {
                return 31;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 30;
            }
            case 9: {
                return 31;
            }
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    private String getDateFromUnixTime() {
        if (this.txtInputTime.getText().length() == 0) {
            JOptionPane.showMessageDialog(null, "You need provide a unix timestamp\nto order to retrieve a date", "Lacking Unix Time", 0);
            return "";
        }
        if (!this.isNumeric(this.txtInputTime.getText())) {
            JOptionPane.showMessageDialog(null, "You need provide a valid unix timestamp", "Invalid Unix Time", 0);
            return "";
        }
        long unix_time_ms = Long.parseLong(this.txtInputTime.getText()) * 1000L;
        Calendar cTimeDate = Calendar.getInstance();
        cTimeDate.setTimeInMillis(unix_time_ms);
        String sTimeDate = this.txtTimeFormat.getText();
        sTimeDate = sTimeDate.replaceAll("h", "" + (cTimeDate.get(11) < 10 ? "0" + (cTimeDate.get(11) - 1) : Integer.valueOf(cTimeDate.get(11) - 1)));
        sTimeDate = sTimeDate.replaceAll("m", "" + (cTimeDate.get(12) < 10 ? "0" + cTimeDate.get(12) : Integer.valueOf(cTimeDate.get(12))));
        sTimeDate = sTimeDate.replaceAll("s", "" + (cTimeDate.get(13) < 10 ? "0" + cTimeDate.get(13) : Integer.valueOf(cTimeDate.get(13))));
        sTimeDate = sTimeDate + " " + this.txtDateFormat.getText();
        sTimeDate = sTimeDate.replaceAll("d", "" + (cTimeDate.get(5) < 10 ? "0" + cTimeDate.get(5) : Integer.valueOf(cTimeDate.get(5))));
        sTimeDate = sTimeDate.replaceAll("m", "" + (cTimeDate.get(2) + 1 < 10 ? "0" + (cTimeDate.get(2) + 1) : Integer.valueOf(cTimeDate.get(2) + 1)));
        sTimeDate = sTimeDate.replaceAll("y", "" + cTimeDate.get(1));
        return sTimeDate;
    }

    private boolean isLeapYear() {
        int i_year = Integer.parseInt(this.cmbYear.getSelectedItem().toString());
        return i_year % 400 == 0 || i_year % 4 == 0 && i_year % 100 != 0;
    }

    private boolean isNumeric(String sText) {
        try {
            Integer.parseInt(sText);
            return true;
        }
        catch (Exception exErr) {
            return false;
        }
    }

    private void setClipboardContents(String sText) {
        StringSelection ssBuffer = new StringSelection(sText);
        Clipboard cbSystem = Toolkit.getDefaultToolkit().getSystemClipboard();
        cbSystem.setContents(ssBuffer, this);
    }
}

