/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;

class EpochUtil {
    private int mDate = 1;
    private int mMonth = 0;
    private int mYear = 1970;
    private int mHour = 1;
    private int mMinute = 0;
    private int mSecond = 0;
    private Calendar mCalendar = Calendar.getInstance();

    public void doRefresh() {
        this.mCalendar = Calendar.getInstance();
    }

    public void doReset() {
        this.mCalendar.set(1, 1970);
        this.mCalendar.set(2, 0);
        this.mCalendar.set(5, 1);
        this.mCalendar.set(11, 1);
        this.mCalendar.set(12, 0);
        this.mCalendar.set(13, 0);
    }

    public Calendar getCalendar() {
        return this.mCalendar;
    }

    public EpochUtil getPresent() {
        this.mCalendar = Calendar.getInstance();
        return this;
    }

    public long getSeconds() {
        return this.mCalendar.getTimeInMillis() / 1000L;
    }

    public boolean isYearLeap() {
        return this.mYear % 400 == 0 || this.mYear % 4 == 0 && this.mYear % 100 != 0;
    }

    public void set(int date, int month, int year, int hour, int minute, int second) {
        this.setDate(date);
        this.setMonth(month);
        this.setYear(year);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
    }

    public void setDate(int date) {
        this.mDate = date;
        this.doUpdate();
    }

    public void setHour(int hour) {
        this.mHour = hour + 1;
        this.doUpdate();
    }

    public void setMinute(int minute) {
        this.mMinute = minute;
        this.doUpdate();
    }

    public void setMonth(int month) {
        this.mMonth = month;
        this.doUpdate();
    }

    public void setSecond(int seconds) {
        this.mSecond = seconds;
        this.doUpdate();
    }

    public void setYear(int year) {
        this.mYear = year;
        this.doUpdate();
    }

    private void doUpdate() {
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(2, this.getMonthConstant(this.mMonth));
        this.mCalendar.set(5, this.mDate);
        this.mCalendar.set(11, this.mHour);
        this.mCalendar.set(12, this.mMinute);
        this.mCalendar.set(13, this.mSecond);
    }

    private int getMonthConstant(int month_idx) {
        switch (month_idx) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
        }
        return 11;
    }
}

