/*  
**  bios.h		ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail uunet!microway!mark
**			       mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _BIOS_H
#define _BIOS_H

#ifndef _OS_H

struct diskinfo_t {
    unsigned drive;
    unsigned head;
    unsigned track;
    unsigned sector;
    unsigned nsectors;
    unsigned bytes_per_sector;
    char     *buffer;
    };

#define _COM_CHR7         2
#define _COM_CHR8         3
#define _COM_STOP1        0
#define _COM_STOP2        4
#define _COM_NOPARITY     0
#define _COM_EVENPARITY  24
#define _COM_ODDPARITY    8
#define _COM_110          0
#define _COM_150         32
#define _COM_300         64
#define _COM_600         96
#define _COM_1200       128
#define _COM_2400       160
#define _COM_4800       192
#define _COM_9600       224
#define _COM_INIT         0
#define _COM_SEND         1
#define _COM_RECEIVE      2
#define _COM_STATUS       3

#define _DISK_RESET     0   /* reset disk controller */
#define _DISK_STATUS    1   /* get disk status */
#define _DISK_READ      2   /* read disk sectors */
#define _DISK_WRITE     3   /* write disk sectors */
#define _DISK_VERIFY    4   /* verify disk sectors */
#define _DISK_FORMAT    5   /* format disk track */

#define _PRINTER_WRITE    0
#define _PRINTER_INIT     1
#define _PRINTER_STATUS   2

#define _KEYBRD_READ               0
#define _KEYBRD_READY              1
#define _KEYBRD_SHIFTSTATUS        2
#define _NKEYBRD_READ           0x10
#define _NKEYBRD_READY          0x11
#define _NKEYBRD_SHIFTSTATUS    0x12

#define _TIME_GETCLOCK 0
#define _TIME_SETCLOCK 1

struct DOUBLEREGS {     /* Double-word registers. */
    unsigned long   eax;
    unsigned long   ebx;
    unsigned long   ecx;
    unsigned long   edx;
    unsigned long   esi;
    unsigned long   edi;
    unsigned long   eflag;
    };

struct WORDREGS {       /* Word registers. */
    unsigned short  ax, l_ax;
    unsigned short  bx, l_bx;
    unsigned short  cx, l_cx;
    unsigned short  dx, l_dx;
    unsigned short  si, l_si;
    unsigned short  di, l_di;
    unsigned short  cflag, l_cflag;
    };

struct BYTEREGS {       /* Byte registers. */
    unsigned char   al, ah, l_al, l_ah;
    unsigned char   bl, bh, l_bl, l_bh;
    unsigned char   cl, ch, l_cl, l_ch;
    unsigned char   dl, dh, l_dl, l_dh;
    unsigned long   esi;
    unsigned long   edi;
    unsigned char   flag, lr_flag, rl_flag, ll_flag;
    };

union REGS {
    struct DOUBLEREGS   d;
    struct WORDREGS     w;
    struct BYTEREGS     b;
    };

/* Segment register structure is used by
   rm_int386, int386x, int86x, intdosx,
   and segread  */

struct SREGS {          /* Segment registers. */
    unsigned short es,cs,ss,ds;
    };

/* 16-bit register structure is used by int86, intdos, int86x, intdosx */

struct WORDREGS16 {       /* Word registers. */
    unsigned short  ax;
    unsigned short  bx;
    unsigned short  cx;
    unsigned short  dx;
    unsigned short  si;
    unsigned short  di;
    unsigned short  cflag;
    };

struct BYTEREGS16 {       /* Byte registers. */
    unsigned char   al, ah;
    unsigned char   bl, bh;
    unsigned char   cl, ch;
    unsigned char   dl, dh;
    unsigned short  si;
    unsigned short  di;
    unsigned short  cflag;
    };

union REGS16 {
    struct WORDREGS16   x;
    struct BYTEREGS16   h;
    };

#endif /* _OS_H */

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

unsigned _bios_disk(unsigned _Service, struct diskinfo_t *_Info);
unsigned _bios_equiplist(void);
unsigned _bios_keybrd(unsigned _Service);
unsigned _bios_memsize(void);
unsigned _bios_printer(unsigned _Service, unsigned _Printer, unsigned _Data);
unsigned _bios_serialcom(unsigned _Service, unsigned _Port, unsigned _Data);
unsigned _bios_timeofday(unsigned _Service, long *_Clockcount);
void      int386(int _Interrupt, union REGS *_Inregs, union REGS *_Outregs);
void      int386x(int _Interrupt, union REGS *_Inregs, union REGS *_Outregs,
                struct SREGS *_Sregs);
int       int86(int _Interrupt, union REGS16 *_Inregs,
                union REGS16 *_Outregs);
int       int86x(int _Interrupt, union REGS16 *_Inregs, 
                union REGS16 *_Outregs, struct SREGS *_Sregs);
int       intdos(union REGS16 *_Inregs, union REGS16 *_Outregs);
int       intdosx(union REGS16 *_Inregs, union REGS16 *_Outregs,
                struct SREGS *_Sregs);

#ifdef __NDPX__         /* C++ */
   }
#endif

#else /* K&R */

unsigned _bios_disk();
unsigned _bios_equiplist();
unsigned _bios_keybrd();
unsigned _bios_memsize();
unsigned _bios_printer();
unsigned _bios_serialcom();
unsigned _bios_timeofday();
void      int386();
void      int386x();
int       int86();
int       int86x();
int       intdos();
int       intdosx();

#endif /* __STDC__ || __NDPX__ */

#endif /* _BIOS_H */
