/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.campi;

import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.campi.NonCoerenzaException;
import finanze.IDTE.studi2002.generale.CheckDigit;
import finanze.IDTE.studi2002.generale.CkPartitaIva;
import finanze.IDTE.studi2002.generale.MetodiUtili;

public class CodFiscModel
extends GericoModel {
    private boolean nuovo;
    private boolean omoCodiceImpostato;
    private int modelloDich;
    private String valorePredefinito = "";
    private boolean obbligatorio;
    private boolean isCodFisc;
    private boolean omoCodice;
    private CheckDigit checkCF = new CheckDigit();
    private CkPartitaIva checkPIVA = new CkPartitaIva();

    public CodFiscModel(String string, String descrizione, boolean obbligatorio) {
        super(string, descrizione, 16);
        this.obbligatorio = obbligatorio;
        this.omoCodice = true;
        this.omoCodiceImpostato = false;
        this.isCodFisc = false;
        String codice = "";
        this.nuovo = true;
        this.modelloDich = 0;
        this.setValorePredefinito();
    }

    /*
     * Unable to fully structure code
     */
    public boolean codiceValido(String s) {
        block5: {
            if (s == null || s.length() == 0) {
                return false;
            }
            testo = s.trim();
            if (!this.controlloPosizionale(0, testo)) break block5;
            if (!this.isCodFisc()) ** GOTO lbl12
            if (testo.length() < 16) {
                return false;
            }
            if (this.getOmoCodice()) {
                return true;
            }
            return this.getCheckCF().checkcontrol(testo);
lbl-1000:
            // 1 sources

            {
                testo = "0" + testo;
lbl12:
                // 2 sources

                ** while (testo.length() < 11)
            }
lbl13:
            // 1 sources

            codiceUfficioIVA = testo.substring(7, 10);
            cod = Integer.parseInt(codiceUfficioIVA);
            if (cod >= 1 && cod <= 100 || cod == 120 || cod == 121) {
                return this.getCheckPIVA().controlPartIva(testo);
            }
            return false;
        }
        return false;
    }

    public boolean controllaSpazi(String codice) {
        if (codice.length() == 16) {
            if (codice.trim().length() == 0) {
                return !this.obbligatorio;
            }
            if (this.isCodFisc()) {
                return this.codiceValido(codice);
            }
            if (!this.isCodFisc()) {
                String ch;
                int offset = 1;
                while (offset <= 11) {
                    ch = codice.substring(offset - 1, offset);
                    if (ch.equals(" ")) {
                        return false;
                    }
                    ++offset;
                }
                offset = 12;
                while (offset <= 16) {
                    ch = codice.substring(offset - 1, offset);
                    if (!ch.equals(" ")) {
                        return false;
                    }
                    ++offset;
                }
                return this.codiceValido(codice.trim());
            }
        }
        return true;
    }

    public boolean controlloPosizionale(int n, String testo) {
        int offset;
        int lunghezza = testo.length();
        if (this.isCodFisc()) {
            if (lunghezza > 16) {
                return false;
            }
            boolean esito = true;
            int i = 1;
            while (i <= lunghezza) {
                String ch = testo.substring(i - 1, i);
                offset = i;
                if (offset <= 6 || offset == 9 || offset == 12) {
                    if (offset == 12 && this.omoCodice) {
                        if (!this.lettere_numeri(ch)) {
                            esito = false;
                            return esito;
                        }
                    } else if (!this.lettere(ch)) {
                        esito = false;
                        return esito;
                    }
                } else if (offset == 7 || offset == 8 || offset == 10 || offset == 11 || offset == 13 || offset == 14 || offset == 15) {
                    if ((offset == 13 || offset == 14 || offset == 15) && this.omoCodice) {
                        if (!this.lettere_numeri(ch)) {
                            esito = false;
                            return esito;
                        }
                    } else if (!this.numeri(ch)) {
                        esito = false;
                        return esito;
                    }
                }
                ++i;
            }
            if (esito && lunghezza == 16) {
                if (!this.omoCodice) {
                    return this.getCheckCF().checkcontrol(testo.toUpperCase());
                }
                esito = this.lettere_numeri(testo.substring(15, 16));
            }
            return esito;
        }
        if (lunghezza > 11) {
            return false;
        }
        boolean esito = true;
        int i = 1;
        while (i <= lunghezza) {
            offset = i;
            String ch = testo.substring(i - 1, i);
            if (!this.numeri(ch)) {
                esito = false;
                return esito;
            }
            ++i;
        }
        return esito;
    }

    private CheckDigit getCheckCF() {
        return this.checkCF;
    }

    private CkPartitaIva getCheckPIVA() {
        return this.checkPIVA;
    }

    private boolean getOmoCodice() {
        return this.omoCodice;
    }

    public String getValorePredefinito() {
        return this.valorePredefinito;
    }

    public String getValue() {
        return this.valore;
    }

    public boolean isCodFisc() {
        return this.isCodFisc;
    }

    private boolean isCodFisc(String codice) {
        if (codice == null || codice.length() != 16) {
            return false;
        }
        boolean esito = true;
        int offset = 1;
        while (offset <= 15) {
            String ch = codice.substring(offset - 1, offset);
            if (offset <= 6 || offset == 9 || offset == 12) {
                if (offset == 12 && this.omoCodice) {
                    if (!this.lettere_numeri(ch.toUpperCase())) {
                        esito = false;
                        break;
                    }
                } else if (!this.lettere(ch.toUpperCase())) {
                    esito = false;
                    break;
                }
            } else if ((offset == 13 || offset == 14 || offset == 15) && this.omoCodice) {
                if (!this.lettere_numeri(ch.toUpperCase())) {
                    esito = false;
                    break;
                }
            } else if (!this.numeri(ch.toUpperCase())) {
                esito = false;
                break;
            }
            ++offset;
        }
        if (!this.omoCodice && esito) {
            esito = this.getCheckCF().checkcontrol(codice.toUpperCase());
        }
        return esito;
    }

    private boolean isPartitaIVA(String codice) {
        if (codice.length() != 11) {
            return false;
        }
        boolean esito = true;
        int offset = 1;
        while (offset <= 11) {
            String ch = codice.substring(offset - 1, offset);
            if (!this.numeri(ch.toUpperCase())) {
                esito = false;
                break;
            }
            ++offset;
        }
        if (esito) {
            boolean ufficioIVA;
            String codiceUfficioIVA = codice.substring(7, 10);
            int cod = Integer.parseInt(codiceUfficioIVA);
            boolean bl = ufficioIVA = cod >= 1 && cod <= 100 || cod >= 120 && cod <= 121;
            if (!ufficioIVA) {
                esito = false;
            }
        }
        if (esito) {
            esito = this.getCheckPIVA().controlPartIva(codice);
        }
        return esito;
    }

    public boolean isValorePredefinito() {
        return false;
    }

    protected boolean lettere(String c) {
        return "ABCDEFGHIJKLMNOPQSRTUVXYWZ".indexOf(c.toUpperCase()) != -1;
    }

    protected boolean lettere_numeri(String c) {
        return "0123456789ABCDEFGHIJKLMNOPQSRTUVXYWZ".indexOf(c.toUpperCase()) != -1;
    }

    private String messaggioDiErrore(String codice, int modelloDich, boolean omoCodice) {
        if (this.omoCodiceImpostato && omoCodice && modelloDich > 3) {
            this.errore = "802";
            this.gravitaErrore = "scarto_confermabile";
            return " Il modello di dichiarazione non e' coerente con il flag omoCodice ";
        }
        boolean codiceFiscaleValido = this.isCodFisc(codice);
        boolean partitaIvaValida = this.isPartitaIVA(codice);
        if (!codiceFiscaleValido && !partitaIvaValida && this.omoCodiceImpostato) {
            this.errore = "012";
            this.gravitaErrore = "scarto_confermabile";
            return "Il codice impostato non e' un " + this.errorDescription + " valido";
        }
        if (this.omoCodiceImpostato && partitaIvaValida && omoCodice) {
            this.errore = "810";
            this.gravitaErrore = "scarto_confermabile";
            return "Il campo " + this.errorDescription + " non e' coerente con il flag omoCodice";
        }
        if (codiceFiscaleValido && modelloDich >= 4) {
            this.errore = "802";
            this.gravitaErrore = "scarto_confermabile";
            return "Il campo " + this.errorDescription + " non e' coerente il modello di dichiarazione";
        }
        if (partitaIvaValida && modelloDich >= 1 && modelloDich <= 3) {
            this.errore = "802";
            this.gravitaErrore = "scarto_confermabile";
            return "Il campo " + this.errorDescription + " non e' coerente il modello di dichiarazione";
        }
        return null;
    }

    protected boolean numeri(String c) {
        return "0123456789".indexOf(c.toUpperCase()) != -1;
    }

    private void setCodFisc(boolean isCodFisc) {
        this.isCodFisc = isCodFisc;
    }

    public void setModelloDichiarazione(int modelloDich) throws NonCoerenzaException {
        String primoCar = this.valore.substring(0, 1);
        if (this.numeri(primoCar)) {
            if (modelloDich >= 1 && modelloDich <= 3) {
                this.errore = "802";
                this.gravitaErrore = "scarto_confermabile";
                throw new NonCoerenzaException(String.valueOf(modelloDich));
            }
        } else if (this.lettere(primoCar) && modelloDich > 3) {
            this.errore = "802";
            this.gravitaErrore = "scarto_confermabile";
            throw new NonCoerenzaException(String.valueOf(modelloDich));
        }
        this.modelloDich = modelloDich;
    }

    public void setOmo(boolean omoCodice) {
        this.omoCodice = omoCodice;
    }

    public void setOmoCodice(boolean omo) throws NonCoerenzaException {
        this.omoCodiceImpostato = true;
        this.omoCodice = omo;
        boolean codiceFiscaleValido = this.isCodFisc(this.valore);
        boolean partitaIvaValida = this.isPartitaIVA(this.valore);
        if (!codiceFiscaleValido && !partitaIvaValida && this.omoCodiceImpostato) {
            this.errore = "012";
            this.gravitaErrore = "scarto_confermabile";
            throw new NonCoerenzaException(this.valore);
        }
        if (this.omoCodiceImpostato && partitaIvaValida && this.omoCodice) {
            this.errore = "810";
            this.gravitaErrore = "scarto_confermabile";
            throw new NonCoerenzaException(this.valore);
        }
    }

    public void setValore(String string) throws ControlloFormaleException {
        String valore = string.trim();
        if (this.getCode().equalsIgnoreCase("CodiceFiscaleCAF") && valore.length() != 0 && this.numeri(valore.substring(0, 1))) {
            valore = MetodiUtili.formattaStringa(valore, 11, 0, '0');
        }
        if (valore.length() == 0) {
            if (this.obbligatorio) {
                this.errore = "012";
                this.gravitaErrore = "scarto_confermabile";
                throw new ControlloFormaleException(valore);
            }
            return;
        }
        String primoCar = valore.substring(0, 1);
        if (this.numeri(primoCar)) {
            this.setCodFisc(false);
            if (valore.length() != 11) {
                this.errore = "020";
                this.gravitaErrore = "scarto";
                this.valore = MetodiUtili.formattaStringa(valore, 11, 0, '0');
                throw new ControlloFormaleException(valore);
            }
        } else if (this.lettere(primoCar)) {
            this.setCodFisc(true);
            if (valore.length() != 16) {
                this.errore = "020";
                this.gravitaErrore = "scarto";
                throw new ControlloFormaleException(valore);
            }
        }
        this.valore = valore.toUpperCase();
    }

    public void setValorePredefinito() {
        this.valore = this.valorePredefinito;
    }
}

