/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2002;

import finanze.IDTE.generale2002.BaseTelem;
import finanze.IDTE.generale2002.Campo;
import finanze.IDTE.generale2002.Diagnostici;
import finanze.IDTE.generale2002.Dichiarazione;
import finanze.IDTE.generale2002.Globali;
import finanze.IDTE.generale2002.Util;
import finanze.IDTE.generale2002.Vincoli2001;
import finanze.IDTE.resources.Controlli;
import finanze.IDTE.resources.ControlliCampo;
import finanze.IDTE.resources.RecordParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Modello {
    protected RecordParser recordA;
    protected RecordParser recordB;
    protected RecordParser recordZ;
    protected Dichiarazione dich = new Dichiarazione();
    protected Globali varGlob = new Globali();
    protected Globali maxQuadri = new Globali();
    protected String TIPO_MODELLO;
    protected String ANNO;
    protected boolean flagConferma = false;
    public boolean flagFornitoreUfficio = false;

    public Modello() {
        this(null, new Dichiarazione());
    }

    public Modello(RecordParser recordB, Dichiarazione dichiarazione) {
        this.recordB = recordB;
        this.dich = dichiarazione;
        String modClassName = this.getClass().getName();
        this.TIPO_MODELLO = modClassName.substring(modClassName.length() - 5, modClassName.length() - 2);
        this.ANNO = modClassName.substring(modClassName.length() - 2);
    }

    public double AD(int indice) {
        try {
            return Util.valoreDouble(this.recordA.prendiValore(indice).trim());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public int AI(int indice) {
        try {
            return Integer.parseInt(this.recordA.prendiValore(indice).trim());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long AL(int indice) {
        try {
            return Long.parseLong(this.recordA.prendiValore(indice).trim());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String AS(int indice) {
        return this.recordA.prendiValore(indice);
    }

    public boolean B(String codice, String range) {
        return Util.isInside(Long.parseLong(this.getDichiarazione().prendiValoreCampo(codice)), range);
    }

    public double BD(int indice) {
        try {
            return Util.valoreDouble(this.recordB.prendiValore(indice).trim());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public int BI(int indice) {
        try {
            return Integer.parseInt(this.recordB.prendiValore(indice).trim());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long BL(int indice) {
        try {
            return Long.parseLong(this.recordB.prendiValore(indice).trim());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String BS(int indice) {
        return this.recordB.prendiValore(indice);
    }

    private int casoANPR(String codice, Campo mioCampo) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 1 || this.getControlli().getFormato(appoCodiceD) == 4) {
            String s = mioCampo.getValore().trim();
            mioCampo.setValore(s);
            this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
            if (BaseTelem.currentSystem != 0) {
                this.getDichiarazione().addElementSort(mioCampo);
            }
        }
        return rc;
    }

    private int casoCB(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 300) {
            String s = mioCampo.getValore().trim();
            if (s.equals("1") || s.equals("0")) {
                if (s.equals("1")) {
                    mioCampo.setValore(s.trim());
                    this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                    if (BaseTelem.currentSystem != 0) {
                        this.getDichiarazione().addElementSort(mioCampo);
                    }
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoCBx(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        int formato = this.getControlli().getFormato(appoCodiceD);
        int lc = formato % 100;
        if (formato / 100 == 3 && 1 <= lc && lc <= 16) {
            String s = mioCampo.getValore().trim();
            if (s.length() == lc) {
                boolean errore = false;
                int i = 0;
                int zeri = 0;
                while (!errore && i < lc) {
                    if (s.charAt(i) != '1' && s.charAt(i) != '0') {
                        errore = true;
                    }
                    if (s.charAt(i) == '0') {
                        ++zeri;
                    }
                    ++i;
                }
                if (!errore) {
                    if (i != zeri) {
                        mioCampo.setValore(s.trim());
                        this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(mioCampo);
                        }
                    }
                } else {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoCFPI(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 2 || this.getControlli().getFormato(appoCodiceD) == 3) {
            String s = mioCampo.getValore().trim();
            if (s.length() == 16) {
                mioCampo.setValore(s);
                this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                if (BaseTelem.currentSystem != 0) {
                    this.getDichiarazione().addElementSort(mioCampo);
                }
            } else if (s.length() == 11) {
                mioCampo.setValore(s);
                this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                if (BaseTelem.currentSystem != 0) {
                    this.getDichiarazione().addElementSort(mioCampo);
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoDA(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 5) {
            String s = mioCampo.getValore().trim();
            if (Util.numerico(s) && s.indexOf(46) == -1 && s.indexOf(44) == -1) {
                if (s.length() == 4) {
                    if (Long.parseLong(s) != 0L) {
                        mioCampo.setValore(s);
                        this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(mioCampo);
                        }
                    }
                } else {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1011", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoDT(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 200) {
            String s = mioCampo.getValore().trim();
            if (Util.numerico(s) && s.indexOf(46) == -1 && s.indexOf(44) == -1 && s.length() <= 8) {
                mioCampo.setValore(Util.formNum(8, Long.parseLong(s)));
                this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                if (BaseTelem.currentSystem != 0) {
                    this.getDichiarazione().addElementSort(mioCampo);
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoDx(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        int formato = this.getControlli().getFormato(appoCodiceD);
        int lc = formato % 100;
        if (formato / 100 == 2 && 1 <= lc && lc <= 16) {
            String s = mioCampo.getValore().trim();
            if (Util.numerico(s) && s.indexOf(46) == -1 && s.indexOf(44) == -1) {
                if (s.length() <= lc) {
                    if (Long.parseLong(s) != 0L) {
                        mioCampo.setValore(Util.formNum(lc, Long.parseLong(s)));
                        this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(mioCampo);
                        }
                    }
                } else {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1011", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoNP(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 10) {
            String s = mioCampo.getValore().trim();
            if (Util.numerico(s) && s.indexOf(46) == -1 && s.indexOf(44) == -1) {
                if (Long.parseLong(s) >= 0L) {
                    if (Long.parseLong(s) != 0L) {
                        mioCampo.setValore(s);
                        this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(mioCampo);
                        }
                    }
                } else {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1078", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1011", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoNU(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 100) {
            String s = mioCampo.getValore().trim();
            if (Util.numerico(s) && s.indexOf(46) == -1 && s.indexOf(44) == -1) {
                if (Long.parseLong(s) != 0L) {
                    mioCampo.setValore(s);
                    this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                    if (BaseTelem.currentSystem != 0) {
                        this.getDichiarazione().addElementSort(mioCampo);
                    }
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1011", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoNx(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        int formato = this.getControlli().getFormato(appoCodiceD);
        int lc = formato % 100;
        if (formato / 100 == 1 && 1 <= lc && lc <= 16) {
            String s = mioCampo.getValore().trim();
            if (Util.numerico(s) && s.indexOf(46) == -1 && s.indexOf(44) == -1) {
                if (s.length() <= lc) {
                    if (Long.parseLong(s) != 0L) {
                        mioCampo.setValore(Util.formNum(lc, Long.parseLong(s)));
                        this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(mioCampo);
                        }
                    }
                } else {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1011", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoPC(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 6) {
            String s = mioCampo.getValore().trim();
            if (Util.numerico(s) && s.indexOf(46) == -1) {
                String s2 = s.replace(',', '.');
                if (Util.valoreDouble(s2) <= 100.0 && Util.valoreDouble(s2) >= 0.0) {
                    mioCampo.setValore(s);
                    this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                    if (BaseTelem.currentSystem != 0) {
                        this.getDichiarazione().addElementSort(mioCampo);
                    }
                } else {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1012", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    private int casoQU(String codice, Campo mioCampo, String cfPerc) {
        String codiceDa6;
        String appoCodiceD = codiceDa6 = codice.substring(0, 8);
        if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
        }
        int rc = 0;
        if (this.getControlli().getFormato(appoCodiceD) == 7) {
            String s = mioCampo.getValore().trim();
            if (Util.numerico(s) && s.indexOf(46) == -1) {
                if (Double.valueOf(Util.replaceString(s, ",", ".")) != 0.0) {
                    mioCampo.setValore(s);
                    this.maxQuadri.aggiornaModulo(mioCampo.getQuadro(), Util.valoreInt(mioCampo.getNumModello()));
                    if (BaseTelem.currentSystem != 0) {
                        this.getDichiarazione().addElementSort(mioCampo);
                    }
                }
            } else {
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
        }
        return rc;
    }

    public int controllaFissaA() {
        int rc = 0;
        int i = 0;
        Enumeration listaRecordA = this.recordA.elements();
        while (listaRecordA.hasMoreElements()) {
            String valore = (String)listaRecordA.nextElement();
            int controllo = this.getRecordAcontrolli().getFormatoAt(i);
            this.getRecordAcontrolli().getVincoliAt(i);
            String cod = "XXA" + Util.formNum(2, i + 1);
            if (!(controllo != 100 && controllo != 200 || Util.numerico(valore) && valore.indexOf(46) == -1 && valore.indexOf(44) == -1 && valore.indexOf(32) == -1)) {
                rc = Diagnostici.DIA(rc, 4, "AAAAAAAAAAAAAAAA", "1011", cod, valore, "");
                valore = "0";
                if (controllo == 200) {
                    valore = "00000000";
                }
                this.recordA.impostaValore(valore, i + 1);
            }
            ++i;
        }
        return rc;
    }

    public int controllaFissaB() {
        int rc = 0;
        int i = 0;
        Enumeration listaRecordB = this.recordB.elements();
        while (listaRecordB.hasMoreElements()) {
            String valore = (String)listaRecordB.nextElement();
            int controllo = this.getRecordBcontrolli().getFormatoAt(i);
            this.getRecordBcontrolli().getVincoliAt(i);
            String cod = "";
            cod = i > 98 && i <= 198 ? "XXX" + Util.formNum(2, i - 100 + 1) : (i > 198 ? "XXY" + Util.formNum(2, i - 200 + 1) : "XXB" + Util.formNum(2, i + 1));
            if (controllo == 8) {
                this.recordB.impostaValore("", i + 1);
            }
            if (controllo == 9) {
                this.recordB.impostaValore("0", i + 1);
            }
            if (controllo == 100 || controllo == 200) {
                if (valore.trim().length() == 0) {
                    valore = Util.formNum(valore.length(), "0");
                    this.recordB.impostaValore(valore, i + 1);
                }
                if (!Util.isNumericoAssoluto(valore)) {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1011", cod, valore, "");
                    valore = "0";
                    if (controllo == 200) {
                        valore = "00000000";
                    }
                    this.recordB.impostaValore(valore, i + 1);
                }
            }
            if (controllo == 199) {
                if (valore.trim().length() == 0) {
                    valore = "0000000000000";
                    this.getRecordB().impostaValore(valore, i + 1);
                }
                if (!Util.numerico(valore) || valore.indexOf(46) != -1 || valore.indexOf(44) != -1) {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1011", cod, valore, "");
                    valore = "0000000000000";
                    this.getRecordB().impostaValore(valore, i + 1);
                }
            }
            if (controllo == 2 && valore.trim().length() != 16 && valore.trim().length() != 11 && valore.trim().length() != 0) {
                this.recordB.impostaValore("", i + 1);
                rc = Diagnostici.DIA(rc, 16, this.BS(2), "1030", cod, valore, "");
            }
            ++i;
        }
        return rc;
    }

    public int controllaFissaZ() {
        int rc = 0;
        int i = 0;
        Enumeration listaRecordZ = this.recordZ.elements();
        while (listaRecordZ.hasMoreElements()) {
            String valore = (String)listaRecordZ.nextElement();
            int controllo = this.getRecordZcontrolli().getFormatoAt(i);
            String cod = "XXZ" + Util.formNum(2, i + 1);
            if (!(controllo != 100 && controllo != 200 || Util.numerico(valore) && valore.indexOf(46) == -1 && valore.indexOf(44) == -1 && valore.indexOf(32) == -1)) {
                rc = Diagnostici.DIA(rc, 4, "ZZZZZZZZZZZZZZZZ", "1011", cod, valore, "");
                valore = "0";
                if (controllo == 200) {
                    valore = "00000000";
                }
                this.recordZ.impostaValore(valore, i + 1);
            }
            ++i;
        }
        return rc;
    }

    public void controlliFormaliAssistenza(String quadro) {
        Enumeration listaCampi = this.getDichiarazione().elements();
        while (listaCampi.hasMoreElements()) {
            Campo mioCampo = (Campo)listaCampi.nextElement();
            if (!quadro.equals(mioCampo.getQuadro())) continue;
            this.casoANPR(mioCampo.getCodice(), mioCampo);
            this.casoCB(mioCampo.getCodice(), mioCampo, "");
            this.casoCBx(mioCampo.getCodice(), mioCampo, "");
            this.casoCFPI(mioCampo.getCodice(), mioCampo, "");
            this.casoDA(mioCampo.getCodice(), mioCampo, "");
            this.casoDT(mioCampo.getCodice(), mioCampo, "");
            this.casoDx(mioCampo.getCodice(), mioCampo, "");
            this.casoNP(mioCampo.getCodice(), mioCampo, "");
            this.casoNU(mioCampo.getCodice(), mioCampo, "");
            this.casoNx(mioCampo.getCodice(), mioCampo, "");
            this.casoPC(mioCampo.getCodice(), mioCampo, "");
            this.casoQU(mioCampo.getCodice(), mioCampo, "");
        }
    }

    public void controlliFormaliAssistenza(String codice, Campo mioCampo) {
        this.casoANPR(codice, mioCampo);
        this.casoCB(codice, mioCampo, "");
        this.casoCBx(codice, mioCampo, "");
        this.casoCFPI(codice, mioCampo, "");
        this.casoDA(codice, mioCampo, "");
        this.casoDT(codice, mioCampo, "");
        this.casoDx(codice, mioCampo, "");
        this.casoNP(mioCampo.getCodice(), mioCampo, "");
        this.casoNU(codice, mioCampo, "");
        this.casoNx(codice, mioCampo, "");
        this.casoPC(codice, mioCampo, "");
        this.casoQU(codice, mioCampo, "");
    }

    public void controlliFormaliAssistenza(String quadro, String modulo) {
        Enumeration listaCampi = this.getDichiarazione().elements();
        while (listaCampi.hasMoreElements()) {
            Campo mioCampo = (Campo)listaCampi.nextElement();
            if (!quadro.equals(mioCampo.getQuadro()) || !modulo.equals(mioCampo.getNumModello())) continue;
            this.casoANPR(mioCampo.getCodice(), mioCampo);
            this.casoCB(mioCampo.getCodice(), mioCampo, "");
            this.casoCBx(mioCampo.getCodice(), mioCampo, "");
            this.casoCFPI(mioCampo.getCodice(), mioCampo, "");
            this.casoDA(mioCampo.getCodice(), mioCampo, "");
            this.casoDT(mioCampo.getCodice(), mioCampo, "");
            this.casoDx(mioCampo.getCodice(), mioCampo, "");
            this.casoNP(mioCampo.getCodice(), mioCampo, "");
            this.casoNU(mioCampo.getCodice(), mioCampo, "");
            this.casoNx(mioCampo.getCodice(), mioCampo, "");
            this.casoPC(mioCampo.getCodice(), mioCampo, "");
            this.casoQU(mioCampo.getCodice(), mioCampo, "");
        }
    }

    public double D(String s) {
        return Util.valoreDouble(this.getDichiarazione().prendiValoreCampo(s));
    }

    public String getCodiceFornitura() {
        return String.valueOf(this.TIPO_MODELLO) + this.ANNO;
    }

    public Controlli getControlli() {
        return BaseTelem.getInstance().getControlli(this.TIPO_MODELLO);
    }

    public Dichiarazione getDichiarazione() {
        if (this.dich == null) {
            try {
                this.dich = new Dichiarazione();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating dichiarazione property.");
            }
        }
        return this.dich;
    }

    public boolean getFlagConferma() {
        return this.flagConferma;
    }

    public String getModName() {
        return String.valueOf(this.TIPO_MODELLO) + this.ANNO;
    }

    public Controlli getRecordAcontrolli() {
        return BaseTelem.getInstance().getRecordAcontrolli();
    }

    public RecordParser getRecordB() {
        return this.recordB;
    }

    public Controlli getRecordBcontrolli() {
        return BaseTelem.getInstance().getRecordBcontrolli();
    }

    public Controlli getRecordZcontrolli() {
        return BaseTelem.getInstance().getRecordZcontrolli();
    }

    public Globali getVarGlob() {
        return this.varGlob;
    }

    public int I(String s) {
        return Integer.parseInt(this.getDichiarazione().prendiValoreCampo(s));
    }

    public boolean isFornitoreInternet() {
        boolean societ\u00e0CheInviaSuaDich;
        int tipoFornitore = this.AI(4);
        boolean bl = societ\u00e0CheInviaSuaDich = tipoFornitore == 9 && this.AS(5).trim().equals(this.BS(2).trim());
        return tipoFornitore == 1 || tipoFornitore == 2 || tipoFornitore == 6 || tipoFornitore == 13 || societ\u00e0CheInviaSuaDich;
    }

    public long L(String s) {
        return Long.parseLong(this.getDichiarazione().prendiValoreCampo(s));
    }

    public void liquidaAssistenza(String quadro, String modulo) {
    }

    public int preliquida() {
        String codiceDa6 = "";
        String codice = "";
        String vincolo = "";
        int RcV = 0;
        String col = "";
        int rc = 0;
        Vincoli2001 vin = new Vincoli2001();
        Enumeration listaDichiarazione = this.getDichiarazione().elements();
        boolean errore = false;
        while (listaDichiarazione.hasMoreElements()) {
            Campo mioCampo = (Campo)listaDichiarazione.nextElement();
            codiceDa6 = String.valueOf(mioCampo.getQuadro()) + mioCampo.getRiga() + mioCampo.getColonna();
            codice = String.valueOf(codiceDa6) + mioCampo.getNumModello();
            int controllo = this.getControlli().getFormato(codiceDa6);
            vincolo = this.getControlli().getVincoli(codiceDa6);
            RcV = this.getControlli().getRcVincoli(codiceDa6);
            errore = false;
            String codcf = String.valueOf(mioCampo.getQuadro()) + mioCampo.getRiga() + "001";
            String cfPerc = "";
            if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.getControlli().getFormato(codcf) == 2) {
                cfPerc = this.getDichiarazione().prendiValoreCampo(String.valueOf(codcf) + mioCampo.getNumModello());
            }
            if ((controllo == 4 || controllo == 2 || controllo == 200 || controllo == 5 || controllo == 204 || controllo == 206) && RcV == 0) {
                RcV = 16;
            }
            if (vincolo.indexOf("E(") >= 0) {
                RcV = this.flagConferma ? 12 : 16;
            }
            if (vincolo.indexOf("R(") >= 0 && RcV == 0) {
                RcV = 16;
            }
            if (!vincolo.equals("")) {
                Vector istruzioni = vin.separaIstruzioni(vincolo);
                Vector diagn = vin.interprete(codice, mioCampo.getValore(), controllo, istruzioni, this.getDichiarazione());
                if (diagn.size() != 0) {
                    this.scriviListaDiagnostici(this.BS(2), codice, diagn, RcV, cfPerc);
                    rc = Util.aggRc(rc, RcV);
                    errore = true;
                }
                istruzioni = null;
                diagn = null;
            }
            if (controllo == 1 && !vincolo.equals("")) {
                if (mioCampo.getValore().equals("-")) {
                    col = Util.formNum(2, 1 + Util.valoreInt(mioCampo.getColonna()));
                    codice = String.valueOf(mioCampo.getQuadro()) + mioCampo.getRiga() + col + mioCampo.getNumModello();
                    this.getDichiarazione().scriviValoreCampo(codice, Integer.toString(Util.valoreInt(this.getDichiarazione().prendiValoreCampo(codice)) * -1));
                }
            } else if (controllo == 2) {
                if (!Util.controlloCF(mioCampo.getValore())) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1013", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 3) {
                if (!Util.controlloPI(mioCampo.getValore())) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1013", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 200) {
                if (!Util.controlloData(mioCampo.getValore())) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 5) {
                if (!Util.controlloData("0101" + mioCampo.getValore())) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 204) {
                if (!Util.controlloData(String.valueOf(mioCampo.getValore()) + "2000")) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 206) {
                int mm = Integer.parseInt(mioCampo.getValore().substring(0, 2));
                int sec = Integer.parseInt(mioCampo.getValore().substring(2, 4));
                if (mm <= 0 || mm > 12 || sec != 19 && sec != 20) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 4 && !Util.esisteProvincia(mioCampo.getValore())) {
                errore = true;
                rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1012", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
            if (!errore || !this.TIPO_MODELLO.equals("730") || RcV != 12) continue;
            this.varGlob.scriviImporto(mioCampo.getQuadro(), 12.0);
        }
        rc = this.preliquidaCampi0(rc);
        return rc;
    }

    public int preliquida(String quadro, String modulo) {
        String codiceDa6 = "";
        String codice = "";
        String vincolo = "";
        int RcV = 0;
        String col = "";
        int rc = 0;
        Vincoli2001 vin = new Vincoli2001();
        Enumeration listaDichiarazione = this.getDichiarazione().elements();
        boolean errore = false;
        while (listaDichiarazione.hasMoreElements()) {
            Campo mioCampo = (Campo)listaDichiarazione.nextElement();
            if (!quadro.equals(mioCampo.getQuadro()) || !modulo.equals(mioCampo.getNumModello())) continue;
            codiceDa6 = String.valueOf(mioCampo.getQuadro()) + mioCampo.getRiga() + mioCampo.getColonna();
            codice = String.valueOf(codiceDa6) + mioCampo.getNumModello();
            int controllo = this.getControlli().getFormato(codiceDa6);
            vincolo = this.getControlli().getVincoli(codiceDa6);
            RcV = this.getControlli().getRcVincoli(codiceDa6);
            errore = false;
            String codcf = String.valueOf(mioCampo.getQuadro()) + mioCampo.getRiga() + "001";
            String cfPerc = "";
            if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.getControlli().getFormato(codcf) == 2) {
                cfPerc = this.getDichiarazione().prendiValoreCampo(String.valueOf(codcf) + mioCampo.getNumModello());
            }
            if ((controllo == 4 || controllo == 2 || controllo == 200 || controllo == 5 || controllo == 204 || controllo == 206) && RcV == 0) {
                RcV = 16;
            }
            if (vincolo.indexOf("E(") >= 0) {
                RcV = this.flagConferma ? 12 : 16;
            }
            if (vincolo.indexOf("R(") >= 0 && RcV == 0) {
                RcV = 16;
            }
            if (!vincolo.equals("")) {
                Vector istruzioni = vin.separaIstruzioni(vincolo);
                Vector diagn = vin.interprete(codice, mioCampo.getValore(), controllo, istruzioni, this.getDichiarazione());
                if (diagn.size() != 0) {
                    this.scriviListaDiagnostici(this.BS(2), codice, diagn, RcV, cfPerc);
                    rc = Util.aggRc(rc, RcV);
                    errore = true;
                }
                istruzioni = null;
                diagn = null;
            }
            if (controllo == 1 && !vincolo.equals("")) {
                if (mioCampo.getValore().equals("-")) {
                    col = Util.formNum(2, 1 + Util.valoreInt(mioCampo.getColonna()));
                    codice = String.valueOf(mioCampo.getQuadro()) + mioCampo.getRiga() + col + mioCampo.getNumModello();
                    this.getDichiarazione().scriviValoreCampo(codice, Integer.toString(Util.valoreInt(this.getDichiarazione().prendiValoreCampo(codice)) * -1));
                }
            } else if (controllo == 2) {
                if (!Util.controlloCF(mioCampo.getValore())) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1013", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 3) {
                if (!Util.controlloPI(mioCampo.getValore())) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1013", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 200) {
                if (!Util.controlloData(mioCampo.getValore())) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 5) {
                if (!Util.controlloData("0101" + mioCampo.getValore())) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 204) {
                if (!Util.controlloData(String.valueOf(mioCampo.getValore()) + "2000")) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 206) {
                int mm = Integer.parseInt(mioCampo.getValore().substring(0, 2));
                int sec = Integer.parseInt(mioCampo.getValore().substring(2, 4));
                if (mm <= 0 || mm > 12 || sec != 19 && sec != 20) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                }
            } else if (controllo == 4 && !Util.esisteProvincia(mioCampo.getValore())) {
                errore = true;
                rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1012", codice, mioCampo.getValore(), "", 0.0, cfPerc);
            }
            if (!errore || !this.TIPO_MODELLO.equals("730") || RcV != 12) continue;
            this.varGlob.scriviImporto(mioCampo.getQuadro(), 12.0);
        }
        rc = this.preliquidaCampi0(rc);
        return rc;
    }

    private int preliquidaCampi0(int rc) {
        Enumeration listaControlli = this.getControlli().keys();
        while (listaControlli.hasMoreElements()) {
            String codice = (String)listaControlli.nextElement();
            ControlliCampo mioCampo = this.getControlli().getCampo(codice);
            String v = mioCampo.vincoli;
            if (v.indexOf("R(") >= 0 || v.indexOf("<(") >= 0 || v.indexOf(">(") >= 0 || v.trim().length() == 0) continue;
            Vector mod = this.getDichiarazione().ricavaModuliDaQuadro(codice.substring(0, 2));
            Enumeration listaMod = mod.elements();
            while (listaMod.hasMoreElements()) {
                String modulo = (String)listaMod.nextElement();
                if (this.getDichiarazione().esisteCampo(String.valueOf(codice) + modulo)) continue;
                int RcV = mioCampo.rcVincoli;
                String cfPerc = "";
                String codcf = String.valueOf(codice.substring(0, 5)) + "001";
                Vincoli2001 vin = new Vincoli2001();
                if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.getControlli().getFormato(codcf) == 2) {
                    cfPerc = this.getDichiarazione().prendiValoreCampo(String.valueOf(codcf) + modulo);
                }
                if (mioCampo.formato == 200 || mioCampo.formato == 204 || mioCampo.formato == 206) {
                    RcV = 16;
                }
                if (mioCampo.vincoli.indexOf("E(") >= 0) {
                    RcV = this.flagConferma ? 12 : 16;
                }
                Vector istruzioni = vin.separaIstruzioni(mioCampo.vincoli);
                Vector diagn = vin.interprete(String.valueOf(codice) + modulo, "0", mioCampo.formato, istruzioni, this.getDichiarazione());
                if (diagn.size() != 0) {
                    this.scriviListaDiagnostici(this.BS(2), String.valueOf(codice) + modulo, diagn, RcV, cfPerc);
                    rc = Util.aggRc(rc, RcV);
                }
                istruzioni = null;
                diagn = null;
            }
        }
        return rc;
    }

    public int preliquidaFissaA() {
        int rc = 0;
        int i = 0;
        Enumeration listaRecordA = this.recordA.elements();
        while (listaRecordA.hasMoreElements()) {
            String valore = (String)listaRecordA.nextElement();
            int controllo = this.getRecordAcontrolli().getFormatoAt(i);
            String vincolo = this.getRecordAcontrolli().getVincoliAt(i);
            int RcV = this.getRecordAcontrolli().getRcVincoliAt(i);
            String cod = "XXA" + Util.formNum(2, i + 1);
            if (controllo == 100 && !vincolo.equals("") && !Util.isInside(Long.parseLong(valore), vincolo.substring(2, vincolo.length() - 1))) {
                rc = Diagnostici.DIA(rc, RcV > 4 ? RcV : 4, "AAAAAAAAAAAAAAAA", "1012", cod, valore, "");
            }
            if (controllo == 1 && !vincolo.equals("") && !Util.isInside(valore, vincolo.substring(2, vincolo.length() - 1))) {
                rc = Diagnostici.DIA(rc, RcV > 4 ? RcV : 4, "AAAAAAAAAAAAAAAA", "1012", cod, valore, "");
            }
            if (controllo == 2 && !valore.trim().equals("") && !Util.controlloCF(valore)) {
                rc = Diagnostici.DIA(rc, RcV > 4 ? RcV : 4, "AAAAAAAAAAAAAAAA", "1013", cod, valore, "");
            }
            if (controllo == 3 && !valore.trim().equals("") && !Util.controlloPI(valore)) {
                rc = Diagnostici.DIA(rc, RcV > 4 ? RcV : 4, "AAAAAAAAAAAAAAAA", "1013", cod, valore, "");
            }
            if (controllo == 200 && !valore.equals("00000000") && !Util.controlloData(valore)) {
                rc = Diagnostici.DIA(rc, RcV > 4 ? RcV : 4, "AAAAAAAAAAAAAAAA", "1015", cod, valore, "");
            }
            if (controllo == 4 && !valore.trim().equals("") && !Util.esisteProvincia(valore)) {
                rc = Diagnostici.DIA(rc, RcV > 4 ? RcV : 4, "AAAAAAAAAAAAAAAA", "1012", cod, valore, "");
            }
            ++i;
        }
        return rc;
    }

    public int preliquidaFissaB() {
        int rc = 0;
        int i = 0;
        Enumeration listaRecordB = this.recordB.elements();
        boolean errore = false;
        while (listaRecordB.hasMoreElements()) {
            String valore = (String)listaRecordB.nextElement();
            int controllo = this.getRecordBcontrolli().getFormatoAt(i);
            String vincolo = this.getRecordBcontrolli().getVincoliAt(i);
            int RcV = this.getRecordBcontrolli().getRcVincoliAt(i);
            if (!valore.equals("") && !valore.equals("0") || BaseTelem.currentSystem != 0) {
                String cod = "";
                errore = false;
                if (controllo == 2 || controllo == 3 || controllo == 100 || controllo == 200 || controllo == 204 || controllo == 206) {
                    RcV = 16;
                }
                if (vincolo.indexOf("E(") >= 0) {
                    RcV = this.flagConferma ? 8 : 14;
                }
                if (vincolo.indexOf("R(") >= 0 && RcV == 0) {
                    RcV = 16;
                }
                cod = i > 98 && i <= 198 ? "XXX" + Util.formNum(2, i - 100 + 1) : (i > 198 ? "XXY" + Util.formNum(2, i - 200 + 1) : "XXB" + Util.formNum(2, i + 1));
                if (!(controllo != 100 && controllo != 200 || vincolo.equals("") || Util.isInside(Long.parseLong(valore), vincolo.substring(2, vincolo.length() - 1)))) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1012", cod, valore, "");
                }
                if (controllo == 1 && !vincolo.equals("") && !Util.isInside(valore, vincolo.substring(2, vincolo.length() - 1))) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1012", cod, valore, "");
                }
                if (controllo == 2 && !valore.trim().equals("") && !Util.controlloCF(valore)) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1013", cod, valore, "");
                }
                if (controllo == 3 && !valore.trim().equals("") && !Util.controlloPI(valore)) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1013", cod, valore, "");
                }
                if (controllo == 200 && !valore.equals("00000000") && !Util.controlloData(valore)) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1015", cod, valore, "");
                }
                if (controllo == 4 && !valore.trim().equals("") && !Util.esisteProvincia(valore)) {
                    errore = true;
                    rc = Diagnostici.DIA(rc, RcV, this.BS(2), "1012", cod, valore, "");
                }
                if (errore && this.TIPO_MODELLO.equals("730") && RcV == 12) {
                    this.varGlob.scriviImporto("B" + Util.formNum(2, i), 12.0);
                }
            }
            ++i;
        }
        return rc;
    }

    public void riempiControlli() throws FileNotFoundException, IOException {
        BaseTelem.getInstance().riempiControlli(this.TIPO_MODELLO, this.ANNO);
    }

    public void riempiControlli(int recMask) throws FileNotFoundException, IOException {
        BaseTelem.getInstance().riempiControlli(recMask, this.TIPO_MODELLO, this.ANNO);
    }

    public int riempiDichiarazione(String recordC, int lfissa) {
        new String();
        Campo mioCampo = new Campo();
        int rc = 0;
        int j = 0;
        boolean flagBuco = false;
        int i = lfissa;
        while (i < 1900 && j < 75) {
            mioCampo.setQuadro(recordC.substring(i, i + 2));
            mioCampo.setRiga(recordC.substring(i + 2, i + 5));
            mioCampo.setColonna(recordC.substring(i + 5, i + 8));
            mioCampo.setNumModello(recordC.substring(17, 25));
            mioCampo.setValore(recordC.substring(i + 8, i + 24));
            String codiceDa6 = String.valueOf(mioCampo.getQuadro()) + mioCampo.getRiga() + mioCampo.getColonna();
            String codice = String.valueOf(codiceDa6) + mioCampo.getNumModello();
            String appoCodiceD = codiceDa6;
            if (codiceDa6.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
                appoCodiceD = String.valueOf(codiceDa6.substring(0, 2)) + "0" + codiceDa6.substring(3, codiceDa6.length());
            }
            int tipoControllo = this.getControlli().getFormato(appoCodiceD);
            String codcf = String.valueOf(mioCampo.getQuadro()) + mioCampo.getRiga() + "001";
            if (this.TIPO_MODELLO.equals("77S")) {
                if (mioCampo.getQuadro().equals("AU")) {
                    codcf = "AU001001";
                }
                if (mioCampo.getQuadro().equals("DA") || mioCampo.getQuadro().equals("DB") || mioCampo.getQuadro().equals("DC") || mioCampo.getQuadro().equals("DD")) {
                    codcf = "DA001001";
                }
            }
            String cfPerc = "";
            if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.getControlli().getFormato(codcf) == 2) {
                cfPerc = this.getDichiarazione().prendiValoreCampo(String.valueOf(codcf) + mioCampo.getNumModello());
            }
            if (codiceDa6.trim().length() == 0 && mioCampo.getValore().trim().length() == 0) {
                flagBuco = true;
            } else {
                if (flagBuco) {
                    rc = Diagnostici.DIA(rc, 4, this.BS(2), "1021", "", "", "", 0.0, cfPerc);
                    flagBuco = false;
                }
                if (this.getDichiarazione().esisteCampo(codice)) {
                    if (mioCampo.getValore().charAt(0) == '+' && tipoControllo == 1) {
                        String s = String.valueOf(this.getDichiarazione().prendiValoreCampo(codice)) + mioCampo.getValore().substring(1, mioCampo.getValore().length());
                        this.getDichiarazione().scriviValoreCampo(codice, s);
                    } else {
                        rc = Diagnostici.DIA(rc, 16, this.BS(2), "1022", "", codice, "", 0.0, cfPerc);
                    }
                } else if (tipoControllo == -1 || mioCampo.getRiga().equals("XXX")) {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1024", "", codice, "", 0.0, cfPerc);
                } else if (!Util.numerico(mioCampo.getNumModello()) || mioCampo.getNumModello().equals("00000000") || mioCampo.getNumModello().equals("00")) {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1024", "", codice, "", 0.0, cfPerc);
                } else if (mioCampo.getValore().equals("                ")) {
                    rc = Diagnostici.DIA(rc, 4, this.BS(2), "1023", codice, "", "", 0.0, cfPerc);
                } else if (Util.detectLowValueChars(mioCampo.getValore())) {
                    rc = Diagnostici.DIA(rc, 16, this.BS(2), "1094", codice, mioCampo.getValore(), "", 0.0, cfPerc);
                } else {
                    rc = Util.aggRc(rc, this.casoANPR(codice, mioCampo));
                    rc = Util.aggRc(rc, this.casoCB(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoCBx(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoCFPI(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoDT(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoDA(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoDx(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoNU(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoNP(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoPC(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoQU(codice, mioCampo, cfPerc));
                    rc = Util.aggRc(rc, this.casoNx(codice, mioCampo, cfPerc));
                }
            }
            mioCampo = new Campo();
            ++j;
            i += 24;
        }
        return rc;
    }

    public void riempiRecordA() throws FileNotFoundException, IOException {
        this.recordA.load(String.valueOf(this.TIPO_MODELLO) + this.ANNO + "_reca" + ".res");
    }

    public void riempiRecordB() throws FileNotFoundException, IOException {
        this.recordB.load(String.valueOf(this.TIPO_MODELLO) + this.ANNO + "_recb" + ".res");
    }

    public void riempiRecordZ() throws FileNotFoundException, IOException {
        this.recordZ.load(String.valueOf(this.TIPO_MODELLO) + this.ANNO + "_recz" + ".res");
    }

    public String S(String s) {
        return this.getDichiarazione().prendiValoreCampo(s);
    }

    private void scriviListaDiagnostici(String CF2, String codice, Vector lista, int RcV, String cfPerc) {
        Enumeration l = lista.elements();
        while (l.hasMoreElements()) {
            String dia = (String)l.nextElement();
            String cod = dia.substring(0, 4);
            String dich = dia.substring(4, 20);
            String calc1 = dia.substring(20, 36);
            double calc2 = 0.0;
            if (dia.substring(36, 52).trim().length() != 0) {
                calc2 = Util.valoreDouble(dia.substring(36, 52));
            }
            Diagnostici.DIA(0, RcV, CF2, cod, codice, dich, calc1, calc2, cfPerc);
            if (BaseTelem.currentSystem != 3) continue;
            this.getDichiarazione().eliminaCampo(new Campo(codice, null));
        }
    }

    public void setDichiarazione(Dichiarazione dichiarazione) {
        this.dich = dichiarazione;
    }

    public void setFlagConferma(boolean flagConferma) {
        this.flagConferma = flagConferma;
    }

    public void setMaxQuadri(Globali maxQuadri) {
        this.maxQuadri = maxQuadri;
    }

    public void setRecordA(RecordParser recordA) {
        this.recordA = recordA;
    }

    public void setRecordB(RecordParser recordB) {
        this.recordB = recordB;
    }

    public void setRecordZ(RecordParser recordZ) {
        this.recordZ = recordZ;
    }

    public void setVarGlob(Globali varGlob) {
        this.varGlob = varGlob;
    }

    public double ZD(int indice) {
        return Util.valoreDouble(this.recordZ.prendiValore(indice));
    }

    public int ZI(int indice) {
        return Integer.parseInt(this.recordZ.prendiValore(indice));
    }

    public String ZS(int indice) {
        return this.recordZ.prendiValore(indice);
    }
}

