/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.telematico.security.login.ui.dialogs;

import it.sogei.rcp.filesystemutil.WorkSpaceUtil;
import it.sogei.rcp.security.login.beans.RuoloBean;
import it.sogei.rcp.security.login.beans.UtentiBean;
import it.sogei.rcp.security.login.db.DesktopDB;
import it.sogei.telematico.security.login.ui.properties.Messages;
import java.io.File;
import java.sql.SQLException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class RecuperaWSUser
extends TitleAreaDialog {
    public static final String WS_IDENTIFIER = "DesktopUnificato.preferences";
    private static final String _KeyWorkspaceRootDir = "wsRootDir";
    private static final String _nuovoUtente = "nuovoUtente";
    private static final String _KeyRememberWorkspace = "wsRemember";
    private static final String _KeyLastUsedWorkspaces = "wsLastUsedWorkspaces";
    private static final String _StrMsg = Messages.CreateUser_5;
    private static final String _StrError = Messages.CreateUser_6;
    private static final String _StrError2 = Messages.CreateUser_6a;
    private static final String _StrErrorPassword = Messages.CreateUser_7;
    private static final String _StrErrorPATH = Messages.CreateUser_8;
    private static final String _StrInfo = Messages.CreateUser_9;
    private static final String _StrErrorG = Messages.CreateUser_10;
    private static final String _StrErrorExist = Messages.CreateUser_11;
    private Button _RememberWorkspaceButton;
    private boolean _switchWorkspace;
    private String _selectedWorkspaceRootLocation;
    private boolean _passwordRequired;
    private boolean _multiUser;
    private UtentiBean utente;
    Text username;
    private Text path;
    private Text password;
    private Text password2;
    private Label labels_1;
    private Label title;
    private GridData gridData_1;
    private GridData gridData_2;
    private GridData gridData_3;
    Button buttonOK;

    public RecuperaWSUser(UtentiBean utente, boolean switchWorkspace, Image wizardImage, boolean passwordRequired, boolean multiUser) {
        super(Display.getDefault().getActiveShell());
        this.setHelpAvailable(false);
        this._switchWorkspace = switchWorkspace;
        this._passwordRequired = passwordRequired;
        this._multiUser = multiUser;
        this.utente = utente;
        if (wizardImage != null) {
            this.setTitleImage(wizardImage);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CreateUser_12);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setFont(SWTResourceManager.getFont("Tahoma", 9, 0));
        this.setMessage(_StrMsg);
        try {
            Composite outer = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(4, false);
            gridLayout.verticalSpacing = 10;
            outer.setLayout((Layout)gridLayout);
            new FontData("Times New Roman", 11, 1);
            new FontData("Tahoma", 13, 7);
            StyleRange style1 = new StyleRange();
            style1.underline = true;
            this.title = new Label(outer, 0);
            this.title.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            this.title.setText(Messages.CreateUser_lblNewUser_text);
            this.title.setText(Messages.CreateUser_15);
            this.title.setForeground(new Color(null, 239, 122, 16));
            CLabel space = new CLabel(outer, 1);
            space.setText("");
            space = new CLabel(outer, 1);
            space.setText("");
            space = new CLabel(outer, 1);
            space.setText("");
            this.labels_1 = new Label(outer, 0);
            this.labels_1.setForeground(new Color(null, 0, 69, 124));
            this.labels_1.setText(Messages.CreateUser_21);
            this.labels_1.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            new Label(outer, 0);
            this.path = new Text(outer, 2048);
            this.path.setToolTipText(Messages.CreateUser_path_toolTipText);
            this.gridData_3 = new GridData(256);
            this.gridData_3.widthHint = 234;
            this.path.setLayoutData((Object)this.gridData_3);
            this.path.setBounds(40, 50, 100, 20);
            this.path.setEditable(false);
            this.path.setEnabled(false);
            Button browse = new Button(outer, 8);
            browse.setEnabled(true);
            browse.setText(Messages.CreateUser_22);
            browse.setBounds(100, 50, 70, 20);
            browse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DirectoryDialog dd = new DirectoryDialog(RecuperaWSUser.this.getParentShell());
                    dd.setText(Messages.CreateUser_23);
                    dd.setMessage(_StrInfo);
                    dd.setFilterPath(RecuperaWSUser.this.path.getText());
                    String pick = dd.open();
                    if (pick == null && RecuperaWSUser.this.path.getText().length() == 0) {
                        RecuperaWSUser.this.setMessage(_StrError, 3);
                    } else {
                        RecuperaWSUser.this.setMessage(_StrMsg);
                        if (pick != null) {
                            String checkWorkspace = RecuperaWSUser.checkWorkspaceDirectory(RecuperaWSUser.this.getParentShell(), pick, false, true);
                            if (checkWorkspace == null) {
                                RecuperaWSUser.this.path.setText(pick);
                                RecuperaWSUser.this.username.setText(pick.substring(pick.lastIndexOf(System.getProperty("file.separator")) + 1));
                                RecuperaWSUser.this.buttonOK.setEnabled(true);
                            } else {
                                RecuperaWSUser.this.setMessage(checkWorkspace, 3);
                                RecuperaWSUser.this.buttonOK.setEnabled(false);
                            }
                        }
                    }
                }
            });
            Label labels = new Label(outer, 0);
            labels.setForeground(new Color(null, 0, 69, 124));
            labels.setText(Messages.CreateUser_19);
            labels.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            new Label(outer, 0);
            this.username = new Text(outer, 2052);
            this.username.setEditable(false);
            GridData gridData = new GridData(256);
            gridData.widthHint = 250;
            this.username.setLayoutData((Object)gridData);
            this.username.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RecuperaWSUser.this.buttonOK.setEnabled(true);
                }
            });
            new Label(outer, 0);
            labels = new Label(outer, 0);
            labels.setText(Messages.CreateUser_20);
            labels.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            labels.setForeground(new Color(null, 0, 69, 124));
            labels.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            labels.setForeground(new Color(null, 0, 69, 124));
            labels.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            new Label(outer, 0);
            this.password = new Text(outer, 0x400804);
            this.gridData_1 = new GridData(256);
            this.password.setLayoutData((Object)this.gridData_1);
            new Label(outer, 0);
            Label labels2 = new Label(outer, 0);
            labels2.setForeground(new Color(null, 0, 69, 124));
            labels2.setText(Messages.CreateUser_0);
            labels2.setFont(SWTResourceManager.getFont("Tahoma", 9, 1));
            new Label(outer, 0);
            this.password2 = new Text(outer, 0x400804);
            if (!this._passwordRequired) {
                this.password.setVisible(false);
                labels.setVisible(false);
                this.password2.setVisible(false);
                labels2.setVisible(false);
            }
            this.gridData_2 = new GridData(256);
            this.password2.setLayoutData((Object)this.gridData_2);
            new Label(outer, 0);
            return outer;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public String getSelectedWorkspaceLocation() {
        return this._selectedWorkspaceRootLocation;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.buttonOK = this.createButton(parent, 0, Messages.CreateUser_41, true);
        this.buttonOK.setEnabled(false);
        this.createButton(parent, 1, Messages.CreateUser_26, false);
    }

    protected void okPressed() {
        String str = this.username.getText();
        String pathFS = this.path.getText();
        DesktopDB prodottoDb = new DesktopDB();
        if (str.length() == 0) {
            this.setMessage(_StrError, 3);
            return;
        }
        if (!RecuperaWSUser.isStringaOk(str)) {
            this.setMessage(_StrError2, 3);
            return;
        }
        if (this.password.getText().length() < 8 || this.password.getText().length() > 15) {
            this.setMessage(Messages.CambiaPsw_Lenght, 3);
            return;
        }
        if (!RecuperaWSUser.isStringaOk(this.password.getText())) {
            this.setMessage(Messages.CreateUser_7a, 3);
            return;
        }
        if (this.password.getText().length() == 0 && this._passwordRequired) {
            this.setMessage(_StrErrorPassword, 3);
            return;
        }
        if (this.path.getText().length() == 0) {
            this.setMessage(_StrErrorPATH, 3);
            return;
        }
        if (this.path.getText().length() == 0 && this.password.getText().length() == 0) {
            this.setMessage(_StrErrorG, 3);
            return;
        }
        if (!(str.length() == 0 || this.password.getText().length() == 0 && this._passwordRequired || this.path.getText().length() == 0)) {
            if (!this.password.getText().equals(this.password2.getText())) {
                this.setMessage(Messages.CreateUser_1, 3);
                return;
            }
            boolean flag = false;
            try {
                flag = prodottoDb.verificaUtente(str);
                if (!flag) {
                    this.utente.setNome(str);
                    this.utente.setPath(new Path(pathFS).addTrailingSeparator().toPortableString());
                    this.utente.setPassword(this.password.getText());
                    RuoloBean adminRole = new RuoloBean("Admin", str, "Desktop");
                    RuoloBean userRole = new RuoloBean("User", str, "Desktop");
                    if ("Admin".equals(str)) {
                        this.utente.setRuoli(new RuoloBean[]{adminRole, userRole});
                    } else {
                        this.utente.setRuoli(new RuoloBean[]{userRole});
                    }
                } else {
                    this.setMessage(_StrErrorExist, 3);
                    return;
                }
                prodottoDb.insertUser(this.utente);
            }
            catch (SQLException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)e.getMessage());
            }
        }
        WorkSpaceUtil wsUtil = new WorkSpaceUtil();
        try {
            wsUtil.CreateWorkspace(pathFS);
        }
        catch (Exception e) {
            this.setMessage(Messages.CreateUser_29);
            e.printStackTrace();
            return;
        }
        this._selectedWorkspaceRootLocation = pathFS;
        super.okPressed();
    }

    public static String checkWorkspaceDirectory(Shell parentShell, String workspaceLocation, boolean askCreate, boolean fromDialog) {
        File f = new File(workspaceLocation);
        if (!f.exists() && askCreate) {
            boolean create = MessageDialog.openConfirm((Shell)parentShell, (String)Messages.CreateUser_31, (String)Messages.CreateUser_32);
            if (create) {
                try {
                    f.mkdirs();
                    File wsDot = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
                    wsDot.createNewFile();
                }
                catch (Exception exception) {
                    return Messages.CreateUser_33;
                }
            }
            if (!f.exists()) {
                return Messages.CreateUser_34;
            }
        }
        if (!f.canRead()) {
            return Messages.CreateUser_35;
        }
        if (!f.isDirectory()) {
            return Messages.CreateUser_36;
        }
        File wsTest = new File(String.valueOf(workspaceLocation) + File.separator + WS_IDENTIFIER);
        if (fromDialog) {
            if (!wsTest.exists()) {
                return Messages.CreateUser_40;
            }
            return null;
        }
        if (!wsTest.exists()) {
            return Messages.CreateUser_40;
        }
        return null;
    }

    public static boolean checkAndCreateWorkspaceRoot(String wsRoot) {
        block3: {
            try {
                File fRoot = new File(wsRoot);
                if (fRoot.exists()) break block3;
                return false;
            }
            catch (Exception err) {
                err.printStackTrace();
                return false;
            }
        }
        File dotFile = new File(String.valueOf(wsRoot) + File.separator + WS_IDENTIFIER);
        return dotFile.exists() || dotFile.createNewFile();
    }

    public static boolean isStringaOk(String s) {
        int lun = s.length();
        int ctr = 0;
        if (lun == 0) {
            return false;
        }
        String riferimento = "1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM-_";
        int i = 0;
        while (i < lun) {
            char ciar = s.charAt(i);
            ctr = 0;
            int h = 0;
            while (h < riferimento.length()) {
                char ciarRif = riferimento.charAt(h);
                if (ciar == ciarRif) {
                    ++ctr;
                }
                ++h;
            }
            if (ctr == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

