/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CompressedData;
import iaik.cms.CompressedDataStream;
import iaik.cms.Content;
import iaik.cms.ContentInfo;
import iaik.cms.ContentInfoStream;
import iaik.cms.ContentStream;
import iaik.cms.Utils;
import iaik.utils.CryptoUtils;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class CMSCompressedData {
    byte[] compressedContent_;

    public void start() {
        String string = "ABABABABABABABBABABABABABABABBABABABABABABABBAABABABABABA.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nImplicit CompressedDataStream demo [create]\n");
            byte[] byArray3 = this.createCompressedDataStream(byArray, 1);
            System.out.println("\nImplicit CompressedDataStream demo [parse]\n");
            byArray2 = this.getCompressedDataStream(byArray3, null);
            if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])byArray2)) {
                throw new CMSException("Decompression error!");
            }
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit CompressedDataStream demo [create]\n");
            byArray3 = this.createCompressedDataStream(byArray, 2);
            System.out.println("\nExplicit CompressedDataStream demo [parse]\n");
            byArray2 = this.getCompressedDataStream(byArray3, this.compressedContent_);
            if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])byArray2)) {
                throw new CMSException("Decompression error!");
            }
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            System.out.println("\nImplicit CompressedData demo [create]\n");
            byArray3 = this.createCompressedData(byArray, 1);
            System.out.println("\nImplicit CompressedData demo [parse]\n");
            byArray2 = this.getCompressedData(byArray3, null);
            if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])byArray2)) {
                throw new CMSException("Decompression error!");
            }
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit CompressedData demo [create]\n");
            byArray3 = this.createCompressedData(byArray, 2);
            System.out.println("\nExplicit CompressedData demo [parse]\n");
            byArray2 = this.getCompressedData(byArray3, this.compressedContent_);
            if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])byArray2)) {
                throw new CMSException("Decompression error!");
            }
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new CMSCompressedData().start();
        System.in.read();
    }

    public byte[] getCompressedDataStream(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, IOException, CMSException {
        System.out.println("Parse CompressedData message.");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CompressedDataStream compressedDataStream = new CompressedDataStream((InputStream)byteArrayInputStream);
        if (compressedDataStream.getMode() == 2) {
            compressedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        InputStream inputStream = compressedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getCompressedData(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, IOException, CMSException {
        System.out.println("Parse CompressedData message.");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CompressedData compressedData = new CompressedData((InputStream)byteArrayInputStream);
        if (compressedData.getMode() == 2) {
            compressedData.setContent(byArray2);
        }
        return compressedData.getContent();
    }

    public byte[] createCompressedDataStream(byte[] byArray, int n) throws NoSuchAlgorithmException, IOException, CMSException {
        ByteArrayOutputStream byteArrayOutputStream;
        Closeable closeable;
        System.out.println("Create a new CompressedData message.");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CompressedDataStream compressedDataStream = new CompressedDataStream((InputStream)byteArrayInputStream, (AlgorithmID)CMSAlgorithmID.zlib_compress, n);
        if (n == 2) {
            closeable = compressedDataStream.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            Utils.copyStream((InputStream)closeable, (OutputStream)byteArrayOutputStream, null);
            this.compressedContent_ = byteArrayOutputStream.toByteArray();
        }
        closeable = new ByteArrayOutputStream();
        compressedDataStream.setBlockSize(4);
        byteArrayOutputStream = new ContentInfoStream((ContentStream)compressedDataStream);
        byteArrayOutputStream.writeTo((OutputStream)closeable);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public byte[] createCompressedData(byte[] byArray, int n) throws NoSuchAlgorithmException, IOException, CMSException {
        System.out.println("Create a new CompressedData message.");
        CompressedData compressedData = new CompressedData(byArray, (AlgorithmID)CMSAlgorithmID.zlib_compress, n);
        if (n == 2) {
            this.compressedContent_ = compressedData.getContent();
        }
        ContentInfo contentInfo = new ContentInfo((Content)compressedData);
        return contentInfo.getEncoded();
    }

    public CMSCompressedData() {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                           CMSCompressedData demo                               *");
        System.out.println("*        (shows the usage of the CMS CompressedData type implementation)         *");
        System.out.println("**********************************************************************************");
        System.out.println();
    }
}

