/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.ecdsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.interfaces.ECDSAParams;
import iaik.security.ecc.interfaces.ECDSAPublicKey;
import iaik.security.ecc.math.ecgroup.CoordinateTypes;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import iaik.security.ecc.spec.ECDSAPublicKeySpec;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;

public class ECPublicKey
extends PublicKeyInfo
implements ECDSAPublicKey {
    private ECPoint w_;
    private transient OCTET_STRING publicKey_;
    private ECDSAParameter p_;
    protected static final String ALGORITHM = "ECDSA";

    protected byte[] encode() {
        try {
            return (byte[])this.publicKey_.getValue();
        }
        catch (Exception exception) {
            System.err.println("Internal error");
            return null;
        }
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.publicKey_ = new OCTET_STRING(byArray);
            ASN1Object aSN1Object = this.public_key_algorithm.getParameter();
            if (aSN1Object == null) {
                throw new InvalidKeyException("No ECDSA Public Key: NoParameters specified");
            }
            if (aSN1Object.isA(ASN.NULL)) {
                // empty if block
            }
            if (aSN1Object.isA(ASN.ObjectID)) {
                ObjectID objectID = (ObjectID)aSN1Object;
                ECCParameterSpec eCCParameterSpec = ECCParameterFactory.getInstance().getParameterByOID((String)objectID.getValue());
                if (eCCParameterSpec == null) {
                    throw new InvalidKeyException("Unknown parameter oid " + objectID.toString());
                }
                this.p_ = new ECDSAParameter(eCCParameterSpec, CoordinateTypes.getDefaultCoordinates(eCCParameterSpec.getA().getField().getFieldId()));
            } else {
                this.p_ = new ECDSAParameter(aSN1Object);
            }
            this.w_ = new ECPoint((byte[])this.publicKey_.getValue(), this.p_.getG().getCurve());
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No ECDSA Public Key: " + exception.toString());
        }
    }

    private void createECDSAPublicKey() {
        try {
            this.public_key_algorithm = AlgorithmID.ecdsa;
            this.public_key_algorithm.setParameter(this.p_.toASN1Object());
            this.publicKey_ = new OCTET_STRING((byte[])this.w_.toASN1Object().getValue());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Cannot encode Key " + exception.getMessage());
        }
        this.createPublicKeyInfo();
    }

    public void validatePublicKey() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\nPoint: ");
        stringBuffer.append(this.w_.toString());
        stringBuffer.append("\nParameter: ");
        if (this.p_ != null) {
            stringBuffer.append(this.p_.toString());
        } else {
            stringBuffer.append("NOT SPECIFIED");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.publicKey_.hashCode() + ALGORITHM.hashCode() + this.p_.hashCode() + this.w_.hashCode();
    }

    public ECPoint getW() {
        return (ECPoint)this.w_.clone();
    }

    public ECDSAParams getParameter() {
        return this.p_;
    }

    public String getAlgorithm() {
        return ALGORITHM;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ECPublicKey)) {
            return false;
        }
        ECPublicKey eCPublicKey = (ECPublicKey)object;
        return eCPublicKey.getParameter().equals(this.p_) && eCPublicKey.getW().equals(this.w_);
    }

    public ECPublicKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    public ECPublicKey(ECDSAPublicKeySpec eCDSAPublicKeySpec) {
        this.p_ = new ECDSAParameter(eCDSAPublicKeySpec.getG(), eCDSAPublicKeySpec.getR(), eCDSAPublicKeySpec.getK());
        this.w_ = eCDSAPublicKeySpec.getW();
        this.createECDSAPublicKey();
    }

    public ECPublicKey(ECDSAParams eCDSAParams, ECPoint eCPoint) {
        this.p_ = new ECDSAParameter(eCDSAParams);
        this.w_ = eCPoint;
        this.createECDSAPublicKey();
    }

    public ECPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public ECPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }
}

