/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.provider.IAIK;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public abstract class PublicKeyInfo
implements Cloneable,
PublicKey,
Serializable,
ASN1Type {
    protected AlgorithmID public_key_algorithm;
    ASN1 a;

    public void writeTo(OutputStream outputStream) throws IOException {
        this.a.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This PublicKeyInfo contains a ");
        if (this.public_key_algorithm.equals(AlgorithmID.rsaEncryption)) {
            stringBuffer.append("RSA public key.");
        } else if (this.public_key_algorithm.equals(AlgorithmID.dsa)) {
            stringBuffer.append("DSA public key.");
        } else if (this.public_key_algorithm.equals(AlgorithmID.dhKeyAgreement)) {
            stringBuffer.append("DH public key.");
        } else {
            stringBuffer.append(String.valueOf(this.public_key_algorithm.getName()) + " key.");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        return this.a.toASN1Object();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.a = new ASN1(objectInputStream);
            this.b();
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore PublicKeyInfo: " + codingException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to restore PublicKeyInfo: " + invalidKeyException.toString());
        }
    }

    public int hashCode() {
        return Util.calculateHashCode(this.getEncoded());
    }

    public static PublicKey getPublicKey(byte[] byArray, String string) throws InvalidKeyException {
        try {
            return PublicKeyInfo.getPublicKey(DerCoder.decode(byArray), string);
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PublicKeyInfo.");
        }
    }

    public static PublicKey getPublicKey(byte[] byArray) throws InvalidKeyException {
        return PublicKeyInfo.getPublicKey(byArray, null);
    }

    public static PublicKey getPublicKey(ASN1Object aSN1Object, String string) throws InvalidKeyException {
        AlgorithmID algorithmID = null;
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(DerCoder.encode(aSN1Object));
            algorithmID = new AlgorithmID(aSN1Object.getComponentAt(0));
            KeyFactory keyFactory = algorithmID.getKeyFactoryInstance(string);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("PublicKey algorithm not implemented: " + algorithmID.getName());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Can't parse PublicKeyInfo: " + invalidKeySpecException.toString());
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PublicKeyInfo: " + codingException.toString());
        }
    }

    public static PublicKey getPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        AlgorithmID algorithmID = null;
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(DerCoder.encode(aSN1Object));
            algorithmID = new AlgorithmID(aSN1Object.getComponentAt(0));
            KeyFactory keyFactory = algorithmID.getKeyFactoryInstance();
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("PublicKey algorithm not implemented: " + algorithmID.getName());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Can't parse PublicKeyInfo: " + invalidKeySpecException.toString());
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PublicKeyInfo: " + codingException.toString());
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getFingerprint() {
        MessageDigest messageDigest = IAIK.getMd5();
        messageDigest.update(this.encode());
        return messageDigest.digest();
    }

    public byte[] getEncoded() {
        return this.a.toByteArray();
    }

    public AlgorithmID getAlgorithmID() {
        return this.public_key_algorithm;
    }

    public abstract String getAlgorithm();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        return CryptoUtils.equalsBlock(this.getEncoded(), ((PublicKey)object).getEncoded());
    }

    protected abstract byte[] encode();

    protected abstract void decode(byte[] var1) throws InvalidKeyException;

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = new ASN1(aSN1Object);
        try {
            this.b();
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CodingException(invalidKeyException.toString());
        }
    }

    private void b() throws InvalidKeyException {
        try {
            this.public_key_algorithm = new AlgorithmID(this.a.getComponentAt(0));
            this.decode((byte[])this.a.getComponentAt(1).getValue());
            return;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No PublicKeyInfo: " + exception.toString());
        }
    }

    protected void createPublicKeyInfo() {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.public_key_algorithm.toASN1Object());
            sEQUENCE.addComponent(new BIT_STRING(this.encode()));
            this.a = new ASN1(sEQUENCE);
            return;
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("CodingException!");
        }
    }

    public Object clone() {
        PublicKeyInfo publicKeyInfo = null;
        try {
            publicKeyInfo = (PublicKeyInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return publicKeyInfo;
    }

    public PublicKeyInfo(byte[] byArray) throws InvalidKeyException {
        try {
            this.a = new ASN1(byArray);
            this.b();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PublicKeyInfo: " + codingException.toString());
        }
    }

    public PublicKeyInfo(InputStream inputStream) throws IOException, InvalidKeyException {
        try {
            this.a = new ASN1(inputStream);
            this.b();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PublicKeyInfo: " + codingException.toString());
        }
    }

    public PublicKeyInfo(ASN1Object aSN1Object) throws InvalidKeyException {
        try {
            this.a = new ASN1(aSN1Object);
            this.b();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PublicKeyInfo: " + codingException.toString());
        }
    }

    protected PublicKeyInfo() {
    }
}

