/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.security.md.SHA;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPssPrivateKey;
import iaik.security.rsa.RSAPssPublicKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.security.rsa.a;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAPssSignature
extends a {
    private RSAPssParameterSpec h;
    private RSAPssParameterSpec g;
    private byte b = (byte)-68;
    byte[] c;
    int d;
    MaskGenerationAlgorithm f;
    AlgorithmID e;
    private static boolean a;
    static final int j = 1;
    private static final byte i = -68;
    private static final String k = "NoPadding";
    static final String l = "RSASSA-PSS";

    public static void setValidateAgainstPssKeyParameters(boolean bl) {
        a = bl;
    }

    void d() {
        ((a)this).d = (AlgorithmID)AlgorithmID.sha1.clone();
        this.e = (AlgorithmID)AlgorithmID.mgf1.clone();
        this.e.setParameter(((a)this).d.toASN1Object());
        this.hash = new SHA();
        this.f = new MGF1(((a)this).d, this.hash);
        this.d = 20;
        this.b = (byte)-68;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        if (this.hash == null) {
            throw new NullPointerException("Cannot verify signature. Digest engine must not be null!");
        }
        if (this.f == null) {
            throw new NullPointerException("Cannot verify signature. MGF engine must not be null!");
        }
        int n2 = this.a();
        int n3 = (n2 + 7) / 8;
        int n4 = n2 - 1;
        if (byArray.length != n3) {
            throw new SignatureException("Invalid signature (length is not k (" + n3 + ") octets!");
        }
        byte[] byArray3 = null;
        try {
            byArray3 = this.a(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException("Signature decryption error: " + exception.toString());
        }
        int n5 = (n4 + 7) / 8;
        if (n5 < byArray3.length) {
            if ((n2 - 1) % 8 == 0 && n5 == byArray3.length - 1) {
                byArray2 = new byte[n5];
                System.arraycopy(byArray3, byArray3.length - n5, byArray2, 0, n5);
                CryptoUtils.zeroBlock(byArray3);
                byArray3 = byArray2;
            } else {
                CryptoUtils.zeroBlock(byArray3);
                throw new SignatureException("Invalid signature. Decrypted message too long");
            }
        }
        byArray2 = this.b();
        int n6 = byArray2.length;
        if (this.d < 0) {
            this.d = 20;
        }
        if (n5 < n6 + this.d + 2) {
            CryptoUtils.zeroBlock(byArray3);
            throw new SignatureException("Inconsitent length: emLen (" + n5 + ") shorter than hashLen + saltLen + 2!");
        }
        if (byArray3[byArray3.length - 1] != this.b) {
            CryptoUtils.zeroBlock(byArray3);
            throw new SignatureException("Invalid signature. Inconsistent trailer field.");
        }
        if ((byArray3[0] & 65280 >> 8 * n5 - n4 & 0xFF) != 0) {
            CryptoUtils.zeroBlock(byArray3);
            throw new SignatureException("Invalid signature. Leftmost 8emLen - emBits not all zero.");
        }
        int n7 = n5 - n6 - 1;
        this.f.mask(byArray3, n7, n6, n7, byArray3, 0);
        byArray3[0] = (byte)(byArray3[0] & 255 >> 8 * n5 - n4);
        int n8 = n5 - n6 - this.d - 2;
        int n9 = 0;
        while (n9 < n8) {
            if (byArray3[n9] != 0) {
                CryptoUtils.zeroBlock(byArray3);
                throw new SignatureException("Invalid signature. Not all leftmost octets of DB are zero");
            }
            ++n9;
        }
        if (byArray3[n8] != 1) {
            CryptoUtils.zeroBlock(byArray3);
            throw new SignatureException("Invalid signature. Missing 0x01 octet");
        }
        byte[] byArray4 = new byte[8 + n6 + this.d];
        System.arraycopy(byArray2, 0, byArray4, 8, n6);
        if (this.d > 0) {
            System.arraycopy(byArray3, n5 - n6 - this.d - 1, byArray4, 8 + n6, this.d);
        }
        byte[] byArray5 = this.hash.digest(byArray4);
        boolean bl = CryptoUtils.equalsBlock(byArray5, 0, byArray3, n7, n6);
        CryptoUtils.zeroBlock(byArray3);
        CryptoUtils.zeroBlock(byArray4);
        return bl;
    }

    protected byte[] engineSign() throws SignatureException {
        Object object;
        byte[] byArray = null;
        if (this.hash == null) {
            throw new NullPointerException("Cannot calculate signature. Digest engine must not be null!");
        }
        if (this.f == null) {
            throw new NullPointerException("Cannot calculate signature. MGF engine must not be null!");
        }
        int n2 = this.a();
        int n3 = n2 - 1;
        int n4 = (n3 + 7) / 8;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = this.b();
        int n5 = byArray3.length;
        if (this.d < 0) {
            this.d = 20;
        }
        if (n4 < n5 + this.d + 2) {
            throw new SignatureException("Encoding error: emLen (" + n4 + ") shorter than hashLen + saltLen + 2!");
        }
        byte[] byArray4 = this.c;
        byte[] byArray5 = new byte[8 + n5 + this.d];
        System.arraycopy(byArray3, 0, byArray5, 8, n5);
        if (this.d > 0) {
            if (byArray4 == null) {
                object = this.c();
                if (object == null) {
                    throw new NullPointerException("Cannot calculate signature. No SecureRandom available!");
                }
                byArray4 = new byte[this.d];
                ((SecureRandom)object).nextBytes(byArray4);
            }
            System.arraycopy(byArray4, 0, byArray5, 8 + n5, this.d);
        }
        object = this.hash.digest(byArray5);
        int n6 = n4 - n5 - 1;
        byArray2[n6 - this.d - 1] = 1;
        if (this.d > 0) {
            System.arraycopy(byArray4, 0, byArray2, n6 - this.d, this.d);
        }
        this.f.mask((byte[])object, 0, ((Object)object).length, n6, byArray2, 0);
        byArray2[0] = (byte)(byArray2[0] & 255 >> 8 * n4 - n3);
        System.arraycopy(object, 0, byArray2, n6, n5);
        byArray2[n4 - 1] = this.b;
        try {
            byArray = this.a(byArray2);
        }
        catch (Exception exception) {
            throw new SignatureException("Signing error: " + exception.toString());
        }
        int n7 = (n2 + 7) / 8;
        if (byArray.length < n7) {
            byte[] byArray6 = new byte[n7];
            System.arraycopy(byArray, 0, byArray6, n7 - byArray.length, byArray.length);
            CryptoUtils.zeroBlock(byArray);
            byArray = byArray6;
        }
        return byArray;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof RSAPssParameterSpec) {
                RSAPssParameterSpec rSAPssParameterSpec = (RSAPssParameterSpec)algorithmParameterSpec;
                int n2 = rSAPssParameterSpec.getTrailerField();
                if (n2 != 1) {
                    throw new InvalidAlgorithmParameterException("Trailer field number " + n2 + " not supported by RSASSA-PSS. Expected " + 1 + "!");
                }
                if (this.g != null && a) {
                    try {
                        if (!RSAPssPublicKey.a(this.g, rSAPssParameterSpec)) {
                            throw new InvalidAlgorithmParameterException("Parameters are not valid for PSS-Key used with this engine!");
                        }
                    }
                    catch (InvalidParameterSpecException invalidParameterSpecException) {}
                }
                ((a)this).d = rSAPssParameterSpec.getHashAlgorithm();
                try {
                    this.hash = rSAPssParameterSpec.getHashEngine();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidAlgorithmParameterException("Cannot set hash algorithm parameter; no hash engine available: " + noSuchAlgorithmException.getMessage());
                }
                this.e = rSAPssParameterSpec.getMaskGenAlgorithm();
                try {
                    this.f = rSAPssParameterSpec.getMGFEngine();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidAlgorithmParameterException("Cannot set mask generation algorithm parameter; no mgf engine available: " + noSuchAlgorithmException.getMessage());
                }
                this.d = rSAPssParameterSpec.getSaltLength();
                if (this.d < 0) {
                    throw new InvalidAlgorithmParameterException("Cannot set saltLength parameter; must not be negative.");
                }
                this.c = rSAPssParameterSpec.getSalt();
                SecureRandom secureRandom = rSAPssParameterSpec.getSecureRandom();
                if (secureRandom != null) {
                    this.a(secureRandom);
                }
                this.h = (RSAPssParameterSpec)rSAPssParameterSpec.clone();
                return;
            }
            throw new InvalidAlgorithmParameterException("Params must be a RSAPssParameterSpec!");
        }
        this.h = null;
        this.d();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey;
        block11: {
            rSAPublicKey = Util.getRSAPublicKey(publicKey);
            if (rSAPublicKey instanceof RSAPssPublicKey) {
                try {
                    AlgorithmParameterSpec algorithmParameterSpec = ((RSAPssPublicKey)rSAPublicKey).getParams();
                    if (algorithmParameterSpec == null) break block11;
                    if (this.h != null) {
                        if (a) {
                            try {
                                if (!RSAPssPublicKey.a((RSAPssParameterSpec)algorithmParameterSpec, this.h)) {
                                    throw new InvalidKeyException("Application set parameters are not valid for PSS-Key used with this engine!");
                                }
                            }
                            catch (InvalidParameterSpecException invalidParameterSpecException) {}
                        }
                    } else {
                        this.engineSetParameter(algorithmParameterSpec);
                    }
                    this.g = (RSAPssParameterSpec)((RSAPssParameterSpec)algorithmParameterSpec).clone();
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw invalidKeyException;
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("RSA-PSS key contains invalid parameters: " + exception.toString());
                }
            }
        }
        super.engineInitVerify(rSAPublicKey);
        if (this.f != null) {
            this.f.reset();
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        block11: {
            rSAPrivateKey = Util.getRSAPrivateKey(privateKey);
            if (rSAPrivateKey instanceof RSAPssPrivateKey) {
                try {
                    AlgorithmParameterSpec algorithmParameterSpec = ((RSAPssPrivateKey)rSAPrivateKey).getParams();
                    if (algorithmParameterSpec == null) break block11;
                    if (this.h != null) {
                        if (a) {
                            try {
                                if (!RSAPssPublicKey.a((RSAPssParameterSpec)algorithmParameterSpec, this.h)) {
                                    throw new InvalidKeyException("Application set parameters are not valid for PSS-Key used with this engine!");
                                }
                            }
                            catch (InvalidParameterSpecException invalidParameterSpecException) {}
                        }
                    } else {
                        this.engineSetParameter(algorithmParameterSpec);
                    }
                    this.g = (RSAPssParameterSpec)((RSAPssParameterSpec)algorithmParameterSpec).clone();
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw invalidKeyException;
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("RSA-PSS key contains invalid parameters: " + exception.toString());
                }
            }
        }
        super.engineInitSign(rSAPrivateKey);
        if (this.f != null) {
            this.f.reset();
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (((a)this).d != null && this.e != null) {
            try {
                RSAPssParameterSpec rSAPssParameterSpec = new RSAPssParameterSpec(((a)this).d, this.e, this.d);
                algorithmParameters = AlgorithmParameters.getInstance(l, "IAIK");
                algorithmParameters.init(rSAPssParameterSpec);
                return algorithmParameters;
            }
            catch (Exception exception) {
            }
        }
        return algorithmParameters;
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return this.engineGetParameters();
    }

    protected RSAPssSignature(String string) {
        super(string, k);
    }

    public RSAPssSignature() {
        this(l);
        this.d();
    }
}

