/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2002;

import finanze.IDTE.generale2002.Util;
import finanze.IDTE.resources.ResourceLoader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ComuniProvincia {
    public static final String fileResProvince = "province_range.res";
    public static final String fileResComCCatAliq = "comuni_ccat_aliq.res";
    private static String[] comuni = null;
    private static String[] codCatastali = null;
    private static double[] aliquote = null;
    public static int[] aliqIncerte = null;
    private static Hashtable provinceRange = null;
    private static Hashtable ricercaCodCat = null;
    public static final Object lock = new Object();

    public static final boolean esisteCodCat(String string) {
        ComuniProvincia.loadRicercaCodCat();
        return ricercaCodCat.containsKey(string);
    }

    public static final double getAliquota(String string) {
        ComuniProvincia.load();
        int n = codCatastali.length;
        int n2 = 0;
        while (n2 < n) {
            if (codCatastali[n2].equals(string)) {
                return aliquote[n2];
            }
            ++n2;
        }
        return -1.0;
    }

    public static final boolean getAliquotaIncerta(String string, double[] dArray) {
        ComuniProvincia.load();
        boolean bl = false;
        dArray[0] = -1.0;
        int n = 0;
        while (n < codCatastali.length) {
            if (codCatastali[n].equals(string)) {
                dArray[0] = aliquote[n];
                if (aliqIncerte.length == 0) {
                    return false;
                }
                int n2 = 0;
                while (!bl && n2 < aliqIncerte.length) {
                    if (aliqIncerte[n2] == n) {
                        bl = true;
                    }
                    ++n2;
                }
                return bl;
            }
            ++n;
        }
        return false;
    }

    public static final String[] getCodCatastaleEAliquota(String string, String string2) {
        String[] stringArray = new String[2];
        ComuniProvincia.load();
        ProvComIndici provComIndici = (ProvComIndici)provinceRange.get(string);
        int n = provComIndici.primo;
        while (n <= provComIndici.ultimo) {
            if (comuni[n].equalsIgnoreCase(string2)) {
                stringArray[0] = codCatastali[n];
                if (aliquote[n] == 0.0) {
                    stringArray[1] = "0";
                    break;
                }
                stringArray[1] = String.valueOf(aliquote[n]).replace('.', ',');
                break;
            }
            ++n;
        }
        return stringArray;
    }

    public static final String[] getComDaProv(String string) {
        ComuniProvincia.load();
        ProvComIndici provComIndici = (ProvComIndici)provinceRange.get(string);
        int n = provComIndici.ultimo - provComIndici.primo + 1;
        String[] stringArray = new String[n];
        System.arraycopy(comuni, provComIndici.primo, stringArray, 0, n);
        return stringArray;
    }

    public static String[] getComProvDaCodCat(String string) {
        ComuniProvincia.load();
        String[] stringArray = new String[2];
        int n = -1;
        int n2 = codCatastali.length;
        int n3 = 0;
        while (n3 < n2) {
            if (codCatastali[n3].equals(string)) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n == -1) {
            return null;
        }
        stringArray[0] = comuni[n];
        Enumeration enumeration = provinceRange.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ProvComIndici provComIndici = (ProvComIndici)provinceRange.get(string2);
            if (n < provComIndici.primo || n > provComIndici.ultimo) continue;
            stringArray[1] = string2;
            return stringArray;
        }
        return null;
    }

    public static final String getRegDaProv(String string) {
        ComuniProvincia.load();
        ProvComIndici provComIndici = (ProvComIndici)provinceRange.get(string);
        return Util.formNum(2, provComIndici.codRegione);
    }

    public static void load() {
        Object object = lock;
        synchronized (object) {
            if (provinceRange == null || comuni == null) {
                System.out.println("Caricamento delle province dal file di risorse province_range.res");
                provinceRange = new Hashtable();
                ProvLoader provLoader = new ProvLoader(provinceRange);
                try {
                    provLoader.load(fileResProvince);
                }
                catch (IOException iOException) {
                    System.out.println("Errore nel caricamento del file di risorse province_range.res");
                }
                System.out.println("OK, province caricate.");
                System.out.println("Caricamento di comuni, cod.catastali e aliquote dal file di risorse province_range.res");
                Vector vector = new Vector();
                Vector<Integer> vector2 = new Vector<Integer>();
                ComCCatAliqLoader comCCatAliqLoader = new ComCCatAliqLoader(vector);
                try {
                    comCCatAliqLoader.load(fileResComCCatAliq);
                    comuni = new String[vector.size()];
                    codCatastali = new String[vector.size()];
                    aliquote = new double[vector.size()];
                    int n = 0;
                    while (n < vector.size()) {
                        String[] stringArray = (String[])vector.elementAt(n);
                        ComuniProvincia.comuni[n] = stringArray[0];
                        ComuniProvincia.codCatastali[n] = stringArray[1];
                        if (stringArray[2].endsWith("?")) {
                            vector2.addElement(new Integer(n));
                            ComuniProvincia.aliquote[n] = Double.valueOf(stringArray[2].substring(0, stringArray[2].length() - 1));
                        } else {
                            ComuniProvincia.aliquote[n] = Double.valueOf(stringArray[2]);
                        }
                        ++n;
                    }
                    aliqIncerte = new int[vector2.size()];
                    n = 0;
                    while (n < vector2.size()) {
                        ComuniProvincia.aliqIncerte[n] = (Integer)vector2.elementAt(n);
                        ++n;
                    }
                    comCCatAliqLoader.resetData();
                    System.out.println("OK, comuni, cod.catastali e aliquote caricati.");
                }
                catch (IOException iOException) {
                    System.out.println("Errore nel caricamento del file di risorse comuni_ccat_aliq.res");
                }
            }
        }
    }

    public static void loadRicercaCodCat() {
        if (ricercaCodCat == null) {
            System.out.println("Caricamento dei codici catastali dal file di risorse comuni_ccat_aliq.res");
            ricercaCodCat = new Hashtable();
            CodCatLoader codCatLoader = new CodCatLoader();
            try {
                codCatLoader.load(fileResComCCatAliq);
            }
            catch (IOException iOException) {
                System.out.println("Errore nel caricamento del file di risorse comuni_ccat_aliq.res");
            }
            System.out.println("OK, codici catastali caricati.");
        }
    }

    public static void unload() {
        ComuniProvincia.unload(true);
    }

    public static void unload(boolean bl) {
        provinceRange = null;
        comuni = null;
        codCatastali = null;
        aliquote = null;
        System.out.println("OK, province, comuni, cod.catastali e aliquote scaricati" + (bl ? " ed eliminati dalla memoria." : "."));
        if (bl) {
            System.gc();
        }
    }

    public static void unloadRicercaCodCat() {
        ComuniProvincia.unloadRicercaCodCat(true);
    }

    public static void unloadRicercaCodCat(boolean bl) {
        ricercaCodCat = null;
        System.out.println("OK, codici catastali scaricati" + (bl ? " ed eliminati dalla memoria." : "."));
        if (bl) {
            System.gc();
        }
    }

    static Hashtable access$ricercaCodCat() {
        return ricercaCodCat;
    }

    static final class ProvComIndici {
        int primo = 0;
        int ultimo = 0;
        int codRegione = 0;

        public ProvComIndici(int n, int n2, int n3) {
            this.primo = n;
            this.ultimo = n2;
            this.codRegione = n3;
        }
    }

    static class ProvLoader
    extends ResourceLoader {
        public ProvLoader(Object object) {
            super(object);
        }

        protected Object createValue(String string) {
            int n = string.indexOf(",");
            int n2 = string.indexOf("*");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, n2);
            String string4 = string.substring(n2 + 1);
            return new ProvComIndici(Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4));
        }
    }

    static class ComCCatAliqLoader
    extends ResourceLoader {
        public ComCCatAliqLoader(Object object) {
            super(object);
        }

        public void resetData() {
            this.resourceData = null;
        }

        protected Object createValue(String string) {
            String[] stringArray = new String[3];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < 3 && n2 >= 0) {
                n2 = string.indexOf("*", n3);
                stringArray[n] = n2 == -1 ? string.substring(n3) : string.substring(n3, n2);
                n3 = n2 + 1;
                ++n;
            }
            if (n < 3) {
                throw new RuntimeException("Impossibile costruire la tabella Comuni/Cod.Catastali/Aliquote: parametri insufficienti");
            }
            return new String[]{stringArray[0], stringArray[1], stringArray[2]};
        }
    }

    static class CodCatLoader
    extends ResourceLoader {
        private String sep = "*";
        private Integer dummyInt = new Integer(0);

        public CodCatLoader() {
            super(new Vector());
        }

        protected void loadData(String string) {
            int n = string.indexOf(this.sep);
            int n2 = string.lastIndexOf(this.sep);
            String string2 = string.substring(n + 1, n2);
            ComuniProvincia.access$ricercaCodCat().put(string2, this.dummyInt);
        }

        protected Object createValue(String string) {
            return null;
        }
    }
}

