/*
 * Decompiled with CFR 0.152.
 */
package demo.smime.ess;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import demo.smime.ess.MySecurityLabelHandler;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.smime.SMimeSignerInfo;
import iaik.smime.SignedContent;
import iaik.smime.ess.ESSSecurityLabel;
import iaik.smime.ess.SecurityLabelException;
import iaik.smime.ess.utils.SecurityLabelHandler;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SecurityLabelDemo {
    X509Certificate encryptionCertOfSigner;
    PrivateKey signerPrivateKey;
    X509Certificate signerCertificate;
    X509Certificate[] signerCertificates;
    String host = "mailhost";
    String from = "smimetest@iaik.at";
    String to = "smimetest@iaik.at";
    String lastName = "SMime";
    String firstName = "John";
    static final boolean a = false;

    public void start() throws IOException {
        Session session = DemoUtil.getSession();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Message message = this.createSignedMessage(session);
            System.out.println("creating implicitly signed message...");
            byteArrayOutputStream.reset();
            message.saveChanges();
            message.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            this.parseMessage(message);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    private static void a(Message message) throws IOException {
        System.out.println("------------------------------------------------------------------");
        System.out.println("Message dump: \n");
        try {
            message.writeTo((OutputStream)System.out);
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.getMessage());
        }
        System.out.println("\n------------------------------------------------------------------");
    }

    public void parseMessage(Message message) throws SignatureException, MessagingException, IOException {
        SignedContent signedContent = (SignedContent)message.getContent();
        signedContent.setSecurityLabelHandler((SecurityLabelHandler)new MySecurityLabelHandler());
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = signedContent.verify();
            System.out.println("This message is signed from: " + x509Certificate.getSubjectDN());
        }
        catch (SignatureException signatureException) {
            throw new SignatureException("Signature verification error: " + signatureException.toString());
        }
        try {
            Object object = signedContent.getContent();
            System.out.println("Included content:");
            if (object instanceof String) {
                System.out.println(object);
                return;
            }
            if (object instanceof InputStream) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Utils.copyStream((InputStream)((InputStream)object), (OutputStream)byteArrayOutputStream, null);
                System.out.println(new String(byteArrayOutputStream.toByteArray()));
                return;
            }
        }
        catch (SecurityLabelException securityLabelException) {
            System.out.println(securityLabelException.getMessage());
        }
    }

    public static void main(String[] stringArray) throws IOException {
        DemoUtil.initSMimeDemos();
        try {
            new SecurityLabelDemo().start();
            System.out.println("Ready!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Util.waitKey();
        System.exit(0);
    }

    public Message createSignedMessage(Session session) throws Exception {
        String string = "IAIK-S/MIME: SecurityLabelDemo (Explicitly Signed)";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This is an explicitly signed message\n");
        stringBuffer.append("containing an ESSSecurityLabel attribute.\n");
        Message message = this.createMessage(session, string);
        SignedContent signedContent = new SignedContent(true);
        signedContent.setText(stringBuffer.toString());
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        SMimeSignerInfo sMimeSignerInfo = new SMimeSignerInfo(this.signerCertificate, AlgorithmID.sha1, AlgorithmID.rsaEncryption, this.signerPrivateKey, this.encryptionCertOfSigner, true);
        ESSSecurityLabel eSSSecurityLabel = new ESSSecurityLabel(MySecurityLabelHandler.MY_SECURITY_POLICY_ID);
        eSSSecurityLabel.setSecurityClassification(3);
        eSSSecurityLabel.setPrivacyMarkString("HIGH CONFIDENTIAL DATA MATERIAL! RESTRICTED USER ACCESS");
        sMimeSignerInfo.addSignedAttribute(new Attribute((AttributeValue)eSSSecurityLabel));
        signedContent.addSigner((SignerInfo)sMimeSignerInfo);
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        return message;
    }

    public Message createMessage(Session session, String string) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.from));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
        mimeMessage.setSentDate(new Date());
        mimeMessage.setSubject(string);
        return mimeMessage;
    }

    public SecurityLabelDemo() {
        System.out.println();
        System.out.println("******************************************************************************************");
        System.out.println("*                               SecurityLabelDemo demo                                   *");
        System.out.println("*                  (shows how to handle the ESS SecurityLabel attribute)                 *");
        System.out.println("******************************************************************************************");
        System.out.println();
        this.signerCertificates = CMSKeyStore.getCertificateChain(0, 1);
        this.signerPrivateKey = CMSKeyStore.getPrivateKey(0, 1);
        this.signerCertificate = this.signerCertificates[0];
        this.encryptionCertOfSigner = CMSKeyStore.getCertificateChain(0, 4)[0];
        CMSKeyStore.getPrivateKey(0, 5);
    }
}

