/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.decoration;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.decoration.AbstractShapeDecoration;
import org.xmind.gef.draw2d.decoration.IShapeDecorationEx;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;

public abstract class PathShapeDecoration
extends AbstractShapeDecoration
implements IShapeDecorationEx {
    private static final PrecisionPoint REF = new PrecisionPoint();
    protected static final int FILL = 1;
    protected static final int OUTLINE = 2;
    protected static final int CHECK = 3;

    protected PathShapeDecoration() {
    }

    protected PathShapeDecoration(String id) {
        super(id);
    }

    protected void paintFill(IFigure figure, Graphics graphics) {
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.sketch(figure, shape, this.getOutlineBox(figure), 1);
        this.paintPath(figure, graphics, shape, true);
        shape.dispose();
    }

    protected void paintOutline(IFigure figure, Graphics graphics) {
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.sketch(figure, shape, this.getOutlineBox(figure), 2);
        this.paintPath(figure, graphics, shape, false);
        shape.dispose();
    }

    protected void paintPath(IFigure figure, Graphics graphics, org.xmind.gef.draw2d.graphics.Path path, boolean fill) {
        if (fill) {
            graphics.fillPath((Path)path);
        } else if (this.getLineWidth() > 0) {
            graphics.drawPath((Path)path);
        }
    }

    public boolean containsPoint(IFigure figure, int x, int y) {
        return this.containsPoint(figure, x, y, false);
    }

    protected boolean containsPoint(IFigure figure, int x, int y, boolean outline) {
        this.checkValidation(figure);
        GC gc = GraphicsUtils.getAdvanced().getGC();
        gc.setLineWidth(this.getCheckingLineWidth());
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.sketch(figure, shape, this.getOutlineBox(figure), 3);
        boolean ret = shape.contains(x, y, gc, outline);
        shape.dispose();
        return ret;
    }

    protected int getCheckingLineWidth() {
        return this.getLineWidth();
    }

    protected abstract void sketch(IFigure var1, org.xmind.gef.draw2d.graphics.Path var2, Rectangle var3, int var4);

    public PrecisionPoint getAnchorLocation(IFigure figure, int orientation, double expansion) {
        this.checkValidation(figure);
        switch (orientation) {
            case 8: {
                return this.getWest(figure, expansion);
            }
            case 4: {
                return this.getSouth(figure, expansion);
            }
            case 1: {
                return this.getNorth(figure, expansion);
            }
            case 16: {
                return this.getEast(figure, expansion);
            }
            case 2: {
                return REF.setLocation(figure.getBounds().getCenter());
            }
        }
        return null;
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        return Geometry.getChopBoxLocation(refX, refY, this.getOutlineBox(figure), expansion);
    }

    protected PrecisionPoint getEast(IFigure figure, double expansion) {
        PrecisionPoint ref = this.getReferencePoint(figure, REF);
        return this.getAnchorLocation(figure, ref.x + 100.0, ref.y, expansion);
    }

    protected PrecisionPoint getNorth(IFigure figure, double expansion) {
        PrecisionPoint ref = this.getReferencePoint(figure, REF);
        return this.getAnchorLocation(figure, ref.x, ref.y - 100.0, expansion);
    }

    protected PrecisionPoint getSouth(IFigure figure, double expansion) {
        PrecisionPoint ref = this.getReferencePoint(figure, REF);
        return this.getAnchorLocation(figure, ref.x, ref.y + 100.0, expansion);
    }

    protected PrecisionPoint getWest(IFigure figure, double expansion) {
        PrecisionPoint ref = this.getReferencePoint(figure, REF);
        return this.getAnchorLocation(figure, ref.x - 100.0, ref.y, expansion);
    }

    protected PrecisionPoint getReferencePoint(IFigure figure, PrecisionPoint result) {
        if (figure instanceof IReferencedFigure) {
            return result.setLocation(((IReferencedFigure)figure).getReference());
        }
        return result.setLocation(figure.getBounds().getCenter());
    }
}

