/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command.remote.lan.dnssd;

import com.apple.dnssd.BrowseListener;
import com.apple.dnssd.DNSSD;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDRegistration;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.RegisterListener;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.core.command.remote.AbstractRemoteCommandServiceDiscoverer;
import org.xmind.core.command.remote.ICommandServerAdvertiser;
import org.xmind.core.command.remote.ICommandServiceInfo;
import org.xmind.core.command.remote.IIdentifier;
import org.xmind.core.command.remote.IRemoteCommandService;
import org.xmind.core.command.remote.IRemoteCommandServiceDiscoverer;
import org.xmind.core.command.remote.Identifier;
import org.xmind.core.command.remote.socket.ISocketAddress;
import org.xmind.core.command.remote.socket.SocketPool;
import org.xmind.core.internal.command.remote.lan.LANRemoteCommandPlugin;
import org.xmind.core.internal.command.remote.lan.Messages;
import org.xmind.core.internal.command.remote.lan.Util;
import org.xmind.core.internal.command.remote.lan.dnssd.AsyncQueuedExecutor;
import org.xmind.core.internal.command.remote.lan.dnssd.DNSSDCommandServiceInfo;
import org.xmind.core.internal.command.remote.lan.dnssd.DNSSDRemoteCommandService;
import org.xmind.core.internal.command.remote.lan.dnssd.ResolveAdapter;

public class DNSSDDiscoveryServiceAdapter
extends AbstractRemoteCommandServiceDiscoverer
implements ICommandServerAdvertiser,
IRemoteCommandServiceDiscoverer,
BrowseListener {
    private static final String OPTION = "/debug/dnssd";
    private static boolean DEBUGGING = LANRemoteCommandPlugin.isDebugging("/debug/dnssd");
    private static final String SERVICE_TYPE = "_xmind._tcp";
    protected static final String NAME = "name";
    private DNSSDService browser = null;
    private Object lock = new Object();
    private boolean active = false;
    private boolean deactivating = false;
    private boolean unregistering = false;
    private ICommandServiceInfo registeringInfo = null;
    private DNSSDCommandServiceInfo registeredInfo = null;
    private AsyncQueuedExecutor asyncQueue = null;
    private Object queueLock = new Object();
    private RegisterListener registerListener = new RegisterListener(){

        public void operationFailed(DNSSDService service, int errorCode) {
            LANRemoteCommandPlugin.log("DNSSD registration failed: ErrorCode=" + errorCode, null);
        }

        public void serviceRegistered(final DNSSDRegistration registration, final int flags, final String serviceName, final String regType, final String domain) {
            if (DEBUGGING) {
                System.out.println("Local DNSSD service registered: " + serviceName + " regType=" + regType + " domain=" + domain);
            }
            DNSSDDiscoveryServiceAdapter.this.enqueue(new Runnable(){

                public void run() {
                    IRemoteCommandService conflictingRemoteCommandService;
                    if (DNSSDDiscoveryServiceAdapter.this.active && !DNSSDDiscoveryServiceAdapter.this.deactivating && DNSSDDiscoveryServiceAdapter.this.registeredInfo != null) {
                        long end;
                        long start;
                        if (DNSSDDiscoveryServiceAdapter.this.browser != null) {
                            start = System.currentTimeMillis();
                            DNSSDDiscoveryServiceAdapter.this.browser.stop();
                            end = System.currentTimeMillis();
                            if (DEBUGGING) {
                                System.out.println("DNSSD browser stopped: (" + (end - start) + " ms)");
                            }
                            DNSSDDiscoveryServiceAdapter.this.browser = null;
                        }
                        start = System.currentTimeMillis();
                        IRemoteCommandService[] services = DNSSDDiscoveryServiceAdapter.this.getRemoteCommandServices();
                        int i = 0;
                        while (i < services.length) {
                            DNSSDDiscoveryServiceAdapter.this.remoteCommandServiceDropped(services[i]);
                            ++i;
                        }
                        end = System.currentTimeMillis();
                        if (DEBUGGING) {
                            System.out.println("All DNSSD remote command services removed: " + services.length + " (" + (end - start) + " ms)");
                        }
                        if (DNSSDDiscoveryServiceAdapter.this.browser == null) {
                            try {
                                start = System.currentTimeMillis();
                                DNSSDService service = DNSSD.browse((String)DNSSDDiscoveryServiceAdapter.SERVICE_TYPE, (BrowseListener)DNSSDDiscoveryServiceAdapter.this);
                                end = System.currentTimeMillis();
                                if (DEBUGGING) {
                                    System.out.println("DNSSD browse listener installed: (" + (end - start) + " ms)");
                                }
                                DNSSDDiscoveryServiceAdapter.this.browser = service;
                            }
                            catch (DNSSDException e) {
                                LANRemoteCommandPlugin.log("Failed to restart DNSSD browser.", e);
                            }
                        }
                    }
                    if ((conflictingRemoteCommandService = DNSSDDiscoveryServiceAdapter.this.findRemoteCommandService(serviceName)) != null) {
                        if (DEBUGGING) {
                            System.out.println("Removing conflicting remote command service: " + serviceName);
                        }
                        DNSSDDiscoveryServiceAdapter.this.remoteCommandServiceDropped(conflictingRemoteCommandService);
                    }
                    DNSSDCommandServiceInfo source = DNSSDDiscoveryServiceAdapter.this.registeredInfo != null ? DNSSDDiscoveryServiceAdapter.this.registeredInfo : DNSSDDiscoveryServiceAdapter.this.registeringInfo;
                    DNSSDCommandServiceInfo info = new DNSSDCommandServiceInfo((ICommandServiceInfo)source, registration, flags, serviceName, regType, domain);
                    info.setId((IIdentifier)new Identifier(DNSSDDiscoveryServiceAdapter.this.getDomain().getId(), serviceName));
                    DNSSDDiscoveryServiceAdapter.this.registeredInfo = info;
                }
            });
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus activate(IProgressMonitor monitor) {
        if (DEBUGGING) {
            System.out.println("Activating DNSSD discovery service.");
        }
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_OperationLock);
        this.deactivating = false;
        Object object = this.lock;
        synchronized (object) {
            monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_ActivateRemoteCommand);
            Object object2 = this.queueLock;
            synchronized (object2) {
                if (this.asyncQueue == null) {
                    this.asyncQueue = new AsyncQueuedExecutor("DNSSDEventHandlingQueue");
                }
            }
            if (this.browser == null) {
                try {
                    long start = System.currentTimeMillis();
                    DNSSDService service = DNSSD.browse((String)SERVICE_TYPE, (BrowseListener)this);
                    long end = System.currentTimeMillis();
                    if (DEBUGGING) {
                        System.out.println("DNSSD browse listener installed: (" + (end - start) + " ms)");
                    }
                    this.browser = service;
                }
                catch (DNSSDException e) {
                    return new Status(4, "org.xmind.core.command.remote.lan", null, (Throwable)e);
                }
                catch (Throwable e) {
                    return new Status(4, "org.xmind.core.command.remote.lan", 23333, Messages.DNSSDDiscoveryServiceAdapter_RemoteCommandServiceDiscoverer, e);
                }
            }
            monitor.worked(90);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.active = true;
            monitor.done();
            if (DEBUGGING) {
                System.out.println("Activated DNSSD discovery service.");
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus deactivate(IProgressMonitor monitor) {
        if (DEBUGGING) {
            System.out.println("Deactivating DNSSD discovery service.");
        }
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_OperationLock);
        this.deactivating = true;
        Object object = this.lock;
        synchronized (object) {
            monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_DeactivateRemoteCommand);
            long start = System.currentTimeMillis();
            IRemoteCommandService[] services = this.getRemoteCommandServices();
            int i = 0;
            while (i < services.length) {
                this.remoteCommandServiceDropped(services[i]);
                ++i;
            }
            long end = System.currentTimeMillis();
            if (DEBUGGING) {
                System.out.println("All DNSSD remote command services removed: " + services.length + " (" + (end - start) + " ms)");
            }
            if (this.browser != null) {
                start = System.currentTimeMillis();
                this.browser.stop();
                end = System.currentTimeMillis();
                if (DEBUGGING) {
                    System.out.println("DNSSD browser stopped: (" + (end - start) + " ms)");
                }
                this.browser = null;
            }
            Object object2 = this.queueLock;
            synchronized (object2) {
                if (this.asyncQueue != null) {
                    this.asyncQueue.dispose();
                    this.asyncQueue = null;
                }
            }
            this.active = false;
            monitor.done();
            if (DEBUGGING) {
                System.out.println("Deactivated DNSSD discovery service.");
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus refresh(IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_OperationLock);
        Object object = this.lock;
        synchronized (object) {
            long end;
            long start;
            monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_RefreshRemoteCommand);
            if (this.browser != null) {
                start = System.currentTimeMillis();
                this.browser.stop();
                end = System.currentTimeMillis();
                if (DEBUGGING) {
                    System.out.println("DNSSD browser stopped: (" + (end - start) + " ms)");
                }
                this.browser = null;
            }
            monitor.worked(30);
            start = System.currentTimeMillis();
            IRemoteCommandService[] services = this.getRemoteCommandServices();
            int i = 0;
            while (i < services.length) {
                this.remoteCommandServiceDropped(services[i]);
                ++i;
            }
            end = System.currentTimeMillis();
            if (DEBUGGING) {
                System.out.println("All DNSSD remote command services removed: " + services.length + " (" + (end - start) + " ms)");
            }
            monitor.worked(40);
            if (this.browser == null) {
                try {
                    start = System.currentTimeMillis();
                    DNSSDService service = DNSSD.browse((String)SERVICE_TYPE, (BrowseListener)this);
                    end = System.currentTimeMillis();
                    if (DEBUGGING) {
                        System.out.println("DNSSD browse listener installed: (" + (end - start) + " ms)");
                    }
                    this.browser = service;
                }
                catch (DNSSDException e) {
                    return new Status(4, "org.xmind.core.command.remote.lan", null, (Throwable)e);
                }
            }
            monitor.worked(30);
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    public void operationFailed(DNSSDService service, int errorCode) {
        if (DEBUGGING) {
            System.out.println("DNSSD operation failed: (ErrorCode=" + errorCode + ") " + service);
        } else {
            LANRemoteCommandPlugin.log("DNSSD operation failed: (ErrorCode=" + errorCode + ") " + service, null);
        }
    }

    public void serviceFound(DNSSDService browser, final int flags, final int ifIndex, final String serviceName, final String regType, final String domain) {
        if (DEBUGGING) {
            System.out.println("DNSSD remote service found: " + serviceName + " regType=" + regType + " domain=" + domain);
        }
        this.enqueue(new Runnable(){

            public void run() {
                if (!DNSSDDiscoveryServiceAdapter.this.active || DNSSDDiscoveryServiceAdapter.this.deactivating) {
                    if (DEBUGGING) {
                        System.out.println("DNSSD service found but discoverer is not active.");
                    }
                    return;
                }
                if (DNSSDDiscoveryServiceAdapter.this.registeredInfo != null && ((DNSSDDiscoveryServiceAdapter)DNSSDDiscoveryServiceAdapter.this).registeredInfo.serviceName.equals(serviceName)) {
                    if (DEBUGGING) {
                        System.out.println("Local DNSSD service found: " + serviceName);
                    }
                    return;
                }
                if (DEBUGGING) {
                    System.out.println("Resolving and adding remote DNSSD service: " + serviceName);
                }
                new RemoteCommandServiceAdder(flags, ifIndex, serviceName, regType, domain);
            }
        });
    }

    public void serviceLost(DNSSDService browser, int flags, int ifIndex, final String serviceName, String regType, String domain) {
        if (DEBUGGING) {
            System.out.println("DNSSD remote service lost: " + serviceName + " regType=" + regType + " domain=" + domain);
        }
        this.enqueue(new Runnable(){

            public void run() {
                if (!DNSSDDiscoveryServiceAdapter.this.active || DNSSDDiscoveryServiceAdapter.this.deactivating) {
                    if (DEBUGGING) {
                        System.out.println("DNSSD remote service lost but discoverer is not active.");
                    }
                    return;
                }
                IRemoteCommandService service = DNSSDDiscoveryServiceAdapter.this.findRemoteCommandService(serviceName);
                if (service != null) {
                    DNSSDDiscoveryServiceAdapter.this.remoteCommandServiceDropped(service);
                }
                if (DEBUGGING) {
                    System.out.println("DNSSD remote service removed: " + serviceName);
                }
            }
        });
    }

    public void setRegisteringInfo(ICommandServiceInfo info) {
        this.registeringInfo = info;
    }

    public ICommandServiceInfo getRegisteredInfo() {
        return this.registeredInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public IStatus register(IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_OperationLock);
        this.unregistering = false;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        var6_2 = this.lock;
        synchronized (var6_2) {
            block17: {
                monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_RegisterLocalCommandServer);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.registeredInfo != null) break block17;
                address = (ISocketAddress)this.registeringInfo.getAdapter(ISocketAddress.class);
                if (address == null) {
                    return new Status(4, "org.xmind.core.command.remote.lan", Messages.DNSSDDiscoveryServiceAdapter_RegisterSocketFailed);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                port = address.getPort();
                txtRecord = new TXTRecord();
                txtRecord.set("name", this.registeringInfo.getName());
                DNSSDDiscoveryServiceAdapter.extractMetadata(this.registeringInfo, txtRecord, "ver");
                DNSSDDiscoveryServiceAdapter.extractMetadata(this.registeringInfo, txtRecord, "cli");
                DNSSDDiscoveryServiceAdapter.extractMetadata(this.registeringInfo, txtRecord, "cliid");
                DNSSDDiscoveryServiceAdapter.extractMetadata(this.registeringInfo, txtRecord, "cliver");
                DNSSDDiscoveryServiceAdapter.extractMetadata(this.registeringInfo, txtRecord, "clibid");
                if (DNSSDDiscoveryServiceAdapter.DEBUGGING) {
                    System.out.println("DNSSD local service registration about to start: port=" + port + " regType=" + "_xmind._tcp" + " txtRecord=" + txtRecord);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                start = System.currentTimeMillis();
                try {
                    DNSSD.register((int)0, (int)0, null, (String)"_xmind._tcp", null, null, (int)port, (TXTRecord)txtRecord, (RegisterListener)this.registerListener);
                    if (true) ** GOTO lbl41
                }
                catch (DNSSDException e) {
                    return new Status(4, "org.xmind.core.command.remote.lan", null, (Throwable)e);
                }
                {
                    do {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        Thread.sleep(1L);
lbl41:
                        // 2 sources

                    } while (this.registeredInfo == null && !this.unregistering);
                }
                if (this.unregistering) {
                    return Status.CANCEL_STATUS;
                }
                end = System.currentTimeMillis();
                if (DNSSDDiscoveryServiceAdapter.DEBUGGING) {
                    System.out.println("DNSSD local service registered: (" + (end - start) + " ms)");
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus unregister(IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_OperationLock);
        this.unregistering = true;
        Object object = this.lock;
        synchronized (object) {
            monitor.subTask(Messages.DNSSDDiscoveryServiceAdapter_UnregisteredLocalCommandServer);
            if (this.registeredInfo != null) {
                long start = System.currentTimeMillis();
                this.registeredInfo.registration.stop();
                long end = System.currentTimeMillis();
                if (DEBUGGING) {
                    System.out.println("DNSSD local service registration stopped: (" + (end - start) + " ms)");
                }
                this.registeredInfo = null;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    private static void extractMetadata(ICommandServiceInfo info, TXTRecord txtRecord, String key) {
        String value = info.getMetadata(key);
        if (value != null) {
            txtRecord.set(key, Util.encode(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Runnable task) {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.asyncQueue != null) {
                this.asyncQueue.execute(task);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private class RemoteCommandServiceAdder
    extends ResolveAdapter {
        private DNSSDService resolver;

        public RemoteCommandServiceAdder(int flags, int ifIndex, String serviceName, String regType, String domain) {
            super(flags, ifIndex, serviceName, regType, domain);
            try {
                this.resolver = DNSSD.resolve((int)flags, (int)ifIndex, (String)serviceName, (String)regType, (String)domain, (ResolveListener)this);
            }
            catch (DNSSDException e) {
                this.resolver = null;
                LANRemoteCommandPlugin.log(null, e);
            }
        }

        public void serviceResolved(DNSSDService resolver, int flags, int ifIndex, String fullName, final String hostName, final int port, final TXTRecord txtRecord) {
            try {
                DNSSDDiscoveryServiceAdapter.this.enqueue(new Runnable(){

                    public void run() {
                        if (!DNSSDDiscoveryServiceAdapter.this.active || DNSSDDiscoveryServiceAdapter.this.deactivating) {
                            return;
                        }
                        if (DEBUGGING) {
                            System.out.println("DNSSD remote service resolved and about to be added: " + RemoteCommandServiceAdder.this.serviceName);
                        }
                        try {
                            DNSSDRemoteCommandService remoteCommandService = new DNSSDRemoteCommandService(RemoteCommandServiceAdder.this.getFlags(), RemoteCommandServiceAdder.this.getIfIndex(), RemoteCommandServiceAdder.this.getServiceName(), RemoteCommandServiceAdder.this.getRegType(), RemoteCommandServiceAdder.this.getDomainName(), hostName, port, txtRecord, DNSSDDiscoveryServiceAdapter.this.getDomain().getId());
                            remoteCommandService.setSocketPool((SocketPool)DNSSDDiscoveryServiceAdapter.this.getDomain().getCommandServer().getAdapter(SocketPool.class));
                            DNSSDDiscoveryServiceAdapter.this.remoteCommandServiceDiscovered(remoteCommandService);
                            if (DEBUGGING) {
                                System.out.println("DNSSD remote service resolved and added: " + RemoteCommandServiceAdder.this.serviceName);
                            }
                        }
                        catch (Throwable e) {
                            LANRemoteCommandPlugin.log(null, e);
                        }
                    }
                });
            }
            finally {
                this.stopResolver();
            }
        }

        private void stopResolver() {
            DNSSDService theResolver = this.resolver;
            this.resolver = null;
            if (theResolver != null) {
                theResolver.stop();
            }
        }
    }
}

