/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.internal.ActionMessages;
import org.xmind.ui.brainstorm.actions.UndoRedoAction;

public class RedoAction
extends UndoRedoAction {
    public RedoAction(IGraphicalViewer viewer) {
        super(viewer, "redo");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ActionFactory.IWorkbenchAction action = ActionFactory.REDO.create(window);
        this.setId(action.getId());
        this.setText(action.getText());
        this.setImageDescriptor(action.getImageDescriptor());
        this.setDisabledImageDescriptor(action.getDisabledImageDescriptor());
        this.setActionDefinitionId("org.eclipse.ui.edit.redo");
    }

    public void run() {
        ICommandStack redoStack = this.getCommandStack();
        if (redoStack == null) {
            return;
        }
        if (redoStack.canRedo()) {
            redoStack.redo();
        }
    }

    protected void update() {
        ICommandStack cs = this.getCommandStack();
        boolean canRedo = cs != null && cs.canRedo();
        this.setEnabled(canRedo);
        String label = null;
        if (canRedo && cs != null) {
            label = cs.getRedoLabel();
        }
        if (label == null) {
            this.setText(ActionMessages.RedoText);
            this.setToolTipText(ActionMessages.RedoTooltip);
        } else {
            this.setText(NLS.bind((String)ActionMessages.RedoTextFormat, (Object)label));
            this.setToolTipText(NLS.bind((String)ActionMessages.RedoTooltipFormat, (Object)label));
        }
    }
}

