/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.model;

import java.io.OutputStream;
import org.scribe.model.SignatureType;

public class OAuthConfig {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final SignatureType signatureType;
    private final String scope;
    private final OutputStream debugStream;

    public OAuthConfig(String key, String secret) {
        this(key, secret, null, null, null, null);
    }

    public OAuthConfig(String key, String secret, String callback, SignatureType type, String scope, OutputStream stream) {
        this.apiKey = key;
        this.apiSecret = secret;
        this.callback = callback;
        this.signatureType = type;
        this.scope = scope;
        this.debugStream = stream;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCallback() {
        return this.callback;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public void log(String message) {
        if (this.debugStream != null) {
            message = String.valueOf(message) + "\n";
            try {
                this.debugStream.write(message.getBytes("UTF8"));
            }
            catch (Exception e) {
                throw new RuntimeException("there were problems while writing to the debug stream", e);
            }
        }
    }
}

