/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.gefext.AbstractFeedback;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.PopupTaskInfoHelper;
import org.xmind.ui.gantt2.viewer.TaskBar;
import org.xmind.ui.gantt2.viewer.TaskBarPart;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.resources.FontUtils;

public class TaskBarToolTipFeedback
extends AbstractFeedback
implements PropertyChangeListener {
    private static final String ASSIGNEE_ICON_KEY = "org.xmind.ui.icon.assignee";
    private IFigure tooltip = null;
    private Set<Object> tooltipRequesters = new HashSet<Object>();
    private boolean hideScheduled = false;
    private static ImageDescriptor assigneeIcon;

    private static ImageDescriptor getAssigneeIcon() {
        if (assigneeIcon == null) {
            assigneeIcon = TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/assignee.gif");
        }
        return assigneeIcon;
    }

    private Image getImage(String key, ImageDescriptor desc) {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, desc);
            image = imageRegistry.get(key);
        }
        return image;
    }

    public TaskBarPart getHost() {
        return (TaskBarPart)super.getHost();
    }

    public void activate() {
        super.activate();
        this.getHost().getTaskBar().getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public void deactivate() {
        this.getHost().getTaskBar().getPropertyChangeSupport().removePropertyChangeListener(this);
        super.deactivate();
    }

    protected IFigure getMainFigure() {
        return this.getHost().getBarFigure();
    }

    private void showToolTip() {
        if (!this.getMainFigure().isShowing()) {
            return;
        }
        PopupTaskInfoHelper helper = this.getPopupHelper();
        if (helper != null) {
            helper.show(this.getMainFigure(), this.getToolTip());
            this.hideScheduled = false;
        }
    }

    private void hideToolTip() {
        if (this.hideScheduled) {
            return;
        }
        this.hideScheduled = true;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (!TaskBarToolTipFeedback.this.hideScheduled || !TaskBarToolTipFeedback.this.getHost().getStatus().isActive()) {
                    return;
                }
                PopupTaskInfoHelper helper = TaskBarToolTipFeedback.this.getPopupHelper();
                if (helper != null) {
                    helper.hide(TaskBarToolTipFeedback.this.getMainFigure());
                }
                TaskBarToolTipFeedback.this.hideScheduled = false;
            }
        });
    }

    private PopupTaskInfoHelper getPopupHelper() {
        return (PopupTaskInfoHelper)this.getHost().getSite().getViewer().getAdapter(PopupTaskInfoHelper.class);
    }

    private IFigure getToolTip() {
        if (this.tooltip == null) {
            this.tooltip = this.buildToolTip();
        }
        return this.tooltip;
    }

    private IFigure buildToolTip() {
        String progressText;
        TaskBar task = this.getHost().getTaskBar();
        Font normalFont = FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1);
        Font titleFont = FontUtils.getBold((String)"org.eclipse.jface.defaultfont");
        Layer layer = new Layer();
        layer.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        layer.setForegroundColor(Colors.tooltipTitle());
        layer.setFont(normalFont);
        RotatableWrapLabel title = new RotatableWrapLabel();
        title.setText(task.task.getTitleText());
        title.setFont(titleFont);
        layer.add((IFigure)title);
        String assigneeText = this.buildAssigneeText(task);
        if (assigneeText != null) {
            Layer assigneeLine = new Layer();
            assigneeLine.setLayoutManager((LayoutManager)new ToolbarLayout(true));
            RotatableWrapLabel assignee = new RotatableWrapLabel();
            assignee.setText(assigneeText);
            assigneeLine.add((IFigure)assignee);
            layer.add((IFigure)assigneeLine);
        }
        RotatableWrapLabel dates = new RotatableWrapLabel();
        dates.setText(this.buildDatesText(task));
        layer.add((IFigure)dates);
        String priorityText = this.buildPriorityText(task);
        if (priorityText != null) {
            RotatableWrapLabel priority = new RotatableWrapLabel();
            priority.setText(priorityText);
            priority.setOpaque(true);
            layer.add((IFigure)priority);
        }
        if ((progressText = this.buildProgressText(task)) != null) {
            RotatableWrapLabel progress = new RotatableWrapLabel();
            progress.setText(progressText);
            layer.add((IFigure)progress);
        }
        return layer;
    }

    private String buildPriorityText(TaskBar task) {
        String priorityId = task.getPriority();
        if (priorityId == null) {
            return null;
        }
        String label = task.task.getOwnedSheet().getLegend().getMarkerDescription(priorityId);
        if (label != null) {
            return label;
        }
        IMarker marker = task.task.getOwnedWorkbook().getMarkerSheet().findMarker(priorityId);
        if (marker != null) {
            return marker.getName();
        }
        return null;
    }

    private String buildProgressText(TaskBar task) {
        int progress = task.getProgress();
        if (progress < 0) {
            return null;
        }
        return NLS.bind((String)GanttMessages.TaskBarToolTipFeedback_Completion_pattern, (Object)progress);
    }

    private String buildDatesText(TaskBar task) {
        DateInfo start = task.getStartDate();
        DateInfo end = task.getEndDate();
        Calendar today = DateInfo.today();
        int thisYear = today.get(1);
        boolean startThisYear = start != null && start.date.get(1) == thisYear;
        boolean endThisYear = end != null && end.date.get(1) == thisYear;
        String startText = this.formatDate(start, startThisYear && (endThisYear || end == null));
        String endText = this.formatDate(end, endThisYear && (startThisYear || start == null));
        if (task.isCheckpoint()) {
            return start == null ? endText : startText;
        }
        return String.valueOf(startText) + " - " + endText;
    }

    private String formatDate(DateInfo info, boolean inThisYear) {
        if (info == null) {
            return "?";
        }
        String format = "%1$tb %1$te";
        if (!inThisYear) {
            format = String.valueOf(format) + ", %1$tY";
        }
        if (!info.allDay) {
            format = String.valueOf(format) + " %1$tT";
        }
        return String.format(format, info.date);
    }

    private String buildAssigneeText(TaskBar task) {
        String assignees = TaskInfoUtils.getContent((ITopic)task.task, (String)"assigned-to");
        return assignees;
    }

    private void refreshToolTip() {
        if (this.hasTooltipRequesters() && this.getMainFigure().isShowing()) {
            this.tooltip = this.buildToolTip();
            this.showToolTip();
        } else {
            this.hideToolTip();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshToolTip();
    }

    public void addTooltipRequester(Object requester) {
        this.tooltipRequesters.add(requester);
        this.refreshToolTip();
    }

    public void removeTooltipRequester(Object requester) {
        this.tooltipRequesters.remove(requester);
        this.refreshToolTip();
    }

    private boolean hasTooltipRequesters() {
        return !this.tooltipRequesters.isEmpty();
    }

    public void showTargetFeedback(Request request) {
        String type = request.getType();
        if ("select".equals(type)) {
            if (this.shouldShowSelectionFeedback(request)) {
                this.addTooltipRequester(this);
            } else {
                this.removeTooltipRequester(this);
            }
        } else {
            super.showTargetFeedback(request);
        }
    }

    private boolean shouldShowSelectionFeedback(Request request) {
        Point point = (Point)request.getParameter("position");
        if (point == null) {
            return true;
        }
        return this.getMainFigure().isVisible() && this.getMainFigure().containsPoint(point);
    }

    public void hideTargetFeedback(Request request) {
        String type = request.getType();
        if ("select".equals(type)) {
            this.removeTooltipRequester(this);
        } else {
            super.hideTargetFeedback(request);
        }
    }
}

